/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.reg.fpmlreporting.product;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.reg.fpmlreporting.product.meta.RegReportingPaymentMeta;
import fpml.consolidated.shared.AdjustableOrRelativeDate;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentType;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RegReportingPayment", builder=RegReportingPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegReportingPayment", model="fpml", builder=RegReportingPaymentBuilderImpl.class, version="1.2.2")
public interface RegReportingPayment
extends NonNegativePayment {
    public static final RegReportingPaymentMeta metaData = new RegReportingPaymentMeta();

    public PaymentType getPaymentType();

    @Override
    public RegReportingPayment build();

    @Override
    public RegReportingPaymentBuilder toBuilder();

    public static RegReportingPaymentBuilder builder() {
        return new RegReportingPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends RegReportingPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegReportingPayment> getType() {
        return RegReportingPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.class, this.getPaymentDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.class, this.getPaymentAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.class, this.getPaymentType(), new AttributeMeta[0]);
    }

    public static class RegReportingPaymentBuilderImpl
    extends NonNegativePayment.NonNegativePaymentBuilderImpl
    implements RegReportingPaymentBuilder {
        protected PaymentType.PaymentTypeBuilder paymentType;

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType.PaymentTypeBuilder getPaymentType() {
            return this.paymentType;
        }

        @Override
        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType() {
            PaymentType.PaymentTypeBuilder result = this.paymentType != null ? this.paymentType : (this.paymentType = PaymentType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public RegReportingPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public RegReportingPaymentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDate")
        @RuneAttribute(value="paymentDate")
        public RegReportingPaymentBuilder setPaymentDate(AdjustableOrRelativeDate _paymentDate) {
            this.paymentDate = _paymentDate == null ? null : _paymentDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public RegReportingPaymentBuilder setPaymentAmount(NonNegativeMoney _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public RegReportingPaymentBuilder setPaymentType(PaymentType _paymentType) {
            this.paymentType = _paymentType == null ? null : _paymentType.toBuilder();
            return this;
        }

        @Override
        public RegReportingPayment build() {
            return new RegReportingPaymentImpl(this);
        }

        @Override
        public RegReportingPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public RegReportingPaymentBuilder prune() {
            super.prune();
            if (this.paymentType != null && !this.paymentType.prune().hasData()) {
                this.paymentType = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPaymentType() != null && this.getPaymentType().hasData();
        }

        @Override
        public RegReportingPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegReportingPaymentBuilder o = (RegReportingPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentType(), (RosettaModelObjectBuilder)o.getPaymentType(), this::setPaymentType);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegReportingPayment _that = (RegReportingPayment)this.getType().cast(o);
            return Objects.equals(this.paymentType, _that.getPaymentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegReportingPaymentBuilder {paymentType=" + String.valueOf(this.paymentType) + "} " + super.toString();
        }
    }

    public static interface RegReportingPaymentBuilder
    extends RegReportingPayment,
    NonNegativePayment.NonNegativePaymentBuilder {
        public PaymentType.PaymentTypeBuilder getOrCreatePaymentType();

        @Override
        public PaymentType.PaymentTypeBuilder getPaymentType();

        @Override
        public RegReportingPaymentBuilder setId(String var1);

        @Override
        public RegReportingPaymentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        @Override
        public RegReportingPaymentBuilder setPaymentDate(AdjustableOrRelativeDate var1);

        @Override
        public RegReportingPaymentBuilder setPaymentAmount(NonNegativeMoney var1);

        public RegReportingPaymentBuilder setPaymentType(PaymentType var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, (RosettaModelObjectBuilder)this.getPayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getPaymentDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, (RosettaModelObjectBuilder)this.getPaymentAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentType"), processor, PaymentType.PaymentTypeBuilder.class, this.getPaymentType(), new AttributeMeta[0]);
        }

        @Override
        public RegReportingPaymentBuilder prune();
    }

    public static class RegReportingPaymentImpl
    extends NonNegativePayment.NonNegativePaymentImpl
    implements RegReportingPayment {
        private final PaymentType paymentType;

        protected RegReportingPaymentImpl(RegReportingPaymentBuilder builder) {
            super(builder);
            this.paymentType = Optional.ofNullable(builder.getPaymentType()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="paymentType")
        @RuneAttribute(value="paymentType")
        public PaymentType getPaymentType() {
            return this.paymentType;
        }

        @Override
        public RegReportingPayment build() {
            return this;
        }

        @Override
        public RegReportingPaymentBuilder toBuilder() {
            RegReportingPaymentBuilder builder = RegReportingPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegReportingPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPaymentType()).ifPresent(builder::setPaymentType);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegReportingPayment _that = (RegReportingPayment)this.getType().cast(o);
            return Objects.equals(this.paymentType, _that.getPaymentType());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.paymentType != null ? this.paymentType.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegReportingPayment {paymentType=" + String.valueOf(this.paymentType) + "} " + super.toString();
        }
    }
}

