/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.FacilityExecutionExceptionDeclaration;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryTradingObligationMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="RegulatoryTradingObligation", builder=RegulatoryTradingObligationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryTradingObligation", model="fpml", builder=RegulatoryTradingObligationBuilderImpl.class, version="1.2.2")
public interface RegulatoryTradingObligation
extends RosettaModelObject {
    public static final RegulatoryTradingObligationMeta metaData = new RegulatoryTradingObligationMeta();

    public Boolean getTradedOnVenue();

    public Boolean getException();

    public FacilityExecutionExceptionDeclaration getExceptionDeclaration();

    public RegulatoryTradingObligation build();

    public RegulatoryTradingObligationBuilder toBuilder();

    public static RegulatoryTradingObligationBuilder builder() {
        return new RegulatoryTradingObligationBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryTradingObligation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryTradingObligation> getType() {
        return RegulatoryTradingObligation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("tradedOnVenue"), Boolean.class, (Object)this.getTradedOnVenue(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exception"), Boolean.class, (Object)this.getException(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exceptionDeclaration"), processor, FacilityExecutionExceptionDeclaration.class, this.getExceptionDeclaration(), new AttributeMeta[0]);
    }

    public static class RegulatoryTradingObligationBuilderImpl
    implements RegulatoryTradingObligationBuilder {
        protected Boolean tradedOnVenue;
        protected Boolean exception;
        protected FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder exceptionDeclaration;

        @Override
        @RosettaAttribute(value="tradedOnVenue", isRequired=true)
        @RuneAttribute(value="tradedOnVenue", isRequired=true)
        public Boolean getTradedOnVenue() {
            return this.tradedOnVenue;
        }

        @Override
        @RosettaAttribute(value="exception")
        @RuneAttribute(value="exception")
        public Boolean getException() {
            return this.exception;
        }

        @Override
        @RosettaAttribute(value="exceptionDeclaration")
        @RuneAttribute(value="exceptionDeclaration")
        public FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder getExceptionDeclaration() {
            return this.exceptionDeclaration;
        }

        @Override
        public FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder getOrCreateExceptionDeclaration() {
            FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder result = this.exceptionDeclaration != null ? this.exceptionDeclaration : (this.exceptionDeclaration = FacilityExecutionExceptionDeclaration.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradedOnVenue", isRequired=true)
        @RuneAttribute(value="tradedOnVenue", isRequired=true)
        public RegulatoryTradingObligationBuilder setTradedOnVenue(Boolean _tradedOnVenue) {
            this.tradedOnVenue = _tradedOnVenue == null ? null : _tradedOnVenue;
            return this;
        }

        @Override
        @RosettaAttribute(value="exception")
        @RuneAttribute(value="exception")
        public RegulatoryTradingObligationBuilder setException(Boolean _exception) {
            this.exception = _exception == null ? null : _exception;
            return this;
        }

        @Override
        @RosettaAttribute(value="exceptionDeclaration")
        @RuneAttribute(value="exceptionDeclaration")
        public RegulatoryTradingObligationBuilder setExceptionDeclaration(FacilityExecutionExceptionDeclaration _exceptionDeclaration) {
            this.exceptionDeclaration = _exceptionDeclaration == null ? null : _exceptionDeclaration.toBuilder();
            return this;
        }

        @Override
        public RegulatoryTradingObligation build() {
            return new RegulatoryTradingObligationImpl(this);
        }

        @Override
        public RegulatoryTradingObligationBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryTradingObligationBuilder prune() {
            if (this.exceptionDeclaration != null && !this.exceptionDeclaration.prune().hasData()) {
                this.exceptionDeclaration = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradedOnVenue() != null) {
                return true;
            }
            if (this.getException() != null) {
                return true;
            }
            return this.getExceptionDeclaration() != null && this.getExceptionDeclaration().hasData();
        }

        public RegulatoryTradingObligationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            RegulatoryTradingObligationBuilder o = (RegulatoryTradingObligationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExceptionDeclaration(), (RosettaModelObjectBuilder)o.getExceptionDeclaration(), this::setExceptionDeclaration);
            merger.mergeBasic((Object)this.getTradedOnVenue(), (Object)o.getTradedOnVenue(), this::setTradedOnVenue, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getException(), (Object)o.getException(), this::setException, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryTradingObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.tradedOnVenue, _that.getTradedOnVenue())) {
                return false;
            }
            if (!Objects.equals(this.exception, _that.getException())) {
                return false;
            }
            return Objects.equals(this.exceptionDeclaration, _that.getExceptionDeclaration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradedOnVenue != null ? this.tradedOnVenue.hashCode() : 0);
            _result = 31 * _result + (this.exception != null ? this.exception.hashCode() : 0);
            _result = 31 * _result + (this.exceptionDeclaration != null ? this.exceptionDeclaration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryTradingObligationBuilder {tradedOnVenue=" + this.tradedOnVenue + ", exception=" + this.exception + ", exceptionDeclaration=" + String.valueOf(this.exceptionDeclaration) + "}";
        }
    }

    public static interface RegulatoryTradingObligationBuilder
    extends RegulatoryTradingObligation,
    RosettaModelObjectBuilder {
        public FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder getOrCreateExceptionDeclaration();

        @Override
        public FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder getExceptionDeclaration();

        public RegulatoryTradingObligationBuilder setTradedOnVenue(Boolean var1);

        public RegulatoryTradingObligationBuilder setException(Boolean var1);

        public RegulatoryTradingObligationBuilder setExceptionDeclaration(FacilityExecutionExceptionDeclaration var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("tradedOnVenue"), Boolean.class, (Object)this.getTradedOnVenue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exception"), Boolean.class, (Object)this.getException(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exceptionDeclaration"), processor, FacilityExecutionExceptionDeclaration.FacilityExecutionExceptionDeclarationBuilder.class, this.getExceptionDeclaration(), new AttributeMeta[0]);
        }

        public RegulatoryTradingObligationBuilder prune();
    }

    public static class RegulatoryTradingObligationImpl
    implements RegulatoryTradingObligation {
        private final Boolean tradedOnVenue;
        private final Boolean exception;
        private final FacilityExecutionExceptionDeclaration exceptionDeclaration;

        protected RegulatoryTradingObligationImpl(RegulatoryTradingObligationBuilder builder) {
            this.tradedOnVenue = builder.getTradedOnVenue();
            this.exception = builder.getException();
            this.exceptionDeclaration = Optional.ofNullable(builder.getExceptionDeclaration()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradedOnVenue", isRequired=true)
        @RuneAttribute(value="tradedOnVenue", isRequired=true)
        public Boolean getTradedOnVenue() {
            return this.tradedOnVenue;
        }

        @Override
        @RosettaAttribute(value="exception")
        @RuneAttribute(value="exception")
        public Boolean getException() {
            return this.exception;
        }

        @Override
        @RosettaAttribute(value="exceptionDeclaration")
        @RuneAttribute(value="exceptionDeclaration")
        public FacilityExecutionExceptionDeclaration getExceptionDeclaration() {
            return this.exceptionDeclaration;
        }

        @Override
        public RegulatoryTradingObligation build() {
            return this;
        }

        @Override
        public RegulatoryTradingObligationBuilder toBuilder() {
            RegulatoryTradingObligationBuilder builder = RegulatoryTradingObligation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryTradingObligationBuilder builder) {
            Optional.ofNullable(this.getTradedOnVenue()).ifPresent(builder::setTradedOnVenue);
            Optional.ofNullable(this.getException()).ifPresent(builder::setException);
            Optional.ofNullable(this.getExceptionDeclaration()).ifPresent(builder::setExceptionDeclaration);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            RegulatoryTradingObligation _that = this.getType().cast(o);
            if (!Objects.equals(this.tradedOnVenue, _that.getTradedOnVenue())) {
                return false;
            }
            if (!Objects.equals(this.exception, _that.getException())) {
                return false;
            }
            return Objects.equals(this.exceptionDeclaration, _that.getExceptionDeclaration());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradedOnVenue != null ? this.tradedOnVenue.hashCode() : 0);
            _result = 31 * _result + (this.exception != null ? this.exception.hashCode() : 0);
            _result = 31 * _result + (this.exceptionDeclaration != null ? this.exceptionDeclaration.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "RegulatoryTradingObligation {tradedOnVenue=" + this.tradedOnVenue + ", exception=" + this.exception + ", exceptionDeclaration=" + String.valueOf(this.exceptionDeclaration) + "}";
        }
    }
}

