/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.asset.BasicQuotation;
import fpml.consolidated.business.events.EventId;
import fpml.consolidated.business.events.EventTaxonomy;
import fpml.consolidated.business.events.ReportingNotionalChangeModel;
import fpml.consolidated.doc.Trade;
import fpml.consolidated.msg.AddressedMessage;
import fpml.consolidated.msg.NotificationMessageHeader;
import fpml.consolidated.recordkeeping.processes.EventTimestamps;
import fpml.consolidated.recordkeeping.processes.RegReportingCDE;
import fpml.consolidated.recordkeeping.processes.RegulationDetails;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryDisclosureMeta;
import fpml.consolidated.reg.fpmlreporting.shared.ApplicableRegulations;
import fpml.consolidated.reg.fpmlreporting.shared.RegulatoryReportingCollateralization;
import fpml.consolidated.reg.fpmlreporting.shared.ReportingAndCounterPartyModel;
import fpml.consolidated.shared.IdentifiedDate;
import fpml.consolidated.shared.NonNegativePayment;
import fpml.consolidated.shared.OnBehalfOf;
import fpml.consolidated.shared.Party;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryDisclosure", builder=RegulatoryDisclosureBuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryDisclosure", model="fpml", builder=RegulatoryDisclosureBuilderImpl.class, version="1.2.2")
public interface RegulatoryDisclosure
extends AddressedMessage {
    public static final RegulatoryDisclosureMeta metaData = new RegulatoryDisclosureMeta();

    public Boolean getIsCorrection();

    public List<? extends OnBehalfOf> getOnBehalfOf();

    public IdentifiedDate getAsOfDate();

    public LocalTime getAsOfTime();

    public EventId getEventId();

    public EventTaxonomy getEventType();

    public EventTimestamps getEventTimestamps();

    public ReportingAndCounterPartyModel getReportingAndCounterPartyModel();

    public ReportingNotionalChangeModel getReportingNotionalChangeModel();

    public List<? extends NonNegativePayment> getPayment();

    public ApplicableRegulations getApplicableRegulations();

    public RegulationDetails getRegulationSpecificInformation();

    public RegReportingCDE getCpmiIoscoCDE();

    public Trade getTrade();

    public List<? extends BasicQuotation> getQuote();

    public List<? extends RegulatoryReportingCollateralization> getCollateralization();

    public List<? extends Party> getParty();

    @Override
    public RegulatoryDisclosure build();

    @Override
    public RegulatoryDisclosureBuilder toBuilder();

    public static RegulatoryDisclosureBuilder builder() {
        return new RegulatoryDisclosureBuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryDisclosure> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryDisclosure> getType() {
        return RegulatoryDisclosure.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.class, this.getOnBehalfOf(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.class, this.getAsOfDate(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventId"), processor, EventId.class, this.getEventId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventType"), processor, EventTaxonomy.class, this.getEventType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventTimestamps"), processor, EventTimestamps.class, this.getEventTimestamps(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingAndCounterPartyModel"), processor, ReportingAndCounterPartyModel.class, this.getReportingAndCounterPartyModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingNotionalChangeModel"), processor, ReportingNotionalChangeModel.class, this.getReportingNotionalChangeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.class, this.getPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("applicableRegulations"), processor, ApplicableRegulations.class, this.getApplicableRegulations(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulationSpecificInformation"), processor, RegulationDetails.class, this.getRegulationSpecificInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cpmiIoscoCDE"), processor, RegReportingCDE.class, this.getCpmiIoscoCDE(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("trade"), processor, Trade.class, this.getTrade(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.class, this.getQuote(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.class, this.getCollateralization(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
    }

    public static class RegulatoryDisclosureBuilderImpl
    extends AddressedMessage.AddressedMessageBuilderImpl
    implements RegulatoryDisclosureBuilder {
        protected Boolean isCorrection;
        protected List<OnBehalfOf.OnBehalfOfBuilder> onBehalfOf = new ArrayList<OnBehalfOf.OnBehalfOfBuilder>();
        protected IdentifiedDate.IdentifiedDateBuilder asOfDate;
        protected LocalTime asOfTime;
        protected EventId.EventIdBuilder eventId;
        protected EventTaxonomy.EventTaxonomyBuilder eventType;
        protected EventTimestamps.EventTimestampsBuilder eventTimestamps;
        protected ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder reportingAndCounterPartyModel;
        protected ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder reportingNotionalChangeModel;
        protected List<NonNegativePayment.NonNegativePaymentBuilder> payment = new ArrayList<NonNegativePayment.NonNegativePaymentBuilder>();
        protected ApplicableRegulations.ApplicableRegulationsBuilder applicableRegulations;
        protected RegulationDetails.RegulationDetailsBuilder regulationSpecificInformation;
        protected RegReportingCDE.RegReportingCDEBuilder cpmiIoscoCDE;
        protected Trade.TradeBuilder trade;
        protected List<BasicQuotation.BasicQuotationBuilder> quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();
        protected List<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public Boolean getIsCorrection() {
            return this.isCorrection;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public List<? extends OnBehalfOf.OnBehalfOfBuilder> getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf(int index) {
            if (this.onBehalfOf == null) {
                this.onBehalfOf = new ArrayList<OnBehalfOf.OnBehalfOfBuilder>();
            }
            return (OnBehalfOf.OnBehalfOfBuilder)this.getIndex(this.onBehalfOf, index, () -> {
                OnBehalfOf.OnBehalfOfBuilder newOnBehalfOf = OnBehalfOf.builder();
                return newOnBehalfOf;
            });
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate() {
            IdentifiedDate.IdentifiedDateBuilder result = this.asOfDate != null ? this.asOfDate : (this.asOfDate = IdentifiedDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="eventId")
        @RuneAttribute(value="eventId")
        public EventId.EventIdBuilder getEventId() {
            return this.eventId;
        }

        @Override
        public EventId.EventIdBuilder getOrCreateEventId() {
            EventId.EventIdBuilder result = this.eventId != null ? this.eventId : (this.eventId = EventId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public EventTaxonomy.EventTaxonomyBuilder getEventType() {
            return this.eventType;
        }

        @Override
        public EventTaxonomy.EventTaxonomyBuilder getOrCreateEventType() {
            EventTaxonomy.EventTaxonomyBuilder result = this.eventType != null ? this.eventType : (this.eventType = EventTaxonomy.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventTimestamps", isRequired=true)
        @RuneAttribute(value="eventTimestamps", isRequired=true)
        public EventTimestamps.EventTimestampsBuilder getEventTimestamps() {
            return this.eventTimestamps;
        }

        @Override
        public EventTimestamps.EventTimestampsBuilder getOrCreateEventTimestamps() {
            EventTimestamps.EventTimestampsBuilder result = this.eventTimestamps != null ? this.eventTimestamps : (this.eventTimestamps = EventTimestamps.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        @RuneAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getReportingAndCounterPartyModel() {
            return this.reportingAndCounterPartyModel;
        }

        @Override
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getOrCreateReportingAndCounterPartyModel() {
            ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder result = this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel : (this.reportingAndCounterPartyModel = ReportingAndCounterPartyModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getReportingNotionalChangeModel() {
            return this.reportingNotionalChangeModel;
        }

        @Override
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getOrCreateReportingNotionalChangeModel() {
            ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder result = this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel : (this.reportingNotionalChangeModel = ReportingNotionalChangeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends NonNegativePayment.NonNegativePaymentBuilder> getPayment() {
            return this.payment;
        }

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment(int index) {
            if (this.payment == null) {
                this.payment = new ArrayList<NonNegativePayment.NonNegativePaymentBuilder>();
            }
            return (NonNegativePayment.NonNegativePaymentBuilder)this.getIndex(this.payment, index, () -> {
                NonNegativePayment.NonNegativePaymentBuilder newPayment = NonNegativePayment.builder();
                return newPayment;
            });
        }

        @Override
        @RosettaAttribute(value="applicableRegulations")
        @RuneAttribute(value="applicableRegulations")
        public ApplicableRegulations.ApplicableRegulationsBuilder getApplicableRegulations() {
            return this.applicableRegulations;
        }

        @Override
        public ApplicableRegulations.ApplicableRegulationsBuilder getOrCreateApplicableRegulations() {
            ApplicableRegulations.ApplicableRegulationsBuilder result = this.applicableRegulations != null ? this.applicableRegulations : (this.applicableRegulations = ApplicableRegulations.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regulationSpecificInformation")
        @RuneAttribute(value="regulationSpecificInformation")
        public RegulationDetails.RegulationDetailsBuilder getRegulationSpecificInformation() {
            return this.regulationSpecificInformation;
        }

        @Override
        public RegulationDetails.RegulationDetailsBuilder getOrCreateRegulationSpecificInformation() {
            RegulationDetails.RegulationDetailsBuilder result = this.regulationSpecificInformation != null ? this.regulationSpecificInformation : (this.regulationSpecificInformation = RegulationDetails.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cpmiIoscoCDE")
        @RuneAttribute(value="cpmiIoscoCDE")
        public RegReportingCDE.RegReportingCDEBuilder getCpmiIoscoCDE() {
            return this.cpmiIoscoCDE;
        }

        @Override
        public RegReportingCDE.RegReportingCDEBuilder getOrCreateCpmiIoscoCDE() {
            RegReportingCDE.RegReportingCDEBuilder result = this.cpmiIoscoCDE != null ? this.cpmiIoscoCDE : (this.cpmiIoscoCDE = RegReportingCDE.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade.TradeBuilder getTrade() {
            return this.trade;
        }

        @Override
        public Trade.TradeBuilder getOrCreateTrade() {
            Trade.TradeBuilder result = this.trade != null ? this.trade : (this.trade = Trade.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote() {
            return this.quote;
        }

        @Override
        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int index) {
            if (this.quote == null) {
                this.quote = new ArrayList<BasicQuotation.BasicQuotationBuilder>();
            }
            return (BasicQuotation.BasicQuotationBuilder)this.getIndex(this.quote, index, () -> {
                BasicQuotation.BasicQuotationBuilder newQuote = BasicQuotation.builder();
                return newQuote;
            });
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization() {
            return this.collateralization;
        }

        @Override
        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int index) {
            if (this.collateralization == null) {
                this.collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
            }
            return (RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder)this.getIndex(this.collateralization, index, () -> {
                RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder newCollateralization = RegulatoryReportingCollateralization.builder();
                return newCollateralization;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public RegulatoryDisclosureBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public RegulatoryDisclosureBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public RegulatoryDisclosureBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public RegulatoryDisclosureBuilder setHeader(NotificationMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public RegulatoryDisclosureBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public RegulatoryDisclosureBuilder addOnBehalfOf(OnBehalfOf _onBehalfOf) {
            if (_onBehalfOf != null) {
                this.onBehalfOf.add(_onBehalfOf.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addOnBehalfOf(OnBehalfOf _onBehalfOf, int idx) {
            this.getIndex(this.onBehalfOf, idx, () -> _onBehalfOf.toBuilder());
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addOnBehalfOf(List<? extends OnBehalfOf> onBehalfOfs) {
            if (onBehalfOfs != null) {
                for (OnBehalfOf onBehalfOf : onBehalfOfs) {
                    this.onBehalfOf.add(onBehalfOf.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="onBehalfOf")
        public RegulatoryDisclosureBuilder setOnBehalfOf(List<? extends OnBehalfOf> onBehalfOfs) {
            this.onBehalfOf = onBehalfOfs == null ? new ArrayList<OnBehalfOf.OnBehalfOfBuilder>() : (List)onBehalfOfs.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public RegulatoryDisclosureBuilder setAsOfDate(IdentifiedDate _asOfDate) {
            this.asOfDate = _asOfDate == null ? null : _asOfDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public RegulatoryDisclosureBuilder setAsOfTime(LocalTime _asOfTime) {
            this.asOfTime = _asOfTime == null ? null : _asOfTime;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventId")
        @RuneAttribute(value="eventId")
        public RegulatoryDisclosureBuilder setEventId(EventId _eventId) {
            this.eventId = _eventId == null ? null : _eventId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public RegulatoryDisclosureBuilder setEventType(EventTaxonomy _eventType) {
            this.eventType = _eventType == null ? null : _eventType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventTimestamps", isRequired=true)
        @RuneAttribute(value="eventTimestamps", isRequired=true)
        public RegulatoryDisclosureBuilder setEventTimestamps(EventTimestamps _eventTimestamps) {
            this.eventTimestamps = _eventTimestamps == null ? null : _eventTimestamps.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        @RuneAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        public RegulatoryDisclosureBuilder setReportingAndCounterPartyModel(ReportingAndCounterPartyModel _reportingAndCounterPartyModel) {
            this.reportingAndCounterPartyModel = _reportingAndCounterPartyModel == null ? null : _reportingAndCounterPartyModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public RegulatoryDisclosureBuilder setReportingNotionalChangeModel(ReportingNotionalChangeModel _reportingNotionalChangeModel) {
            this.reportingNotionalChangeModel = _reportingNotionalChangeModel == null ? null : _reportingNotionalChangeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public RegulatoryDisclosureBuilder addPayment(NonNegativePayment _payment) {
            if (_payment != null) {
                this.payment.add(_payment.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addPayment(NonNegativePayment _payment, int idx) {
            this.getIndex(this.payment, idx, () -> _payment.toBuilder());
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addPayment(List<? extends NonNegativePayment> payments) {
            if (payments != null) {
                for (NonNegativePayment nonNegativePayment : payments) {
                    this.payment.add(nonNegativePayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payment")
        public RegulatoryDisclosureBuilder setPayment(List<? extends NonNegativePayment> payments) {
            this.payment = payments == null ? new ArrayList<NonNegativePayment.NonNegativePaymentBuilder>() : (List)payments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="applicableRegulations")
        @RuneAttribute(value="applicableRegulations")
        public RegulatoryDisclosureBuilder setApplicableRegulations(ApplicableRegulations _applicableRegulations) {
            this.applicableRegulations = _applicableRegulations == null ? null : _applicableRegulations.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regulationSpecificInformation")
        @RuneAttribute(value="regulationSpecificInformation")
        public RegulatoryDisclosureBuilder setRegulationSpecificInformation(RegulationDetails _regulationSpecificInformation) {
            this.regulationSpecificInformation = _regulationSpecificInformation == null ? null : _regulationSpecificInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cpmiIoscoCDE")
        @RuneAttribute(value="cpmiIoscoCDE")
        public RegulatoryDisclosureBuilder setCpmiIoscoCDE(RegReportingCDE _cpmiIoscoCDE) {
            this.cpmiIoscoCDE = _cpmiIoscoCDE == null ? null : _cpmiIoscoCDE.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public RegulatoryDisclosureBuilder setTrade(Trade _trade) {
            this.trade = _trade == null ? null : _trade.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public RegulatoryDisclosureBuilder addQuote(BasicQuotation _quote) {
            if (_quote != null) {
                this.quote.add(_quote.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addQuote(BasicQuotation _quote, int idx) {
            this.getIndex(this.quote, idx, () -> _quote.toBuilder());
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addQuote(List<? extends BasicQuotation> quotes) {
            if (quotes != null) {
                for (BasicQuotation basicQuotation : quotes) {
                    this.quote.add(basicQuotation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="quote")
        public RegulatoryDisclosureBuilder setQuote(List<? extends BasicQuotation> quotes) {
            this.quote = quotes == null ? new ArrayList<BasicQuotation.BasicQuotationBuilder>() : (List)quotes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public RegulatoryDisclosureBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization) {
            if (_collateralization != null) {
                this.collateralization.add(_collateralization.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization, int idx) {
            this.getIndex(this.collateralization, idx, () -> _collateralization.toBuilder());
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            if (collateralizations != null) {
                for (RegulatoryReportingCollateralization regulatoryReportingCollateralization : collateralizations) {
                    this.collateralization.add(regulatoryReportingCollateralization.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralization")
        public RegulatoryDisclosureBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            this.collateralization = collateralizations == null ? new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>() : (List)collateralizations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public RegulatoryDisclosureBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public RegulatoryDisclosureBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public RegulatoryDisclosure build() {
            return new RegulatoryDisclosureImpl(this);
        }

        @Override
        public RegulatoryDisclosureBuilder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder prune() {
            super.prune();
            this.onBehalfOf = this.onBehalfOf.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.asOfDate != null && !this.asOfDate.prune().hasData()) {
                this.asOfDate = null;
            }
            if (this.eventId != null && !this.eventId.prune().hasData()) {
                this.eventId = null;
            }
            if (this.eventType != null && !this.eventType.prune().hasData()) {
                this.eventType = null;
            }
            if (this.eventTimestamps != null && !this.eventTimestamps.prune().hasData()) {
                this.eventTimestamps = null;
            }
            if (this.reportingAndCounterPartyModel != null && !this.reportingAndCounterPartyModel.prune().hasData()) {
                this.reportingAndCounterPartyModel = null;
            }
            if (this.reportingNotionalChangeModel != null && !this.reportingNotionalChangeModel.prune().hasData()) {
                this.reportingNotionalChangeModel = null;
            }
            this.payment = this.payment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.applicableRegulations != null && !this.applicableRegulations.prune().hasData()) {
                this.applicableRegulations = null;
            }
            if (this.regulationSpecificInformation != null && !this.regulationSpecificInformation.prune().hasData()) {
                this.regulationSpecificInformation = null;
            }
            if (this.cpmiIoscoCDE != null && !this.cpmiIoscoCDE.prune().hasData()) {
                this.cpmiIoscoCDE = null;
            }
            if (this.trade != null && !this.trade.prune().hasData()) {
                this.trade = null;
            }
            this.quote = this.quote.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.collateralization = this.collateralization.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getIsCorrection() != null) {
                return true;
            }
            if (this.getOnBehalfOf() != null && this.getOnBehalfOf().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAsOfDate() != null && this.getAsOfDate().hasData()) {
                return true;
            }
            if (this.getAsOfTime() != null) {
                return true;
            }
            if (this.getEventId() != null && this.getEventId().hasData()) {
                return true;
            }
            if (this.getEventType() != null && this.getEventType().hasData()) {
                return true;
            }
            if (this.getEventTimestamps() != null && this.getEventTimestamps().hasData()) {
                return true;
            }
            if (this.getReportingAndCounterPartyModel() != null && this.getReportingAndCounterPartyModel().hasData()) {
                return true;
            }
            if (this.getReportingNotionalChangeModel() != null && this.getReportingNotionalChangeModel().hasData()) {
                return true;
            }
            if (this.getPayment() != null && this.getPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getApplicableRegulations() != null && this.getApplicableRegulations().hasData()) {
                return true;
            }
            if (this.getRegulationSpecificInformation() != null && this.getRegulationSpecificInformation().hasData()) {
                return true;
            }
            if (this.getCpmiIoscoCDE() != null && this.getCpmiIoscoCDE().hasData()) {
                return true;
            }
            if (this.getTrade() != null && this.getTrade().hasData()) {
                return true;
            }
            if (this.getQuote() != null && this.getQuote().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getCollateralization() != null && this.getCollateralization().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public RegulatoryDisclosureBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryDisclosureBuilder o = (RegulatoryDisclosureBuilder)other;
            merger.mergeRosetta(this.getOnBehalfOf(), o.getOnBehalfOf(), this::getOrCreateOnBehalfOf);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAsOfDate(), (RosettaModelObjectBuilder)o.getAsOfDate(), this::setAsOfDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventId(), (RosettaModelObjectBuilder)o.getEventId(), this::setEventId);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventType(), (RosettaModelObjectBuilder)o.getEventType(), this::setEventType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventTimestamps(), (RosettaModelObjectBuilder)o.getEventTimestamps(), this::setEventTimestamps);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingAndCounterPartyModel(), (RosettaModelObjectBuilder)o.getReportingAndCounterPartyModel(), this::setReportingAndCounterPartyModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingNotionalChangeModel(), (RosettaModelObjectBuilder)o.getReportingNotionalChangeModel(), this::setReportingNotionalChangeModel);
            merger.mergeRosetta(this.getPayment(), o.getPayment(), this::getOrCreatePayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApplicableRegulations(), (RosettaModelObjectBuilder)o.getApplicableRegulations(), this::setApplicableRegulations);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulationSpecificInformation(), (RosettaModelObjectBuilder)o.getRegulationSpecificInformation(), this::setRegulationSpecificInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCpmiIoscoCDE(), (RosettaModelObjectBuilder)o.getCpmiIoscoCDE(), this::setCpmiIoscoCDE);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTrade(), (RosettaModelObjectBuilder)o.getTrade(), this::setTrade);
            merger.mergeRosetta(this.getQuote(), o.getQuote(), this::getOrCreateQuote);
            merger.mergeRosetta(this.getCollateralization(), o.getCollateralization(), this::getOrCreateCollateralization);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeBasic((Object)this.getIsCorrection(), (Object)o.getIsCorrection(), this::setIsCorrection, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAsOfTime(), (Object)o.getAsOfTime(), this::setAsOfTime, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryDisclosure _that = (RegulatoryDisclosure)this.getType().cast(o);
            if (!Objects.equals(this.isCorrection, _that.getIsCorrection())) {
                return false;
            }
            if (!ListEquals.listEquals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.eventId, _that.getEventId())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamps, _that.getEventTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.reportingAndCounterPartyModel, _that.getReportingAndCounterPartyModel())) {
                return false;
            }
            if (!Objects.equals(this.reportingNotionalChangeModel, _that.getReportingNotionalChangeModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.payment, _that.getPayment())) {
                return false;
            }
            if (!Objects.equals(this.applicableRegulations, _that.getApplicableRegulations())) {
                return false;
            }
            if (!Objects.equals(this.regulationSpecificInformation, _that.getRegulationSpecificInformation())) {
                return false;
            }
            if (!Objects.equals(this.cpmiIoscoCDE, _that.getCpmiIoscoCDE())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.isCorrection != null ? this.isCorrection.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.eventId != null ? this.eventId.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamps != null ? this.eventTimestamps.hashCode() : 0);
            _result = 31 * _result + (this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel.hashCode() : 0);
            _result = 31 * _result + (this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.applicableRegulations != null ? this.applicableRegulations.hashCode() : 0);
            _result = 31 * _result + (this.regulationSpecificInformation != null ? this.regulationSpecificInformation.hashCode() : 0);
            _result = 31 * _result + (this.cpmiIoscoCDE != null ? this.cpmiIoscoCDE.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryDisclosureBuilder {isCorrection=" + this.isCorrection + ", onBehalfOf=" + String.valueOf(this.onBehalfOf) + ", asOfDate=" + String.valueOf(this.asOfDate) + ", asOfTime=" + String.valueOf(this.asOfTime) + ", eventId=" + String.valueOf(this.eventId) + ", eventType=" + String.valueOf(this.eventType) + ", eventTimestamps=" + String.valueOf(this.eventTimestamps) + ", reportingAndCounterPartyModel=" + String.valueOf(this.reportingAndCounterPartyModel) + ", reportingNotionalChangeModel=" + String.valueOf(this.reportingNotionalChangeModel) + ", payment=" + String.valueOf(this.payment) + ", applicableRegulations=" + String.valueOf(this.applicableRegulations) + ", regulationSpecificInformation=" + String.valueOf(this.regulationSpecificInformation) + ", cpmiIoscoCDE=" + String.valueOf(this.cpmiIoscoCDE) + ", trade=" + String.valueOf(this.trade) + ", quote=" + String.valueOf(this.quote) + ", collateralization=" + String.valueOf(this.collateralization) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }

    public static interface RegulatoryDisclosureBuilder
    extends RegulatoryDisclosure,
    AddressedMessage.AddressedMessageBuilder {
        public OnBehalfOf.OnBehalfOfBuilder getOrCreateOnBehalfOf(int var1);

        public List<? extends OnBehalfOf.OnBehalfOfBuilder> getOnBehalfOf();

        public IdentifiedDate.IdentifiedDateBuilder getOrCreateAsOfDate();

        @Override
        public IdentifiedDate.IdentifiedDateBuilder getAsOfDate();

        public EventId.EventIdBuilder getOrCreateEventId();

        @Override
        public EventId.EventIdBuilder getEventId();

        public EventTaxonomy.EventTaxonomyBuilder getOrCreateEventType();

        @Override
        public EventTaxonomy.EventTaxonomyBuilder getEventType();

        public EventTimestamps.EventTimestampsBuilder getOrCreateEventTimestamps();

        @Override
        public EventTimestamps.EventTimestampsBuilder getEventTimestamps();

        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getOrCreateReportingAndCounterPartyModel();

        @Override
        public ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder getReportingAndCounterPartyModel();

        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getOrCreateReportingNotionalChangeModel();

        @Override
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getReportingNotionalChangeModel();

        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment(int var1);

        public List<? extends NonNegativePayment.NonNegativePaymentBuilder> getPayment();

        public ApplicableRegulations.ApplicableRegulationsBuilder getOrCreateApplicableRegulations();

        @Override
        public ApplicableRegulations.ApplicableRegulationsBuilder getApplicableRegulations();

        public RegulationDetails.RegulationDetailsBuilder getOrCreateRegulationSpecificInformation();

        @Override
        public RegulationDetails.RegulationDetailsBuilder getRegulationSpecificInformation();

        public RegReportingCDE.RegReportingCDEBuilder getOrCreateCpmiIoscoCDE();

        @Override
        public RegReportingCDE.RegReportingCDEBuilder getCpmiIoscoCDE();

        public Trade.TradeBuilder getOrCreateTrade();

        @Override
        public Trade.TradeBuilder getTrade();

        public BasicQuotation.BasicQuotationBuilder getOrCreateQuote(int var1);

        public List<? extends BasicQuotation.BasicQuotationBuilder> getQuote();

        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int var1);

        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        @Override
        public RegulatoryDisclosureBuilder setFpmlVersion(String var1);

        @Override
        public RegulatoryDisclosureBuilder setExpectedBuild(Integer var1);

        @Override
        public RegulatoryDisclosureBuilder setActualBuild(Integer var1);

        @Override
        public RegulatoryDisclosureBuilder setHeader(NotificationMessageHeader var1);

        public RegulatoryDisclosureBuilder setIsCorrection(Boolean var1);

        public RegulatoryDisclosureBuilder addOnBehalfOf(OnBehalfOf var1);

        public RegulatoryDisclosureBuilder addOnBehalfOf(OnBehalfOf var1, int var2);

        public RegulatoryDisclosureBuilder addOnBehalfOf(List<? extends OnBehalfOf> var1);

        public RegulatoryDisclosureBuilder setOnBehalfOf(List<? extends OnBehalfOf> var1);

        public RegulatoryDisclosureBuilder setAsOfDate(IdentifiedDate var1);

        public RegulatoryDisclosureBuilder setAsOfTime(LocalTime var1);

        public RegulatoryDisclosureBuilder setEventId(EventId var1);

        public RegulatoryDisclosureBuilder setEventType(EventTaxonomy var1);

        public RegulatoryDisclosureBuilder setEventTimestamps(EventTimestamps var1);

        public RegulatoryDisclosureBuilder setReportingAndCounterPartyModel(ReportingAndCounterPartyModel var1);

        public RegulatoryDisclosureBuilder setReportingNotionalChangeModel(ReportingNotionalChangeModel var1);

        public RegulatoryDisclosureBuilder addPayment(NonNegativePayment var1);

        public RegulatoryDisclosureBuilder addPayment(NonNegativePayment var1, int var2);

        public RegulatoryDisclosureBuilder addPayment(List<? extends NonNegativePayment> var1);

        public RegulatoryDisclosureBuilder setPayment(List<? extends NonNegativePayment> var1);

        public RegulatoryDisclosureBuilder setApplicableRegulations(ApplicableRegulations var1);

        public RegulatoryDisclosureBuilder setRegulationSpecificInformation(RegulationDetails var1);

        public RegulatoryDisclosureBuilder setCpmiIoscoCDE(RegReportingCDE var1);

        public RegulatoryDisclosureBuilder setTrade(Trade var1);

        public RegulatoryDisclosureBuilder addQuote(BasicQuotation var1);

        public RegulatoryDisclosureBuilder addQuote(BasicQuotation var1, int var2);

        public RegulatoryDisclosureBuilder addQuote(List<? extends BasicQuotation> var1);

        public RegulatoryDisclosureBuilder setQuote(List<? extends BasicQuotation> var1);

        public RegulatoryDisclosureBuilder addCollateralization(RegulatoryReportingCollateralization var1);

        public RegulatoryDisclosureBuilder addCollateralization(RegulatoryReportingCollateralization var1, int var2);

        public RegulatoryDisclosureBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public RegulatoryDisclosureBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public RegulatoryDisclosureBuilder addParty(Party var1);

        public RegulatoryDisclosureBuilder addParty(Party var1, int var2);

        public RegulatoryDisclosureBuilder addParty(List<? extends Party> var1);

        public RegulatoryDisclosureBuilder setParty(List<? extends Party> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, NotificationMessageHeader.NotificationMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOf"), processor, OnBehalfOf.OnBehalfOfBuilder.class, this.getOnBehalfOf(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("asOfDate"), processor, IdentifiedDate.IdentifiedDateBuilder.class, this.getAsOfDate(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("asOfTime"), LocalTime.class, (Object)this.getAsOfTime(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventId"), processor, EventId.EventIdBuilder.class, this.getEventId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventType"), processor, EventTaxonomy.EventTaxonomyBuilder.class, this.getEventType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventTimestamps"), processor, EventTimestamps.EventTimestampsBuilder.class, this.getEventTimestamps(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingAndCounterPartyModel"), processor, ReportingAndCounterPartyModel.ReportingAndCounterPartyModelBuilder.class, this.getReportingAndCounterPartyModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingNotionalChangeModel"), processor, ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder.class, this.getReportingNotionalChangeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.NonNegativePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("applicableRegulations"), processor, ApplicableRegulations.ApplicableRegulationsBuilder.class, this.getApplicableRegulations(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulationSpecificInformation"), processor, RegulationDetails.RegulationDetailsBuilder.class, this.getRegulationSpecificInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cpmiIoscoCDE"), processor, RegReportingCDE.RegReportingCDEBuilder.class, this.getCpmiIoscoCDE(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("trade"), processor, Trade.TradeBuilder.class, this.getTrade(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quote"), processor, BasicQuotation.BasicQuotationBuilder.class, this.getQuote(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder.class, this.getCollateralization(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryDisclosureBuilder prune();
    }

    public static class RegulatoryDisclosureImpl
    extends AddressedMessage.AddressedMessageImpl
    implements RegulatoryDisclosure {
        private final Boolean isCorrection;
        private final List<? extends OnBehalfOf> onBehalfOf;
        private final IdentifiedDate asOfDate;
        private final LocalTime asOfTime;
        private final EventId eventId;
        private final EventTaxonomy eventType;
        private final EventTimestamps eventTimestamps;
        private final ReportingAndCounterPartyModel reportingAndCounterPartyModel;
        private final ReportingNotionalChangeModel reportingNotionalChangeModel;
        private final List<? extends NonNegativePayment> payment;
        private final ApplicableRegulations applicableRegulations;
        private final RegulationDetails regulationSpecificInformation;
        private final RegReportingCDE cpmiIoscoCDE;
        private final Trade trade;
        private final List<? extends BasicQuotation> quote;
        private final List<? extends RegulatoryReportingCollateralization> collateralization;
        private final List<? extends Party> party;

        protected RegulatoryDisclosureImpl(RegulatoryDisclosureBuilder builder) {
            super(builder);
            this.isCorrection = builder.getIsCorrection();
            this.onBehalfOf = Optional.ofNullable(builder.getOnBehalfOf()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.asOfDate = Optional.ofNullable(builder.getAsOfDate()).map(f -> f.build()).orElse(null);
            this.asOfTime = builder.getAsOfTime();
            this.eventId = Optional.ofNullable(builder.getEventId()).map(f -> f.build()).orElse(null);
            this.eventType = Optional.ofNullable(builder.getEventType()).map(f -> f.build()).orElse(null);
            this.eventTimestamps = Optional.ofNullable(builder.getEventTimestamps()).map(f -> f.build()).orElse(null);
            this.reportingAndCounterPartyModel = Optional.ofNullable(builder.getReportingAndCounterPartyModel()).map(f -> f.build()).orElse(null);
            this.reportingNotionalChangeModel = Optional.ofNullable(builder.getReportingNotionalChangeModel()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.applicableRegulations = Optional.ofNullable(builder.getApplicableRegulations()).map(f -> f.build()).orElse(null);
            this.regulationSpecificInformation = Optional.ofNullable(builder.getRegulationSpecificInformation()).map(f -> f.build()).orElse(null);
            this.cpmiIoscoCDE = Optional.ofNullable(builder.getCpmiIoscoCDE()).map(f -> f.build()).orElse(null);
            this.trade = Optional.ofNullable(builder.getTrade()).map(f -> f.build()).orElse(null);
            this.quote = Optional.ofNullable(builder.getQuote()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.collateralization = Optional.ofNullable(builder.getCollateralization()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public Boolean getIsCorrection() {
            return this.isCorrection;
        }

        @Override
        @RosettaAttribute(value="onBehalfOf")
        @RuneAttribute(value="onBehalfOf")
        public List<? extends OnBehalfOf> getOnBehalfOf() {
            return this.onBehalfOf;
        }

        @Override
        @RosettaAttribute(value="asOfDate")
        @RuneAttribute(value="asOfDate")
        public IdentifiedDate getAsOfDate() {
            return this.asOfDate;
        }

        @Override
        @RosettaAttribute(value="asOfTime")
        @RuneAttribute(value="asOfTime")
        public LocalTime getAsOfTime() {
            return this.asOfTime;
        }

        @Override
        @RosettaAttribute(value="eventId")
        @RuneAttribute(value="eventId")
        public EventId getEventId() {
            return this.eventId;
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public EventTaxonomy getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="eventTimestamps", isRequired=true)
        @RuneAttribute(value="eventTimestamps", isRequired=true)
        public EventTimestamps getEventTimestamps() {
            return this.eventTimestamps;
        }

        @Override
        @RosettaAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        @RuneAttribute(value="reportingAndCounterPartyModel", isRequired=true)
        public ReportingAndCounterPartyModel getReportingAndCounterPartyModel() {
            return this.reportingAndCounterPartyModel;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public ReportingNotionalChangeModel getReportingNotionalChangeModel() {
            return this.reportingNotionalChangeModel;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public List<? extends NonNegativePayment> getPayment() {
            return this.payment;
        }

        @Override
        @RosettaAttribute(value="applicableRegulations")
        @RuneAttribute(value="applicableRegulations")
        public ApplicableRegulations getApplicableRegulations() {
            return this.applicableRegulations;
        }

        @Override
        @RosettaAttribute(value="regulationSpecificInformation")
        @RuneAttribute(value="regulationSpecificInformation")
        public RegulationDetails getRegulationSpecificInformation() {
            return this.regulationSpecificInformation;
        }

        @Override
        @RosettaAttribute(value="cpmiIoscoCDE")
        @RuneAttribute(value="cpmiIoscoCDE")
        public RegReportingCDE getCpmiIoscoCDE() {
            return this.cpmiIoscoCDE;
        }

        @Override
        @RosettaAttribute(value="trade", isRequired=true)
        @RuneAttribute(value="trade", isRequired=true)
        public Trade getTrade() {
            return this.trade;
        }

        @Override
        @RosettaAttribute(value="quote")
        @RuneAttribute(value="quote")
        public List<? extends BasicQuotation> getQuote() {
            return this.quote;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization> getCollateralization() {
            return this.collateralization;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        public RegulatoryDisclosure build() {
            return this;
        }

        @Override
        public RegulatoryDisclosureBuilder toBuilder() {
            RegulatoryDisclosureBuilder builder = RegulatoryDisclosure.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryDisclosureBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getIsCorrection()).ifPresent(builder::setIsCorrection);
            Optional.ofNullable(this.getOnBehalfOf()).ifPresent(builder::setOnBehalfOf);
            Optional.ofNullable(this.getAsOfDate()).ifPresent(builder::setAsOfDate);
            Optional.ofNullable(this.getAsOfTime()).ifPresent(builder::setAsOfTime);
            Optional.ofNullable(this.getEventId()).ifPresent(builder::setEventId);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getEventTimestamps()).ifPresent(builder::setEventTimestamps);
            Optional.ofNullable(this.getReportingAndCounterPartyModel()).ifPresent(builder::setReportingAndCounterPartyModel);
            Optional.ofNullable(this.getReportingNotionalChangeModel()).ifPresent(builder::setReportingNotionalChangeModel);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
            Optional.ofNullable(this.getApplicableRegulations()).ifPresent(builder::setApplicableRegulations);
            Optional.ofNullable(this.getRegulationSpecificInformation()).ifPresent(builder::setRegulationSpecificInformation);
            Optional.ofNullable(this.getCpmiIoscoCDE()).ifPresent(builder::setCpmiIoscoCDE);
            Optional.ofNullable(this.getTrade()).ifPresent(builder::setTrade);
            Optional.ofNullable(this.getQuote()).ifPresent(builder::setQuote);
            Optional.ofNullable(this.getCollateralization()).ifPresent(builder::setCollateralization);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryDisclosure _that = (RegulatoryDisclosure)this.getType().cast(o);
            if (!Objects.equals(this.isCorrection, _that.getIsCorrection())) {
                return false;
            }
            if (!ListEquals.listEquals(this.onBehalfOf, _that.getOnBehalfOf())) {
                return false;
            }
            if (!Objects.equals(this.asOfDate, _that.getAsOfDate())) {
                return false;
            }
            if (!Objects.equals(this.asOfTime, _that.getAsOfTime())) {
                return false;
            }
            if (!Objects.equals(this.eventId, _that.getEventId())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.eventTimestamps, _that.getEventTimestamps())) {
                return false;
            }
            if (!Objects.equals(this.reportingAndCounterPartyModel, _that.getReportingAndCounterPartyModel())) {
                return false;
            }
            if (!Objects.equals(this.reportingNotionalChangeModel, _that.getReportingNotionalChangeModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.payment, _that.getPayment())) {
                return false;
            }
            if (!Objects.equals(this.applicableRegulations, _that.getApplicableRegulations())) {
                return false;
            }
            if (!Objects.equals(this.regulationSpecificInformation, _that.getRegulationSpecificInformation())) {
                return false;
            }
            if (!Objects.equals(this.cpmiIoscoCDE, _that.getCpmiIoscoCDE())) {
                return false;
            }
            if (!Objects.equals(this.trade, _that.getTrade())) {
                return false;
            }
            if (!ListEquals.listEquals(this.quote, _that.getQuote())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            return ListEquals.listEquals(this.party, _that.getParty());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.isCorrection != null ? this.isCorrection.hashCode() : 0);
            _result = 31 * _result + (this.onBehalfOf != null ? this.onBehalfOf.hashCode() : 0);
            _result = 31 * _result + (this.asOfDate != null ? this.asOfDate.hashCode() : 0);
            _result = 31 * _result + (this.asOfTime != null ? this.asOfTime.hashCode() : 0);
            _result = 31 * _result + (this.eventId != null ? this.eventId.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.eventTimestamps != null ? this.eventTimestamps.hashCode() : 0);
            _result = 31 * _result + (this.reportingAndCounterPartyModel != null ? this.reportingAndCounterPartyModel.hashCode() : 0);
            _result = 31 * _result + (this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            _result = 31 * _result + (this.applicableRegulations != null ? this.applicableRegulations.hashCode() : 0);
            _result = 31 * _result + (this.regulationSpecificInformation != null ? this.regulationSpecificInformation.hashCode() : 0);
            _result = 31 * _result + (this.cpmiIoscoCDE != null ? this.cpmiIoscoCDE.hashCode() : 0);
            _result = 31 * _result + (this.trade != null ? this.trade.hashCode() : 0);
            _result = 31 * _result + (this.quote != null ? this.quote.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryDisclosure {isCorrection=" + this.isCorrection + ", onBehalfOf=" + String.valueOf(this.onBehalfOf) + ", asOfDate=" + String.valueOf(this.asOfDate) + ", asOfTime=" + String.valueOf(this.asOfTime) + ", eventId=" + String.valueOf(this.eventId) + ", eventType=" + String.valueOf(this.eventType) + ", eventTimestamps=" + String.valueOf(this.eventTimestamps) + ", reportingAndCounterPartyModel=" + String.valueOf(this.reportingAndCounterPartyModel) + ", reportingNotionalChangeModel=" + String.valueOf(this.reportingNotionalChangeModel) + ", payment=" + String.valueOf(this.payment) + ", applicableRegulations=" + String.valueOf(this.applicableRegulations) + ", regulationSpecificInformation=" + String.valueOf(this.regulationSpecificInformation) + ", cpmiIoscoCDE=" + String.valueOf(this.cpmiIoscoCDE) + ", trade=" + String.valueOf(this.trade) + ", quote=" + String.valueOf(this.quote) + ", collateralization=" + String.valueOf(this.collateralization) + ", party=" + String.valueOf(this.party) + "} " + super.toString();
        }
    }
}

