/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.EntityClassification;
import fpml.consolidated.doc.PartyRelationshipType;
import fpml.consolidated.fpmlenum.EMIRSupervisoryBodyEnum;
import fpml.consolidated.recordkeeping.processes.ESMALevel3Model;
import fpml.consolidated.recordkeeping.processes.RegulatoryClassification;
import fpml.consolidated.recordkeeping.processes.ReportingRoleAndPurposeModel;
import fpml.consolidated.recordkeeping.processes.meta.RegulatoryClassificationEMIR_2015Meta;
import fpml.consolidated.shared.ActionType;
import fpml.consolidated.shared.RegulatoryBuyerAndSellerModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="RegulatoryClassificationEMIR_2015", builder=RegulatoryClassificationEMIR_2015BuilderImpl.class, version="1.2.2")
@RuneDataType(value="RegulatoryClassificationEMIR_2015", model="fpml", builder=RegulatoryClassificationEMIR_2015BuilderImpl.class, version="1.2.2")
public interface RegulatoryClassificationEMIR_2015
extends RegulatoryClassification {
    public static final RegulatoryClassificationEMIR_2015Meta metaData = new RegulatoryClassificationEMIR_2015Meta();

    public List<EMIRSupervisoryBodyEnum> getSupervisoryBody();

    public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel();

    public RegulatoryBuyerAndSellerModel getRegulatoryBuyerAndSellerModel();

    public PartyRelationshipType getTradePartyRelationshipType();

    public ActionType getActionType();

    public Boolean getMandatorilyClearable();

    public Boolean getExceedsClearingThreshold();

    public EntityClassification getReportingPartyClassification();

    public EntityClassification getCounterPartyClassification();

    public Boolean getCounterPartyisEEA();

    public ESMALevel3Model getEsmaLevel3Model();

    @Override
    public RegulatoryClassificationEMIR_2015 build();

    @Override
    public RegulatoryClassificationEMIR_2015Builder toBuilder();

    public static RegulatoryClassificationEMIR_2015Builder builder() {
        return new RegulatoryClassificationEMIR_2015BuilderImpl();
    }

    default public RosettaMetaData<? extends RegulatoryClassificationEMIR_2015> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends RegulatoryClassificationEMIR_2015> getType() {
        return RegulatoryClassificationEMIR_2015.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("supervisoryBody"), EMIRSupervisoryBodyEnum.class, this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulatoryBuyerAndSellerModel"), processor, RegulatoryBuyerAndSellerModel.class, this.getRegulatoryBuyerAndSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradePartyRelationshipType"), processor, PartyRelationshipType.class, this.getTradePartyRelationshipType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("actionType"), processor, ActionType.class, this.getActionType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("mandatorilyClearable"), Boolean.class, (Object)this.getMandatorilyClearable(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exceedsClearingThreshold"), Boolean.class, (Object)this.getExceedsClearingThreshold(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingPartyClassification"), processor, EntityClassification.class, this.getReportingPartyClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterPartyClassification"), processor, EntityClassification.class, this.getCounterPartyClassification(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterPartyisEEA"), Boolean.class, (Object)this.getCounterPartyisEEA(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("esmaLevel3Model"), processor, ESMALevel3Model.class, this.getEsmaLevel3Model(), new AttributeMeta[0]);
    }

    public static class RegulatoryClassificationEMIR_2015BuilderImpl
    extends RegulatoryClassification.RegulatoryClassificationBuilderImpl
    implements RegulatoryClassificationEMIR_2015Builder {
        protected List<EMIRSupervisoryBodyEnum> supervisoryBody = new ArrayList<EMIRSupervisoryBodyEnum>();
        protected ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder reportingRoleAndPurposeModel;
        protected RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder regulatoryBuyerAndSellerModel;
        protected PartyRelationshipType.PartyRelationshipTypeBuilder tradePartyRelationshipType;
        protected ActionType.ActionTypeBuilder actionType;
        protected Boolean mandatorilyClearable;
        protected Boolean exceedsClearingThreshold;
        protected EntityClassification.EntityClassificationBuilder reportingPartyClassification;
        protected EntityClassification.EntityClassificationBuilder counterPartyClassification;
        protected Boolean counterPartyisEEA;
        protected ESMALevel3Model.ESMALevel3ModelBuilder esmaLevel3Model;

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<EMIRSupervisoryBodyEnum> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel() {
            ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder result = this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel : (this.reportingRoleAndPurposeModel = ReportingRoleAndPurposeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getRegulatoryBuyerAndSellerModel() {
            return this.regulatoryBuyerAndSellerModel;
        }

        @Override
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getOrCreateRegulatoryBuyerAndSellerModel() {
            RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder result = this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel : (this.regulatoryBuyerAndSellerModel = RegulatoryBuyerAndSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradePartyRelationshipType")
        @RuneAttribute(value="tradePartyRelationshipType")
        public PartyRelationshipType.PartyRelationshipTypeBuilder getTradePartyRelationshipType() {
            return this.tradePartyRelationshipType;
        }

        @Override
        public PartyRelationshipType.PartyRelationshipTypeBuilder getOrCreateTradePartyRelationshipType() {
            PartyRelationshipType.PartyRelationshipTypeBuilder result = this.tradePartyRelationshipType != null ? this.tradePartyRelationshipType : (this.tradePartyRelationshipType = PartyRelationshipType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ActionType.ActionTypeBuilder getActionType() {
            return this.actionType;
        }

        @Override
        public ActionType.ActionTypeBuilder getOrCreateActionType() {
            ActionType.ActionTypeBuilder result = this.actionType != null ? this.actionType : (this.actionType = ActionType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public Boolean getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public Boolean getExceedsClearingThreshold() {
            return this.exceedsClearingThreshold;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClassification")
        @RuneAttribute(value="reportingPartyClassification")
        public EntityClassification.EntityClassificationBuilder getReportingPartyClassification() {
            return this.reportingPartyClassification;
        }

        @Override
        public EntityClassification.EntityClassificationBuilder getOrCreateReportingPartyClassification() {
            EntityClassification.EntityClassificationBuilder result = this.reportingPartyClassification != null ? this.reportingPartyClassification : (this.reportingPartyClassification = EntityClassification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterPartyClassification")
        @RuneAttribute(value="counterPartyClassification")
        public EntityClassification.EntityClassificationBuilder getCounterPartyClassification() {
            return this.counterPartyClassification;
        }

        @Override
        public EntityClassification.EntityClassificationBuilder getOrCreateCounterPartyClassification() {
            EntityClassification.EntityClassificationBuilder result = this.counterPartyClassification != null ? this.counterPartyClassification : (this.counterPartyClassification = EntityClassification.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterPartyisEEA")
        @RuneAttribute(value="counterPartyisEEA")
        public Boolean getCounterPartyisEEA() {
            return this.counterPartyisEEA;
        }

        @Override
        @RosettaAttribute(value="esmaLevel3Model")
        @RuneAttribute(value="esmaLevel3Model")
        public ESMALevel3Model.ESMALevel3ModelBuilder getEsmaLevel3Model() {
            return this.esmaLevel3Model;
        }

        @Override
        public ESMALevel3Model.ESMALevel3ModelBuilder getOrCreateEsmaLevel3Model() {
            ESMALevel3Model.ESMALevel3ModelBuilder result = this.esmaLevel3Model != null ? this.esmaLevel3Model : (this.esmaLevel3Model = ESMALevel3Model.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(EMIRSupervisoryBodyEnum _supervisoryBody) {
            if (_supervisoryBody != null) {
                this.supervisoryBody.add(_supervisoryBody);
            }
            return this;
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(EMIRSupervisoryBodyEnum _supervisoryBody, int idx) {
            this.getIndex(this.supervisoryBody, idx, () -> _supervisoryBody);
            return this;
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(List<EMIRSupervisoryBodyEnum> supervisoryBodys) {
            if (supervisoryBodys != null) {
                for (EMIRSupervisoryBodyEnum toAdd : supervisoryBodys) {
                    this.supervisoryBody.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="supervisoryBody")
        public RegulatoryClassificationEMIR_2015Builder setSupervisoryBody(List<EMIRSupervisoryBodyEnum> supervisoryBodys) {
            this.supervisoryBody = supervisoryBodys == null ? new ArrayList<EMIRSupervisoryBodyEnum>() : (List)supervisoryBodys.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public RegulatoryClassificationEMIR_2015Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel _reportingRoleAndPurposeModel) {
            this.reportingRoleAndPurposeModel = _reportingRoleAndPurposeModel == null ? null : _reportingRoleAndPurposeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryClassificationEMIR_2015Builder setRegulatoryBuyerAndSellerModel(RegulatoryBuyerAndSellerModel _regulatoryBuyerAndSellerModel) {
            this.regulatoryBuyerAndSellerModel = _regulatoryBuyerAndSellerModel == null ? null : _regulatoryBuyerAndSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradePartyRelationshipType")
        @RuneAttribute(value="tradePartyRelationshipType")
        public RegulatoryClassificationEMIR_2015Builder setTradePartyRelationshipType(PartyRelationshipType _tradePartyRelationshipType) {
            this.tradePartyRelationshipType = _tradePartyRelationshipType == null ? null : _tradePartyRelationshipType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public RegulatoryClassificationEMIR_2015Builder setActionType(ActionType _actionType) {
            this.actionType = _actionType == null ? null : _actionType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public RegulatoryClassificationEMIR_2015Builder setMandatorilyClearable(Boolean _mandatorilyClearable) {
            this.mandatorilyClearable = _mandatorilyClearable == null ? null : _mandatorilyClearable;
            return this;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public RegulatoryClassificationEMIR_2015Builder setExceedsClearingThreshold(Boolean _exceedsClearingThreshold) {
            this.exceedsClearingThreshold = _exceedsClearingThreshold == null ? null : _exceedsClearingThreshold;
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClassification")
        @RuneAttribute(value="reportingPartyClassification")
        public RegulatoryClassificationEMIR_2015Builder setReportingPartyClassification(EntityClassification _reportingPartyClassification) {
            this.reportingPartyClassification = _reportingPartyClassification == null ? null : _reportingPartyClassification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterPartyClassification")
        @RuneAttribute(value="counterPartyClassification")
        public RegulatoryClassificationEMIR_2015Builder setCounterPartyClassification(EntityClassification _counterPartyClassification) {
            this.counterPartyClassification = _counterPartyClassification == null ? null : _counterPartyClassification.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterPartyisEEA")
        @RuneAttribute(value="counterPartyisEEA")
        public RegulatoryClassificationEMIR_2015Builder setCounterPartyisEEA(Boolean _counterPartyisEEA) {
            this.counterPartyisEEA = _counterPartyisEEA == null ? null : _counterPartyisEEA;
            return this;
        }

        @Override
        @RosettaAttribute(value="esmaLevel3Model")
        @RuneAttribute(value="esmaLevel3Model")
        public RegulatoryClassificationEMIR_2015Builder setEsmaLevel3Model(ESMALevel3Model _esmaLevel3Model) {
            this.esmaLevel3Model = _esmaLevel3Model == null ? null : _esmaLevel3Model.toBuilder();
            return this;
        }

        @Override
        public RegulatoryClassificationEMIR_2015 build() {
            return new RegulatoryClassificationEMIR_2015Impl(this);
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder toBuilder() {
            return this;
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder prune() {
            super.prune();
            if (this.reportingRoleAndPurposeModel != null && !this.reportingRoleAndPurposeModel.prune().hasData()) {
                this.reportingRoleAndPurposeModel = null;
            }
            if (this.regulatoryBuyerAndSellerModel != null && !this.regulatoryBuyerAndSellerModel.prune().hasData()) {
                this.regulatoryBuyerAndSellerModel = null;
            }
            if (this.tradePartyRelationshipType != null && !this.tradePartyRelationshipType.prune().hasData()) {
                this.tradePartyRelationshipType = null;
            }
            if (this.actionType != null && !this.actionType.prune().hasData()) {
                this.actionType = null;
            }
            if (this.reportingPartyClassification != null && !this.reportingPartyClassification.prune().hasData()) {
                this.reportingPartyClassification = null;
            }
            if (this.counterPartyClassification != null && !this.counterPartyClassification.prune().hasData()) {
                this.counterPartyClassification = null;
            }
            if (this.esmaLevel3Model != null && !this.esmaLevel3Model.prune().hasData()) {
                this.esmaLevel3Model = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getSupervisoryBody() != null && !this.getSupervisoryBody().isEmpty()) {
                return true;
            }
            if (this.getReportingRoleAndPurposeModel() != null && this.getReportingRoleAndPurposeModel().hasData()) {
                return true;
            }
            if (this.getRegulatoryBuyerAndSellerModel() != null && this.getRegulatoryBuyerAndSellerModel().hasData()) {
                return true;
            }
            if (this.getTradePartyRelationshipType() != null && this.getTradePartyRelationshipType().hasData()) {
                return true;
            }
            if (this.getActionType() != null && this.getActionType().hasData()) {
                return true;
            }
            if (this.getMandatorilyClearable() != null) {
                return true;
            }
            if (this.getExceedsClearingThreshold() != null) {
                return true;
            }
            if (this.getReportingPartyClassification() != null && this.getReportingPartyClassification().hasData()) {
                return true;
            }
            if (this.getCounterPartyClassification() != null && this.getCounterPartyClassification().hasData()) {
                return true;
            }
            if (this.getCounterPartyisEEA() != null) {
                return true;
            }
            return this.getEsmaLevel3Model() != null && this.getEsmaLevel3Model().hasData();
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            RegulatoryClassificationEMIR_2015Builder o = (RegulatoryClassificationEMIR_2015Builder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingRoleAndPurposeModel(), (RosettaModelObjectBuilder)o.getReportingRoleAndPurposeModel(), this::setReportingRoleAndPurposeModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRegulatoryBuyerAndSellerModel(), (RosettaModelObjectBuilder)o.getRegulatoryBuyerAndSellerModel(), this::setRegulatoryBuyerAndSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradePartyRelationshipType(), (RosettaModelObjectBuilder)o.getTradePartyRelationshipType(), this::setTradePartyRelationshipType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getActionType(), (RosettaModelObjectBuilder)o.getActionType(), this::setActionType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingPartyClassification(), (RosettaModelObjectBuilder)o.getReportingPartyClassification(), this::setReportingPartyClassification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterPartyClassification(), (RosettaModelObjectBuilder)o.getCounterPartyClassification(), this::setCounterPartyClassification);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEsmaLevel3Model(), (RosettaModelObjectBuilder)o.getEsmaLevel3Model(), this::setEsmaLevel3Model);
            merger.mergeBasic(this.getSupervisoryBody(), o.getSupervisoryBody(), this::addSupervisoryBody);
            merger.mergeBasic((Object)this.getMandatorilyClearable(), (Object)o.getMandatorilyClearable(), this::setMandatorilyClearable, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getExceedsClearingThreshold(), (Object)o.getExceedsClearingThreshold(), this::setExceedsClearingThreshold, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterPartyisEEA(), (Object)o.getCounterPartyisEEA(), this::setCounterPartyisEEA, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationEMIR_2015 _that = (RegulatoryClassificationEMIR_2015)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryBuyerAndSellerModel, _that.getRegulatoryBuyerAndSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.tradePartyRelationshipType, _that.getTradePartyRelationshipType())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.exceedsClearingThreshold, _that.getExceedsClearingThreshold())) {
                return false;
            }
            if (!Objects.equals(this.reportingPartyClassification, _that.getReportingPartyClassification())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyClassification, _that.getCounterPartyClassification())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyisEEA, _that.getCounterPartyisEEA())) {
                return false;
            }
            return Objects.equals(this.esmaLevel3Model, _that.getEsmaLevel3Model());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.tradePartyRelationshipType != null ? this.tradePartyRelationshipType.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.exceedsClearingThreshold != null ? this.exceedsClearingThreshold.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyClassification != null ? this.reportingPartyClassification.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyClassification != null ? this.counterPartyClassification.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyisEEA != null ? this.counterPartyisEEA.hashCode() : 0);
            _result = 31 * _result + (this.esmaLevel3Model != null ? this.esmaLevel3Model.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationEMIR_2015Builder {supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", reportingRoleAndPurposeModel=" + String.valueOf(this.reportingRoleAndPurposeModel) + ", regulatoryBuyerAndSellerModel=" + String.valueOf(this.regulatoryBuyerAndSellerModel) + ", tradePartyRelationshipType=" + String.valueOf(this.tradePartyRelationshipType) + ", actionType=" + String.valueOf(this.actionType) + ", mandatorilyClearable=" + this.mandatorilyClearable + ", exceedsClearingThreshold=" + this.exceedsClearingThreshold + ", reportingPartyClassification=" + String.valueOf(this.reportingPartyClassification) + ", counterPartyClassification=" + String.valueOf(this.counterPartyClassification) + ", counterPartyisEEA=" + this.counterPartyisEEA + ", esmaLevel3Model=" + String.valueOf(this.esmaLevel3Model) + "} " + super.toString();
        }
    }

    public static interface RegulatoryClassificationEMIR_2015Builder
    extends RegulatoryClassificationEMIR_2015,
    RegulatoryClassification.RegulatoryClassificationBuilder {
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getOrCreateReportingRoleAndPurposeModel();

        @Override
        public ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder getReportingRoleAndPurposeModel();

        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getOrCreateRegulatoryBuyerAndSellerModel();

        @Override
        public RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder getRegulatoryBuyerAndSellerModel();

        public PartyRelationshipType.PartyRelationshipTypeBuilder getOrCreateTradePartyRelationshipType();

        @Override
        public PartyRelationshipType.PartyRelationshipTypeBuilder getTradePartyRelationshipType();

        public ActionType.ActionTypeBuilder getOrCreateActionType();

        @Override
        public ActionType.ActionTypeBuilder getActionType();

        public EntityClassification.EntityClassificationBuilder getOrCreateReportingPartyClassification();

        @Override
        public EntityClassification.EntityClassificationBuilder getReportingPartyClassification();

        public EntityClassification.EntityClassificationBuilder getOrCreateCounterPartyClassification();

        @Override
        public EntityClassification.EntityClassificationBuilder getCounterPartyClassification();

        public ESMALevel3Model.ESMALevel3ModelBuilder getOrCreateEsmaLevel3Model();

        @Override
        public ESMALevel3Model.ESMALevel3ModelBuilder getEsmaLevel3Model();

        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(EMIRSupervisoryBodyEnum var1);

        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(EMIRSupervisoryBodyEnum var1, int var2);

        public RegulatoryClassificationEMIR_2015Builder addSupervisoryBody(List<EMIRSupervisoryBodyEnum> var1);

        public RegulatoryClassificationEMIR_2015Builder setSupervisoryBody(List<EMIRSupervisoryBodyEnum> var1);

        public RegulatoryClassificationEMIR_2015Builder setReportingRoleAndPurposeModel(ReportingRoleAndPurposeModel var1);

        public RegulatoryClassificationEMIR_2015Builder setRegulatoryBuyerAndSellerModel(RegulatoryBuyerAndSellerModel var1);

        public RegulatoryClassificationEMIR_2015Builder setTradePartyRelationshipType(PartyRelationshipType var1);

        public RegulatoryClassificationEMIR_2015Builder setActionType(ActionType var1);

        public RegulatoryClassificationEMIR_2015Builder setMandatorilyClearable(Boolean var1);

        public RegulatoryClassificationEMIR_2015Builder setExceedsClearingThreshold(Boolean var1);

        public RegulatoryClassificationEMIR_2015Builder setReportingPartyClassification(EntityClassification var1);

        public RegulatoryClassificationEMIR_2015Builder setCounterPartyClassification(EntityClassification var1);

        public RegulatoryClassificationEMIR_2015Builder setCounterPartyisEEA(Boolean var1);

        public RegulatoryClassificationEMIR_2015Builder setEsmaLevel3Model(ESMALevel3Model var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("supervisoryBody"), EMIRSupervisoryBodyEnum.class, this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingRoleAndPurposeModel"), processor, ReportingRoleAndPurposeModel.ReportingRoleAndPurposeModelBuilder.class, this.getReportingRoleAndPurposeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulatoryBuyerAndSellerModel"), processor, RegulatoryBuyerAndSellerModel.RegulatoryBuyerAndSellerModelBuilder.class, this.getRegulatoryBuyerAndSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradePartyRelationshipType"), processor, PartyRelationshipType.PartyRelationshipTypeBuilder.class, this.getTradePartyRelationshipType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("actionType"), processor, ActionType.ActionTypeBuilder.class, this.getActionType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("mandatorilyClearable"), Boolean.class, (Object)this.getMandatorilyClearable(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exceedsClearingThreshold"), Boolean.class, (Object)this.getExceedsClearingThreshold(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingPartyClassification"), processor, EntityClassification.EntityClassificationBuilder.class, this.getReportingPartyClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterPartyClassification"), processor, EntityClassification.EntityClassificationBuilder.class, this.getCounterPartyClassification(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterPartyisEEA"), Boolean.class, (Object)this.getCounterPartyisEEA(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("esmaLevel3Model"), processor, ESMALevel3Model.ESMALevel3ModelBuilder.class, this.getEsmaLevel3Model(), new AttributeMeta[0]);
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder prune();
    }

    public static class RegulatoryClassificationEMIR_2015Impl
    extends RegulatoryClassification.RegulatoryClassificationImpl
    implements RegulatoryClassificationEMIR_2015 {
        private final List<EMIRSupervisoryBodyEnum> supervisoryBody;
        private final ReportingRoleAndPurposeModel reportingRoleAndPurposeModel;
        private final RegulatoryBuyerAndSellerModel regulatoryBuyerAndSellerModel;
        private final PartyRelationshipType tradePartyRelationshipType;
        private final ActionType actionType;
        private final Boolean mandatorilyClearable;
        private final Boolean exceedsClearingThreshold;
        private final EntityClassification reportingPartyClassification;
        private final EntityClassification counterPartyClassification;
        private final Boolean counterPartyisEEA;
        private final ESMALevel3Model esmaLevel3Model;

        protected RegulatoryClassificationEMIR_2015Impl(RegulatoryClassificationEMIR_2015Builder builder) {
            super(builder);
            this.supervisoryBody = Optional.ofNullable(builder.getSupervisoryBody()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
            this.reportingRoleAndPurposeModel = Optional.ofNullable(builder.getReportingRoleAndPurposeModel()).map(f -> f.build()).orElse(null);
            this.regulatoryBuyerAndSellerModel = Optional.ofNullable(builder.getRegulatoryBuyerAndSellerModel()).map(f -> f.build()).orElse(null);
            this.tradePartyRelationshipType = Optional.ofNullable(builder.getTradePartyRelationshipType()).map(f -> f.build()).orElse(null);
            this.actionType = Optional.ofNullable(builder.getActionType()).map(f -> f.build()).orElse(null);
            this.mandatorilyClearable = builder.getMandatorilyClearable();
            this.exceedsClearingThreshold = builder.getExceedsClearingThreshold();
            this.reportingPartyClassification = Optional.ofNullable(builder.getReportingPartyClassification()).map(f -> f.build()).orElse(null);
            this.counterPartyClassification = Optional.ofNullable(builder.getCounterPartyClassification()).map(f -> f.build()).orElse(null);
            this.counterPartyisEEA = builder.getCounterPartyisEEA();
            this.esmaLevel3Model = Optional.ofNullable(builder.getEsmaLevel3Model()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="supervisoryBody")
        @RuneAttribute(value="supervisoryBody")
        public List<EMIRSupervisoryBodyEnum> getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        @RuneAttribute(value="reportingRoleAndPurposeModel", isRequired=true)
        public ReportingRoleAndPurposeModel getReportingRoleAndPurposeModel() {
            return this.reportingRoleAndPurposeModel;
        }

        @Override
        @RosettaAttribute(value="regulatoryBuyerAndSellerModel")
        @RuneAttribute(value="regulatoryBuyerAndSellerModel")
        public RegulatoryBuyerAndSellerModel getRegulatoryBuyerAndSellerModel() {
            return this.regulatoryBuyerAndSellerModel;
        }

        @Override
        @RosettaAttribute(value="tradePartyRelationshipType")
        @RuneAttribute(value="tradePartyRelationshipType")
        public PartyRelationshipType getTradePartyRelationshipType() {
            return this.tradePartyRelationshipType;
        }

        @Override
        @RosettaAttribute(value="actionType")
        @RuneAttribute(value="actionType")
        public ActionType getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="mandatorilyClearable")
        @RuneAttribute(value="mandatorilyClearable")
        public Boolean getMandatorilyClearable() {
            return this.mandatorilyClearable;
        }

        @Override
        @RosettaAttribute(value="exceedsClearingThreshold")
        @RuneAttribute(value="exceedsClearingThreshold")
        public Boolean getExceedsClearingThreshold() {
            return this.exceedsClearingThreshold;
        }

        @Override
        @RosettaAttribute(value="reportingPartyClassification")
        @RuneAttribute(value="reportingPartyClassification")
        public EntityClassification getReportingPartyClassification() {
            return this.reportingPartyClassification;
        }

        @Override
        @RosettaAttribute(value="counterPartyClassification")
        @RuneAttribute(value="counterPartyClassification")
        public EntityClassification getCounterPartyClassification() {
            return this.counterPartyClassification;
        }

        @Override
        @RosettaAttribute(value="counterPartyisEEA")
        @RuneAttribute(value="counterPartyisEEA")
        public Boolean getCounterPartyisEEA() {
            return this.counterPartyisEEA;
        }

        @Override
        @RosettaAttribute(value="esmaLevel3Model")
        @RuneAttribute(value="esmaLevel3Model")
        public ESMALevel3Model getEsmaLevel3Model() {
            return this.esmaLevel3Model;
        }

        @Override
        public RegulatoryClassificationEMIR_2015 build() {
            return this;
        }

        @Override
        public RegulatoryClassificationEMIR_2015Builder toBuilder() {
            RegulatoryClassificationEMIR_2015Builder builder = RegulatoryClassificationEMIR_2015.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(RegulatoryClassificationEMIR_2015Builder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getReportingRoleAndPurposeModel()).ifPresent(builder::setReportingRoleAndPurposeModel);
            Optional.ofNullable(this.getRegulatoryBuyerAndSellerModel()).ifPresent(builder::setRegulatoryBuyerAndSellerModel);
            Optional.ofNullable(this.getTradePartyRelationshipType()).ifPresent(builder::setTradePartyRelationshipType);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getMandatorilyClearable()).ifPresent(builder::setMandatorilyClearable);
            Optional.ofNullable(this.getExceedsClearingThreshold()).ifPresent(builder::setExceedsClearingThreshold);
            Optional.ofNullable(this.getReportingPartyClassification()).ifPresent(builder::setReportingPartyClassification);
            Optional.ofNullable(this.getCounterPartyClassification()).ifPresent(builder::setCounterPartyClassification);
            Optional.ofNullable(this.getCounterPartyisEEA()).ifPresent(builder::setCounterPartyisEEA);
            Optional.ofNullable(this.getEsmaLevel3Model()).ifPresent(builder::setEsmaLevel3Model);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            RegulatoryClassificationEMIR_2015 _that = (RegulatoryClassificationEMIR_2015)this.getType().cast(o);
            if (!ListEquals.listEquals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            if (!Objects.equals(this.reportingRoleAndPurposeModel, _that.getReportingRoleAndPurposeModel())) {
                return false;
            }
            if (!Objects.equals(this.regulatoryBuyerAndSellerModel, _that.getRegulatoryBuyerAndSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.tradePartyRelationshipType, _that.getTradePartyRelationshipType())) {
                return false;
            }
            if (!Objects.equals(this.actionType, _that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.mandatorilyClearable, _that.getMandatorilyClearable())) {
                return false;
            }
            if (!Objects.equals(this.exceedsClearingThreshold, _that.getExceedsClearingThreshold())) {
                return false;
            }
            if (!Objects.equals(this.reportingPartyClassification, _that.getReportingPartyClassification())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyClassification, _that.getCounterPartyClassification())) {
                return false;
            }
            if (!Objects.equals(this.counterPartyisEEA, _that.getCounterPartyisEEA())) {
                return false;
            }
            return Objects.equals(this.esmaLevel3Model, _that.getEsmaLevel3Model());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
            _result = 31 * _result + (this.reportingRoleAndPurposeModel != null ? this.reportingRoleAndPurposeModel.hashCode() : 0);
            _result = 31 * _result + (this.regulatoryBuyerAndSellerModel != null ? this.regulatoryBuyerAndSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.tradePartyRelationshipType != null ? this.tradePartyRelationshipType.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? this.actionType.hashCode() : 0);
            _result = 31 * _result + (this.mandatorilyClearable != null ? this.mandatorilyClearable.hashCode() : 0);
            _result = 31 * _result + (this.exceedsClearingThreshold != null ? this.exceedsClearingThreshold.hashCode() : 0);
            _result = 31 * _result + (this.reportingPartyClassification != null ? this.reportingPartyClassification.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyClassification != null ? this.counterPartyClassification.hashCode() : 0);
            _result = 31 * _result + (this.counterPartyisEEA != null ? this.counterPartyisEEA.hashCode() : 0);
            _result = 31 * _result + (this.esmaLevel3Model != null ? this.esmaLevel3Model.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "RegulatoryClassificationEMIR_2015 {supervisoryBody=" + String.valueOf(this.supervisoryBody) + ", reportingRoleAndPurposeModel=" + String.valueOf(this.reportingRoleAndPurposeModel) + ", regulatoryBuyerAndSellerModel=" + String.valueOf(this.regulatoryBuyerAndSellerModel) + ", tradePartyRelationshipType=" + String.valueOf(this.tradePartyRelationshipType) + ", actionType=" + String.valueOf(this.actionType) + ", mandatorilyClearable=" + this.mandatorilyClearable + ", exceedsClearingThreshold=" + this.exceedsClearingThreshold + ", reportingPartyClassification=" + String.valueOf(this.reportingPartyClassification) + ", counterPartyClassification=" + String.valueOf(this.counterPartyClassification) + ", counterPartyisEEA=" + this.counterPartyisEEA + ", esmaLevel3Model=" + String.valueOf(this.esmaLevel3Model) + "} " + super.toString();
        }
    }
}

