/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.recordkeeping.processes.meta.InapplicableRegulationSequenceMeta;
import fpml.consolidated.reg.fpmlreporting.shared.RegulationName;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InapplicableRegulationSequence", builder=InapplicableRegulationSequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="InapplicableRegulationSequence", model="fpml", builder=InapplicableRegulationSequenceBuilderImpl.class, version="1.2.2")
public interface InapplicableRegulationSequence
extends RosettaModelObject {
    public static final InapplicableRegulationSequenceMeta metaData = new InapplicableRegulationSequenceMeta();

    public String getSupervisoryBody();

    public List<? extends RegulationName> getRegulation();

    public InapplicableRegulationSequence build();

    public InapplicableRegulationSequenceBuilder toBuilder();

    public static InapplicableRegulationSequenceBuilder builder() {
        return new InapplicableRegulationSequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends InapplicableRegulationSequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InapplicableRegulationSequence> getType() {
        return InapplicableRegulationSequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("supervisoryBody"), String.class, (Object)this.getSupervisoryBody(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.class, this.getRegulation(), new AttributeMeta[0]);
    }

    public static class InapplicableRegulationSequenceBuilderImpl
    implements InapplicableRegulationSequenceBuilder {
        protected String supervisoryBody;
        protected List<RegulationName.RegulationNameBuilder> regulation = new ArrayList<RegulationName.RegulationNameBuilder>();

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public String getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public List<? extends RegulationName.RegulationNameBuilder> getRegulation() {
            return this.regulation;
        }

        @Override
        public RegulationName.RegulationNameBuilder getOrCreateRegulation(int index) {
            if (this.regulation == null) {
                this.regulation = new ArrayList<RegulationName.RegulationNameBuilder>();
            }
            return (RegulationName.RegulationNameBuilder)this.getIndex(this.regulation, index, () -> {
                RegulationName.RegulationNameBuilder newRegulation = RegulationName.builder();
                return newRegulation;
            });
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public InapplicableRegulationSequenceBuilder setSupervisoryBody(String _supervisoryBody) {
            this.supervisoryBody = _supervisoryBody == null ? null : _supervisoryBody;
            return this;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public InapplicableRegulationSequenceBuilder addRegulation(RegulationName _regulation) {
            if (_regulation != null) {
                this.regulation.add(_regulation.toBuilder());
            }
            return this;
        }

        @Override
        public InapplicableRegulationSequenceBuilder addRegulation(RegulationName _regulation, int idx) {
            this.getIndex(this.regulation, idx, () -> _regulation.toBuilder());
            return this;
        }

        @Override
        public InapplicableRegulationSequenceBuilder addRegulation(List<? extends RegulationName> regulations) {
            if (regulations != null) {
                for (RegulationName regulationName : regulations) {
                    this.regulation.add(regulationName.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="regulation")
        public InapplicableRegulationSequenceBuilder setRegulation(List<? extends RegulationName> regulations) {
            this.regulation = regulations == null ? new ArrayList<RegulationName.RegulationNameBuilder>() : (List)regulations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public InapplicableRegulationSequence build() {
            return new InapplicableRegulationSequenceImpl(this);
        }

        @Override
        public InapplicableRegulationSequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public InapplicableRegulationSequenceBuilder prune() {
            this.regulation = this.regulation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getSupervisoryBody() != null) {
                return true;
            }
            return this.getRegulation() != null && this.getRegulation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public InapplicableRegulationSequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            InapplicableRegulationSequenceBuilder o = (InapplicableRegulationSequenceBuilder)other;
            merger.mergeRosetta(this.getRegulation(), o.getRegulation(), this::getOrCreateRegulation);
            merger.mergeBasic((Object)this.getSupervisoryBody(), (Object)o.getSupervisoryBody(), this::setSupervisoryBody, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InapplicableRegulationSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            return ListEquals.listEquals(this.regulation, _that.getRegulation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InapplicableRegulationSequenceBuilder {supervisoryBody=" + this.supervisoryBody + ", regulation=" + String.valueOf(this.regulation) + "}";
        }
    }

    public static interface InapplicableRegulationSequenceBuilder
    extends InapplicableRegulationSequence,
    RosettaModelObjectBuilder {
        public RegulationName.RegulationNameBuilder getOrCreateRegulation(int var1);

        public List<? extends RegulationName.RegulationNameBuilder> getRegulation();

        public InapplicableRegulationSequenceBuilder setSupervisoryBody(String var1);

        public InapplicableRegulationSequenceBuilder addRegulation(RegulationName var1);

        public InapplicableRegulationSequenceBuilder addRegulation(RegulationName var1, int var2);

        public InapplicableRegulationSequenceBuilder addRegulation(List<? extends RegulationName> var1);

        public InapplicableRegulationSequenceBuilder setRegulation(List<? extends RegulationName> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("supervisoryBody"), String.class, (Object)this.getSupervisoryBody(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("regulation"), processor, RegulationName.RegulationNameBuilder.class, this.getRegulation(), new AttributeMeta[0]);
        }

        public InapplicableRegulationSequenceBuilder prune();
    }

    public static class InapplicableRegulationSequenceImpl
    implements InapplicableRegulationSequence {
        private final String supervisoryBody;
        private final List<? extends RegulationName> regulation;

        protected InapplicableRegulationSequenceImpl(InapplicableRegulationSequenceBuilder builder) {
            this.supervisoryBody = builder.getSupervisoryBody();
            this.regulation = Optional.ofNullable(builder.getRegulation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="supervisoryBody", isRequired=true)
        @RuneAttribute(value="supervisoryBody", isRequired=true)
        public String getSupervisoryBody() {
            return this.supervisoryBody;
        }

        @Override
        @RosettaAttribute(value="regulation")
        @RuneAttribute(value="regulation")
        public List<? extends RegulationName> getRegulation() {
            return this.regulation;
        }

        @Override
        public InapplicableRegulationSequence build() {
            return this;
        }

        @Override
        public InapplicableRegulationSequenceBuilder toBuilder() {
            InapplicableRegulationSequenceBuilder builder = InapplicableRegulationSequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InapplicableRegulationSequenceBuilder builder) {
            Optional.ofNullable(this.getSupervisoryBody()).ifPresent(builder::setSupervisoryBody);
            Optional.ofNullable(this.getRegulation()).ifPresent(builder::setRegulation);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            InapplicableRegulationSequence _that = this.getType().cast(o);
            if (!Objects.equals(this.supervisoryBody, _that.getSupervisoryBody())) {
                return false;
            }
            return ListEquals.listEquals(this.regulation, _that.getRegulation());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.supervisoryBody != null ? this.supervisoryBody.hashCode() : 0);
            _result = 31 * _result + (this.regulation != null ? this.regulation.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "InapplicableRegulationSequence {supervisoryBody=" + this.supervisoryBody + ", regulation=" + String.valueOf(this.regulation) + "}";
        }
    }
}

