/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.recordkeeping.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.recordkeeping.processes.ESMACreditSeniority;
import fpml.consolidated.recordkeeping.processes.meta.ESMACreditDetailsMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ESMACreditDetails", builder=ESMACreditDetailsBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ESMACreditDetails", model="fpml", builder=ESMACreditDetailsBuilderImpl.class, version="1.2.2")
public interface ESMACreditDetails
extends RosettaModelObject {
    public static final ESMACreditDetailsMeta metaData = new ESMACreditDetailsMeta();

    public ESMACreditSeniority getSeniority();

    public List<BigDecimal> getIndexFactor();

    public ESMACreditDetails build();

    public ESMACreditDetailsBuilder toBuilder();

    public static ESMACreditDetailsBuilder builder() {
        return new ESMACreditDetailsBuilderImpl();
    }

    default public RosettaMetaData<? extends ESMACreditDetails> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ESMACreditDetails> getType() {
        return ESMACreditDetails.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("seniority"), processor, ESMACreditSeniority.class, this.getSeniority(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, this.getIndexFactor(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ESMACreditDetailsBuilderImpl
    implements ESMACreditDetailsBuilder {
        protected ESMACreditSeniority.ESMACreditSeniorityBuilder seniority;
        protected List<BigDecimal> indexFactor = new ArrayList<BigDecimal>();

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public ESMACreditSeniority.ESMACreditSeniorityBuilder getSeniority() {
            return this.seniority;
        }

        @Override
        public ESMACreditSeniority.ESMACreditSeniorityBuilder getOrCreateSeniority() {
            ESMACreditSeniority.ESMACreditSeniorityBuilder result = this.seniority != null ? this.seniority : (this.seniority = ESMACreditSeniority.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public List<BigDecimal> getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public ESMACreditDetailsBuilder setSeniority(ESMACreditSeniority _seniority) {
            this.seniority = _seniority == null ? null : _seniority.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public ESMACreditDetailsBuilder addIndexFactor(BigDecimal _indexFactor) {
            if (_indexFactor != null) {
                this.indexFactor.add(_indexFactor);
            }
            return this;
        }

        @Override
        public ESMACreditDetailsBuilder addIndexFactor(BigDecimal _indexFactor, int idx) {
            this.getIndex(this.indexFactor, idx, () -> _indexFactor);
            return this;
        }

        @Override
        public ESMACreditDetailsBuilder addIndexFactor(List<BigDecimal> indexFactors) {
            if (indexFactors != null) {
                for (BigDecimal toAdd : indexFactors) {
                    this.indexFactor.add(toAdd);
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="indexFactor")
        public ESMACreditDetailsBuilder setIndexFactor(List<BigDecimal> indexFactors) {
            this.indexFactor = indexFactors == null ? new ArrayList<BigDecimal>() : (List)indexFactors.stream().collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ESMACreditDetails build() {
            return new ESMACreditDetailsImpl(this);
        }

        @Override
        public ESMACreditDetailsBuilder toBuilder() {
            return this;
        }

        @Override
        public ESMACreditDetailsBuilder prune() {
            if (this.seniority != null && !this.seniority.prune().hasData()) {
                this.seniority = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getSeniority() != null && this.getSeniority().hasData()) {
                return true;
            }
            return this.getIndexFactor() != null && !this.getIndexFactor().isEmpty();
        }

        public ESMACreditDetailsBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ESMACreditDetailsBuilder o = (ESMACreditDetailsBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSeniority(), (RosettaModelObjectBuilder)o.getSeniority(), this::setSeniority);
            merger.mergeBasic(this.getIndexFactor(), o.getIndexFactor(), this::addIndexFactor);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ESMACreditDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            return ListEquals.listEquals(this.indexFactor, _that.getIndexFactor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ESMACreditDetailsBuilder {seniority=" + String.valueOf(this.seniority) + ", indexFactor=" + String.valueOf(this.indexFactor) + "}";
        }
    }

    public static interface ESMACreditDetailsBuilder
    extends ESMACreditDetails,
    RosettaModelObjectBuilder {
        public ESMACreditSeniority.ESMACreditSeniorityBuilder getOrCreateSeniority();

        @Override
        public ESMACreditSeniority.ESMACreditSeniorityBuilder getSeniority();

        public ESMACreditDetailsBuilder setSeniority(ESMACreditSeniority var1);

        public ESMACreditDetailsBuilder addIndexFactor(BigDecimal var1);

        public ESMACreditDetailsBuilder addIndexFactor(BigDecimal var1, int var2);

        public ESMACreditDetailsBuilder addIndexFactor(List<BigDecimal> var1);

        public ESMACreditDetailsBuilder setIndexFactor(List<BigDecimal> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("seniority"), processor, ESMACreditSeniority.ESMACreditSeniorityBuilder.class, this.getSeniority(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, this.getIndexFactor(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ESMACreditDetailsBuilder prune();
    }

    public static class ESMACreditDetailsImpl
    implements ESMACreditDetails {
        private final ESMACreditSeniority seniority;
        private final List<BigDecimal> indexFactor;

        protected ESMACreditDetailsImpl(ESMACreditDetailsBuilder builder) {
            this.seniority = Optional.ofNullable(builder.getSeniority()).map(f -> f.build()).orElse(null);
            this.indexFactor = Optional.ofNullable(builder.getIndexFactor()).filter(_l -> !_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
        }

        @Override
        @RosettaAttribute(value="seniority")
        @RuneAttribute(value="seniority")
        public ESMACreditSeniority getSeniority() {
            return this.seniority;
        }

        @Override
        @RosettaAttribute(value="indexFactor")
        @RuneAttribute(value="indexFactor")
        public List<BigDecimal> getIndexFactor() {
            return this.indexFactor;
        }

        @Override
        public ESMACreditDetails build() {
            return this;
        }

        @Override
        public ESMACreditDetailsBuilder toBuilder() {
            ESMACreditDetailsBuilder builder = ESMACreditDetails.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ESMACreditDetailsBuilder builder) {
            Optional.ofNullable(this.getSeniority()).ifPresent(builder::setSeniority);
            Optional.ofNullable(this.getIndexFactor()).ifPresent(builder::setIndexFactor);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ESMACreditDetails _that = this.getType().cast(o);
            if (!Objects.equals(this.seniority, _that.getSeniority())) {
                return false;
            }
            return ListEquals.listEquals(this.indexFactor, _that.getIndexFactor());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.seniority != null ? this.seniority.hashCode() : 0);
            _result = 31 * _result + (this.indexFactor != null ? this.indexFactor.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ESMACreditDetails {seniority=" + String.valueOf(this.seniority) + ", indexFactor=" + String.valueOf(this.indexFactor) + "}";
        }
    }
}

