/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.option.shared.Knock;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="KnockChoice")
@ImplementedBy(value=Default.class)
public interface KnockChoice
extends Validator<Knock> {
    public static final String NAME = "KnockChoice";
    public static final String DEFINITION = "one-of";

    public static class NoOp
    implements KnockChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Knock knock) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements KnockChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Knock knock) {
            ComparisonResult result = this.executeDataRule(knock);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)KnockChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Knock", (RosettaPath)path, (String)KnockChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)KnockChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Knock", (RosettaPath)path, (String)KnockChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Knock knock) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)knock), Arrays.asList("knockSequence", "knockOut"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.REQUIRED);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

