/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.option.shared;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.fpmlenum.TriggerTimeTypeEnum;
import fpml.consolidated.fpmlenum.TriggerTypeEnum;
import fpml.consolidated.option.shared.TriggerChoice;
import fpml.consolidated.option.shared.meta.TriggerMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="Trigger", builder=TriggerBuilderImpl.class, version="1.2.2")
@RuneDataType(value="Trigger", model="fpml", builder=TriggerBuilderImpl.class, version="1.2.2")
public interface Trigger
extends RosettaModelObject {
    public static final TriggerMeta metaData = new TriggerMeta();

    public BigDecimal getLevel();

    public BigDecimal getLevelPercentage();

    public TriggerChoice getTriggerChoice();

    public TriggerTypeEnum getTriggerType();

    public TriggerTimeTypeEnum getTriggerTimeType();

    public Trigger build();

    public TriggerBuilder toBuilder();

    public static TriggerBuilder builder() {
        return new TriggerBuilderImpl();
    }

    default public RosettaMetaData<? extends Trigger> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Trigger> getType() {
        return Trigger.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("level"), BigDecimal.class, (Object)this.getLevel(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("triggerChoice"), processor, TriggerChoice.class, this.getTriggerChoice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerType"), TriggerTypeEnum.class, (Object)this.getTriggerType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerTimeType"), TriggerTimeTypeEnum.class, (Object)this.getTriggerTimeType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TriggerBuilderImpl
    implements TriggerBuilder {
        protected BigDecimal level;
        protected BigDecimal levelPercentage;
        protected TriggerChoice.TriggerChoiceBuilder triggerChoice;
        protected TriggerTypeEnum triggerType;
        protected TriggerTimeTypeEnum triggerTimeType;

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public BigDecimal getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="levelPercentage")
        @RuneAttribute(value="levelPercentage")
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        @RosettaAttribute(value="triggerChoice")
        @RuneAttribute(value="triggerChoice")
        public TriggerChoice.TriggerChoiceBuilder getTriggerChoice() {
            return this.triggerChoice;
        }

        @Override
        public TriggerChoice.TriggerChoiceBuilder getOrCreateTriggerChoice() {
            TriggerChoice.TriggerChoiceBuilder result = this.triggerChoice != null ? this.triggerChoice : (this.triggerChoice = TriggerChoice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="triggerType")
        @RuneAttribute(value="triggerType")
        public TriggerTypeEnum getTriggerType() {
            return this.triggerType;
        }

        @Override
        @RosettaAttribute(value="triggerTimeType")
        @RuneAttribute(value="triggerTimeType")
        public TriggerTimeTypeEnum getTriggerTimeType() {
            return this.triggerTimeType;
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public TriggerBuilder setLevel(BigDecimal _level) {
            this.level = _level == null ? null : _level;
            return this;
        }

        @Override
        @RosettaAttribute(value="levelPercentage")
        @RuneAttribute(value="levelPercentage")
        public TriggerBuilder setLevelPercentage(BigDecimal _levelPercentage) {
            this.levelPercentage = _levelPercentage == null ? null : _levelPercentage;
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerChoice")
        @RuneAttribute(value="triggerChoice")
        public TriggerBuilder setTriggerChoice(TriggerChoice _triggerChoice) {
            this.triggerChoice = _triggerChoice == null ? null : _triggerChoice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerType")
        @RuneAttribute(value="triggerType")
        public TriggerBuilder setTriggerType(TriggerTypeEnum _triggerType) {
            this.triggerType = _triggerType == null ? null : _triggerType;
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerTimeType")
        @RuneAttribute(value="triggerTimeType")
        public TriggerBuilder setTriggerTimeType(TriggerTimeTypeEnum _triggerTimeType) {
            this.triggerTimeType = _triggerTimeType == null ? null : _triggerTimeType;
            return this;
        }

        @Override
        public Trigger build() {
            return new TriggerImpl(this);
        }

        @Override
        public TriggerBuilder toBuilder() {
            return this;
        }

        @Override
        public TriggerBuilder prune() {
            if (this.triggerChoice != null && !this.triggerChoice.prune().hasData()) {
                this.triggerChoice = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getLevel() != null) {
                return true;
            }
            if (this.getLevelPercentage() != null) {
                return true;
            }
            if (this.getTriggerChoice() != null && this.getTriggerChoice().hasData()) {
                return true;
            }
            if (this.getTriggerType() != null) {
                return true;
            }
            return this.getTriggerTimeType() != null;
        }

        public TriggerBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TriggerBuilder o = (TriggerBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTriggerChoice(), (RosettaModelObjectBuilder)o.getTriggerChoice(), this::setTriggerChoice);
            merger.mergeBasic((Object)this.getLevel(), (Object)o.getLevel(), this::setLevel, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getLevelPercentage(), (Object)o.getLevelPercentage(), this::setLevelPercentage, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerType(), (Object)o.getTriggerType(), this::setTriggerType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTriggerTimeType(), (Object)o.getTriggerTimeType(), this::setTriggerTimeType, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trigger _that = this.getType().cast(o);
            if (!Objects.equals(this.level, _that.getLevel())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals(this.triggerChoice, _that.getTriggerChoice())) {
                return false;
            }
            if (!Objects.equals((Object)this.triggerType, (Object)_that.getTriggerType())) {
                return false;
            }
            return Objects.equals((Object)this.triggerTimeType, (Object)_that.getTriggerTimeType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.level != null ? this.level.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.triggerChoice != null ? this.triggerChoice.hashCode() : 0);
            _result = 31 * _result + (this.triggerType != null ? ((Object)((Object)this.triggerType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.triggerTimeType != null ? ((Object)((Object)this.triggerTimeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TriggerBuilder {level=" + String.valueOf(this.level) + ", levelPercentage=" + String.valueOf(this.levelPercentage) + ", triggerChoice=" + String.valueOf(this.triggerChoice) + ", triggerType=" + String.valueOf((Object)this.triggerType) + ", triggerTimeType=" + String.valueOf((Object)this.triggerTimeType) + "}";
        }
    }

    public static interface TriggerBuilder
    extends Trigger,
    RosettaModelObjectBuilder {
        public TriggerChoice.TriggerChoiceBuilder getOrCreateTriggerChoice();

        @Override
        public TriggerChoice.TriggerChoiceBuilder getTriggerChoice();

        public TriggerBuilder setLevel(BigDecimal var1);

        public TriggerBuilder setLevelPercentage(BigDecimal var1);

        public TriggerBuilder setTriggerChoice(TriggerChoice var1);

        public TriggerBuilder setTriggerType(TriggerTypeEnum var1);

        public TriggerBuilder setTriggerTimeType(TriggerTimeTypeEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("level"), BigDecimal.class, (Object)this.getLevel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("levelPercentage"), BigDecimal.class, (Object)this.getLevelPercentage(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("triggerChoice"), processor, TriggerChoice.TriggerChoiceBuilder.class, this.getTriggerChoice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerType"), TriggerTypeEnum.class, (Object)this.getTriggerType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerTimeType"), TriggerTimeTypeEnum.class, (Object)this.getTriggerTimeType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TriggerBuilder prune();
    }

    public static class TriggerImpl
    implements Trigger {
        private final BigDecimal level;
        private final BigDecimal levelPercentage;
        private final TriggerChoice triggerChoice;
        private final TriggerTypeEnum triggerType;
        private final TriggerTimeTypeEnum triggerTimeType;

        protected TriggerImpl(TriggerBuilder builder) {
            this.level = builder.getLevel();
            this.levelPercentage = builder.getLevelPercentage();
            this.triggerChoice = Optional.ofNullable(builder.getTriggerChoice()).map(f -> f.build()).orElse(null);
            this.triggerType = builder.getTriggerType();
            this.triggerTimeType = builder.getTriggerTimeType();
        }

        @Override
        @RosettaAttribute(value="level")
        @RuneAttribute(value="level")
        public BigDecimal getLevel() {
            return this.level;
        }

        @Override
        @RosettaAttribute(value="levelPercentage")
        @RuneAttribute(value="levelPercentage")
        public BigDecimal getLevelPercentage() {
            return this.levelPercentage;
        }

        @Override
        @RosettaAttribute(value="triggerChoice")
        @RuneAttribute(value="triggerChoice")
        public TriggerChoice getTriggerChoice() {
            return this.triggerChoice;
        }

        @Override
        @RosettaAttribute(value="triggerType")
        @RuneAttribute(value="triggerType")
        public TriggerTypeEnum getTriggerType() {
            return this.triggerType;
        }

        @Override
        @RosettaAttribute(value="triggerTimeType")
        @RuneAttribute(value="triggerTimeType")
        public TriggerTimeTypeEnum getTriggerTimeType() {
            return this.triggerTimeType;
        }

        @Override
        public Trigger build() {
            return this;
        }

        @Override
        public TriggerBuilder toBuilder() {
            TriggerBuilder builder = Trigger.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TriggerBuilder builder) {
            Optional.ofNullable(this.getLevel()).ifPresent(builder::setLevel);
            Optional.ofNullable(this.getLevelPercentage()).ifPresent(builder::setLevelPercentage);
            Optional.ofNullable(this.getTriggerChoice()).ifPresent(builder::setTriggerChoice);
            Optional.ofNullable(this.getTriggerType()).ifPresent(builder::setTriggerType);
            Optional.ofNullable(this.getTriggerTimeType()).ifPresent(builder::setTriggerTimeType);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Trigger _that = this.getType().cast(o);
            if (!Objects.equals(this.level, _that.getLevel())) {
                return false;
            }
            if (!Objects.equals(this.levelPercentage, _that.getLevelPercentage())) {
                return false;
            }
            if (!Objects.equals(this.triggerChoice, _that.getTriggerChoice())) {
                return false;
            }
            if (!Objects.equals((Object)this.triggerType, (Object)_that.getTriggerType())) {
                return false;
            }
            return Objects.equals((Object)this.triggerTimeType, (Object)_that.getTriggerTimeType());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.level != null ? this.level.hashCode() : 0);
            _result = 31 * _result + (this.levelPercentage != null ? this.levelPercentage.hashCode() : 0);
            _result = 31 * _result + (this.triggerChoice != null ? this.triggerChoice.hashCode() : 0);
            _result = 31 * _result + (this.triggerType != null ? ((Object)((Object)this.triggerType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.triggerTimeType != null ? ((Object)((Object)this.triggerTimeType)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Trigger {level=" + String.valueOf(this.level) + ", levelPercentage=" + String.valueOf(this.levelPercentage) + ", triggerChoice=" + String.valueOf(this.triggerChoice) + ", triggerType=" + String.valueOf((Object)this.triggerType) + ", triggerTimeType=" + String.valueOf((Object)this.triggerTimeType) + "}";
        }
    }
}

