/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.mktenv;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.mktenv.TermPoint;
import fpml.consolidated.mktenv.meta.TermCurveMeta;
import fpml.consolidated.shared.InterpolationMethod;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TermCurve", builder=TermCurveBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TermCurve", model="fpml", builder=TermCurveBuilderImpl.class, version="1.2.2")
public interface TermCurve
extends RosettaModelObject {
    public static final TermCurveMeta metaData = new TermCurveMeta();

    public InterpolationMethod getInterpolationMethod();

    public Boolean getExtrapolationPermitted();

    public List<? extends TermPoint> getPoint();

    public TermCurve build();

    public TermCurveBuilder toBuilder();

    public static TermCurveBuilder builder() {
        return new TermCurveBuilderImpl();
    }

    default public RosettaMetaData<? extends TermCurve> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TermCurve> getType() {
        return TermCurve.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("interpolationMethod"), processor, InterpolationMethod.class, this.getInterpolationMethod(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("extrapolationPermitted"), Boolean.class, (Object)this.getExtrapolationPermitted(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("point"), processor, TermPoint.class, this.getPoint(), new AttributeMeta[0]);
    }

    public static class TermCurveBuilderImpl
    implements TermCurveBuilder {
        protected InterpolationMethod.InterpolationMethodBuilder interpolationMethod;
        protected Boolean extrapolationPermitted;
        protected List<TermPoint.TermPointBuilder> point = new ArrayList<TermPoint.TermPointBuilder>();

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethod.InterpolationMethodBuilder getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        public InterpolationMethod.InterpolationMethodBuilder getOrCreateInterpolationMethod() {
            InterpolationMethod.InterpolationMethodBuilder result = this.interpolationMethod != null ? this.interpolationMethod : (this.interpolationMethod = InterpolationMethod.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="extrapolationPermitted")
        @RuneAttribute(value="extrapolationPermitted")
        public Boolean getExtrapolationPermitted() {
            return this.extrapolationPermitted;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public List<? extends TermPoint.TermPointBuilder> getPoint() {
            return this.point;
        }

        @Override
        public TermPoint.TermPointBuilder getOrCreatePoint(int index) {
            if (this.point == null) {
                this.point = new ArrayList<TermPoint.TermPointBuilder>();
            }
            return (TermPoint.TermPointBuilder)this.getIndex(this.point, index, () -> {
                TermPoint.TermPointBuilder newPoint = TermPoint.builder();
                return newPoint;
            });
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public TermCurveBuilder setInterpolationMethod(InterpolationMethod _interpolationMethod) {
            this.interpolationMethod = _interpolationMethod == null ? null : _interpolationMethod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="extrapolationPermitted")
        @RuneAttribute(value="extrapolationPermitted")
        public TermCurveBuilder setExtrapolationPermitted(Boolean _extrapolationPermitted) {
            this.extrapolationPermitted = _extrapolationPermitted == null ? null : _extrapolationPermitted;
            return this;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public TermCurveBuilder addPoint(TermPoint _point) {
            if (_point != null) {
                this.point.add(_point.toBuilder());
            }
            return this;
        }

        @Override
        public TermCurveBuilder addPoint(TermPoint _point, int idx) {
            this.getIndex(this.point, idx, () -> _point.toBuilder());
            return this;
        }

        @Override
        public TermCurveBuilder addPoint(List<? extends TermPoint> points) {
            if (points != null) {
                for (TermPoint termPoint : points) {
                    this.point.add(termPoint.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="point")
        public TermCurveBuilder setPoint(List<? extends TermPoint> points) {
            this.point = points == null ? new ArrayList<TermPoint.TermPointBuilder>() : (List)points.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public TermCurve build() {
            return new TermCurveImpl(this);
        }

        @Override
        public TermCurveBuilder toBuilder() {
            return this;
        }

        @Override
        public TermCurveBuilder prune() {
            if (this.interpolationMethod != null && !this.interpolationMethod.prune().hasData()) {
                this.interpolationMethod = null;
            }
            this.point = this.point.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getInterpolationMethod() != null && this.getInterpolationMethod().hasData()) {
                return true;
            }
            if (this.getExtrapolationPermitted() != null) {
                return true;
            }
            return this.getPoint() != null && this.getPoint().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public TermCurveBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TermCurveBuilder o = (TermCurveBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterpolationMethod(), (RosettaModelObjectBuilder)o.getInterpolationMethod(), this::setInterpolationMethod);
            merger.mergeRosetta(this.getPoint(), o.getPoint(), this::getOrCreatePoint);
            merger.mergeBasic((Object)this.getExtrapolationPermitted(), (Object)o.getExtrapolationPermitted(), this::setExtrapolationPermitted, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TermCurve _that = this.getType().cast(o);
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            if (!Objects.equals(this.extrapolationPermitted, _that.getExtrapolationPermitted())) {
                return false;
            }
            return ListEquals.listEquals(this.point, _that.getPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.extrapolationPermitted != null ? this.extrapolationPermitted.hashCode() : 0);
            _result = 31 * _result + (this.point != null ? this.point.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TermCurveBuilder {interpolationMethod=" + String.valueOf(this.interpolationMethod) + ", extrapolationPermitted=" + this.extrapolationPermitted + ", point=" + String.valueOf(this.point) + "}";
        }
    }

    public static interface TermCurveBuilder
    extends TermCurve,
    RosettaModelObjectBuilder {
        public InterpolationMethod.InterpolationMethodBuilder getOrCreateInterpolationMethod();

        @Override
        public InterpolationMethod.InterpolationMethodBuilder getInterpolationMethod();

        public TermPoint.TermPointBuilder getOrCreatePoint(int var1);

        public List<? extends TermPoint.TermPointBuilder> getPoint();

        public TermCurveBuilder setInterpolationMethod(InterpolationMethod var1);

        public TermCurveBuilder setExtrapolationPermitted(Boolean var1);

        public TermCurveBuilder addPoint(TermPoint var1);

        public TermCurveBuilder addPoint(TermPoint var1, int var2);

        public TermCurveBuilder addPoint(List<? extends TermPoint> var1);

        public TermCurveBuilder setPoint(List<? extends TermPoint> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("interpolationMethod"), processor, InterpolationMethod.InterpolationMethodBuilder.class, this.getInterpolationMethod(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("extrapolationPermitted"), Boolean.class, (Object)this.getExtrapolationPermitted(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("point"), processor, TermPoint.TermPointBuilder.class, this.getPoint(), new AttributeMeta[0]);
        }

        public TermCurveBuilder prune();
    }

    public static class TermCurveImpl
    implements TermCurve {
        private final InterpolationMethod interpolationMethod;
        private final Boolean extrapolationPermitted;
        private final List<? extends TermPoint> point;

        protected TermCurveImpl(TermCurveBuilder builder) {
            this.interpolationMethod = Optional.ofNullable(builder.getInterpolationMethod()).map(f -> f.build()).orElse(null);
            this.extrapolationPermitted = builder.getExtrapolationPermitted();
            this.point = Optional.ofNullable(builder.getPoint()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="interpolationMethod")
        @RuneAttribute(value="interpolationMethod")
        public InterpolationMethod getInterpolationMethod() {
            return this.interpolationMethod;
        }

        @Override
        @RosettaAttribute(value="extrapolationPermitted")
        @RuneAttribute(value="extrapolationPermitted")
        public Boolean getExtrapolationPermitted() {
            return this.extrapolationPermitted;
        }

        @Override
        @RosettaAttribute(value="point")
        @RuneAttribute(value="point")
        public List<? extends TermPoint> getPoint() {
            return this.point;
        }

        @Override
        public TermCurve build() {
            return this;
        }

        @Override
        public TermCurveBuilder toBuilder() {
            TermCurveBuilder builder = TermCurve.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TermCurveBuilder builder) {
            Optional.ofNullable(this.getInterpolationMethod()).ifPresent(builder::setInterpolationMethod);
            Optional.ofNullable(this.getExtrapolationPermitted()).ifPresent(builder::setExtrapolationPermitted);
            Optional.ofNullable(this.getPoint()).ifPresent(builder::setPoint);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TermCurve _that = this.getType().cast(o);
            if (!Objects.equals(this.interpolationMethod, _that.getInterpolationMethod())) {
                return false;
            }
            if (!Objects.equals(this.extrapolationPermitted, _that.getExtrapolationPermitted())) {
                return false;
            }
            return ListEquals.listEquals(this.point, _that.getPoint());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.interpolationMethod != null ? this.interpolationMethod.hashCode() : 0);
            _result = 31 * _result + (this.extrapolationPermitted != null ? this.extrapolationPermitted.hashCode() : 0);
            _result = 31 * _result + (this.point != null ? this.point.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TermCurve {interpolationMethod=" + String.valueOf(this.interpolationMethod) + ", extrapolationPermitted=" + this.extrapolationPermitted + ", point=" + String.valueOf(this.point) + "}";
        }
    }
}

