/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.LoanTradingCostOfCarryAccrual;
import fpml.consolidated.loan.SimplePayerReceiverModel;
import fpml.consolidated.loan.meta.LoanTradingCostOfCarryMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradingCostOfCarry", builder=LoanTradingCostOfCarryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanTradingCostOfCarry", model="fpml", builder=LoanTradingCostOfCarryBuilderImpl.class, version="1.2.2")
public interface LoanTradingCostOfCarry
extends RosettaModelObject {
    public static final LoanTradingCostOfCarryMeta metaData = new LoanTradingCostOfCarryMeta();

    public NonNegativeMoney getAmount();

    public SimplePayerReceiverModel getSimplePayerReceiverModel();

    public LoanTradingCostOfCarryAccrual getAccrual();

    public LoanTradingCostOfCarry build();

    public LoanTradingCostOfCarryBuilder toBuilder();

    public static LoanTradingCostOfCarryBuilder builder() {
        return new LoanTradingCostOfCarryBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradingCostOfCarry> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradingCostOfCarry> getType() {
        return LoanTradingCostOfCarry.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrual"), processor, LoanTradingCostOfCarryAccrual.class, this.getAccrual(), new AttributeMeta[0]);
    }

    public static class LoanTradingCostOfCarryBuilderImpl
    implements LoanTradingCostOfCarryBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected SimplePayerReceiverModel.SimplePayerReceiverModelBuilder simplePayerReceiverModel;
        protected LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder accrual;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel() {
            SimplePayerReceiverModel.SimplePayerReceiverModelBuilder result = this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel : (this.simplePayerReceiverModel = SimplePayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrual")
        @RuneAttribute(value="accrual")
        public LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder getAccrual() {
            return this.accrual;
        }

        @Override
        public LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder getOrCreateAccrual() {
            LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder result = this.accrual != null ? this.accrual : (this.accrual = LoanTradingCostOfCarryAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradingCostOfCarryBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public LoanTradingCostOfCarryBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel _simplePayerReceiverModel) {
            this.simplePayerReceiverModel = _simplePayerReceiverModel == null ? null : _simplePayerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrual")
        @RuneAttribute(value="accrual")
        public LoanTradingCostOfCarryBuilder setAccrual(LoanTradingCostOfCarryAccrual _accrual) {
            this.accrual = _accrual == null ? null : _accrual.toBuilder();
            return this;
        }

        @Override
        public LoanTradingCostOfCarry build() {
            return new LoanTradingCostOfCarryImpl(this);
        }

        @Override
        public LoanTradingCostOfCarryBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradingCostOfCarryBuilder prune() {
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.simplePayerReceiverModel != null && !this.simplePayerReceiverModel.prune().hasData()) {
                this.simplePayerReceiverModel = null;
            }
            if (this.accrual != null && !this.accrual.prune().hasData()) {
                this.accrual = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            if (this.getSimplePayerReceiverModel() != null && this.getSimplePayerReceiverModel().hasData()) {
                return true;
            }
            return this.getAccrual() != null && this.getAccrual().hasData();
        }

        public LoanTradingCostOfCarryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanTradingCostOfCarryBuilder o = (LoanTradingCostOfCarryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSimplePayerReceiverModel(), (RosettaModelObjectBuilder)o.getSimplePayerReceiverModel(), this::setSimplePayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrual(), (RosettaModelObjectBuilder)o.getAccrual(), this::setAccrual);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCostOfCarry _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            return Objects.equals(this.accrual, _that.getAccrual());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCostOfCarryBuilder {amount=" + String.valueOf(this.amount) + ", simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", accrual=" + String.valueOf(this.accrual) + "}";
        }
    }

    public static interface LoanTradingCostOfCarryBuilder
    extends LoanTradingCostOfCarry,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getOrCreateSimplePayerReceiverModel();

        @Override
        public SimplePayerReceiverModel.SimplePayerReceiverModelBuilder getSimplePayerReceiverModel();

        public LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder getOrCreateAccrual();

        @Override
        public LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder getAccrual();

        public LoanTradingCostOfCarryBuilder setAmount(NonNegativeMoney var1);

        public LoanTradingCostOfCarryBuilder setSimplePayerReceiverModel(SimplePayerReceiverModel var1);

        public LoanTradingCostOfCarryBuilder setAccrual(LoanTradingCostOfCarryAccrual var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("simplePayerReceiverModel"), processor, SimplePayerReceiverModel.SimplePayerReceiverModelBuilder.class, this.getSimplePayerReceiverModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrual"), processor, LoanTradingCostOfCarryAccrual.LoanTradingCostOfCarryAccrualBuilder.class, this.getAccrual(), new AttributeMeta[0]);
        }

        public LoanTradingCostOfCarryBuilder prune();
    }

    public static class LoanTradingCostOfCarryImpl
    implements LoanTradingCostOfCarry {
        private final NonNegativeMoney amount;
        private final SimplePayerReceiverModel simplePayerReceiverModel;
        private final LoanTradingCostOfCarryAccrual accrual;

        protected LoanTradingCostOfCarryImpl(LoanTradingCostOfCarryBuilder builder) {
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.simplePayerReceiverModel = Optional.ofNullable(builder.getSimplePayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.accrual = Optional.ofNullable(builder.getAccrual()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="simplePayerReceiverModel")
        @RuneAttribute(value="simplePayerReceiverModel")
        public SimplePayerReceiverModel getSimplePayerReceiverModel() {
            return this.simplePayerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="accrual")
        @RuneAttribute(value="accrual")
        public LoanTradingCostOfCarryAccrual getAccrual() {
            return this.accrual;
        }

        @Override
        public LoanTradingCostOfCarry build() {
            return this;
        }

        @Override
        public LoanTradingCostOfCarryBuilder toBuilder() {
            LoanTradingCostOfCarryBuilder builder = LoanTradingCostOfCarry.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradingCostOfCarryBuilder builder) {
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getSimplePayerReceiverModel()).ifPresent(builder::setSimplePayerReceiverModel);
            Optional.ofNullable(this.getAccrual()).ifPresent(builder::setAccrual);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanTradingCostOfCarry _that = this.getType().cast(o);
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            if (!Objects.equals(this.simplePayerReceiverModel, _that.getSimplePayerReceiverModel())) {
                return false;
            }
            return Objects.equals(this.accrual, _that.getAccrual());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.simplePayerReceiverModel != null ? this.simplePayerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanTradingCostOfCarry {amount=" + String.valueOf(this.amount) + ", simplePayerReceiverModel=" + String.valueOf(this.simplePayerReceiverModel) + ", accrual=" + String.valueOf(this.accrual) + "}";
        }
    }
}

