/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.UnprocessedElementWrapper;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.LoanIdentifiersModel;
import fpml.consolidated.loan.meta.LoanNotificationRetractedMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.Party;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanNotificationRetracted", builder=LoanNotificationRetractedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanNotificationRetracted", model="fpml", builder=LoanNotificationRetractedBuilderImpl.class, version="1.2.2")
public interface LoanNotificationRetracted
extends NonCorrectableRequestMessage {
    public static final LoanNotificationRetractedMeta metaData = new LoanNotificationRetractedMeta();

    public LoanIdentifiersModel getLoanIdentifiersModel();

    public Party getParty();

    public UnprocessedElementWrapper getOriginalMessage();

    @Override
    public LoanNotificationRetracted build();

    @Override
    public LoanNotificationRetractedBuilder toBuilder();

    public static LoanNotificationRetractedBuilder builder() {
        return new LoanNotificationRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanNotificationRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanNotificationRetracted> getType() {
        return LoanNotificationRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanIdentifiersModel"), processor, LoanIdentifiersModel.class, this.getLoanIdentifiersModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("originalMessage"), processor, UnprocessedElementWrapper.class, this.getOriginalMessage(), new AttributeMeta[0]);
    }

    public static class LoanNotificationRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements LoanNotificationRetractedBuilder {
        protected LoanIdentifiersModel.LoanIdentifiersModelBuilder loanIdentifiersModel;
        protected Party.PartyBuilder party;
        protected UnprocessedElementWrapper.UnprocessedElementWrapperBuilder originalMessage;

        @Override
        @RosettaAttribute(value="loanIdentifiersModel", isRequired=true)
        @RuneAttribute(value="loanIdentifiersModel", isRequired=true)
        public LoanIdentifiersModel.LoanIdentifiersModelBuilder getLoanIdentifiersModel() {
            return this.loanIdentifiersModel;
        }

        @Override
        public LoanIdentifiersModel.LoanIdentifiersModelBuilder getOrCreateLoanIdentifiersModel() {
            LoanIdentifiersModel.LoanIdentifiersModelBuilder result = this.loanIdentifiersModel != null ? this.loanIdentifiersModel : (this.loanIdentifiersModel = LoanIdentifiersModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party.PartyBuilder getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty() {
            Party.PartyBuilder result = this.party != null ? this.party : (this.party = Party.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="originalMessage")
        @RuneAttribute(value="originalMessage")
        public UnprocessedElementWrapper.UnprocessedElementWrapperBuilder getOriginalMessage() {
            return this.originalMessage;
        }

        @Override
        public UnprocessedElementWrapper.UnprocessedElementWrapperBuilder getOrCreateOriginalMessage() {
            UnprocessedElementWrapper.UnprocessedElementWrapperBuilder result = this.originalMessage != null ? this.originalMessage : (this.originalMessage = UnprocessedElementWrapper.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public LoanNotificationRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public LoanNotificationRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public LoanNotificationRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public LoanNotificationRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public LoanNotificationRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public LoanNotificationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public LoanNotificationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanIdentifiersModel", isRequired=true)
        @RuneAttribute(value="loanIdentifiersModel", isRequired=true)
        public LoanNotificationRetractedBuilder setLoanIdentifiersModel(LoanIdentifiersModel _loanIdentifiersModel) {
            this.loanIdentifiersModel = _loanIdentifiersModel == null ? null : _loanIdentifiersModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public LoanNotificationRetractedBuilder setParty(Party _party) {
            this.party = _party == null ? null : _party.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="originalMessage")
        @RuneAttribute(value="originalMessage")
        public LoanNotificationRetractedBuilder setOriginalMessage(UnprocessedElementWrapper _originalMessage) {
            this.originalMessage = _originalMessage == null ? null : _originalMessage.toBuilder();
            return this;
        }

        @Override
        public LoanNotificationRetracted build() {
            return new LoanNotificationRetractedImpl(this);
        }

        @Override
        public LoanNotificationRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanNotificationRetractedBuilder prune() {
            super.prune();
            if (this.loanIdentifiersModel != null && !this.loanIdentifiersModel.prune().hasData()) {
                this.loanIdentifiersModel = null;
            }
            if (this.party != null && !this.party.prune().hasData()) {
                this.party = null;
            }
            if (this.originalMessage != null && !this.originalMessage.prune().hasData()) {
                this.originalMessage = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getLoanIdentifiersModel() != null && this.getLoanIdentifiersModel().hasData()) {
                return true;
            }
            if (this.getParty() != null && this.getParty().hasData()) {
                return true;
            }
            return this.getOriginalMessage() != null && this.getOriginalMessage().hasData();
        }

        @Override
        public LoanNotificationRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanNotificationRetractedBuilder o = (LoanNotificationRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLoanIdentifiersModel(), (RosettaModelObjectBuilder)o.getLoanIdentifiersModel(), this::setLoanIdentifiersModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getParty(), (RosettaModelObjectBuilder)o.getParty(), this::setParty);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOriginalMessage(), (RosettaModelObjectBuilder)o.getOriginalMessage(), this::setOriginalMessage);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanNotificationRetracted _that = (LoanNotificationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.loanIdentifiersModel, _that.getLoanIdentifiersModel())) {
                return false;
            }
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            return Objects.equals(this.originalMessage, _that.getOriginalMessage());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanIdentifiersModel != null ? this.loanIdentifiersModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.originalMessage != null ? this.originalMessage.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanNotificationRetractedBuilder {loanIdentifiersModel=" + String.valueOf(this.loanIdentifiersModel) + ", party=" + String.valueOf(this.party) + ", originalMessage=" + String.valueOf(this.originalMessage) + "} " + super.toString();
        }
    }

    public static interface LoanNotificationRetractedBuilder
    extends LoanNotificationRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public LoanIdentifiersModel.LoanIdentifiersModelBuilder getOrCreateLoanIdentifiersModel();

        @Override
        public LoanIdentifiersModel.LoanIdentifiersModelBuilder getLoanIdentifiersModel();

        public Party.PartyBuilder getOrCreateParty();

        @Override
        public Party.PartyBuilder getParty();

        public UnprocessedElementWrapper.UnprocessedElementWrapperBuilder getOrCreateOriginalMessage();

        @Override
        public UnprocessedElementWrapper.UnprocessedElementWrapperBuilder getOriginalMessage();

        @Override
        public LoanNotificationRetractedBuilder setFpmlVersion(String var1);

        @Override
        public LoanNotificationRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public LoanNotificationRetractedBuilder setActualBuild(Integer var1);

        @Override
        public LoanNotificationRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public LoanNotificationRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public LoanNotificationRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public LoanNotificationRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public LoanNotificationRetractedBuilder setLoanIdentifiersModel(LoanIdentifiersModel var1);

        public LoanNotificationRetractedBuilder setParty(Party var1);

        public LoanNotificationRetractedBuilder setOriginalMessage(UnprocessedElementWrapper var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanIdentifiersModel"), processor, LoanIdentifiersModel.LoanIdentifiersModelBuilder.class, this.getLoanIdentifiersModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("originalMessage"), processor, UnprocessedElementWrapper.UnprocessedElementWrapperBuilder.class, this.getOriginalMessage(), new AttributeMeta[0]);
        }

        @Override
        public LoanNotificationRetractedBuilder prune();
    }

    public static class LoanNotificationRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements LoanNotificationRetracted {
        private final LoanIdentifiersModel loanIdentifiersModel;
        private final Party party;
        private final UnprocessedElementWrapper originalMessage;

        protected LoanNotificationRetractedImpl(LoanNotificationRetractedBuilder builder) {
            super(builder);
            this.loanIdentifiersModel = Optional.ofNullable(builder.getLoanIdentifiersModel()).map(f -> f.build()).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).map(f -> f.build()).orElse(null);
            this.originalMessage = Optional.ofNullable(builder.getOriginalMessage()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="loanIdentifiersModel", isRequired=true)
        @RuneAttribute(value="loanIdentifiersModel", isRequired=true)
        public LoanIdentifiersModel getLoanIdentifiersModel() {
            return this.loanIdentifiersModel;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public Party getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="originalMessage")
        @RuneAttribute(value="originalMessage")
        public UnprocessedElementWrapper getOriginalMessage() {
            return this.originalMessage;
        }

        @Override
        public LoanNotificationRetracted build() {
            return this;
        }

        @Override
        public LoanNotificationRetractedBuilder toBuilder() {
            LoanNotificationRetractedBuilder builder = LoanNotificationRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanNotificationRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getLoanIdentifiersModel()).ifPresent(builder::setLoanIdentifiersModel);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getOriginalMessage()).ifPresent(builder::setOriginalMessage);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanNotificationRetracted _that = (LoanNotificationRetracted)this.getType().cast(o);
            if (!Objects.equals(this.loanIdentifiersModel, _that.getLoanIdentifiersModel())) {
                return false;
            }
            if (!Objects.equals(this.party, _that.getParty())) {
                return false;
            }
            return Objects.equals(this.originalMessage, _that.getOriginalMessage());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.loanIdentifiersModel != null ? this.loanIdentifiersModel.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.originalMessage != null ? this.originalMessage.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanNotificationRetracted {loanIdentifiersModel=" + String.valueOf(this.loanIdentifiersModel) + ", party=" + String.valueOf(this.party) + ", originalMessage=" + String.valueOf(this.originalMessage) + "} " + super.toString();
        }
    }
}

