/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ContractId;
import fpml.consolidated.doc.VersionedContractId;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.FixedRateAccrual;
import fpml.consolidated.loan.FxTerms;
import fpml.consolidated.loan.LegacyFloatingRateAccrual;
import fpml.consolidated.loan.LoanContractSummary;
import fpml.consolidated.loan.LoanFloatingRateAccrual;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LoanContractMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContract", builder=LoanContractBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LoanContract", model="fpml", builder=LoanContractBuilderImpl.class, version="1.2.2")
public interface LoanContract
extends LoanContractSummary {
    public static final LoanContractMeta metaData = new LoanContractMeta();

    public ZonedDateTime getRepricingDate();

    public ZonedDateTime getMaturityDate();

    public FixedRateAccrual getFixedRateAccrual();

    public LoanFloatingRateAccrual getFloatingRateAccrual();

    public LegacyFloatingRateAccrual getLegacyFloatingRateAccrual();

    public FxTerms getFacilityFxRate();

    @Override
    public LoanContract build();

    @Override
    public LoanContractBuilder toBuilder();

    public static LoanContractBuilder builder() {
        return new LoanContractBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContract> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContract> getType() {
        return LoanContract.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractId"), processor, ContractId.class, this.getContractId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.class, this.getVersionedContractId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.class, this.getBorrowerPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.class, this.getGuarantorPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("repricingDate"), ZonedDateTime.class, (Object)this.getRepricingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixedRateAccrual"), processor, FixedRateAccrual.class, this.getFixedRateAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("floatingRateAccrual"), processor, LoanFloatingRateAccrual.class, this.getFloatingRateAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyFloatingRateAccrual"), processor, LegacyFloatingRateAccrual.class, this.getLegacyFloatingRateAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.class, this.getFacilityFxRate(), new AttributeMeta[0]);
    }

    public static class LoanContractBuilderImpl
    extends LoanContractSummary.LoanContractSummaryBuilderImpl
    implements LoanContractBuilder {
        protected ZonedDateTime repricingDate;
        protected ZonedDateTime maturityDate;
        protected FixedRateAccrual.FixedRateAccrualBuilder fixedRateAccrual;
        protected LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder floatingRateAccrual;
        protected LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder legacyFloatingRateAccrual;
        protected FxTerms.FxTermsBuilder facilityFxRate;

        @Override
        @RosettaAttribute(value="repricingDate")
        @RuneAttribute(value="repricingDate")
        public ZonedDateTime getRepricingDate() {
            return this.repricingDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrual")
        @RuneAttribute(value="fixedRateAccrual")
        public FixedRateAccrual.FixedRateAccrualBuilder getFixedRateAccrual() {
            return this.fixedRateAccrual;
        }

        @Override
        public FixedRateAccrual.FixedRateAccrualBuilder getOrCreateFixedRateAccrual() {
            FixedRateAccrual.FixedRateAccrualBuilder result = this.fixedRateAccrual != null ? this.fixedRateAccrual : (this.fixedRateAccrual = FixedRateAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="floatingRateAccrual")
        @RuneAttribute(value="floatingRateAccrual")
        public LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder getFloatingRateAccrual() {
            return this.floatingRateAccrual;
        }

        @Override
        public LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder getOrCreateFloatingRateAccrual() {
            LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder result = this.floatingRateAccrual != null ? this.floatingRateAccrual : (this.floatingRateAccrual = LoanFloatingRateAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrual")
        @RuneAttribute(value="legacyFloatingRateAccrual")
        public LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder getLegacyFloatingRateAccrual() {
            return this.legacyFloatingRateAccrual;
        }

        @Override
        public LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder getOrCreateLegacyFloatingRateAccrual() {
            LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder result = this.legacyFloatingRateAccrual != null ? this.legacyFloatingRateAccrual : (this.legacyFloatingRateAccrual = LegacyFloatingRateAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms.FxTermsBuilder getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate() {
            FxTerms.FxTermsBuilder result = this.facilityFxRate != null ? this.facilityFxRate : (this.facilityFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LoanContractBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public LoanContractBuilder addContractId(ContractId _contractId) {
            if (_contractId != null) {
                this.contractId.add(_contractId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractBuilder addContractId(ContractId _contractId, int idx) {
            this.getIndex(this.contractId, idx, () -> _contractId.toBuilder());
            return this;
        }

        @Override
        public LoanContractBuilder addContractId(List<? extends ContractId> contractIds) {
            if (contractIds != null) {
                for (ContractId contractId : contractIds) {
                    this.contractId.add(contractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractId")
        public LoanContractBuilder setContractId(List<? extends ContractId> contractIds) {
            this.contractId = contractIds == null ? new ArrayList() : (List)contractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public LoanContractBuilder addVersionedContractId(VersionedContractId _versionedContractId) {
            if (_versionedContractId != null) {
                this.versionedContractId.add(_versionedContractId.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractBuilder addVersionedContractId(VersionedContractId _versionedContractId, int idx) {
            this.getIndex(this.versionedContractId, idx, () -> _versionedContractId.toBuilder());
            return this;
        }

        @Override
        public LoanContractBuilder addVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            if (versionedContractIds != null) {
                for (VersionedContractId versionedContractId : versionedContractIds) {
                    this.versionedContractId.add(versionedContractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedContractId")
        public LoanContractBuilder setVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            this.versionedContractId = versionedContractIds == null ? new ArrayList() : (List)versionedContractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanContractBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LoanContractBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LoanContractBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="borrowerPartyReference", isRequired=true)
        @RuneAttribute(value="borrowerPartyReference", isRequired=true)
        public LoanContractBuilder setBorrowerPartyReference(PartyReference _borrowerPartyReference) {
            this.borrowerPartyReference = _borrowerPartyReference == null ? null : _borrowerPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="guarantorPartyReference")
        @RuneAttribute(value="guarantorPartyReference")
        public LoanContractBuilder setGuarantorPartyReference(PartyReference _guarantorPartyReference) {
            this.guarantorPartyReference = _guarantorPartyReference == null ? null : _guarantorPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanContractBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="repricingDate")
        @RuneAttribute(value="repricingDate")
        public LoanContractBuilder setRepricingDate(ZonedDateTime _repricingDate) {
            this.repricingDate = _repricingDate == null ? null : _repricingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public LoanContractBuilder setMaturityDate(ZonedDateTime _maturityDate) {
            this.maturityDate = _maturityDate == null ? null : _maturityDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrual")
        @RuneAttribute(value="fixedRateAccrual")
        public LoanContractBuilder setFixedRateAccrual(FixedRateAccrual _fixedRateAccrual) {
            this.fixedRateAccrual = _fixedRateAccrual == null ? null : _fixedRateAccrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="floatingRateAccrual")
        @RuneAttribute(value="floatingRateAccrual")
        public LoanContractBuilder setFloatingRateAccrual(LoanFloatingRateAccrual _floatingRateAccrual) {
            this.floatingRateAccrual = _floatingRateAccrual == null ? null : _floatingRateAccrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrual")
        @RuneAttribute(value="legacyFloatingRateAccrual")
        public LoanContractBuilder setLegacyFloatingRateAccrual(LegacyFloatingRateAccrual _legacyFloatingRateAccrual) {
            this.legacyFloatingRateAccrual = _legacyFloatingRateAccrual == null ? null : _legacyFloatingRateAccrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public LoanContractBuilder setFacilityFxRate(FxTerms _facilityFxRate) {
            this.facilityFxRate = _facilityFxRate == null ? null : _facilityFxRate.toBuilder();
            return this;
        }

        @Override
        public LoanContract build() {
            return new LoanContractImpl(this);
        }

        @Override
        public LoanContractBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractBuilder prune() {
            super.prune();
            if (this.fixedRateAccrual != null && !this.fixedRateAccrual.prune().hasData()) {
                this.fixedRateAccrual = null;
            }
            if (this.floatingRateAccrual != null && !this.floatingRateAccrual.prune().hasData()) {
                this.floatingRateAccrual = null;
            }
            if (this.legacyFloatingRateAccrual != null && !this.legacyFloatingRateAccrual.prune().hasData()) {
                this.legacyFloatingRateAccrual = null;
            }
            if (this.facilityFxRate != null && !this.facilityFxRate.prune().hasData()) {
                this.facilityFxRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRepricingDate() != null) {
                return true;
            }
            if (this.getMaturityDate() != null) {
                return true;
            }
            if (this.getFixedRateAccrual() != null && this.getFixedRateAccrual().hasData()) {
                return true;
            }
            if (this.getFloatingRateAccrual() != null && this.getFloatingRateAccrual().hasData()) {
                return true;
            }
            if (this.getLegacyFloatingRateAccrual() != null && this.getLegacyFloatingRateAccrual().hasData()) {
                return true;
            }
            return this.getFacilityFxRate() != null && this.getFacilityFxRate().hasData();
        }

        @Override
        public LoanContractBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanContractBuilder o = (LoanContractBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixedRateAccrual(), (RosettaModelObjectBuilder)o.getFixedRateAccrual(), this::setFixedRateAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFloatingRateAccrual(), (RosettaModelObjectBuilder)o.getFloatingRateAccrual(), this::setFloatingRateAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyFloatingRateAccrual(), (RosettaModelObjectBuilder)o.getLegacyFloatingRateAccrual(), this::setLegacyFloatingRateAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityFxRate(), (RosettaModelObjectBuilder)o.getFacilityFxRate(), this::setFacilityFxRate);
            merger.mergeBasic((Object)this.getRepricingDate(), (Object)o.getRepricingDate(), this::setRepricingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaturityDate(), (Object)o.getMaturityDate(), this::setMaturityDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContract _that = (LoanContract)this.getType().cast(o);
            if (!Objects.equals(this.repricingDate, _that.getRepricingDate())) {
                return false;
            }
            if (!Objects.equals(this.maturityDate, _that.getMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateAccrual, _that.getFixedRateAccrual())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateAccrual, _that.getFloatingRateAccrual())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateAccrual, _that.getLegacyFloatingRateAccrual())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.repricingDate != null ? this.repricingDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateAccrual != null ? this.fixedRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateAccrual != null ? this.floatingRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateAccrual != null ? this.legacyFloatingRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContractBuilder {repricingDate=" + String.valueOf(this.repricingDate) + ", maturityDate=" + String.valueOf(this.maturityDate) + ", fixedRateAccrual=" + String.valueOf(this.fixedRateAccrual) + ", floatingRateAccrual=" + String.valueOf(this.floatingRateAccrual) + ", legacyFloatingRateAccrual=" + String.valueOf(this.legacyFloatingRateAccrual) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }

    public static interface LoanContractBuilder
    extends LoanContract,
    LoanContractSummary.LoanContractSummaryBuilder {
        public FixedRateAccrual.FixedRateAccrualBuilder getOrCreateFixedRateAccrual();

        @Override
        public FixedRateAccrual.FixedRateAccrualBuilder getFixedRateAccrual();

        public LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder getOrCreateFloatingRateAccrual();

        @Override
        public LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder getFloatingRateAccrual();

        public LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder getOrCreateLegacyFloatingRateAccrual();

        @Override
        public LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder getLegacyFloatingRateAccrual();

        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate();

        @Override
        public FxTerms.FxTermsBuilder getFacilityFxRate();

        @Override
        public LoanContractBuilder setPartyReference(PartyReference var1);

        @Override
        public LoanContractBuilder addContractId(ContractId var1);

        @Override
        public LoanContractBuilder addContractId(ContractId var1, int var2);

        @Override
        public LoanContractBuilder addContractId(List<? extends ContractId> var1);

        @Override
        public LoanContractBuilder setContractId(List<? extends ContractId> var1);

        @Override
        public LoanContractBuilder addVersionedContractId(VersionedContractId var1);

        @Override
        public LoanContractBuilder addVersionedContractId(VersionedContractId var1, int var2);

        @Override
        public LoanContractBuilder addVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LoanContractBuilder setVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LoanContractBuilder setId(String var1);

        @Override
        public LoanContractBuilder setFacilityReference(FacilityReference var1);

        @Override
        public LoanContractBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LoanContractBuilder setBorrowerPartyReference(PartyReference var1);

        @Override
        public LoanContractBuilder setGuarantorPartyReference(PartyReference var1);

        @Override
        public LoanContractBuilder setAmount(MoneyWithParticipantShare var1);

        public LoanContractBuilder setRepricingDate(ZonedDateTime var1);

        public LoanContractBuilder setMaturityDate(ZonedDateTime var1);

        public LoanContractBuilder setFixedRateAccrual(FixedRateAccrual var1);

        public LoanContractBuilder setFloatingRateAccrual(LoanFloatingRateAccrual var1);

        public LoanContractBuilder setLegacyFloatingRateAccrual(LegacyFloatingRateAccrual var1);

        public LoanContractBuilder setFacilityFxRate(FxTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractId"), processor, ContractId.ContractIdBuilder.class, this.getContractId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.VersionedContractIdBuilder.class, this.getVersionedContractId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("borrowerPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getBorrowerPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("guarantorPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getGuarantorPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("repricingDate"), ZonedDateTime.class, (Object)this.getRepricingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maturityDate"), ZonedDateTime.class, (Object)this.getMaturityDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixedRateAccrual"), processor, FixedRateAccrual.FixedRateAccrualBuilder.class, this.getFixedRateAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("floatingRateAccrual"), processor, LoanFloatingRateAccrual.LoanFloatingRateAccrualBuilder.class, this.getFloatingRateAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyFloatingRateAccrual"), processor, LegacyFloatingRateAccrual.LegacyFloatingRateAccrualBuilder.class, this.getLegacyFloatingRateAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getFacilityFxRate(), new AttributeMeta[0]);
        }

        @Override
        public LoanContractBuilder prune();
    }

    public static class LoanContractImpl
    extends LoanContractSummary.LoanContractSummaryImpl
    implements LoanContract {
        private final ZonedDateTime repricingDate;
        private final ZonedDateTime maturityDate;
        private final FixedRateAccrual fixedRateAccrual;
        private final LoanFloatingRateAccrual floatingRateAccrual;
        private final LegacyFloatingRateAccrual legacyFloatingRateAccrual;
        private final FxTerms facilityFxRate;

        protected LoanContractImpl(LoanContractBuilder builder) {
            super(builder);
            this.repricingDate = builder.getRepricingDate();
            this.maturityDate = builder.getMaturityDate();
            this.fixedRateAccrual = Optional.ofNullable(builder.getFixedRateAccrual()).map(f -> f.build()).orElse(null);
            this.floatingRateAccrual = Optional.ofNullable(builder.getFloatingRateAccrual()).map(f -> f.build()).orElse(null);
            this.legacyFloatingRateAccrual = Optional.ofNullable(builder.getLegacyFloatingRateAccrual()).map(f -> f.build()).orElse(null);
            this.facilityFxRate = Optional.ofNullable(builder.getFacilityFxRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="repricingDate")
        @RuneAttribute(value="repricingDate")
        public ZonedDateTime getRepricingDate() {
            return this.repricingDate;
        }

        @Override
        @RosettaAttribute(value="maturityDate")
        @RuneAttribute(value="maturityDate")
        public ZonedDateTime getMaturityDate() {
            return this.maturityDate;
        }

        @Override
        @RosettaAttribute(value="fixedRateAccrual")
        @RuneAttribute(value="fixedRateAccrual")
        public FixedRateAccrual getFixedRateAccrual() {
            return this.fixedRateAccrual;
        }

        @Override
        @RosettaAttribute(value="floatingRateAccrual")
        @RuneAttribute(value="floatingRateAccrual")
        public LoanFloatingRateAccrual getFloatingRateAccrual() {
            return this.floatingRateAccrual;
        }

        @Override
        @RosettaAttribute(value="legacyFloatingRateAccrual")
        @RuneAttribute(value="legacyFloatingRateAccrual")
        public LegacyFloatingRateAccrual getLegacyFloatingRateAccrual() {
            return this.legacyFloatingRateAccrual;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public LoanContract build() {
            return this;
        }

        @Override
        public LoanContractBuilder toBuilder() {
            LoanContractBuilder builder = LoanContract.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRepricingDate()).ifPresent(builder::setRepricingDate);
            Optional.ofNullable(this.getMaturityDate()).ifPresent(builder::setMaturityDate);
            Optional.ofNullable(this.getFixedRateAccrual()).ifPresent(builder::setFixedRateAccrual);
            Optional.ofNullable(this.getFloatingRateAccrual()).ifPresent(builder::setFloatingRateAccrual);
            Optional.ofNullable(this.getLegacyFloatingRateAccrual()).ifPresent(builder::setLegacyFloatingRateAccrual);
            Optional.ofNullable(this.getFacilityFxRate()).ifPresent(builder::setFacilityFxRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanContract _that = (LoanContract)this.getType().cast(o);
            if (!Objects.equals(this.repricingDate, _that.getRepricingDate())) {
                return false;
            }
            if (!Objects.equals(this.maturityDate, _that.getMaturityDate())) {
                return false;
            }
            if (!Objects.equals(this.fixedRateAccrual, _that.getFixedRateAccrual())) {
                return false;
            }
            if (!Objects.equals(this.floatingRateAccrual, _that.getFloatingRateAccrual())) {
                return false;
            }
            if (!Objects.equals(this.legacyFloatingRateAccrual, _that.getLegacyFloatingRateAccrual())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.repricingDate != null ? this.repricingDate.hashCode() : 0);
            _result = 31 * _result + (this.maturityDate != null ? this.maturityDate.hashCode() : 0);
            _result = 31 * _result + (this.fixedRateAccrual != null ? this.fixedRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.floatingRateAccrual != null ? this.floatingRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.legacyFloatingRateAccrual != null ? this.legacyFloatingRateAccrual.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanContract {repricingDate=" + String.valueOf(this.repricingDate) + ", maturityDate=" + String.valueOf(this.maturityDate) + ", fixedRateAccrual=" + String.valueOf(this.fixedRateAccrual) + ", floatingRateAccrual=" + String.valueOf(this.floatingRateAccrual) + ", legacyFloatingRateAccrual=" + String.valueOf(this.legacyFloatingRateAccrual) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }
}

