/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ContractId;
import fpml.consolidated.doc.VersionedContractId;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.FxTerms;
import fpml.consolidated.loan.LcAccrual;
import fpml.consolidated.loan.LcPurpose;
import fpml.consolidated.loan.LcType;
import fpml.consolidated.loan.LetterOfCreditFeaturesModel;
import fpml.consolidated.loan.LetterOfCreditRolesModel;
import fpml.consolidated.loan.LetterOfCreditSummary;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.LetterOfCreditMeta;
import fpml.consolidated.shared.PartyReference;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LetterOfCredit", builder=LetterOfCreditBuilderImpl.class, version="1.2.2")
@RuneDataType(value="LetterOfCredit", model="fpml", builder=LetterOfCreditBuilderImpl.class, version="1.2.2")
public interface LetterOfCredit
extends LetterOfCreditSummary {
    public static final LetterOfCreditMeta metaData = new LetterOfCreditMeta();

    public ZonedDateTime getExpiryDate();

    public ZonedDateTime getFinalExpiryDate();

    public LcAccrual getLcAccrual();

    public LcPurpose getPurpose();

    public LetterOfCreditFeaturesModel getLetterOfCreditFeaturesModel();

    public FxTerms getFacilityFxRate();

    @Override
    public LetterOfCredit build();

    @Override
    public LetterOfCreditBuilder toBuilder();

    public static LetterOfCreditBuilder builder() {
        return new LetterOfCreditBuilderImpl();
    }

    default public RosettaMetaData<? extends LetterOfCredit> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LetterOfCredit> getType() {
        return LetterOfCredit.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.class, this.getPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("contractId"), processor, ContractId.class, this.getContractId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.class, this.getVersionedContractId(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("type"), processor, LcType.class, this._getType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditRolesModel"), processor, LetterOfCreditRolesModel.class, this.getLetterOfCreditRolesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lcAccrual"), processor, LcAccrual.class, this.getLcAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("purpose"), processor, LcPurpose.class, this.getPurpose(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("letterOfCreditFeaturesModel"), processor, LetterOfCreditFeaturesModel.class, this.getLetterOfCreditFeaturesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.class, this.getFacilityFxRate(), new AttributeMeta[0]);
    }

    public static class LetterOfCreditBuilderImpl
    extends LetterOfCreditSummary.LetterOfCreditSummaryBuilderImpl
    implements LetterOfCreditBuilder {
        protected ZonedDateTime expiryDate;
        protected ZonedDateTime finalExpiryDate;
        protected LcAccrual.LcAccrualBuilder lcAccrual;
        protected LcPurpose.LcPurposeBuilder purpose;
        protected LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder letterOfCreditFeaturesModel;
        protected FxTerms.FxTermsBuilder facilityFxRate;

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public ZonedDateTime getExpiryDate() {
            return this.expiryDate;
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="lcAccrual", isRequired=true)
        @RuneAttribute(value="lcAccrual", isRequired=true)
        public LcAccrual.LcAccrualBuilder getLcAccrual() {
            return this.lcAccrual;
        }

        @Override
        public LcAccrual.LcAccrualBuilder getOrCreateLcAccrual() {
            LcAccrual.LcAccrualBuilder result = this.lcAccrual != null ? this.lcAccrual : (this.lcAccrual = LcAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="purpose")
        @RuneAttribute(value="purpose")
        public LcPurpose.LcPurposeBuilder getPurpose() {
            return this.purpose;
        }

        @Override
        public LcPurpose.LcPurposeBuilder getOrCreatePurpose() {
            LcPurpose.LcPurposeBuilder result = this.purpose != null ? this.purpose : (this.purpose = LcPurpose.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        public LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder getLetterOfCreditFeaturesModel() {
            return this.letterOfCreditFeaturesModel;
        }

        @Override
        public LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder getOrCreateLetterOfCreditFeaturesModel() {
            LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder result = this.letterOfCreditFeaturesModel != null ? this.letterOfCreditFeaturesModel : (this.letterOfCreditFeaturesModel = LetterOfCreditFeaturesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms.FxTermsBuilder getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate() {
            FxTerms.FxTermsBuilder result = this.facilityFxRate != null ? this.facilityFxRate : (this.facilityFxRate = FxTerms.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="partyReference", isRequired=true)
        @RuneAttribute(value="partyReference", isRequired=true)
        public LetterOfCreditBuilder setPartyReference(PartyReference _partyReference) {
            this.partyReference = _partyReference == null ? null : _partyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="contractId")
        @RuneAttribute(value="contractId")
        public LetterOfCreditBuilder addContractId(ContractId _contractId) {
            if (_contractId != null) {
                this.contractId.add(_contractId.toBuilder());
            }
            return this;
        }

        @Override
        public LetterOfCreditBuilder addContractId(ContractId _contractId, int idx) {
            this.getIndex(this.contractId, idx, () -> _contractId.toBuilder());
            return this;
        }

        @Override
        public LetterOfCreditBuilder addContractId(List<? extends ContractId> contractIds) {
            if (contractIds != null) {
                for (ContractId contractId : contractIds) {
                    this.contractId.add(contractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contractId")
        public LetterOfCreditBuilder setContractId(List<? extends ContractId> contractIds) {
            this.contractId = contractIds == null ? new ArrayList() : (List)contractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="versionedContractId")
        @RuneAttribute(value="versionedContractId")
        public LetterOfCreditBuilder addVersionedContractId(VersionedContractId _versionedContractId) {
            if (_versionedContractId != null) {
                this.versionedContractId.add(_versionedContractId.toBuilder());
            }
            return this;
        }

        @Override
        public LetterOfCreditBuilder addVersionedContractId(VersionedContractId _versionedContractId, int idx) {
            this.getIndex(this.versionedContractId, idx, () -> _versionedContractId.toBuilder());
            return this;
        }

        @Override
        public LetterOfCreditBuilder addVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            if (versionedContractIds != null) {
                for (VersionedContractId versionedContractId : versionedContractIds) {
                    this.versionedContractId.add(versionedContractId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="versionedContractId")
        public LetterOfCreditBuilder setVersionedContractId(List<? extends VersionedContractId> versionedContractIds) {
            this.versionedContractId = versionedContractIds == null ? new ArrayList() : (List)versionedContractIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LetterOfCreditBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LetterOfCreditBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="type", isRequired=true)
        @RuneAttribute(value="type", isRequired=true)
        public LetterOfCreditBuilder setType(LcType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LetterOfCreditBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditRolesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditRolesModel", isRequired=true)
        public LetterOfCreditBuilder setLetterOfCreditRolesModel(LetterOfCreditRolesModel _letterOfCreditRolesModel) {
            this.letterOfCreditRolesModel = _letterOfCreditRolesModel == null ? null : _letterOfCreditRolesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LetterOfCreditBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public LetterOfCreditBuilder setExpiryDate(ZonedDateTime _expiryDate) {
            this.expiryDate = _expiryDate == null ? null : _expiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public LetterOfCreditBuilder setFinalExpiryDate(ZonedDateTime _finalExpiryDate) {
            this.finalExpiryDate = _finalExpiryDate == null ? null : _finalExpiryDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="lcAccrual", isRequired=true)
        @RuneAttribute(value="lcAccrual", isRequired=true)
        public LetterOfCreditBuilder setLcAccrual(LcAccrual _lcAccrual) {
            this.lcAccrual = _lcAccrual == null ? null : _lcAccrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="purpose")
        @RuneAttribute(value="purpose")
        public LetterOfCreditBuilder setPurpose(LcPurpose _purpose) {
            this.purpose = _purpose == null ? null : _purpose.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        public LetterOfCreditBuilder setLetterOfCreditFeaturesModel(LetterOfCreditFeaturesModel _letterOfCreditFeaturesModel) {
            this.letterOfCreditFeaturesModel = _letterOfCreditFeaturesModel == null ? null : _letterOfCreditFeaturesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public LetterOfCreditBuilder setFacilityFxRate(FxTerms _facilityFxRate) {
            this.facilityFxRate = _facilityFxRate == null ? null : _facilityFxRate.toBuilder();
            return this;
        }

        @Override
        public LetterOfCredit build() {
            return new LetterOfCreditImpl(this);
        }

        @Override
        public LetterOfCreditBuilder toBuilder() {
            return this;
        }

        @Override
        public LetterOfCreditBuilder prune() {
            super.prune();
            if (this.lcAccrual != null && !this.lcAccrual.prune().hasData()) {
                this.lcAccrual = null;
            }
            if (this.purpose != null && !this.purpose.prune().hasData()) {
                this.purpose = null;
            }
            if (this.letterOfCreditFeaturesModel != null && !this.letterOfCreditFeaturesModel.prune().hasData()) {
                this.letterOfCreditFeaturesModel = null;
            }
            if (this.facilityFxRate != null && !this.facilityFxRate.prune().hasData()) {
                this.facilityFxRate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getExpiryDate() != null) {
                return true;
            }
            if (this.getFinalExpiryDate() != null) {
                return true;
            }
            if (this.getLcAccrual() != null && this.getLcAccrual().hasData()) {
                return true;
            }
            if (this.getPurpose() != null && this.getPurpose().hasData()) {
                return true;
            }
            if (this.getLetterOfCreditFeaturesModel() != null && this.getLetterOfCreditFeaturesModel().hasData()) {
                return true;
            }
            return this.getFacilityFxRate() != null && this.getFacilityFxRate().hasData();
        }

        @Override
        public LetterOfCreditBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LetterOfCreditBuilder o = (LetterOfCreditBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLcAccrual(), (RosettaModelObjectBuilder)o.getLcAccrual(), this::setLcAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPurpose(), (RosettaModelObjectBuilder)o.getPurpose(), this::setPurpose);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLetterOfCreditFeaturesModel(), (RosettaModelObjectBuilder)o.getLetterOfCreditFeaturesModel(), this::setLetterOfCreditFeaturesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityFxRate(), (RosettaModelObjectBuilder)o.getFacilityFxRate(), this::setFacilityFxRate);
            merger.mergeBasic((Object)this.getExpiryDate(), (Object)o.getExpiryDate(), this::setExpiryDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getFinalExpiryDate(), (Object)o.getFinalExpiryDate(), this::setFinalExpiryDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LetterOfCredit _that = (LetterOfCredit)this.getType().cast(o);
            if (!Objects.equals(this.expiryDate, _that.getExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.lcAccrual, _that.getLcAccrual())) {
                return false;
            }
            if (!Objects.equals(this.purpose, _that.getPurpose())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditFeaturesModel, _that.getLetterOfCreditFeaturesModel())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.lcAccrual != null ? this.lcAccrual.hashCode() : 0);
            _result = 31 * _result + (this.purpose != null ? this.purpose.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditFeaturesModel != null ? this.letterOfCreditFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LetterOfCreditBuilder {expiryDate=" + String.valueOf(this.expiryDate) + ", finalExpiryDate=" + String.valueOf(this.finalExpiryDate) + ", lcAccrual=" + String.valueOf(this.lcAccrual) + ", purpose=" + String.valueOf(this.purpose) + ", letterOfCreditFeaturesModel=" + String.valueOf(this.letterOfCreditFeaturesModel) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }

    public static interface LetterOfCreditBuilder
    extends LetterOfCredit,
    LetterOfCreditSummary.LetterOfCreditSummaryBuilder {
        public LcAccrual.LcAccrualBuilder getOrCreateLcAccrual();

        @Override
        public LcAccrual.LcAccrualBuilder getLcAccrual();

        public LcPurpose.LcPurposeBuilder getOrCreatePurpose();

        @Override
        public LcPurpose.LcPurposeBuilder getPurpose();

        public LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder getOrCreateLetterOfCreditFeaturesModel();

        @Override
        public LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder getLetterOfCreditFeaturesModel();

        public FxTerms.FxTermsBuilder getOrCreateFacilityFxRate();

        @Override
        public FxTerms.FxTermsBuilder getFacilityFxRate();

        @Override
        public LetterOfCreditBuilder setPartyReference(PartyReference var1);

        @Override
        public LetterOfCreditBuilder addContractId(ContractId var1);

        @Override
        public LetterOfCreditBuilder addContractId(ContractId var1, int var2);

        @Override
        public LetterOfCreditBuilder addContractId(List<? extends ContractId> var1);

        @Override
        public LetterOfCreditBuilder setContractId(List<? extends ContractId> var1);

        @Override
        public LetterOfCreditBuilder addVersionedContractId(VersionedContractId var1);

        @Override
        public LetterOfCreditBuilder addVersionedContractId(VersionedContractId var1, int var2);

        @Override
        public LetterOfCreditBuilder addVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LetterOfCreditBuilder setVersionedContractId(List<? extends VersionedContractId> var1);

        @Override
        public LetterOfCreditBuilder setId(String var1);

        @Override
        public LetterOfCreditBuilder setFacilityReference(FacilityReference var1);

        @Override
        public LetterOfCreditBuilder setType(LcType var1);

        @Override
        public LetterOfCreditBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LetterOfCreditBuilder setLetterOfCreditRolesModel(LetterOfCreditRolesModel var1);

        @Override
        public LetterOfCreditBuilder setAmount(MoneyWithParticipantShare var1);

        public LetterOfCreditBuilder setExpiryDate(ZonedDateTime var1);

        public LetterOfCreditBuilder setFinalExpiryDate(ZonedDateTime var1);

        public LetterOfCreditBuilder setLcAccrual(LcAccrual var1);

        public LetterOfCreditBuilder setPurpose(LcPurpose var1);

        public LetterOfCreditBuilder setLetterOfCreditFeaturesModel(LetterOfCreditFeaturesModel var1);

        public LetterOfCreditBuilder setFacilityFxRate(FxTerms var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyReference"), processor, PartyReference.PartyReferenceBuilder.class, (RosettaModelObjectBuilder)this.getPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("contractId"), processor, ContractId.ContractIdBuilder.class, this.getContractId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("versionedContractId"), processor, VersionedContractId.VersionedContractIdBuilder.class, this.getVersionedContractId(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("type"), processor, LcType.LcTypeBuilder.class, (RosettaModelObjectBuilder)this._getType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditRolesModel"), processor, LetterOfCreditRolesModel.LetterOfCreditRolesModelBuilder.class, (RosettaModelObjectBuilder)this.getLetterOfCreditRolesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, (RosettaModelObjectBuilder)this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expiryDate"), ZonedDateTime.class, (Object)this.getExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("finalExpiryDate"), ZonedDateTime.class, (Object)this.getFinalExpiryDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lcAccrual"), processor, LcAccrual.LcAccrualBuilder.class, this.getLcAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("purpose"), processor, LcPurpose.LcPurposeBuilder.class, this.getPurpose(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("letterOfCreditFeaturesModel"), processor, LetterOfCreditFeaturesModel.LetterOfCreditFeaturesModelBuilder.class, this.getLetterOfCreditFeaturesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityFxRate"), processor, FxTerms.FxTermsBuilder.class, this.getFacilityFxRate(), new AttributeMeta[0]);
        }

        @Override
        public LetterOfCreditBuilder prune();
    }

    public static class LetterOfCreditImpl
    extends LetterOfCreditSummary.LetterOfCreditSummaryImpl
    implements LetterOfCredit {
        private final ZonedDateTime expiryDate;
        private final ZonedDateTime finalExpiryDate;
        private final LcAccrual lcAccrual;
        private final LcPurpose purpose;
        private final LetterOfCreditFeaturesModel letterOfCreditFeaturesModel;
        private final FxTerms facilityFxRate;

        protected LetterOfCreditImpl(LetterOfCreditBuilder builder) {
            super(builder);
            this.expiryDate = builder.getExpiryDate();
            this.finalExpiryDate = builder.getFinalExpiryDate();
            this.lcAccrual = Optional.ofNullable(builder.getLcAccrual()).map(f -> f.build()).orElse(null);
            this.purpose = Optional.ofNullable(builder.getPurpose()).map(f -> f.build()).orElse(null);
            this.letterOfCreditFeaturesModel = Optional.ofNullable(builder.getLetterOfCreditFeaturesModel()).map(f -> f.build()).orElse(null);
            this.facilityFxRate = Optional.ofNullable(builder.getFacilityFxRate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="expiryDate", isRequired=true)
        @RuneAttribute(value="expiryDate", isRequired=true)
        public ZonedDateTime getExpiryDate() {
            return this.expiryDate;
        }

        @Override
        @RosettaAttribute(value="finalExpiryDate")
        @RuneAttribute(value="finalExpiryDate")
        public ZonedDateTime getFinalExpiryDate() {
            return this.finalExpiryDate;
        }

        @Override
        @RosettaAttribute(value="lcAccrual", isRequired=true)
        @RuneAttribute(value="lcAccrual", isRequired=true)
        public LcAccrual getLcAccrual() {
            return this.lcAccrual;
        }

        @Override
        @RosettaAttribute(value="purpose")
        @RuneAttribute(value="purpose")
        public LcPurpose getPurpose() {
            return this.purpose;
        }

        @Override
        @RosettaAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        @RuneAttribute(value="letterOfCreditFeaturesModel", isRequired=true)
        public LetterOfCreditFeaturesModel getLetterOfCreditFeaturesModel() {
            return this.letterOfCreditFeaturesModel;
        }

        @Override
        @RosettaAttribute(value="facilityFxRate")
        @RuneAttribute(value="facilityFxRate")
        public FxTerms getFacilityFxRate() {
            return this.facilityFxRate;
        }

        @Override
        public LetterOfCredit build() {
            return this;
        }

        @Override
        public LetterOfCreditBuilder toBuilder() {
            LetterOfCreditBuilder builder = LetterOfCredit.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LetterOfCreditBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getExpiryDate()).ifPresent(builder::setExpiryDate);
            Optional.ofNullable(this.getFinalExpiryDate()).ifPresent(builder::setFinalExpiryDate);
            Optional.ofNullable(this.getLcAccrual()).ifPresent(builder::setLcAccrual);
            Optional.ofNullable(this.getPurpose()).ifPresent(builder::setPurpose);
            Optional.ofNullable(this.getLetterOfCreditFeaturesModel()).ifPresent(builder::setLetterOfCreditFeaturesModel);
            Optional.ofNullable(this.getFacilityFxRate()).ifPresent(builder::setFacilityFxRate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LetterOfCredit _that = (LetterOfCredit)this.getType().cast(o);
            if (!Objects.equals(this.expiryDate, _that.getExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.finalExpiryDate, _that.getFinalExpiryDate())) {
                return false;
            }
            if (!Objects.equals(this.lcAccrual, _that.getLcAccrual())) {
                return false;
            }
            if (!Objects.equals(this.purpose, _that.getPurpose())) {
                return false;
            }
            if (!Objects.equals(this.letterOfCreditFeaturesModel, _that.getLetterOfCreditFeaturesModel())) {
                return false;
            }
            return Objects.equals(this.facilityFxRate, _that.getFacilityFxRate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.expiryDate != null ? this.expiryDate.hashCode() : 0);
            _result = 31 * _result + (this.finalExpiryDate != null ? this.finalExpiryDate.hashCode() : 0);
            _result = 31 * _result + (this.lcAccrual != null ? this.lcAccrual.hashCode() : 0);
            _result = 31 * _result + (this.purpose != null ? this.purpose.hashCode() : 0);
            _result = 31 * _result + (this.letterOfCreditFeaturesModel != null ? this.letterOfCreditFeaturesModel.hashCode() : 0);
            _result = 31 * _result + (this.facilityFxRate != null ? this.facilityFxRate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LetterOfCredit {expiryDate=" + String.valueOf(this.expiryDate) + ", finalExpiryDate=" + String.valueOf(this.finalExpiryDate) + ", lcAccrual=" + String.valueOf(this.lcAccrual) + ", purpose=" + String.valueOf(this.purpose) + ", letterOfCreditFeaturesModel=" + String.valueOf(this.letterOfCreditFeaturesModel) + ", facilityFxRate=" + String.valueOf(this.facilityFxRate) + "} " + super.toString();
        }
    }
}

