/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.fpmlenum.InterestCalculationMethodEnum;
import fpml.consolidated.loan.AbstractLoanContractEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.InterestCapitalizationSequence;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanContractReference;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.InterestCapitalizationMeta;
import fpml.consolidated.shared.PeriodModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="InterestCapitalization", builder=InterestCapitalizationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="InterestCapitalization", model="fpml", builder=InterestCapitalizationBuilderImpl.class, version="1.2.2")
public interface InterestCapitalization
extends AbstractLoanContractEvent {
    public static final InterestCapitalizationMeta metaData = new InterestCapitalizationMeta();

    public PeriodModel getPeriodModel();

    public InterestCalculationMethodEnum getCalculationMethod();

    public MoneyWithParticipantShare getAmount();

    public InterestCapitalizationSequence getInterestCapitalizationSequence();

    @Override
    public InterestCapitalization build();

    @Override
    public InterestCapitalizationBuilder toBuilder();

    public static InterestCapitalizationBuilder builder() {
        return new InterestCapitalizationBuilderImpl();
    }

    default public RosettaMetaData<? extends InterestCapitalization> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InterestCapitalization> getType() {
        return InterestCapitalization.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCapitalizationSequence"), processor, InterestCapitalizationSequence.class, this.getInterestCapitalizationSequence(), new AttributeMeta[0]);
    }

    public static class InterestCapitalizationBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements InterestCapitalizationBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected InterestCalculationMethodEnum calculationMethod;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder interestCapitalizationSequence;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestCapitalizationSequence")
        @RuneAttribute(value="interestCapitalizationSequence")
        public InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder getInterestCapitalizationSequence() {
            return this.interestCapitalizationSequence;
        }

        @Override
        public InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder getOrCreateInterestCapitalizationSequence() {
            InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder result = this.interestCapitalizationSequence != null ? this.interestCapitalizationSequence : (this.interestCapitalizationSequence = InterestCapitalizationSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public InterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public InterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public InterestCapitalizationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public InterestCapitalizationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public InterestCapitalizationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public InterestCapitalizationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public InterestCapitalizationBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public InterestCapitalizationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public InterestCapitalizationBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public InterestCapitalizationBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public InterestCapitalizationBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public InterestCapitalizationBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCapitalizationBuilder setCalculationMethod(InterestCalculationMethodEnum _calculationMethod) {
            this.calculationMethod = _calculationMethod == null ? null : _calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public InterestCapitalizationBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestCapitalizationSequence")
        @RuneAttribute(value="interestCapitalizationSequence")
        public InterestCapitalizationBuilder setInterestCapitalizationSequence(InterestCapitalizationSequence _interestCapitalizationSequence) {
            this.interestCapitalizationSequence = _interestCapitalizationSequence == null ? null : _interestCapitalizationSequence.toBuilder();
            return this;
        }

        @Override
        public InterestCapitalization build() {
            return new InterestCapitalizationImpl(this);
        }

        @Override
        public InterestCapitalizationBuilder toBuilder() {
            return this;
        }

        @Override
        public InterestCapitalizationBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.interestCapitalizationSequence != null && !this.interestCapitalizationSequence.prune().hasData()) {
                this.interestCapitalizationSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getInterestCapitalizationSequence() != null && this.getInterestCapitalizationSequence().hasData();
        }

        @Override
        public InterestCapitalizationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InterestCapitalizationBuilder o = (InterestCapitalizationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCapitalizationSequence(), (RosettaModelObjectBuilder)o.getInterestCapitalizationSequence(), this::setInterestCapitalizationSequence);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestCapitalization _that = (InterestCapitalization)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.interestCapitalizationSequence, _that.getInterestCapitalizationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.interestCapitalizationSequence != null ? this.interestCapitalizationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestCapitalizationBuilder {periodModel=" + String.valueOf(this.periodModel) + ", calculationMethod=" + String.valueOf((Object)this.calculationMethod) + ", amount=" + String.valueOf(this.amount) + ", interestCapitalizationSequence=" + String.valueOf(this.interestCapitalizationSequence) + "} " + super.toString();
        }
    }

    public static interface InterestCapitalizationBuilder
    extends InterestCapitalization,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder getOrCreateInterestCapitalizationSequence();

        @Override
        public InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder getInterestCapitalizationSequence();

        @Override
        public InterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public InterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public InterestCapitalizationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public InterestCapitalizationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public InterestCapitalizationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public InterestCapitalizationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public InterestCapitalizationBuilder setComment(String var1);

        @Override
        public InterestCapitalizationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public InterestCapitalizationBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public InterestCapitalizationBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public InterestCapitalizationBuilder setLoanContractReference(LoanContractReference var1);

        public InterestCapitalizationBuilder setPeriodModel(PeriodModel var1);

        public InterestCapitalizationBuilder setCalculationMethod(InterestCalculationMethodEnum var1);

        public InterestCapitalizationBuilder setAmount(MoneyWithParticipantShare var1);

        public InterestCapitalizationBuilder setInterestCapitalizationSequence(InterestCapitalizationSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCapitalizationSequence"), processor, InterestCapitalizationSequence.InterestCapitalizationSequenceBuilder.class, this.getInterestCapitalizationSequence(), new AttributeMeta[0]);
        }

        @Override
        public InterestCapitalizationBuilder prune();
    }

    public static class InterestCapitalizationImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements InterestCapitalization {
        private final PeriodModel periodModel;
        private final InterestCalculationMethodEnum calculationMethod;
        private final MoneyWithParticipantShare amount;
        private final InterestCapitalizationSequence interestCapitalizationSequence;

        protected InterestCapitalizationImpl(InterestCapitalizationBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.calculationMethod = builder.getCalculationMethod();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.interestCapitalizationSequence = Optional.ofNullable(builder.getInterestCapitalizationSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="interestCapitalizationSequence")
        @RuneAttribute(value="interestCapitalizationSequence")
        public InterestCapitalizationSequence getInterestCapitalizationSequence() {
            return this.interestCapitalizationSequence;
        }

        @Override
        public InterestCapitalization build() {
            return this;
        }

        @Override
        public InterestCapitalizationBuilder toBuilder() {
            InterestCapitalizationBuilder builder = InterestCapitalization.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InterestCapitalizationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getInterestCapitalizationSequence()).ifPresent(builder::setInterestCapitalizationSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InterestCapitalization _that = (InterestCapitalization)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.interestCapitalizationSequence, _that.getInterestCapitalizationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.interestCapitalizationSequence != null ? this.interestCapitalizationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InterestCapitalization {periodModel=" + String.valueOf(this.periodModel) + ", calculationMethod=" + String.valueOf((Object)this.calculationMethod) + ", amount=" + String.valueOf(this.amount) + ", interestCapitalizationSequence=" + String.valueOf(this.interestCapitalizationSequence) + "} " + super.toString();
        }
    }
}

