/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.loan.AbstractFacilityEvent;
import fpml.consolidated.loan.AbstractLoanEventSequence;
import fpml.consolidated.loan.BusinessEventPartiesModel;
import fpml.consolidated.loan.FacilityReference;
import fpml.consolidated.loan.LenderAndCashDetailsModel;
import fpml.consolidated.loan.LoanLegalActionReference;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.FacilityPrepaymentFeePaymentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityPrepaymentFeePayment", builder=FacilityPrepaymentFeePaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FacilityPrepaymentFeePayment", model="fpml", builder=FacilityPrepaymentFeePaymentBuilderImpl.class, version="1.2.2")
public interface FacilityPrepaymentFeePayment
extends AbstractFacilityEvent {
    public static final FacilityPrepaymentFeePaymentMeta metaData = new FacilityPrepaymentFeePaymentMeta();

    public MoneyWithParticipantShare getAmount();

    @Override
    public FacilityPrepaymentFeePayment build();

    @Override
    public FacilityPrepaymentFeePaymentBuilder toBuilder();

    public static FacilityPrepaymentFeePaymentBuilder builder() {
        return new FacilityPrepaymentFeePaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityPrepaymentFeePayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityPrepaymentFeePayment> getType() {
        return FacilityPrepaymentFeePayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
    }

    public static class FacilityPrepaymentFeePaymentBuilderImpl
    extends AbstractFacilityEvent.AbstractFacilityEventBuilderImpl
    implements FacilityPrepaymentFeePaymentBuilder {
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public FacilityPrepaymentFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public FacilityPrepaymentFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public FacilityPrepaymentFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public FacilityPrepaymentFeePaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public FacilityPrepaymentFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public FacilityPrepaymentFeePaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public FacilityPrepaymentFeePaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityPrepaymentFeePaymentBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public FacilityPrepaymentFeePaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        public FacilityPrepaymentFeePayment build() {
            return new FacilityPrepaymentFeePaymentImpl(this);
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder prune() {
            super.prune();
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getAmount() != null && this.getAmount().hasData();
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FacilityPrepaymentFeePaymentBuilder o = (FacilityPrepaymentFeePaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPrepaymentFeePayment _that = (FacilityPrepaymentFeePayment)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPrepaymentFeePaymentBuilder {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }

    public static interface FacilityPrepaymentFeePaymentBuilder
    extends FacilityPrepaymentFeePayment,
    AbstractFacilityEvent.AbstractFacilityEventBuilder {
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        @Override
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public FacilityPrepaymentFeePaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setComment(String var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public FacilityPrepaymentFeePaymentBuilder setFacilityReference(FacilityReference var1);

        public FacilityPrepaymentFeePaymentBuilder setAmount(MoneyWithParticipantShare var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, (RosettaModelObjectBuilder)this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder prune();
    }

    public static class FacilityPrepaymentFeePaymentImpl
    extends AbstractFacilityEvent.AbstractFacilityEventImpl
    implements FacilityPrepaymentFeePayment {
        private final MoneyWithParticipantShare amount;

        protected FacilityPrepaymentFeePaymentImpl(FacilityPrepaymentFeePaymentBuilder builder) {
            super(builder);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        public FacilityPrepaymentFeePayment build() {
            return this;
        }

        @Override
        public FacilityPrepaymentFeePaymentBuilder toBuilder() {
            FacilityPrepaymentFeePaymentBuilder builder = FacilityPrepaymentFeePayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityPrepaymentFeePaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FacilityPrepaymentFeePayment _that = (FacilityPrepaymentFeePayment)this.getType().cast(o);
            return Objects.equals(this.amount, _that.getAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FacilityPrepaymentFeePayment {amount=" + String.valueOf(this.amount) + "} " + super.toString();
        }
    }
}

