/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.MoneyWithParticipantShare;
import fpml.consolidated.loan.meta.DealSummarySequenceMeta;
import fpml.consolidated.shared.NonNegativeMoney;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="DealSummarySequence", builder=DealSummarySequenceBuilderImpl.class, version="1.2.2")
@RuneDataType(value="DealSummarySequence", model="fpml", builder=DealSummarySequenceBuilderImpl.class, version="1.2.2")
public interface DealSummarySequence
extends RosettaModelObject {
    public static final DealSummarySequenceMeta metaData = new DealSummarySequenceMeta();

    public NonNegativeMoney getIssuedAmount();

    public MoneyWithParticipantShare getCurrentDealAmount();

    public DealSummarySequence build();

    public DealSummarySequenceBuilder toBuilder();

    public static DealSummarySequenceBuilder builder() {
        return new DealSummarySequenceBuilderImpl();
    }

    default public RosettaMetaData<? extends DealSummarySequence> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends DealSummarySequence> getType() {
        return DealSummarySequence.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuedAmount"), processor, NonNegativeMoney.class, this.getIssuedAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currentDealAmount"), processor, MoneyWithParticipantShare.class, this.getCurrentDealAmount(), new AttributeMeta[0]);
    }

    public static class DealSummarySequenceBuilderImpl
    implements DealSummarySequenceBuilder {
        protected NonNegativeMoney.NonNegativeMoneyBuilder issuedAmount;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder currentDealAmount;

        @Override
        @RosettaAttribute(value="issuedAmount", isRequired=true)
        @RuneAttribute(value="issuedAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getIssuedAmount() {
            return this.issuedAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateIssuedAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.issuedAmount != null ? this.issuedAmount : (this.issuedAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currentDealAmount")
        @RuneAttribute(value="currentDealAmount")
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getCurrentDealAmount() {
            return this.currentDealAmount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateCurrentDealAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.currentDealAmount != null ? this.currentDealAmount : (this.currentDealAmount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuedAmount", isRequired=true)
        @RuneAttribute(value="issuedAmount", isRequired=true)
        public DealSummarySequenceBuilder setIssuedAmount(NonNegativeMoney _issuedAmount) {
            this.issuedAmount = _issuedAmount == null ? null : _issuedAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currentDealAmount")
        @RuneAttribute(value="currentDealAmount")
        public DealSummarySequenceBuilder setCurrentDealAmount(MoneyWithParticipantShare _currentDealAmount) {
            this.currentDealAmount = _currentDealAmount == null ? null : _currentDealAmount.toBuilder();
            return this;
        }

        @Override
        public DealSummarySequence build() {
            return new DealSummarySequenceImpl(this);
        }

        @Override
        public DealSummarySequenceBuilder toBuilder() {
            return this;
        }

        @Override
        public DealSummarySequenceBuilder prune() {
            if (this.issuedAmount != null && !this.issuedAmount.prune().hasData()) {
                this.issuedAmount = null;
            }
            if (this.currentDealAmount != null && !this.currentDealAmount.prune().hasData()) {
                this.currentDealAmount = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIssuedAmount() != null && this.getIssuedAmount().hasData()) {
                return true;
            }
            return this.getCurrentDealAmount() != null && this.getCurrentDealAmount().hasData();
        }

        public DealSummarySequenceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            DealSummarySequenceBuilder o = (DealSummarySequenceBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuedAmount(), (RosettaModelObjectBuilder)o.getIssuedAmount(), this::setIssuedAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrentDealAmount(), (RosettaModelObjectBuilder)o.getCurrentDealAmount(), this::setCurrentDealAmount);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DealSummarySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.issuedAmount, _that.getIssuedAmount())) {
                return false;
            }
            return Objects.equals(this.currentDealAmount, _that.getCurrentDealAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuedAmount != null ? this.issuedAmount.hashCode() : 0);
            _result = 31 * _result + (this.currentDealAmount != null ? this.currentDealAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DealSummarySequenceBuilder {issuedAmount=" + String.valueOf(this.issuedAmount) + ", currentDealAmount=" + String.valueOf(this.currentDealAmount) + "}";
        }
    }

    public static interface DealSummarySequenceBuilder
    extends DealSummarySequence,
    RosettaModelObjectBuilder {
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateIssuedAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getIssuedAmount();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateCurrentDealAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getCurrentDealAmount();

        public DealSummarySequenceBuilder setIssuedAmount(NonNegativeMoney var1);

        public DealSummarySequenceBuilder setCurrentDealAmount(MoneyWithParticipantShare var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuedAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getIssuedAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currentDealAmount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getCurrentDealAmount(), new AttributeMeta[0]);
        }

        public DealSummarySequenceBuilder prune();
    }

    public static class DealSummarySequenceImpl
    implements DealSummarySequence {
        private final NonNegativeMoney issuedAmount;
        private final MoneyWithParticipantShare currentDealAmount;

        protected DealSummarySequenceImpl(DealSummarySequenceBuilder builder) {
            this.issuedAmount = Optional.ofNullable(builder.getIssuedAmount()).map(f -> f.build()).orElse(null);
            this.currentDealAmount = Optional.ofNullable(builder.getCurrentDealAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="issuedAmount", isRequired=true)
        @RuneAttribute(value="issuedAmount", isRequired=true)
        public NonNegativeMoney getIssuedAmount() {
            return this.issuedAmount;
        }

        @Override
        @RosettaAttribute(value="currentDealAmount")
        @RuneAttribute(value="currentDealAmount")
        public MoneyWithParticipantShare getCurrentDealAmount() {
            return this.currentDealAmount;
        }

        @Override
        public DealSummarySequence build() {
            return this;
        }

        @Override
        public DealSummarySequenceBuilder toBuilder() {
            DealSummarySequenceBuilder builder = DealSummarySequence.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(DealSummarySequenceBuilder builder) {
            Optional.ofNullable(this.getIssuedAmount()).ifPresent(builder::setIssuedAmount);
            Optional.ofNullable(this.getCurrentDealAmount()).ifPresent(builder::setCurrentDealAmount);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            DealSummarySequence _that = this.getType().cast(o);
            if (!Objects.equals(this.issuedAmount, _that.getIssuedAmount())) {
                return false;
            }
            return Objects.equals(this.currentDealAmount, _that.getCurrentDealAmount());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.issuedAmount != null ? this.issuedAmount.hashCode() : 0);
            _result = 31 * _result + (this.currentDealAmount != null ? this.currentDealAmount.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "DealSummarySequence {issuedAmount=" + String.valueOf(this.issuedAmount) + ", currentDealAmount=" + String.valueOf(this.currentDealAmount) + "}";
        }
    }
}

