/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.FeeRateOptionBase;
import fpml.consolidated.loan.meta.AccruingPikOptionMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import fpml.consolidated.shared.PeriodModel;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AccruingPikOption", builder=AccruingPikOptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AccruingPikOption", model="fpml", builder=AccruingPikOptionBuilderImpl.class, version="1.2.2")
public interface AccruingPikOption
extends FeeRateOptionBase {
    public static final AccruingPikOptionMeta metaData = new AccruingPikOptionMeta();

    public PeriodModel getPeriodModel();

    @Override
    public AccruingPikOption build();

    @Override
    public AccruingPikOptionBuilder toBuilder();

    public static AccruingPikOptionBuilder builder() {
        return new AccruingPikOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends AccruingPikOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AccruingPikOption> getType() {
        return AccruingPikOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
    }

    public static class AccruingPikOptionBuilderImpl
    extends FeeRateOptionBase.FeeRateOptionBaseBuilderImpl
    implements AccruingPikOptionBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AccruingPikOptionBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public AccruingPikOptionBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public AccruingPikOptionBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AccruingPikOptionBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public AccruingPikOptionBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        public AccruingPikOption build() {
            return new AccruingPikOptionImpl(this);
        }

        @Override
        public AccruingPikOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public AccruingPikOptionBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getPeriodModel() != null && this.getPeriodModel().hasData();
        }

        @Override
        public AccruingPikOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AccruingPikOptionBuilder o = (AccruingPikOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingPikOption _that = (AccruingPikOption)this.getType().cast(o);
            return Objects.equals(this.periodModel, _that.getPeriodModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingPikOptionBuilder {periodModel=" + String.valueOf(this.periodModel) + "} " + super.toString();
        }
    }

    public static interface AccruingPikOptionBuilder
    extends AccruingPikOption,
    FeeRateOptionBase.FeeRateOptionBaseBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        @Override
        public AccruingPikOptionBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public AccruingPikOptionBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public AccruingPikOptionBuilder setPaymentFrequency(Period var1);

        @Override
        public AccruingPikOptionBuilder setRate(BigDecimal var1);

        public AccruingPikOptionBuilder setPeriodModel(PeriodModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
        }

        @Override
        public AccruingPikOptionBuilder prune();
    }

    public static class AccruingPikOptionImpl
    extends FeeRateOptionBase.FeeRateOptionBaseImpl
    implements AccruingPikOption {
        private final PeriodModel periodModel;

        protected AccruingPikOptionImpl(AccruingPikOptionBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public AccruingPikOption build() {
            return this;
        }

        @Override
        public AccruingPikOptionBuilder toBuilder() {
            AccruingPikOptionBuilder builder = AccruingPikOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AccruingPikOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AccruingPikOption _that = (AccruingPikOption)this.getType().cast(o);
            return Objects.equals(this.periodModel, _that.getPeriodModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AccruingPikOption {periodModel=" + String.valueOf(this.periodModel) + "} " + super.toString();
        }
    }
}

