/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.loan.AbstractAccrualOptionBase;
import fpml.consolidated.loan.AccrualTypeId;
import fpml.consolidated.loan.meta.AbstractFixedRateOptionBaseMeta;
import fpml.consolidated.shared.DayCountFraction;
import fpml.consolidated.shared.Period;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="AbstractFixedRateOptionBase", builder=AbstractFixedRateOptionBaseBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractFixedRateOptionBase", model="fpml", builder=AbstractFixedRateOptionBaseBuilderImpl.class, version="1.2.2")
public interface AbstractFixedRateOptionBase
extends AbstractAccrualOptionBase {
    public static final AbstractFixedRateOptionBaseMeta metaData = new AbstractFixedRateOptionBaseMeta();

    public BigDecimal getRate();

    public BigDecimal getPikSpread();

    @Override
    public AbstractFixedRateOptionBase build();

    @Override
    public AbstractFixedRateOptionBaseBuilder toBuilder();

    public static AbstractFixedRateOptionBaseBuilder builder() {
        return new AbstractFixedRateOptionBaseBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFixedRateOptionBase> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFixedRateOptionBase> getType() {
        return AbstractFixedRateOptionBase.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.class, this.getAccrualOptionId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.class, this.getDayCountFraction(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.class, this.getPaymentFrequency(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AbstractFixedRateOptionBaseBuilderImpl
    extends AbstractAccrualOptionBase.AbstractAccrualOptionBaseBuilderImpl
    implements AbstractFixedRateOptionBaseBuilder {
        protected BigDecimal rate;
        protected BigDecimal pikSpread;

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="pikSpread")
        @RuneAttribute(value="pikSpread")
        public BigDecimal getPikSpread() {
            return this.pikSpread;
        }

        @Override
        @RosettaAttribute(value="accrualOptionId", isRequired=true)
        @RuneAttribute(value="accrualOptionId", isRequired=true)
        public AbstractFixedRateOptionBaseBuilder setAccrualOptionId(AccrualTypeId _accrualOptionId) {
            this.accrualOptionId = _accrualOptionId == null ? null : _accrualOptionId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="dayCountFraction", isRequired=true)
        @RuneAttribute(value="dayCountFraction", isRequired=true)
        public AbstractFixedRateOptionBaseBuilder setDayCountFraction(DayCountFraction _dayCountFraction) {
            this.dayCountFraction = _dayCountFraction == null ? null : _dayCountFraction.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentFrequency")
        @RuneAttribute(value="paymentFrequency")
        public AbstractFixedRateOptionBaseBuilder setPaymentFrequency(Period _paymentFrequency) {
            this.paymentFrequency = _paymentFrequency == null ? null : _paymentFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public AbstractFixedRateOptionBaseBuilder setRate(BigDecimal _rate) {
            this.rate = _rate == null ? null : _rate;
            return this;
        }

        @Override
        @RosettaAttribute(value="pikSpread")
        @RuneAttribute(value="pikSpread")
        public AbstractFixedRateOptionBaseBuilder setPikSpread(BigDecimal _pikSpread) {
            this.pikSpread = _pikSpread == null ? null : _pikSpread;
            return this;
        }

        @Override
        public AbstractFixedRateOptionBase build() {
            return new AbstractFixedRateOptionBaseImpl(this);
        }

        @Override
        public AbstractFixedRateOptionBaseBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFixedRateOptionBaseBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getRate() != null) {
                return true;
            }
            return this.getPikSpread() != null;
        }

        @Override
        public AbstractFixedRateOptionBaseBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFixedRateOptionBaseBuilder o = (AbstractFixedRateOptionBaseBuilder)other;
            merger.mergeBasic((Object)this.getRate(), (Object)o.getRate(), this::setRate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getPikSpread(), (Object)o.getPikSpread(), this::setPikSpread, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFixedRateOptionBase _that = (AbstractFixedRateOptionBase)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.pikSpread, _that.getPikSpread());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.pikSpread != null ? this.pikSpread.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFixedRateOptionBaseBuilder {rate=" + String.valueOf(this.rate) + ", pikSpread=" + String.valueOf(this.pikSpread) + "} " + super.toString();
        }
    }

    public static interface AbstractFixedRateOptionBaseBuilder
    extends AbstractFixedRateOptionBase,
    AbstractAccrualOptionBase.AbstractAccrualOptionBaseBuilder {
        @Override
        public AbstractFixedRateOptionBaseBuilder setAccrualOptionId(AccrualTypeId var1);

        @Override
        public AbstractFixedRateOptionBaseBuilder setDayCountFraction(DayCountFraction var1);

        @Override
        public AbstractFixedRateOptionBaseBuilder setPaymentFrequency(Period var1);

        public AbstractFixedRateOptionBaseBuilder setRate(BigDecimal var1);

        public AbstractFixedRateOptionBaseBuilder setPikSpread(BigDecimal var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("accrualOptionId"), processor, AccrualTypeId.AccrualTypeIdBuilder.class, (RosettaModelObjectBuilder)this.getAccrualOptionId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("dayCountFraction"), processor, DayCountFraction.DayCountFractionBuilder.class, (RosettaModelObjectBuilder)this.getDayCountFraction(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentFrequency"), processor, Period.PeriodBuilder.class, (RosettaModelObjectBuilder)this.getPaymentFrequency(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("rate"), BigDecimal.class, (Object)this.getRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("pikSpread"), BigDecimal.class, (Object)this.getPikSpread(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public AbstractFixedRateOptionBaseBuilder prune();
    }

    public static class AbstractFixedRateOptionBaseImpl
    extends AbstractAccrualOptionBase.AbstractAccrualOptionBaseImpl
    implements AbstractFixedRateOptionBase {
        private final BigDecimal rate;
        private final BigDecimal pikSpread;

        protected AbstractFixedRateOptionBaseImpl(AbstractFixedRateOptionBaseBuilder builder) {
            super(builder);
            this.rate = builder.getRate();
            this.pikSpread = builder.getPikSpread();
        }

        @Override
        @RosettaAttribute(value="rate", isRequired=true)
        @RuneAttribute(value="rate", isRequired=true)
        public BigDecimal getRate() {
            return this.rate;
        }

        @Override
        @RosettaAttribute(value="pikSpread")
        @RuneAttribute(value="pikSpread")
        public BigDecimal getPikSpread() {
            return this.pikSpread;
        }

        @Override
        public AbstractFixedRateOptionBase build() {
            return this;
        }

        @Override
        public AbstractFixedRateOptionBaseBuilder toBuilder() {
            AbstractFixedRateOptionBaseBuilder builder = AbstractFixedRateOptionBase.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFixedRateOptionBaseBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRate()).ifPresent(builder::setRate);
            Optional.ofNullable(this.getPikSpread()).ifPresent(builder::setPikSpread);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFixedRateOptionBase _that = (AbstractFixedRateOptionBase)this.getType().cast(o);
            if (!Objects.equals(this.rate, _that.getRate())) {
                return false;
            }
            return Objects.equals(this.pikSpread, _that.getPikSpread());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rate != null ? this.rate.hashCode() : 0);
            _result = 31 * _result + (this.pikSpread != null ? this.pikSpread.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFixedRateOptionBase {rate=" + String.valueOf(this.rate) + ", pikSpread=" + String.valueOf(this.pikSpread) + "} " + super.toString();
        }
    }
}

