/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.loan;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.loan.AbstractServicingNotification;
import fpml.consolidated.loan.EventPayment;
import fpml.consolidated.loan.FacilityPosition;
import fpml.consolidated.loan.meta.AbstractFacilityNotificationMeta;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="AbstractFacilityNotification", builder=AbstractFacilityNotificationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="AbstractFacilityNotification", model="fpml", builder=AbstractFacilityNotificationBuilderImpl.class, version="1.2.2")
public interface AbstractFacilityNotification
extends AbstractServicingNotification {
    public static final AbstractFacilityNotificationMeta metaData = new AbstractFacilityNotificationMeta();

    public FacilityPosition getFacilityPosition();

    @Override
    public AbstractFacilityNotification build();

    @Override
    public AbstractFacilityNotificationBuilder toBuilder();

    public static AbstractFacilityNotificationBuilder builder() {
        return new AbstractFacilityNotificationBuilderImpl();
    }

    default public RosettaMetaData<? extends AbstractFacilityNotification> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends AbstractFacilityNotification> getType() {
        return AbstractFacilityNotification.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.class, this.getEventPayment(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.class, this.getFacilityPosition(), new AttributeMeta[0]);
    }

    public static class AbstractFacilityNotificationBuilderImpl
    extends AbstractServicingNotification.AbstractServicingNotificationBuilderImpl
    implements AbstractFacilityNotificationBuilder {
        protected FacilityPosition.FacilityPositionBuilder facilityPosition;

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition() {
            FacilityPosition.FacilityPositionBuilder result = this.facilityPosition != null ? this.facilityPosition : (this.facilityPosition = FacilityPosition.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public AbstractFacilityNotificationBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public AbstractFacilityNotificationBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public AbstractFacilityNotificationBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public AbstractFacilityNotificationBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public AbstractFacilityNotificationBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCorrection")
        @RuneAttribute(value="isCorrection")
        public AbstractFacilityNotificationBuilder setIsCorrection(Boolean _isCorrection) {
            this.isCorrection = _isCorrection == null ? null : _isCorrection;
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public AbstractFacilityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public AbstractFacilityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="noticeDate", isRequired=true)
        @RuneAttribute(value="noticeDate", isRequired=true)
        public AbstractFacilityNotificationBuilder setNoticeDate(ZonedDateTime _noticeDate) {
            this.noticeDate = _noticeDate == null ? null : _noticeDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="isGlobalOnly", isRequired=true)
        @RuneAttribute(value="isGlobalOnly", isRequired=true)
        public AbstractFacilityNotificationBuilder setIsGlobalOnly(Boolean _isGlobalOnly) {
            this.isGlobalOnly = _isGlobalOnly == null ? null : _isGlobalOnly;
            return this;
        }

        @Override
        @RosettaAttribute(value="eventPayment")
        @RuneAttribute(value="eventPayment")
        public AbstractFacilityNotificationBuilder addEventPayment(EventPayment _eventPayment) {
            if (_eventPayment != null) {
                this.eventPayment.add(_eventPayment.toBuilder());
            }
            return this;
        }

        @Override
        public AbstractFacilityNotificationBuilder addEventPayment(EventPayment _eventPayment, int idx) {
            this.getIndex(this.eventPayment, idx, () -> _eventPayment.toBuilder());
            return this;
        }

        @Override
        public AbstractFacilityNotificationBuilder addEventPayment(List<? extends EventPayment> eventPayments) {
            if (eventPayments != null) {
                for (EventPayment eventPayment : eventPayments) {
                    this.eventPayment.add(eventPayment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventPayment")
        public AbstractFacilityNotificationBuilder setEventPayment(List<? extends EventPayment> eventPayments) {
            this.eventPayment = eventPayments == null ? new ArrayList() : (List)eventPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public AbstractFacilityNotificationBuilder setFacilityPosition(FacilityPosition _facilityPosition) {
            this.facilityPosition = _facilityPosition == null ? null : _facilityPosition.toBuilder();
            return this;
        }

        @Override
        public AbstractFacilityNotification build() {
            return new AbstractFacilityNotificationImpl(this);
        }

        @Override
        public AbstractFacilityNotificationBuilder toBuilder() {
            return this;
        }

        @Override
        public AbstractFacilityNotificationBuilder prune() {
            super.prune();
            if (this.facilityPosition != null && !this.facilityPosition.prune().hasData()) {
                this.facilityPosition = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getFacilityPosition() != null && this.getFacilityPosition().hasData();
        }

        @Override
        public AbstractFacilityNotificationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            AbstractFacilityNotificationBuilder o = (AbstractFacilityNotificationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityPosition(), (RosettaModelObjectBuilder)o.getFacilityPosition(), this::setFacilityPosition);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityNotification _that = (AbstractFacilityNotification)this.getType().cast(o);
            return Objects.equals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityNotificationBuilder {facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }

    public static interface AbstractFacilityNotificationBuilder
    extends AbstractFacilityNotification,
    AbstractServicingNotification.AbstractServicingNotificationBuilder {
        public FacilityPosition.FacilityPositionBuilder getOrCreateFacilityPosition();

        @Override
        public FacilityPosition.FacilityPositionBuilder getFacilityPosition();

        @Override
        public AbstractFacilityNotificationBuilder setFpmlVersion(String var1);

        @Override
        public AbstractFacilityNotificationBuilder setExpectedBuild(Integer var1);

        @Override
        public AbstractFacilityNotificationBuilder setActualBuild(Integer var1);

        @Override
        public AbstractFacilityNotificationBuilder setHeader(RequestMessageHeader var1);

        @Override
        public AbstractFacilityNotificationBuilder setValidationModel(ValidationModel var1);

        @Override
        public AbstractFacilityNotificationBuilder setIsCorrection(Boolean var1);

        @Override
        public AbstractFacilityNotificationBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public AbstractFacilityNotificationBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        @Override
        public AbstractFacilityNotificationBuilder setNoticeDate(ZonedDateTime var1);

        @Override
        public AbstractFacilityNotificationBuilder setIsGlobalOnly(Boolean var1);

        @Override
        public AbstractFacilityNotificationBuilder addEventPayment(EventPayment var1);

        @Override
        public AbstractFacilityNotificationBuilder addEventPayment(EventPayment var1, int var2);

        @Override
        public AbstractFacilityNotificationBuilder addEventPayment(List<? extends EventPayment> var1);

        @Override
        public AbstractFacilityNotificationBuilder setEventPayment(List<? extends EventPayment> var1);

        public AbstractFacilityNotificationBuilder setFacilityPosition(FacilityPosition var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCorrection"), Boolean.class, (Object)this.getIsCorrection(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("noticeDate"), ZonedDateTime.class, (Object)this.getNoticeDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isGlobalOnly"), Boolean.class, (Object)this.getIsGlobalOnly(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventPayment"), processor, EventPayment.EventPaymentBuilder.class, this.getEventPayment(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityPosition"), processor, FacilityPosition.FacilityPositionBuilder.class, this.getFacilityPosition(), new AttributeMeta[0]);
        }

        @Override
        public AbstractFacilityNotificationBuilder prune();
    }

    public static class AbstractFacilityNotificationImpl
    extends AbstractServicingNotification.AbstractServicingNotificationImpl
    implements AbstractFacilityNotification {
        private final FacilityPosition facilityPosition;

        protected AbstractFacilityNotificationImpl(AbstractFacilityNotificationBuilder builder) {
            super(builder);
            this.facilityPosition = Optional.ofNullable(builder.getFacilityPosition()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityPosition")
        @RuneAttribute(value="facilityPosition")
        public FacilityPosition getFacilityPosition() {
            return this.facilityPosition;
        }

        @Override
        public AbstractFacilityNotification build() {
            return this;
        }

        @Override
        public AbstractFacilityNotificationBuilder toBuilder() {
            AbstractFacilityNotificationBuilder builder = AbstractFacilityNotification.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AbstractFacilityNotificationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityPosition()).ifPresent(builder::setFacilityPosition);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            AbstractFacilityNotification _that = (AbstractFacilityNotification)this.getType().cast(o);
            return Objects.equals(this.facilityPosition, _that.getFacilityPosition());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityPosition != null ? this.facilityPosition.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "AbstractFacilityNotification {facilityPosition=" + String.valueOf(this.facilityPosition) + "} " + super.toString();
        }
    }
}

