/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.ird;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.QuotationCharacteristics;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.ird.ReturnInflationModel;
import fpml.consolidated.ird.meta.ReturnCalculationMeta;
import fpml.consolidated.shared.Rate;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ReturnCalculation", builder=ReturnCalculationBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ReturnCalculation", model="fpml", builder=ReturnCalculationBuilderImpl.class, version="1.2.2")
public interface ReturnCalculation
extends Rate {
    public static final ReturnCalculationMeta metaData = new ReturnCalculationMeta();

    public Underlyer getUnderlyer();

    public SettlementTypeEnum getSettlementType();

    public QuotationCharacteristics getFinalValuation();

    public ReturnInflationModel getReturnInflationModel();

    @Override
    public ReturnCalculation build();

    @Override
    public ReturnCalculationBuilder toBuilder();

    public static ReturnCalculationBuilder builder() {
        return new ReturnCalculationBuilderImpl();
    }

    default public RosettaMetaData<? extends ReturnCalculation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ReturnCalculation> getType() {
        return ReturnCalculation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("finalValuation"), processor, QuotationCharacteristics.class, this.getFinalValuation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("returnInflationModel"), processor, ReturnInflationModel.class, this.getReturnInflationModel(), new AttributeMeta[0]);
    }

    public static class ReturnCalculationBuilderImpl
    extends Rate.RateBuilderImpl
    implements ReturnCalculationBuilder {
        protected Underlyer.UnderlyerBuilder underlyer;
        protected SettlementTypeEnum settlementType;
        protected QuotationCharacteristics.QuotationCharacteristicsBuilder finalValuation;
        protected ReturnInflationModel.ReturnInflationModelBuilder returnInflationModel;

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public Underlyer.UnderlyerBuilder getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer() {
            Underlyer.UnderlyerBuilder result = this.underlyer != null ? this.underlyer : (this.underlyer = Underlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="finalValuation")
        @RuneAttribute(value="finalValuation")
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getFinalValuation() {
            return this.finalValuation;
        }

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateFinalValuation() {
            QuotationCharacteristics.QuotationCharacteristicsBuilder result = this.finalValuation != null ? this.finalValuation : (this.finalValuation = QuotationCharacteristics.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="returnInflationModel", isRequired=true)
        @RuneAttribute(value="returnInflationModel", isRequired=true)
        public ReturnInflationModel.ReturnInflationModelBuilder getReturnInflationModel() {
            return this.returnInflationModel;
        }

        @Override
        public ReturnInflationModel.ReturnInflationModelBuilder getOrCreateReturnInflationModel() {
            ReturnInflationModel.ReturnInflationModelBuilder result = this.returnInflationModel != null ? this.returnInflationModel : (this.returnInflationModel = ReturnInflationModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ReturnCalculationBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public ReturnCalculationBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public ReturnCalculationBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="finalValuation")
        @RuneAttribute(value="finalValuation")
        public ReturnCalculationBuilder setFinalValuation(QuotationCharacteristics _finalValuation) {
            this.finalValuation = _finalValuation == null ? null : _finalValuation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="returnInflationModel", isRequired=true)
        @RuneAttribute(value="returnInflationModel", isRequired=true)
        public ReturnCalculationBuilder setReturnInflationModel(ReturnInflationModel _returnInflationModel) {
            this.returnInflationModel = _returnInflationModel == null ? null : _returnInflationModel.toBuilder();
            return this;
        }

        @Override
        public ReturnCalculation build() {
            return new ReturnCalculationImpl(this);
        }

        @Override
        public ReturnCalculationBuilder toBuilder() {
            return this;
        }

        @Override
        public ReturnCalculationBuilder prune() {
            super.prune();
            if (this.underlyer != null && !this.underlyer.prune().hasData()) {
                this.underlyer = null;
            }
            if (this.finalValuation != null && !this.finalValuation.prune().hasData()) {
                this.finalValuation = null;
            }
            if (this.returnInflationModel != null && !this.returnInflationModel.prune().hasData()) {
                this.returnInflationModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().hasData()) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getFinalValuation() != null && this.getFinalValuation().hasData()) {
                return true;
            }
            return this.getReturnInflationModel() != null && this.getReturnInflationModel().hasData();
        }

        @Override
        public ReturnCalculationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ReturnCalculationBuilder o = (ReturnCalculationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyer(), (RosettaModelObjectBuilder)o.getUnderlyer(), this::setUnderlyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFinalValuation(), (RosettaModelObjectBuilder)o.getFinalValuation(), this::setFinalValuation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReturnInflationModel(), (RosettaModelObjectBuilder)o.getReturnInflationModel(), this::setReturnInflationModel);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnCalculation _that = (ReturnCalculation)this.getType().cast(o);
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.finalValuation, _that.getFinalValuation())) {
                return false;
            }
            return Objects.equals(this.returnInflationModel, _that.getReturnInflationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalValuation != null ? this.finalValuation.hashCode() : 0);
            _result = 31 * _result + (this.returnInflationModel != null ? this.returnInflationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnCalculationBuilder {underlyer=" + String.valueOf(this.underlyer) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", finalValuation=" + String.valueOf(this.finalValuation) + ", returnInflationModel=" + String.valueOf(this.returnInflationModel) + "} " + super.toString();
        }
    }

    public static interface ReturnCalculationBuilder
    extends ReturnCalculation,
    Rate.RateBuilder {
        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer();

        @Override
        public Underlyer.UnderlyerBuilder getUnderlyer();

        public QuotationCharacteristics.QuotationCharacteristicsBuilder getOrCreateFinalValuation();

        @Override
        public QuotationCharacteristics.QuotationCharacteristicsBuilder getFinalValuation();

        public ReturnInflationModel.ReturnInflationModelBuilder getOrCreateReturnInflationModel();

        @Override
        public ReturnInflationModel.ReturnInflationModelBuilder getReturnInflationModel();

        @Override
        public ReturnCalculationBuilder setId(String var1);

        public ReturnCalculationBuilder setUnderlyer(Underlyer var1);

        public ReturnCalculationBuilder setSettlementType(SettlementTypeEnum var1);

        public ReturnCalculationBuilder setFinalValuation(QuotationCharacteristics var1);

        public ReturnCalculationBuilder setReturnInflationModel(ReturnInflationModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, this.getUnderlyer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("finalValuation"), processor, QuotationCharacteristics.QuotationCharacteristicsBuilder.class, this.getFinalValuation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("returnInflationModel"), processor, ReturnInflationModel.ReturnInflationModelBuilder.class, this.getReturnInflationModel(), new AttributeMeta[0]);
        }

        @Override
        public ReturnCalculationBuilder prune();
    }

    public static class ReturnCalculationImpl
    extends Rate.RateImpl
    implements ReturnCalculation {
        private final Underlyer underlyer;
        private final SettlementTypeEnum settlementType;
        private final QuotationCharacteristics finalValuation;
        private final ReturnInflationModel returnInflationModel;

        protected ReturnCalculationImpl(ReturnCalculationBuilder builder) {
            super(builder);
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
            this.finalValuation = Optional.ofNullable(builder.getFinalValuation()).map(f -> f.build()).orElse(null);
            this.returnInflationModel = Optional.ofNullable(builder.getReturnInflationModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public Underlyer getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="finalValuation")
        @RuneAttribute(value="finalValuation")
        public QuotationCharacteristics getFinalValuation() {
            return this.finalValuation;
        }

        @Override
        @RosettaAttribute(value="returnInflationModel", isRequired=true)
        @RuneAttribute(value="returnInflationModel", isRequired=true)
        public ReturnInflationModel getReturnInflationModel() {
            return this.returnInflationModel;
        }

        @Override
        public ReturnCalculation build() {
            return this;
        }

        @Override
        public ReturnCalculationBuilder toBuilder() {
            ReturnCalculationBuilder builder = ReturnCalculation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ReturnCalculationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getFinalValuation()).ifPresent(builder::setFinalValuation);
            Optional.ofNullable(this.getReturnInflationModel()).ifPresent(builder::setReturnInflationModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ReturnCalculation _that = (ReturnCalculation)this.getType().cast(o);
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.finalValuation, _that.getFinalValuation())) {
                return false;
            }
            return Objects.equals(this.returnInflationModel, _that.getReturnInflationModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.finalValuation != null ? this.finalValuation.hashCode() : 0);
            _result = 31 * _result + (this.returnInflationModel != null ? this.returnInflationModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ReturnCalculation {underlyer=" + String.valueOf(this.underlyer) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", finalValuation=" + String.valueOf(this.finalValuation) + ", returnInflationModel=" + String.valueOf(this.returnInflationModel) + "} " + super.toString();
        }
    }
}

