/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.meta.PrioritizedRateSourceModelMeta;
import fpml.consolidated.shared.SettlementRateOption;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="PrioritizedRateSourceModel", builder=PrioritizedRateSourceModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="PrioritizedRateSourceModel", model="fpml", builder=PrioritizedRateSourceModelBuilderImpl.class, version="1.2.2")
public interface PrioritizedRateSourceModel
extends RosettaModelObject {
    public static final PrioritizedRateSourceModelMeta metaData = new PrioritizedRateSourceModelMeta();

    public SettlementRateOption getPrimaryRateSource();

    public List<? extends SettlementRateOption> getSecondaryRateSource();

    public PrioritizedRateSourceModel build();

    public PrioritizedRateSourceModelBuilder toBuilder();

    public static PrioritizedRateSourceModelBuilder builder() {
        return new PrioritizedRateSourceModelBuilderImpl();
    }

    default public RosettaMetaData<? extends PrioritizedRateSourceModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends PrioritizedRateSourceModel> getType() {
        return PrioritizedRateSourceModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("primaryRateSource"), processor, SettlementRateOption.class, this.getPrimaryRateSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("secondaryRateSource"), processor, SettlementRateOption.class, this.getSecondaryRateSource(), new AttributeMeta[0]);
    }

    public static class PrioritizedRateSourceModelBuilderImpl
    implements PrioritizedRateSourceModelBuilder {
        protected SettlementRateOption.SettlementRateOptionBuilder primaryRateSource;
        protected List<SettlementRateOption.SettlementRateOptionBuilder> secondaryRateSource = new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>();

        @Override
        @RosettaAttribute(value="primaryRateSource")
        @RuneAttribute(value="primaryRateSource")
        public SettlementRateOption.SettlementRateOptionBuilder getPrimaryRateSource() {
            return this.primaryRateSource;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreatePrimaryRateSource() {
            SettlementRateOption.SettlementRateOptionBuilder result = this.primaryRateSource != null ? this.primaryRateSource : (this.primaryRateSource = SettlementRateOption.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="secondaryRateSource")
        @RuneAttribute(value="secondaryRateSource")
        public List<? extends SettlementRateOption.SettlementRateOptionBuilder> getSecondaryRateSource() {
            return this.secondaryRateSource;
        }

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSecondaryRateSource(int index) {
            if (this.secondaryRateSource == null) {
                this.secondaryRateSource = new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>();
            }
            return (SettlementRateOption.SettlementRateOptionBuilder)this.getIndex(this.secondaryRateSource, index, () -> {
                SettlementRateOption.SettlementRateOptionBuilder newSecondaryRateSource = SettlementRateOption.builder();
                return newSecondaryRateSource;
            });
        }

        @Override
        @RosettaAttribute(value="primaryRateSource")
        @RuneAttribute(value="primaryRateSource")
        public PrioritizedRateSourceModelBuilder setPrimaryRateSource(SettlementRateOption _primaryRateSource) {
            this.primaryRateSource = _primaryRateSource == null ? null : _primaryRateSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="secondaryRateSource")
        @RuneAttribute(value="secondaryRateSource")
        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(SettlementRateOption _secondaryRateSource) {
            if (_secondaryRateSource != null) {
                this.secondaryRateSource.add(_secondaryRateSource.toBuilder());
            }
            return this;
        }

        @Override
        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(SettlementRateOption _secondaryRateSource, int idx) {
            this.getIndex(this.secondaryRateSource, idx, () -> _secondaryRateSource.toBuilder());
            return this;
        }

        @Override
        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(List<? extends SettlementRateOption> secondaryRateSources) {
            if (secondaryRateSources != null) {
                for (SettlementRateOption settlementRateOption : secondaryRateSources) {
                    this.secondaryRateSource.add(settlementRateOption.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="secondaryRateSource")
        public PrioritizedRateSourceModelBuilder setSecondaryRateSource(List<? extends SettlementRateOption> secondaryRateSources) {
            this.secondaryRateSource = secondaryRateSources == null ? new ArrayList<SettlementRateOption.SettlementRateOptionBuilder>() : (List)secondaryRateSources.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public PrioritizedRateSourceModel build() {
            return new PrioritizedRateSourceModelImpl(this);
        }

        @Override
        public PrioritizedRateSourceModelBuilder toBuilder() {
            return this;
        }

        @Override
        public PrioritizedRateSourceModelBuilder prune() {
            if (this.primaryRateSource != null && !this.primaryRateSource.prune().hasData()) {
                this.primaryRateSource = null;
            }
            this.secondaryRateSource = this.secondaryRateSource.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPrimaryRateSource() != null && this.getPrimaryRateSource().hasData()) {
                return true;
            }
            return this.getSecondaryRateSource() != null && this.getSecondaryRateSource().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public PrioritizedRateSourceModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            PrioritizedRateSourceModelBuilder o = (PrioritizedRateSourceModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrimaryRateSource(), (RosettaModelObjectBuilder)o.getPrimaryRateSource(), this::setPrimaryRateSource);
            merger.mergeRosetta(this.getSecondaryRateSource(), o.getSecondaryRateSource(), this::getOrCreateSecondaryRateSource);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrioritizedRateSourceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryRateSource, _that.getPrimaryRateSource())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryRateSource, _that.getSecondaryRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryRateSource != null ? this.primaryRateSource.hashCode() : 0);
            _result = 31 * _result + (this.secondaryRateSource != null ? this.secondaryRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrioritizedRateSourceModelBuilder {primaryRateSource=" + String.valueOf(this.primaryRateSource) + ", secondaryRateSource=" + String.valueOf(this.secondaryRateSource) + "}";
        }
    }

    public static interface PrioritizedRateSourceModelBuilder
    extends PrioritizedRateSourceModel,
    RosettaModelObjectBuilder {
        public SettlementRateOption.SettlementRateOptionBuilder getOrCreatePrimaryRateSource();

        @Override
        public SettlementRateOption.SettlementRateOptionBuilder getPrimaryRateSource();

        public SettlementRateOption.SettlementRateOptionBuilder getOrCreateSecondaryRateSource(int var1);

        public List<? extends SettlementRateOption.SettlementRateOptionBuilder> getSecondaryRateSource();

        public PrioritizedRateSourceModelBuilder setPrimaryRateSource(SettlementRateOption var1);

        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(SettlementRateOption var1);

        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(SettlementRateOption var1, int var2);

        public PrioritizedRateSourceModelBuilder addSecondaryRateSource(List<? extends SettlementRateOption> var1);

        public PrioritizedRateSourceModelBuilder setSecondaryRateSource(List<? extends SettlementRateOption> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("primaryRateSource"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getPrimaryRateSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("secondaryRateSource"), processor, SettlementRateOption.SettlementRateOptionBuilder.class, this.getSecondaryRateSource(), new AttributeMeta[0]);
        }

        public PrioritizedRateSourceModelBuilder prune();
    }

    public static class PrioritizedRateSourceModelImpl
    implements PrioritizedRateSourceModel {
        private final SettlementRateOption primaryRateSource;
        private final List<? extends SettlementRateOption> secondaryRateSource;

        protected PrioritizedRateSourceModelImpl(PrioritizedRateSourceModelBuilder builder) {
            this.primaryRateSource = Optional.ofNullable(builder.getPrimaryRateSource()).map(f -> f.build()).orElse(null);
            this.secondaryRateSource = Optional.ofNullable(builder.getSecondaryRateSource()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="primaryRateSource")
        @RuneAttribute(value="primaryRateSource")
        public SettlementRateOption getPrimaryRateSource() {
            return this.primaryRateSource;
        }

        @Override
        @RosettaAttribute(value="secondaryRateSource")
        @RuneAttribute(value="secondaryRateSource")
        public List<? extends SettlementRateOption> getSecondaryRateSource() {
            return this.secondaryRateSource;
        }

        @Override
        public PrioritizedRateSourceModel build() {
            return this;
        }

        @Override
        public PrioritizedRateSourceModelBuilder toBuilder() {
            PrioritizedRateSourceModelBuilder builder = PrioritizedRateSourceModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PrioritizedRateSourceModelBuilder builder) {
            Optional.ofNullable(this.getPrimaryRateSource()).ifPresent(builder::setPrimaryRateSource);
            Optional.ofNullable(this.getSecondaryRateSource()).ifPresent(builder::setSecondaryRateSource);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            PrioritizedRateSourceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.primaryRateSource, _that.getPrimaryRateSource())) {
                return false;
            }
            return ListEquals.listEquals(this.secondaryRateSource, _that.getSecondaryRateSource());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.primaryRateSource != null ? this.primaryRateSource.hashCode() : 0);
            _result = 31 * _result + (this.secondaryRateSource != null ? this.secondaryRateSource.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "PrioritizedRateSourceModel {primaryRateSource=" + String.valueOf(this.primaryRateSource) + ", secondaryRateSource=" + String.valueOf(this.secondaryRateSource) + "}";
        }
    }
}

