/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxStraddle;
import fpml.consolidated.fx.meta.FxForwardVolatilityAgreementMeta;
import fpml.consolidated.shared.BusinessCenterTime;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Payment;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.QuotedCurrencyPair;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxForwardVolatilityAgreement", builder=FxForwardVolatilityAgreementBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxForwardVolatilityAgreement", model="fpml", builder=FxForwardVolatilityAgreementBuilderImpl.class, version="1.2.2")
public interface FxForwardVolatilityAgreement
extends Product {
    public static final FxForwardVolatilityAgreementMeta metaData = new FxForwardVolatilityAgreementMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public QuotedCurrencyPair getQuotedCurrencyPair();

    public ZonedDateTime getFixingDate();

    public BusinessCenterTime getFixingTime();

    public BigDecimal getForwardVolatilityStrikePrice();

    public FxStraddle getStraddle();

    public List<? extends Payment> getAdditionalPayment();

    @Override
    public FxForwardVolatilityAgreement build();

    @Override
    public FxForwardVolatilityAgreementBuilder toBuilder();

    public static FxForwardVolatilityAgreementBuilder builder() {
        return new FxForwardVolatilityAgreementBuilderImpl();
    }

    default public RosettaMetaData<? extends FxForwardVolatilityAgreement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxForwardVolatilityAgreement> getType() {
        return FxForwardVolatilityAgreement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.class, this.getFixingTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("forwardVolatilityStrikePrice"), BigDecimal.class, (Object)this.getForwardVolatilityStrikePrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("straddle"), processor, FxStraddle.class, this.getStraddle(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.class, this.getAdditionalPayment(), new AttributeMeta[0]);
    }

    public static class FxForwardVolatilityAgreementBuilderImpl
    extends Product.ProductBuilderImpl
    implements FxForwardVolatilityAgreementBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected QuotedCurrencyPair.QuotedCurrencyPairBuilder quotedCurrencyPair;
        protected ZonedDateTime fixingDate;
        protected BusinessCenterTime.BusinessCenterTimeBuilder fixingTime;
        protected BigDecimal forwardVolatilityStrikePrice;
        protected FxStraddle.FxStraddleBuilder straddle;
        protected List<Payment.PaymentBuilder> additionalPayment = new ArrayList<Payment.PaymentBuilder>();

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair() {
            QuotedCurrencyPair.QuotedCurrencyPairBuilder result = this.quotedCurrencyPair != null ? this.quotedCurrencyPair : (this.quotedCurrencyPair = QuotedCurrencyPair.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime() {
            return this.fixingTime;
        }

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime() {
            BusinessCenterTime.BusinessCenterTimeBuilder result = this.fixingTime != null ? this.fixingTime : (this.fixingTime = BusinessCenterTime.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        public BigDecimal getForwardVolatilityStrikePrice() {
            return this.forwardVolatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="straddle", isRequired=true)
        @RuneAttribute(value="straddle", isRequired=true)
        public FxStraddle.FxStraddleBuilder getStraddle() {
            return this.straddle;
        }

        @Override
        public FxStraddle.FxStraddleBuilder getOrCreateStraddle() {
            FxStraddle.FxStraddleBuilder result = this.straddle != null ? this.straddle : (this.straddle = FxStraddle.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment.PaymentBuilder> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int index) {
            if (this.additionalPayment == null) {
                this.additionalPayment = new ArrayList<Payment.PaymentBuilder>();
            }
            return (Payment.PaymentBuilder)this.getIndex(this.additionalPayment, index, () -> {
                Payment.PaymentBuilder newAdditionalPayment = Payment.builder();
                return newAdditionalPayment;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxForwardVolatilityAgreementBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxForwardVolatilityAgreementBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FxForwardVolatilityAgreementBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public FxForwardVolatilityAgreementBuilder setQuotedCurrencyPair(QuotedCurrencyPair _quotedCurrencyPair) {
            this.quotedCurrencyPair = _quotedCurrencyPair == null ? null : _quotedCurrencyPair.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public FxForwardVolatilityAgreementBuilder setFixingDate(ZonedDateTime _fixingDate) {
            this.fixingDate = _fixingDate == null ? null : _fixingDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public FxForwardVolatilityAgreementBuilder setFixingTime(BusinessCenterTime _fixingTime) {
            this.fixingTime = _fixingTime == null ? null : _fixingTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        public FxForwardVolatilityAgreementBuilder setForwardVolatilityStrikePrice(BigDecimal _forwardVolatilityStrikePrice) {
            this.forwardVolatilityStrikePrice = _forwardVolatilityStrikePrice == null ? null : _forwardVolatilityStrikePrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="straddle", isRequired=true)
        @RuneAttribute(value="straddle", isRequired=true)
        public FxForwardVolatilityAgreementBuilder setStraddle(FxStraddle _straddle) {
            this.straddle = _straddle == null ? null : _straddle.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(Payment _additionalPayment) {
            if (_additionalPayment != null) {
                this.additionalPayment.add(_additionalPayment.toBuilder());
            }
            return this;
        }

        @Override
        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(Payment _additionalPayment, int idx) {
            this.getIndex(this.additionalPayment, idx, () -> _additionalPayment.toBuilder());
            return this;
        }

        @Override
        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(List<? extends Payment> additionalPayments) {
            if (additionalPayments != null) {
                for (Payment payment : additionalPayments) {
                    this.additionalPayment.add(payment.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="additionalPayment")
        public FxForwardVolatilityAgreementBuilder setAdditionalPayment(List<? extends Payment> additionalPayments) {
            this.additionalPayment = additionalPayments == null ? new ArrayList<Payment.PaymentBuilder>() : (List)additionalPayments.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxForwardVolatilityAgreement build() {
            return new FxForwardVolatilityAgreementImpl(this);
        }

        @Override
        public FxForwardVolatilityAgreementBuilder toBuilder() {
            return this;
        }

        @Override
        public FxForwardVolatilityAgreementBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.quotedCurrencyPair != null && !this.quotedCurrencyPair.prune().hasData()) {
                this.quotedCurrencyPair = null;
            }
            if (this.fixingTime != null && !this.fixingTime.prune().hasData()) {
                this.fixingTime = null;
            }
            if (this.straddle != null && !this.straddle.prune().hasData()) {
                this.straddle = null;
            }
            this.additionalPayment = this.additionalPayment.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getQuotedCurrencyPair() != null && this.getQuotedCurrencyPair().hasData()) {
                return true;
            }
            if (this.getFixingDate() != null) {
                return true;
            }
            if (this.getFixingTime() != null && this.getFixingTime().hasData()) {
                return true;
            }
            if (this.getForwardVolatilityStrikePrice() != null) {
                return true;
            }
            if (this.getStraddle() != null && this.getStraddle().hasData()) {
                return true;
            }
            return this.getAdditionalPayment() != null && this.getAdditionalPayment().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxForwardVolatilityAgreementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxForwardVolatilityAgreementBuilder o = (FxForwardVolatilityAgreementBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getQuotedCurrencyPair(), (RosettaModelObjectBuilder)o.getQuotedCurrencyPair(), this::setQuotedCurrencyPair);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFixingTime(), (RosettaModelObjectBuilder)o.getFixingTime(), this::setFixingTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStraddle(), (RosettaModelObjectBuilder)o.getStraddle(), this::setStraddle);
            merger.mergeRosetta(this.getAdditionalPayment(), o.getAdditionalPayment(), this::getOrCreateAdditionalPayment);
            merger.mergeBasic((Object)this.getFixingDate(), (Object)o.getFixingDate(), this::setFixingDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getForwardVolatilityStrikePrice(), (Object)o.getForwardVolatilityStrikePrice(), this::setForwardVolatilityStrikePrice, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxForwardVolatilityAgreement _that = (FxForwardVolatilityAgreement)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!Objects.equals(this.forwardVolatilityStrikePrice, _that.getForwardVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.straddle, _that.getStraddle())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.forwardVolatilityStrikePrice != null ? this.forwardVolatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.straddle != null ? this.straddle.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxForwardVolatilityAgreementBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", fixingDate=" + String.valueOf(this.fixingDate) + ", fixingTime=" + String.valueOf(this.fixingTime) + ", forwardVolatilityStrikePrice=" + String.valueOf(this.forwardVolatilityStrikePrice) + ", straddle=" + String.valueOf(this.straddle) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + "} " + super.toString();
        }
    }

    public static interface FxForwardVolatilityAgreementBuilder
    extends FxForwardVolatilityAgreement,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getOrCreateQuotedCurrencyPair();

        @Override
        public QuotedCurrencyPair.QuotedCurrencyPairBuilder getQuotedCurrencyPair();

        public BusinessCenterTime.BusinessCenterTimeBuilder getOrCreateFixingTime();

        @Override
        public BusinessCenterTime.BusinessCenterTimeBuilder getFixingTime();

        public FxStraddle.FxStraddleBuilder getOrCreateStraddle();

        @Override
        public FxStraddle.FxStraddleBuilder getStraddle();

        public Payment.PaymentBuilder getOrCreateAdditionalPayment(int var1);

        public List<? extends Payment.PaymentBuilder> getAdditionalPayment();

        @Override
        public FxForwardVolatilityAgreementBuilder setProductModel(ProductModel var1);

        @Override
        public FxForwardVolatilityAgreementBuilder setId(String var1);

        public FxForwardVolatilityAgreementBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FxForwardVolatilityAgreementBuilder setQuotedCurrencyPair(QuotedCurrencyPair var1);

        public FxForwardVolatilityAgreementBuilder setFixingDate(ZonedDateTime var1);

        public FxForwardVolatilityAgreementBuilder setFixingTime(BusinessCenterTime var1);

        public FxForwardVolatilityAgreementBuilder setForwardVolatilityStrikePrice(BigDecimal var1);

        public FxForwardVolatilityAgreementBuilder setStraddle(FxStraddle var1);

        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(Payment var1);

        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(Payment var1, int var2);

        public FxForwardVolatilityAgreementBuilder addAdditionalPayment(List<? extends Payment> var1);

        public FxForwardVolatilityAgreementBuilder setAdditionalPayment(List<? extends Payment> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("quotedCurrencyPair"), processor, QuotedCurrencyPair.QuotedCurrencyPairBuilder.class, this.getQuotedCurrencyPair(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("fixingDate"), ZonedDateTime.class, (Object)this.getFixingDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fixingTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, this.getFixingTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("forwardVolatilityStrikePrice"), BigDecimal.class, (Object)this.getForwardVolatilityStrikePrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("straddle"), processor, FxStraddle.FxStraddleBuilder.class, this.getStraddle(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalPayment"), processor, Payment.PaymentBuilder.class, this.getAdditionalPayment(), new AttributeMeta[0]);
        }

        @Override
        public FxForwardVolatilityAgreementBuilder prune();
    }

    public static class FxForwardVolatilityAgreementImpl
    extends Product.ProductImpl
    implements FxForwardVolatilityAgreement {
        private final BuyerSellerModel buyerSellerModel;
        private final QuotedCurrencyPair quotedCurrencyPair;
        private final ZonedDateTime fixingDate;
        private final BusinessCenterTime fixingTime;
        private final BigDecimal forwardVolatilityStrikePrice;
        private final FxStraddle straddle;
        private final List<? extends Payment> additionalPayment;

        protected FxForwardVolatilityAgreementImpl(FxForwardVolatilityAgreementBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.quotedCurrencyPair = Optional.ofNullable(builder.getQuotedCurrencyPair()).map(f -> f.build()).orElse(null);
            this.fixingDate = builder.getFixingDate();
            this.fixingTime = Optional.ofNullable(builder.getFixingTime()).map(f -> f.build()).orElse(null);
            this.forwardVolatilityStrikePrice = builder.getForwardVolatilityStrikePrice();
            this.straddle = Optional.ofNullable(builder.getStraddle()).map(f -> f.build()).orElse(null);
            this.additionalPayment = Optional.ofNullable(builder.getAdditionalPayment()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="quotedCurrencyPair", isRequired=true)
        @RuneAttribute(value="quotedCurrencyPair", isRequired=true)
        public QuotedCurrencyPair getQuotedCurrencyPair() {
            return this.quotedCurrencyPair;
        }

        @Override
        @RosettaAttribute(value="fixingDate", isRequired=true)
        @RuneAttribute(value="fixingDate", isRequired=true)
        public ZonedDateTime getFixingDate() {
            return this.fixingDate;
        }

        @Override
        @RosettaAttribute(value="fixingTime")
        @RuneAttribute(value="fixingTime")
        public BusinessCenterTime getFixingTime() {
            return this.fixingTime;
        }

        @Override
        @RosettaAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        @RuneAttribute(value="forwardVolatilityStrikePrice", isRequired=true)
        public BigDecimal getForwardVolatilityStrikePrice() {
            return this.forwardVolatilityStrikePrice;
        }

        @Override
        @RosettaAttribute(value="straddle", isRequired=true)
        @RuneAttribute(value="straddle", isRequired=true)
        public FxStraddle getStraddle() {
            return this.straddle;
        }

        @Override
        @RosettaAttribute(value="additionalPayment")
        @RuneAttribute(value="additionalPayment")
        public List<? extends Payment> getAdditionalPayment() {
            return this.additionalPayment;
        }

        @Override
        public FxForwardVolatilityAgreement build() {
            return this;
        }

        @Override
        public FxForwardVolatilityAgreementBuilder toBuilder() {
            FxForwardVolatilityAgreementBuilder builder = FxForwardVolatilityAgreement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxForwardVolatilityAgreementBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getQuotedCurrencyPair()).ifPresent(builder::setQuotedCurrencyPair);
            Optional.ofNullable(this.getFixingDate()).ifPresent(builder::setFixingDate);
            Optional.ofNullable(this.getFixingTime()).ifPresent(builder::setFixingTime);
            Optional.ofNullable(this.getForwardVolatilityStrikePrice()).ifPresent(builder::setForwardVolatilityStrikePrice);
            Optional.ofNullable(this.getStraddle()).ifPresent(builder::setStraddle);
            Optional.ofNullable(this.getAdditionalPayment()).ifPresent(builder::setAdditionalPayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxForwardVolatilityAgreement _that = (FxForwardVolatilityAgreement)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.quotedCurrencyPair, _that.getQuotedCurrencyPair())) {
                return false;
            }
            if (!Objects.equals(this.fixingDate, _that.getFixingDate())) {
                return false;
            }
            if (!Objects.equals(this.fixingTime, _that.getFixingTime())) {
                return false;
            }
            if (!Objects.equals(this.forwardVolatilityStrikePrice, _that.getForwardVolatilityStrikePrice())) {
                return false;
            }
            if (!Objects.equals(this.straddle, _that.getStraddle())) {
                return false;
            }
            return ListEquals.listEquals(this.additionalPayment, _that.getAdditionalPayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.quotedCurrencyPair != null ? this.quotedCurrencyPair.hashCode() : 0);
            _result = 31 * _result + (this.fixingDate != null ? this.fixingDate.hashCode() : 0);
            _result = 31 * _result + (this.fixingTime != null ? this.fixingTime.hashCode() : 0);
            _result = 31 * _result + (this.forwardVolatilityStrikePrice != null ? this.forwardVolatilityStrikePrice.hashCode() : 0);
            _result = 31 * _result + (this.straddle != null ? this.straddle.hashCode() : 0);
            _result = 31 * _result + (this.additionalPayment != null ? this.additionalPayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxForwardVolatilityAgreement {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", quotedCurrencyPair=" + String.valueOf(this.quotedCurrencyPair) + ", fixingDate=" + String.valueOf(this.fixingDate) + ", fixingTime=" + String.valueOf(this.fixingTime) + ", forwardVolatilityStrikePrice=" + String.valueOf(this.forwardVolatilityStrikePrice) + ", straddle=" + String.valueOf(this.straddle) + ", additionalPayment=" + String.valueOf(this.additionalPayment) + "} " + super.toString();
        }
    }
}

