/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.fx;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.fx.FxDisruptionProvisions;
import fpml.consolidated.fx.meta.FxDisruptionMeta;
import fpml.consolidated.shared.Currency;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxDisruption", builder=FxDisruptionBuilderImpl.class, version="1.2.2")
@RuneDataType(value="FxDisruption", model="fpml", builder=FxDisruptionBuilderImpl.class, version="1.2.2")
public interface FxDisruption
extends RosettaModelObject {
    public static final FxDisruptionMeta metaData = new FxDisruptionMeta();

    public Currency getBaseCurrency();

    public Currency getReferenceCurrency();

    public List<? extends FxDisruptionProvisions> getProvisions();

    public FxDisruption build();

    public FxDisruptionBuilder toBuilder();

    public static FxDisruptionBuilder builder() {
        return new FxDisruptionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxDisruption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxDisruption> getType() {
        return FxDisruption.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("baseCurrency"), processor, Currency.class, this.getBaseCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.class, this.getReferenceCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("provisions"), processor, FxDisruptionProvisions.class, this.getProvisions(), new AttributeMeta[0]);
    }

    public static class FxDisruptionBuilderImpl
    implements FxDisruptionBuilder {
        protected Currency.CurrencyBuilder baseCurrency;
        protected Currency.CurrencyBuilder referenceCurrency;
        protected List<FxDisruptionProvisions.FxDisruptionProvisionsBuilder> provisions = new ArrayList<FxDisruptionProvisions.FxDisruptionProvisionsBuilder>();

        @Override
        @RosettaAttribute(value="baseCurrency")
        @RuneAttribute(value="baseCurrency")
        public Currency.CurrencyBuilder getBaseCurrency() {
            return this.baseCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateBaseCurrency() {
            Currency.CurrencyBuilder result = this.baseCurrency != null ? this.baseCurrency : (this.baseCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency.CurrencyBuilder getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateReferenceCurrency() {
            Currency.CurrencyBuilder result = this.referenceCurrency != null ? this.referenceCurrency : (this.referenceCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="provisions")
        @RuneAttribute(value="provisions")
        public List<? extends FxDisruptionProvisions.FxDisruptionProvisionsBuilder> getProvisions() {
            return this.provisions;
        }

        @Override
        public FxDisruptionProvisions.FxDisruptionProvisionsBuilder getOrCreateProvisions(int index) {
            if (this.provisions == null) {
                this.provisions = new ArrayList<FxDisruptionProvisions.FxDisruptionProvisionsBuilder>();
            }
            return (FxDisruptionProvisions.FxDisruptionProvisionsBuilder)this.getIndex(this.provisions, index, () -> {
                FxDisruptionProvisions.FxDisruptionProvisionsBuilder newProvisions = FxDisruptionProvisions.builder();
                return newProvisions;
            });
        }

        @Override
        @RosettaAttribute(value="baseCurrency")
        @RuneAttribute(value="baseCurrency")
        public FxDisruptionBuilder setBaseCurrency(Currency _baseCurrency) {
            this.baseCurrency = _baseCurrency == null ? null : _baseCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public FxDisruptionBuilder setReferenceCurrency(Currency _referenceCurrency) {
            this.referenceCurrency = _referenceCurrency == null ? null : _referenceCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="provisions")
        @RuneAttribute(value="provisions")
        public FxDisruptionBuilder addProvisions(FxDisruptionProvisions _provisions) {
            if (_provisions != null) {
                this.provisions.add(_provisions.toBuilder());
            }
            return this;
        }

        @Override
        public FxDisruptionBuilder addProvisions(FxDisruptionProvisions _provisions, int idx) {
            this.getIndex(this.provisions, idx, () -> _provisions.toBuilder());
            return this;
        }

        @Override
        public FxDisruptionBuilder addProvisions(List<? extends FxDisruptionProvisions> provisionss) {
            if (provisionss != null) {
                for (FxDisruptionProvisions fxDisruptionProvisions : provisionss) {
                    this.provisions.add(fxDisruptionProvisions.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="provisions")
        public FxDisruptionBuilder setProvisions(List<? extends FxDisruptionProvisions> provisionss) {
            this.provisions = provisionss == null ? new ArrayList<FxDisruptionProvisions.FxDisruptionProvisionsBuilder>() : (List)provisionss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxDisruption build() {
            return new FxDisruptionImpl(this);
        }

        @Override
        public FxDisruptionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxDisruptionBuilder prune() {
            if (this.baseCurrency != null && !this.baseCurrency.prune().hasData()) {
                this.baseCurrency = null;
            }
            if (this.referenceCurrency != null && !this.referenceCurrency.prune().hasData()) {
                this.referenceCurrency = null;
            }
            this.provisions = this.provisions.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getBaseCurrency() != null && this.getBaseCurrency().hasData()) {
                return true;
            }
            if (this.getReferenceCurrency() != null && this.getReferenceCurrency().hasData()) {
                return true;
            }
            return this.getProvisions() != null && this.getProvisions().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FxDisruptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FxDisruptionBuilder o = (FxDisruptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBaseCurrency(), (RosettaModelObjectBuilder)o.getBaseCurrency(), this::setBaseCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReferenceCurrency(), (RosettaModelObjectBuilder)o.getReferenceCurrency(), this::setReferenceCurrency);
            merger.mergeRosetta(this.getProvisions(), o.getProvisions(), this::getOrCreateProvisions);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxDisruption _that = this.getType().cast(o);
            if (!Objects.equals(this.baseCurrency, _that.getBaseCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.provisions, _that.getProvisions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.baseCurrency != null ? this.baseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.provisions != null ? this.provisions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxDisruptionBuilder {baseCurrency=" + String.valueOf(this.baseCurrency) + ", referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", provisions=" + String.valueOf(this.provisions) + "}";
        }
    }

    public static interface FxDisruptionBuilder
    extends FxDisruption,
    RosettaModelObjectBuilder {
        public Currency.CurrencyBuilder getOrCreateBaseCurrency();

        @Override
        public Currency.CurrencyBuilder getBaseCurrency();

        public Currency.CurrencyBuilder getOrCreateReferenceCurrency();

        @Override
        public Currency.CurrencyBuilder getReferenceCurrency();

        public FxDisruptionProvisions.FxDisruptionProvisionsBuilder getOrCreateProvisions(int var1);

        public List<? extends FxDisruptionProvisions.FxDisruptionProvisionsBuilder> getProvisions();

        public FxDisruptionBuilder setBaseCurrency(Currency var1);

        public FxDisruptionBuilder setReferenceCurrency(Currency var1);

        public FxDisruptionBuilder addProvisions(FxDisruptionProvisions var1);

        public FxDisruptionBuilder addProvisions(FxDisruptionProvisions var1, int var2);

        public FxDisruptionBuilder addProvisions(List<? extends FxDisruptionProvisions> var1);

        public FxDisruptionBuilder setProvisions(List<? extends FxDisruptionProvisions> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("baseCurrency"), processor, Currency.CurrencyBuilder.class, this.getBaseCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("referenceCurrency"), processor, Currency.CurrencyBuilder.class, this.getReferenceCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("provisions"), processor, FxDisruptionProvisions.FxDisruptionProvisionsBuilder.class, this.getProvisions(), new AttributeMeta[0]);
        }

        public FxDisruptionBuilder prune();
    }

    public static class FxDisruptionImpl
    implements FxDisruption {
        private final Currency baseCurrency;
        private final Currency referenceCurrency;
        private final List<? extends FxDisruptionProvisions> provisions;

        protected FxDisruptionImpl(FxDisruptionBuilder builder) {
            this.baseCurrency = Optional.ofNullable(builder.getBaseCurrency()).map(f -> f.build()).orElse(null);
            this.referenceCurrency = Optional.ofNullable(builder.getReferenceCurrency()).map(f -> f.build()).orElse(null);
            this.provisions = Optional.ofNullable(builder.getProvisions()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="baseCurrency")
        @RuneAttribute(value="baseCurrency")
        public Currency getBaseCurrency() {
            return this.baseCurrency;
        }

        @Override
        @RosettaAttribute(value="referenceCurrency")
        @RuneAttribute(value="referenceCurrency")
        public Currency getReferenceCurrency() {
            return this.referenceCurrency;
        }

        @Override
        @RosettaAttribute(value="provisions")
        @RuneAttribute(value="provisions")
        public List<? extends FxDisruptionProvisions> getProvisions() {
            return this.provisions;
        }

        @Override
        public FxDisruption build() {
            return this;
        }

        @Override
        public FxDisruptionBuilder toBuilder() {
            FxDisruptionBuilder builder = FxDisruption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxDisruptionBuilder builder) {
            Optional.ofNullable(this.getBaseCurrency()).ifPresent(builder::setBaseCurrency);
            Optional.ofNullable(this.getReferenceCurrency()).ifPresent(builder::setReferenceCurrency);
            Optional.ofNullable(this.getProvisions()).ifPresent(builder::setProvisions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FxDisruption _that = this.getType().cast(o);
            if (!Objects.equals(this.baseCurrency, _that.getBaseCurrency())) {
                return false;
            }
            if (!Objects.equals(this.referenceCurrency, _that.getReferenceCurrency())) {
                return false;
            }
            return ListEquals.listEquals(this.provisions, _that.getProvisions());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.baseCurrency != null ? this.baseCurrency.hashCode() : 0);
            _result = 31 * _result + (this.referenceCurrency != null ? this.referenceCurrency.hashCode() : 0);
            _result = 31 * _result + (this.provisions != null ? this.provisions.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FxDisruption {baseCurrency=" + String.valueOf(this.baseCurrency) + ", referenceCurrency=" + String.valueOf(this.referenceCurrency) + ", provisions=" + String.valueOf(this.provisions) + "}";
        }
    }
}

