/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.doc.OtcClassification;
import fpml.consolidated.doc.ShortSale;
import fpml.consolidated.doc.TradingWaiver;
import fpml.consolidated.doc.meta.TransactionClassificationModelMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TransactionClassificationModel", builder=TransactionClassificationModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TransactionClassificationModel", model="fpml", builder=TransactionClassificationModelBuilderImpl.class, version="1.2.2")
public interface TransactionClassificationModel
extends RosettaModelObject {
    public static final TransactionClassificationModelMeta metaData = new TransactionClassificationModelMeta();

    public Boolean getIsSecuritiesFinancing();

    public List<? extends OtcClassification> getOtcClassification();

    public List<? extends TradingWaiver> getTradingWaiver();

    public ShortSale getShortSale();

    public Boolean getIsCommodityHedge();

    public TransactionClassificationModel build();

    public TransactionClassificationModelBuilder toBuilder();

    public static TransactionClassificationModelBuilder builder() {
        return new TransactionClassificationModelBuilderImpl();
    }

    default public RosettaMetaData<? extends TransactionClassificationModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TransactionClassificationModel> getType() {
        return TransactionClassificationModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("isSecuritiesFinancing"), Boolean.class, (Object)this.getIsSecuritiesFinancing(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("otcClassification"), processor, OtcClassification.class, this.getOtcClassification(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingWaiver"), processor, TradingWaiver.class, this.getTradingWaiver(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("shortSale"), processor, ShortSale.class, this.getShortSale(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("isCommodityHedge"), Boolean.class, (Object)this.getIsCommodityHedge(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class TransactionClassificationModelBuilderImpl
    implements TransactionClassificationModelBuilder {
        protected Boolean isSecuritiesFinancing;
        protected List<OtcClassification.OtcClassificationBuilder> otcClassification = new ArrayList<OtcClassification.OtcClassificationBuilder>();
        protected List<TradingWaiver.TradingWaiverBuilder> tradingWaiver = new ArrayList<TradingWaiver.TradingWaiverBuilder>();
        protected ShortSale.ShortSaleBuilder shortSale;
        protected Boolean isCommodityHedge;

        @Override
        @RosettaAttribute(value="isSecuritiesFinancing")
        @RuneAttribute(value="isSecuritiesFinancing")
        public Boolean getIsSecuritiesFinancing() {
            return this.isSecuritiesFinancing;
        }

        @Override
        @RosettaAttribute(value="otcClassification")
        @RuneAttribute(value="otcClassification")
        public List<? extends OtcClassification.OtcClassificationBuilder> getOtcClassification() {
            return this.otcClassification;
        }

        @Override
        public OtcClassification.OtcClassificationBuilder getOrCreateOtcClassification(int index) {
            if (this.otcClassification == null) {
                this.otcClassification = new ArrayList<OtcClassification.OtcClassificationBuilder>();
            }
            return (OtcClassification.OtcClassificationBuilder)this.getIndex(this.otcClassification, index, () -> {
                OtcClassification.OtcClassificationBuilder newOtcClassification = OtcClassification.builder();
                return newOtcClassification;
            });
        }

        @Override
        @RosettaAttribute(value="tradingWaiver")
        @RuneAttribute(value="tradingWaiver")
        public List<? extends TradingWaiver.TradingWaiverBuilder> getTradingWaiver() {
            return this.tradingWaiver;
        }

        @Override
        public TradingWaiver.TradingWaiverBuilder getOrCreateTradingWaiver(int index) {
            if (this.tradingWaiver == null) {
                this.tradingWaiver = new ArrayList<TradingWaiver.TradingWaiverBuilder>();
            }
            return (TradingWaiver.TradingWaiverBuilder)this.getIndex(this.tradingWaiver, index, () -> {
                TradingWaiver.TradingWaiverBuilder newTradingWaiver = TradingWaiver.builder();
                return newTradingWaiver;
            });
        }

        @Override
        @RosettaAttribute(value="shortSale")
        @RuneAttribute(value="shortSale")
        public ShortSale.ShortSaleBuilder getShortSale() {
            return this.shortSale;
        }

        @Override
        public ShortSale.ShortSaleBuilder getOrCreateShortSale() {
            ShortSale.ShortSaleBuilder result = this.shortSale != null ? this.shortSale : (this.shortSale = ShortSale.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="isCommodityHedge")
        @RuneAttribute(value="isCommodityHedge")
        public Boolean getIsCommodityHedge() {
            return this.isCommodityHedge;
        }

        @Override
        @RosettaAttribute(value="isSecuritiesFinancing")
        @RuneAttribute(value="isSecuritiesFinancing")
        public TransactionClassificationModelBuilder setIsSecuritiesFinancing(Boolean _isSecuritiesFinancing) {
            this.isSecuritiesFinancing = _isSecuritiesFinancing == null ? null : _isSecuritiesFinancing;
            return this;
        }

        @Override
        @RosettaAttribute(value="otcClassification")
        @RuneAttribute(value="otcClassification")
        public TransactionClassificationModelBuilder addOtcClassification(OtcClassification _otcClassification) {
            if (_otcClassification != null) {
                this.otcClassification.add(_otcClassification.toBuilder());
            }
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder addOtcClassification(OtcClassification _otcClassification, int idx) {
            this.getIndex(this.otcClassification, idx, () -> _otcClassification.toBuilder());
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder addOtcClassification(List<? extends OtcClassification> otcClassifications) {
            if (otcClassifications != null) {
                for (OtcClassification otcClassification : otcClassifications) {
                    this.otcClassification.add(otcClassification.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="otcClassification")
        public TransactionClassificationModelBuilder setOtcClassification(List<? extends OtcClassification> otcClassifications) {
            this.otcClassification = otcClassifications == null ? new ArrayList<OtcClassification.OtcClassificationBuilder>() : (List)otcClassifications.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingWaiver")
        @RuneAttribute(value="tradingWaiver")
        public TransactionClassificationModelBuilder addTradingWaiver(TradingWaiver _tradingWaiver) {
            if (_tradingWaiver != null) {
                this.tradingWaiver.add(_tradingWaiver.toBuilder());
            }
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder addTradingWaiver(TradingWaiver _tradingWaiver, int idx) {
            this.getIndex(this.tradingWaiver, idx, () -> _tradingWaiver.toBuilder());
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder addTradingWaiver(List<? extends TradingWaiver> tradingWaivers) {
            if (tradingWaivers != null) {
                for (TradingWaiver tradingWaiver : tradingWaivers) {
                    this.tradingWaiver.add(tradingWaiver.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="tradingWaiver")
        public TransactionClassificationModelBuilder setTradingWaiver(List<? extends TradingWaiver> tradingWaivers) {
            this.tradingWaiver = tradingWaivers == null ? new ArrayList<TradingWaiver.TradingWaiverBuilder>() : (List)tradingWaivers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="shortSale")
        @RuneAttribute(value="shortSale")
        public TransactionClassificationModelBuilder setShortSale(ShortSale _shortSale) {
            this.shortSale = _shortSale == null ? null : _shortSale.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="isCommodityHedge")
        @RuneAttribute(value="isCommodityHedge")
        public TransactionClassificationModelBuilder setIsCommodityHedge(Boolean _isCommodityHedge) {
            this.isCommodityHedge = _isCommodityHedge == null ? null : _isCommodityHedge;
            return this;
        }

        @Override
        public TransactionClassificationModel build() {
            return new TransactionClassificationModelImpl(this);
        }

        @Override
        public TransactionClassificationModelBuilder toBuilder() {
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder prune() {
            this.otcClassification = this.otcClassification.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.tradingWaiver = this.tradingWaiver.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.shortSale != null && !this.shortSale.prune().hasData()) {
                this.shortSale = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIsSecuritiesFinancing() != null) {
                return true;
            }
            if (this.getOtcClassification() != null && this.getOtcClassification().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getTradingWaiver() != null && this.getTradingWaiver().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getShortSale() != null && this.getShortSale().hasData()) {
                return true;
            }
            return this.getIsCommodityHedge() != null;
        }

        public TransactionClassificationModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TransactionClassificationModelBuilder o = (TransactionClassificationModelBuilder)other;
            merger.mergeRosetta(this.getOtcClassification(), o.getOtcClassification(), this::getOrCreateOtcClassification);
            merger.mergeRosetta(this.getTradingWaiver(), o.getTradingWaiver(), this::getOrCreateTradingWaiver);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getShortSale(), (RosettaModelObjectBuilder)o.getShortSale(), this::setShortSale);
            merger.mergeBasic((Object)this.getIsSecuritiesFinancing(), (Object)o.getIsSecuritiesFinancing(), this::setIsSecuritiesFinancing, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getIsCommodityHedge(), (Object)o.getIsCommodityHedge(), this::setIsCommodityHedge, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransactionClassificationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.isSecuritiesFinancing, _that.getIsSecuritiesFinancing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otcClassification, _that.getOtcClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradingWaiver, _that.getTradingWaiver())) {
                return false;
            }
            if (!Objects.equals(this.shortSale, _that.getShortSale())) {
                return false;
            }
            return Objects.equals(this.isCommodityHedge, _that.getIsCommodityHedge());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isSecuritiesFinancing != null ? this.isSecuritiesFinancing.hashCode() : 0);
            _result = 31 * _result + (this.otcClassification != null ? this.otcClassification.hashCode() : 0);
            _result = 31 * _result + (this.tradingWaiver != null ? this.tradingWaiver.hashCode() : 0);
            _result = 31 * _result + (this.shortSale != null ? this.shortSale.hashCode() : 0);
            _result = 31 * _result + (this.isCommodityHedge != null ? this.isCommodityHedge.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransactionClassificationModelBuilder {isSecuritiesFinancing=" + this.isSecuritiesFinancing + ", otcClassification=" + String.valueOf(this.otcClassification) + ", tradingWaiver=" + String.valueOf(this.tradingWaiver) + ", shortSale=" + String.valueOf(this.shortSale) + ", isCommodityHedge=" + this.isCommodityHedge + "}";
        }
    }

    public static interface TransactionClassificationModelBuilder
    extends TransactionClassificationModel,
    RosettaModelObjectBuilder {
        public OtcClassification.OtcClassificationBuilder getOrCreateOtcClassification(int var1);

        public List<? extends OtcClassification.OtcClassificationBuilder> getOtcClassification();

        public TradingWaiver.TradingWaiverBuilder getOrCreateTradingWaiver(int var1);

        public List<? extends TradingWaiver.TradingWaiverBuilder> getTradingWaiver();

        public ShortSale.ShortSaleBuilder getOrCreateShortSale();

        @Override
        public ShortSale.ShortSaleBuilder getShortSale();

        public TransactionClassificationModelBuilder setIsSecuritiesFinancing(Boolean var1);

        public TransactionClassificationModelBuilder addOtcClassification(OtcClassification var1);

        public TransactionClassificationModelBuilder addOtcClassification(OtcClassification var1, int var2);

        public TransactionClassificationModelBuilder addOtcClassification(List<? extends OtcClassification> var1);

        public TransactionClassificationModelBuilder setOtcClassification(List<? extends OtcClassification> var1);

        public TransactionClassificationModelBuilder addTradingWaiver(TradingWaiver var1);

        public TransactionClassificationModelBuilder addTradingWaiver(TradingWaiver var1, int var2);

        public TransactionClassificationModelBuilder addTradingWaiver(List<? extends TradingWaiver> var1);

        public TransactionClassificationModelBuilder setTradingWaiver(List<? extends TradingWaiver> var1);

        public TransactionClassificationModelBuilder setShortSale(ShortSale var1);

        public TransactionClassificationModelBuilder setIsCommodityHedge(Boolean var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("isSecuritiesFinancing"), Boolean.class, (Object)this.getIsSecuritiesFinancing(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("otcClassification"), processor, OtcClassification.OtcClassificationBuilder.class, this.getOtcClassification(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingWaiver"), processor, TradingWaiver.TradingWaiverBuilder.class, this.getTradingWaiver(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("shortSale"), processor, ShortSale.ShortSaleBuilder.class, this.getShortSale(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("isCommodityHedge"), Boolean.class, (Object)this.getIsCommodityHedge(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public TransactionClassificationModelBuilder prune();
    }

    public static class TransactionClassificationModelImpl
    implements TransactionClassificationModel {
        private final Boolean isSecuritiesFinancing;
        private final List<? extends OtcClassification> otcClassification;
        private final List<? extends TradingWaiver> tradingWaiver;
        private final ShortSale shortSale;
        private final Boolean isCommodityHedge;

        protected TransactionClassificationModelImpl(TransactionClassificationModelBuilder builder) {
            this.isSecuritiesFinancing = builder.getIsSecuritiesFinancing();
            this.otcClassification = Optional.ofNullable(builder.getOtcClassification()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.tradingWaiver = Optional.ofNullable(builder.getTradingWaiver()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.shortSale = Optional.ofNullable(builder.getShortSale()).map(f -> f.build()).orElse(null);
            this.isCommodityHedge = builder.getIsCommodityHedge();
        }

        @Override
        @RosettaAttribute(value="isSecuritiesFinancing")
        @RuneAttribute(value="isSecuritiesFinancing")
        public Boolean getIsSecuritiesFinancing() {
            return this.isSecuritiesFinancing;
        }

        @Override
        @RosettaAttribute(value="otcClassification")
        @RuneAttribute(value="otcClassification")
        public List<? extends OtcClassification> getOtcClassification() {
            return this.otcClassification;
        }

        @Override
        @RosettaAttribute(value="tradingWaiver")
        @RuneAttribute(value="tradingWaiver")
        public List<? extends TradingWaiver> getTradingWaiver() {
            return this.tradingWaiver;
        }

        @Override
        @RosettaAttribute(value="shortSale")
        @RuneAttribute(value="shortSale")
        public ShortSale getShortSale() {
            return this.shortSale;
        }

        @Override
        @RosettaAttribute(value="isCommodityHedge")
        @RuneAttribute(value="isCommodityHedge")
        public Boolean getIsCommodityHedge() {
            return this.isCommodityHedge;
        }

        @Override
        public TransactionClassificationModel build() {
            return this;
        }

        @Override
        public TransactionClassificationModelBuilder toBuilder() {
            TransactionClassificationModelBuilder builder = TransactionClassificationModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TransactionClassificationModelBuilder builder) {
            Optional.ofNullable(this.getIsSecuritiesFinancing()).ifPresent(builder::setIsSecuritiesFinancing);
            Optional.ofNullable(this.getOtcClassification()).ifPresent(builder::setOtcClassification);
            Optional.ofNullable(this.getTradingWaiver()).ifPresent(builder::setTradingWaiver);
            Optional.ofNullable(this.getShortSale()).ifPresent(builder::setShortSale);
            Optional.ofNullable(this.getIsCommodityHedge()).ifPresent(builder::setIsCommodityHedge);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TransactionClassificationModel _that = this.getType().cast(o);
            if (!Objects.equals(this.isSecuritiesFinancing, _that.getIsSecuritiesFinancing())) {
                return false;
            }
            if (!ListEquals.listEquals(this.otcClassification, _that.getOtcClassification())) {
                return false;
            }
            if (!ListEquals.listEquals(this.tradingWaiver, _that.getTradingWaiver())) {
                return false;
            }
            if (!Objects.equals(this.shortSale, _that.getShortSale())) {
                return false;
            }
            return Objects.equals(this.isCommodityHedge, _that.getIsCommodityHedge());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.isSecuritiesFinancing != null ? this.isSecuritiesFinancing.hashCode() : 0);
            _result = 31 * _result + (this.otcClassification != null ? this.otcClassification.hashCode() : 0);
            _result = 31 * _result + (this.tradingWaiver != null ? this.tradingWaiver.hashCode() : 0);
            _result = 31 * _result + (this.shortSale != null ? this.shortSale.hashCode() : 0);
            _result = 31 * _result + (this.isCommodityHedge != null ? this.isCommodityHedge.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TransactionClassificationModel {isSecuritiesFinancing=" + this.isSecuritiesFinancing + ", otcClassification=" + String.valueOf(this.otcClassification) + ", tradingWaiver=" + String.valueOf(this.tradingWaiver) + ", shortSale=" + String.valueOf(this.shortSale) + ", isCommodityHedge=" + this.isCommodityHedge + "}";
        }
    }
}

