/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.doc;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.doc.meta.ProductComponentIdentifierMeta;
import fpml.consolidated.shared.IssuerId;
import fpml.consolidated.shared.ProductReference;
import fpml.consolidated.shared.TradeId;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="ProductComponentIdentifier", builder=ProductComponentIdentifierBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ProductComponentIdentifier", model="fpml", builder=ProductComponentIdentifierBuilderImpl.class, version="1.2.2")
public interface ProductComponentIdentifier
extends RosettaModelObject {
    public static final ProductComponentIdentifierMeta metaData = new ProductComponentIdentifierMeta();

    public ProductReference getPremiumProductReference();

    public IssuerId getIssuer();

    public TradeId getTradeId();

    public ProductComponentIdentifier build();

    public ProductComponentIdentifierBuilder toBuilder();

    public static ProductComponentIdentifierBuilder builder() {
        return new ProductComponentIdentifierBuilderImpl();
    }

    default public RosettaMetaData<? extends ProductComponentIdentifier> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ProductComponentIdentifier> getType() {
        return ProductComponentIdentifier.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("premiumProductReference"), processor, ProductReference.class, this.getPremiumProductReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("issuer"), processor, IssuerId.class, this.getIssuer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.class, this.getTradeId(), new AttributeMeta[0]);
    }

    public static class ProductComponentIdentifierBuilderImpl
    implements ProductComponentIdentifierBuilder {
        protected ProductReference.ProductReferenceBuilder premiumProductReference;
        protected IssuerId.IssuerIdBuilder issuer;
        protected TradeId.TradeIdBuilder tradeId;

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public ProductReference.ProductReferenceBuilder getPremiumProductReference() {
            return this.premiumProductReference;
        }

        @Override
        public ProductReference.ProductReferenceBuilder getOrCreatePremiumProductReference() {
            ProductReference.ProductReferenceBuilder result = this.premiumProductReference != null ? this.premiumProductReference : (this.premiumProductReference = ProductReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public IssuerId.IssuerIdBuilder getIssuer() {
            return this.issuer;
        }

        @Override
        public IssuerId.IssuerIdBuilder getOrCreateIssuer() {
            IssuerId.IssuerIdBuilder result = this.issuer != null ? this.issuer : (this.issuer = IssuerId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public TradeId.TradeIdBuilder getTradeId() {
            return this.tradeId;
        }

        @Override
        public TradeId.TradeIdBuilder getOrCreateTradeId() {
            TradeId.TradeIdBuilder result = this.tradeId != null ? this.tradeId : (this.tradeId = TradeId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public ProductComponentIdentifierBuilder setPremiumProductReference(ProductReference _premiumProductReference) {
            this.premiumProductReference = _premiumProductReference == null ? null : _premiumProductReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public ProductComponentIdentifierBuilder setIssuer(IssuerId _issuer) {
            this.issuer = _issuer == null ? null : _issuer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public ProductComponentIdentifierBuilder setTradeId(TradeId _tradeId) {
            this.tradeId = _tradeId == null ? null : _tradeId.toBuilder();
            return this;
        }

        @Override
        public ProductComponentIdentifier build() {
            return new ProductComponentIdentifierImpl(this);
        }

        @Override
        public ProductComponentIdentifierBuilder toBuilder() {
            return this;
        }

        @Override
        public ProductComponentIdentifierBuilder prune() {
            if (this.premiumProductReference != null && !this.premiumProductReference.prune().hasData()) {
                this.premiumProductReference = null;
            }
            if (this.issuer != null && !this.issuer.prune().hasData()) {
                this.issuer = null;
            }
            if (this.tradeId != null && !this.tradeId.prune().hasData()) {
                this.tradeId = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPremiumProductReference() != null && this.getPremiumProductReference().hasData()) {
                return true;
            }
            if (this.getIssuer() != null && this.getIssuer().hasData()) {
                return true;
            }
            return this.getTradeId() != null && this.getTradeId().hasData();
        }

        public ProductComponentIdentifierBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ProductComponentIdentifierBuilder o = (ProductComponentIdentifierBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremiumProductReference(), (RosettaModelObjectBuilder)o.getPremiumProductReference(), this::setPremiumProductReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getIssuer(), (RosettaModelObjectBuilder)o.getIssuer(), this::setIssuer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeId(), (RosettaModelObjectBuilder)o.getTradeId(), this::setTradeId);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductComponentIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.premiumProductReference, _that.getPremiumProductReference())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            return Objects.equals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.premiumProductReference != null ? this.premiumProductReference.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductComponentIdentifierBuilder {premiumProductReference=" + String.valueOf(this.premiumProductReference) + ", issuer=" + String.valueOf(this.issuer) + ", tradeId=" + String.valueOf(this.tradeId) + "}";
        }
    }

    public static interface ProductComponentIdentifierBuilder
    extends ProductComponentIdentifier,
    RosettaModelObjectBuilder {
        public ProductReference.ProductReferenceBuilder getOrCreatePremiumProductReference();

        @Override
        public ProductReference.ProductReferenceBuilder getPremiumProductReference();

        public IssuerId.IssuerIdBuilder getOrCreateIssuer();

        @Override
        public IssuerId.IssuerIdBuilder getIssuer();

        public TradeId.TradeIdBuilder getOrCreateTradeId();

        @Override
        public TradeId.TradeIdBuilder getTradeId();

        public ProductComponentIdentifierBuilder setPremiumProductReference(ProductReference var1);

        public ProductComponentIdentifierBuilder setIssuer(IssuerId var1);

        public ProductComponentIdentifierBuilder setTradeId(TradeId var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("premiumProductReference"), processor, ProductReference.ProductReferenceBuilder.class, this.getPremiumProductReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("issuer"), processor, IssuerId.IssuerIdBuilder.class, this.getIssuer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeId"), processor, TradeId.TradeIdBuilder.class, this.getTradeId(), new AttributeMeta[0]);
        }

        public ProductComponentIdentifierBuilder prune();
    }

    public static class ProductComponentIdentifierImpl
    implements ProductComponentIdentifier {
        private final ProductReference premiumProductReference;
        private final IssuerId issuer;
        private final TradeId tradeId;

        protected ProductComponentIdentifierImpl(ProductComponentIdentifierBuilder builder) {
            this.premiumProductReference = Optional.ofNullable(builder.getPremiumProductReference()).map(f -> f.build()).orElse(null);
            this.issuer = Optional.ofNullable(builder.getIssuer()).map(f -> f.build()).orElse(null);
            this.tradeId = Optional.ofNullable(builder.getTradeId()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="premiumProductReference")
        @RuneAttribute(value="premiumProductReference")
        public ProductReference getPremiumProductReference() {
            return this.premiumProductReference;
        }

        @Override
        @RosettaAttribute(value="issuer", isRequired=true)
        @RuneAttribute(value="issuer", isRequired=true)
        public IssuerId getIssuer() {
            return this.issuer;
        }

        @Override
        @RosettaAttribute(value="tradeId", isRequired=true)
        @RuneAttribute(value="tradeId", isRequired=true)
        public TradeId getTradeId() {
            return this.tradeId;
        }

        @Override
        public ProductComponentIdentifier build() {
            return this;
        }

        @Override
        public ProductComponentIdentifierBuilder toBuilder() {
            ProductComponentIdentifierBuilder builder = ProductComponentIdentifier.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ProductComponentIdentifierBuilder builder) {
            Optional.ofNullable(this.getPremiumProductReference()).ifPresent(builder::setPremiumProductReference);
            Optional.ofNullable(this.getIssuer()).ifPresent(builder::setIssuer);
            Optional.ofNullable(this.getTradeId()).ifPresent(builder::setTradeId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ProductComponentIdentifier _that = this.getType().cast(o);
            if (!Objects.equals(this.premiumProductReference, _that.getPremiumProductReference())) {
                return false;
            }
            if (!Objects.equals(this.issuer, _that.getIssuer())) {
                return false;
            }
            return Objects.equals(this.tradeId, _that.getTradeId());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.premiumProductReference != null ? this.premiumProductReference.hashCode() : 0);
            _result = 31 * _result + (this.issuer != null ? this.issuer.hashCode() : 0);
            _result = 31 * _result + (this.tradeId != null ? this.tradeId.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ProductComponentIdentifier {premiumProductReference=" + String.valueOf(this.premiumProductReference) + ", issuer=" + String.valueOf(this.issuer) + ", tradeId=" + String.valueOf(this.tradeId) + "}";
        }
    }
}

