/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AdditionalEvent;
import fpml.consolidated.business.events.ChangeEventsBaseModel;
import fpml.consolidated.business.events.OptionsEventsBaseModel;
import fpml.consolidated.business.events.PostTradeEventsBaseModel;
import fpml.consolidated.business.events.TradingEventsBaseModel;
import fpml.consolidated.confirmation.processes.meta.ExecutionAdviceRetractedMeta;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndSequenceModel;
import fpml.consolidated.msg.NonCorrectableRequestMessage;
import fpml.consolidated.msg.RequestMessageHeader;
import fpml.consolidated.reg.fpmlreporting.shared.RegulatoryReportingCollateralization;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.PaymentDetails;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExecutionAdviceRetracted", builder=ExecutionAdviceRetractedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ExecutionAdviceRetracted", model="fpml", builder=ExecutionAdviceRetractedBuilderImpl.class, version="1.2.2")
public interface ExecutionAdviceRetracted
extends NonCorrectableRequestMessage {
    public static final ExecutionAdviceRetractedMeta metaData = new ExecutionAdviceRetractedMeta();

    public TradingEventsBaseModel getTradingEventsBaseModel();

    public PostTradeEventsBaseModel getPostTradeEventsBaseModel();

    public ChangeEventsBaseModel getChangeEventsBaseModel();

    public OptionsEventsBaseModel getOptionsEventsBaseModel();

    public AdditionalEvent getAdditionalEvent();

    public List<? extends RegulatoryReportingCollateralization> getCollateralization();

    public List<? extends PaymentDetails> getPaymentDetails();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    @Override
    public ExecutionAdviceRetracted build();

    @Override
    public ExecutionAdviceRetractedBuilder toBuilder();

    public static ExecutionAdviceRetractedBuilder builder() {
        return new ExecutionAdviceRetractedBuilderImpl();
    }

    default public RosettaMetaData<? extends ExecutionAdviceRetracted> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExecutionAdviceRetracted> getType() {
        return ExecutionAdviceRetracted.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.class, this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.class, this.getAdditionalEvent(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.class, this.getCollateralization(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.class, this.getPaymentDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
    }

    public static class ExecutionAdviceRetractedBuilderImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilderImpl
    implements ExecutionAdviceRetractedBuilder {
        protected TradingEventsBaseModel.TradingEventsBaseModelBuilder tradingEventsBaseModel;
        protected PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder postTradeEventsBaseModel;
        protected ChangeEventsBaseModel.ChangeEventsBaseModelBuilder changeEventsBaseModel;
        protected OptionsEventsBaseModel.OptionsEventsBaseModelBuilder optionsEventsBaseModel;
        protected AdditionalEvent.AdditionalEventBuilder additionalEvent;
        protected List<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
        protected List<PaymentDetails.PaymentDetailsBuilder> paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel() {
            TradingEventsBaseModel.TradingEventsBaseModelBuilder result = this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel : (this.tradingEventsBaseModel = TradingEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel() {
            PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder result = this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel : (this.postTradeEventsBaseModel = PostTradeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel() {
            ChangeEventsBaseModel.ChangeEventsBaseModelBuilder result = this.changeEventsBaseModel != null ? this.changeEventsBaseModel : (this.changeEventsBaseModel = ChangeEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel() {
            OptionsEventsBaseModel.OptionsEventsBaseModelBuilder result = this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel : (this.optionsEventsBaseModel = OptionsEventsBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent() {
            AdditionalEvent.AdditionalEventBuilder result = this.additionalEvent != null ? this.additionalEvent : (this.additionalEvent = AdditionalEvent.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization() {
            return this.collateralization;
        }

        @Override
        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int index) {
            if (this.collateralization == null) {
                this.collateralization = new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>();
            }
            return (RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder)this.getIndex(this.collateralization, index, () -> {
                RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder newCollateralization = RegulatoryReportingCollateralization.builder();
                return newCollateralization;
            });
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int index) {
            if (this.paymentDetails == null) {
                this.paymentDetails = new ArrayList<PaymentDetails.PaymentDetailsBuilder>();
            }
            return (PaymentDetails.PaymentDetailsBuilder)this.getIndex(this.paymentDetails, index, () -> {
                PaymentDetails.PaymentDetailsBuilder newPaymentDetails = PaymentDetails.builder();
                return newPaymentDetails;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ExecutionAdviceRetractedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ExecutionAdviceRetractedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ExecutionAdviceRetractedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ExecutionAdviceRetractedBuilder setHeader(RequestMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ExecutionAdviceRetractedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndSequenceModel")
        @RuneAttribute(value="correlationAndSequenceModel")
        public ExecutionAdviceRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel _correlationAndSequenceModel) {
            this.correlationAndSequenceModel = _correlationAndSequenceModel == null ? null : _correlationAndSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ExecutionAdviceRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public ExecutionAdviceRetractedBuilder setTradingEventsBaseModel(TradingEventsBaseModel _tradingEventsBaseModel) {
            this.tradingEventsBaseModel = _tradingEventsBaseModel == null ? null : _tradingEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public ExecutionAdviceRetractedBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel _postTradeEventsBaseModel) {
            this.postTradeEventsBaseModel = _postTradeEventsBaseModel == null ? null : _postTradeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ExecutionAdviceRetractedBuilder setChangeEventsBaseModel(ChangeEventsBaseModel _changeEventsBaseModel) {
            this.changeEventsBaseModel = _changeEventsBaseModel == null ? null : _changeEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public ExecutionAdviceRetractedBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel _optionsEventsBaseModel) {
            this.optionsEventsBaseModel = _optionsEventsBaseModel == null ? null : _optionsEventsBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public ExecutionAdviceRetractedBuilder setAdditionalEvent(AdditionalEvent _additionalEvent) {
            this.additionalEvent = _additionalEvent == null ? null : _additionalEvent.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public ExecutionAdviceRetractedBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization) {
            if (_collateralization != null) {
                this.collateralization.add(_collateralization.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder addCollateralization(RegulatoryReportingCollateralization _collateralization, int idx) {
            this.getIndex(this.collateralization, idx, () -> _collateralization.toBuilder());
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            if (collateralizations != null) {
                for (RegulatoryReportingCollateralization regulatoryReportingCollateralization : collateralizations) {
                    this.collateralization.add(regulatoryReportingCollateralization.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="collateralization")
        public ExecutionAdviceRetractedBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> collateralizations) {
            this.collateralization = collateralizations == null ? new ArrayList<RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder>() : (List)collateralizations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public ExecutionAdviceRetractedBuilder addPaymentDetails(PaymentDetails _paymentDetails) {
            if (_paymentDetails != null) {
                this.paymentDetails.add(_paymentDetails.toBuilder());
            }
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder addPaymentDetails(PaymentDetails _paymentDetails, int idx) {
            this.getIndex(this.paymentDetails, idx, () -> _paymentDetails.toBuilder());
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder addPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            if (paymentDetailss != null) {
                for (PaymentDetails paymentDetails : paymentDetailss) {
                    this.paymentDetails.add(paymentDetails.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="paymentDetails")
        public ExecutionAdviceRetractedBuilder setPaymentDetails(List<? extends PaymentDetails> paymentDetailss) {
            this.paymentDetails = paymentDetailss == null ? new ArrayList<PaymentDetails.PaymentDetailsBuilder>() : (List)paymentDetailss.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ExecutionAdviceRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        public ExecutionAdviceRetracted build() {
            return new ExecutionAdviceRetractedImpl(this);
        }

        @Override
        public ExecutionAdviceRetractedBuilder toBuilder() {
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder prune() {
            super.prune();
            if (this.tradingEventsBaseModel != null && !this.tradingEventsBaseModel.prune().hasData()) {
                this.tradingEventsBaseModel = null;
            }
            if (this.postTradeEventsBaseModel != null && !this.postTradeEventsBaseModel.prune().hasData()) {
                this.postTradeEventsBaseModel = null;
            }
            if (this.changeEventsBaseModel != null && !this.changeEventsBaseModel.prune().hasData()) {
                this.changeEventsBaseModel = null;
            }
            if (this.optionsEventsBaseModel != null && !this.optionsEventsBaseModel.prune().hasData()) {
                this.optionsEventsBaseModel = null;
            }
            if (this.additionalEvent != null && !this.additionalEvent.prune().hasData()) {
                this.additionalEvent = null;
            }
            this.collateralization = this.collateralization.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.paymentDetails = this.paymentDetails.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getTradingEventsBaseModel() != null && this.getTradingEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getPostTradeEventsBaseModel() != null && this.getPostTradeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getChangeEventsBaseModel() != null && this.getChangeEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getOptionsEventsBaseModel() != null && this.getOptionsEventsBaseModel().hasData()) {
                return true;
            }
            if (this.getAdditionalEvent() != null && this.getAdditionalEvent().hasData()) {
                return true;
            }
            if (this.getCollateralization() != null && this.getCollateralization().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPaymentDetails() != null && this.getPaymentDetails().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData();
        }

        @Override
        public ExecutionAdviceRetractedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExecutionAdviceRetractedBuilder o = (ExecutionAdviceRetractedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradingEventsBaseModel(), (RosettaModelObjectBuilder)o.getTradingEventsBaseModel(), this::setTradingEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPostTradeEventsBaseModel(), (RosettaModelObjectBuilder)o.getPostTradeEventsBaseModel(), this::setPostTradeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getChangeEventsBaseModel(), (RosettaModelObjectBuilder)o.getChangeEventsBaseModel(), this::setChangeEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getOptionsEventsBaseModel(), (RosettaModelObjectBuilder)o.getOptionsEventsBaseModel(), this::setOptionsEventsBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAdditionalEvent(), (RosettaModelObjectBuilder)o.getAdditionalEvent(), this::setAdditionalEvent);
            merger.mergeRosetta(this.getCollateralization(), o.getCollateralization(), this::getOrCreateCollateralization);
            merger.mergeRosetta(this.getPaymentDetails(), o.getPaymentDetails(), this::getOrCreatePaymentDetails);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionAdviceRetracted _that = (ExecutionAdviceRetracted)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionAdviceRetractedBuilder {tradingEventsBaseModel=" + String.valueOf(this.tradingEventsBaseModel) + ", postTradeEventsBaseModel=" + String.valueOf(this.postTradeEventsBaseModel) + ", changeEventsBaseModel=" + String.valueOf(this.changeEventsBaseModel) + ", optionsEventsBaseModel=" + String.valueOf(this.optionsEventsBaseModel) + ", additionalEvent=" + String.valueOf(this.additionalEvent) + ", collateralization=" + String.valueOf(this.collateralization) + ", paymentDetails=" + String.valueOf(this.paymentDetails) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }

    public static interface ExecutionAdviceRetractedBuilder
    extends ExecutionAdviceRetracted,
    NonCorrectableRequestMessage.NonCorrectableRequestMessageBuilder {
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getOrCreateTradingEventsBaseModel();

        @Override
        public TradingEventsBaseModel.TradingEventsBaseModelBuilder getTradingEventsBaseModel();

        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getOrCreatePostTradeEventsBaseModel();

        @Override
        public PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder getPostTradeEventsBaseModel();

        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getOrCreateChangeEventsBaseModel();

        @Override
        public ChangeEventsBaseModel.ChangeEventsBaseModelBuilder getChangeEventsBaseModel();

        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOrCreateOptionsEventsBaseModel();

        @Override
        public OptionsEventsBaseModel.OptionsEventsBaseModelBuilder getOptionsEventsBaseModel();

        public AdditionalEvent.AdditionalEventBuilder getOrCreateAdditionalEvent();

        @Override
        public AdditionalEvent.AdditionalEventBuilder getAdditionalEvent();

        public RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder getOrCreateCollateralization(int var1);

        public List<? extends RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder> getCollateralization();

        public PaymentDetails.PaymentDetailsBuilder getOrCreatePaymentDetails(int var1);

        public List<? extends PaymentDetails.PaymentDetailsBuilder> getPaymentDetails();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        @Override
        public ExecutionAdviceRetractedBuilder setFpmlVersion(String var1);

        @Override
        public ExecutionAdviceRetractedBuilder setExpectedBuild(Integer var1);

        @Override
        public ExecutionAdviceRetractedBuilder setActualBuild(Integer var1);

        @Override
        public ExecutionAdviceRetractedBuilder setHeader(RequestMessageHeader var1);

        @Override
        public ExecutionAdviceRetractedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ExecutionAdviceRetractedBuilder setCorrelationAndSequenceModel(CorrelationAndSequenceModel var1);

        @Override
        public ExecutionAdviceRetractedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ExecutionAdviceRetractedBuilder setTradingEventsBaseModel(TradingEventsBaseModel var1);

        public ExecutionAdviceRetractedBuilder setPostTradeEventsBaseModel(PostTradeEventsBaseModel var1);

        public ExecutionAdviceRetractedBuilder setChangeEventsBaseModel(ChangeEventsBaseModel var1);

        public ExecutionAdviceRetractedBuilder setOptionsEventsBaseModel(OptionsEventsBaseModel var1);

        public ExecutionAdviceRetractedBuilder setAdditionalEvent(AdditionalEvent var1);

        public ExecutionAdviceRetractedBuilder addCollateralization(RegulatoryReportingCollateralization var1);

        public ExecutionAdviceRetractedBuilder addCollateralization(RegulatoryReportingCollateralization var1, int var2);

        public ExecutionAdviceRetractedBuilder addCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public ExecutionAdviceRetractedBuilder setCollateralization(List<? extends RegulatoryReportingCollateralization> var1);

        public ExecutionAdviceRetractedBuilder addPaymentDetails(PaymentDetails var1);

        public ExecutionAdviceRetractedBuilder addPaymentDetails(PaymentDetails var1, int var2);

        public ExecutionAdviceRetractedBuilder addPaymentDetails(List<? extends PaymentDetails> var1);

        public ExecutionAdviceRetractedBuilder setPaymentDetails(List<? extends PaymentDetails> var1);

        public ExecutionAdviceRetractedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, RequestMessageHeader.RequestMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndSequenceModel"), processor, CorrelationAndSequenceModel.CorrelationAndSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradingEventsBaseModel"), processor, TradingEventsBaseModel.TradingEventsBaseModelBuilder.class, this.getTradingEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("postTradeEventsBaseModel"), processor, PostTradeEventsBaseModel.PostTradeEventsBaseModelBuilder.class, this.getPostTradeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("changeEventsBaseModel"), processor, ChangeEventsBaseModel.ChangeEventsBaseModelBuilder.class, this.getChangeEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("optionsEventsBaseModel"), processor, OptionsEventsBaseModel.OptionsEventsBaseModelBuilder.class, this.getOptionsEventsBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("additionalEvent"), processor, AdditionalEvent.AdditionalEventBuilder.class, this.getAdditionalEvent(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralization"), processor, RegulatoryReportingCollateralization.RegulatoryReportingCollateralizationBuilder.class, this.getCollateralization(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentDetails"), processor, PaymentDetails.PaymentDetailsBuilder.class, this.getPaymentDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        }

        @Override
        public ExecutionAdviceRetractedBuilder prune();
    }

    public static class ExecutionAdviceRetractedImpl
    extends NonCorrectableRequestMessage.NonCorrectableRequestMessageImpl
    implements ExecutionAdviceRetracted {
        private final TradingEventsBaseModel tradingEventsBaseModel;
        private final PostTradeEventsBaseModel postTradeEventsBaseModel;
        private final ChangeEventsBaseModel changeEventsBaseModel;
        private final OptionsEventsBaseModel optionsEventsBaseModel;
        private final AdditionalEvent additionalEvent;
        private final List<? extends RegulatoryReportingCollateralization> collateralization;
        private final List<? extends PaymentDetails> paymentDetails;
        private final PartiesAndAccountsModel partiesAndAccountsModel;

        protected ExecutionAdviceRetractedImpl(ExecutionAdviceRetractedBuilder builder) {
            super(builder);
            this.tradingEventsBaseModel = Optional.ofNullable(builder.getTradingEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.postTradeEventsBaseModel = Optional.ofNullable(builder.getPostTradeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.changeEventsBaseModel = Optional.ofNullable(builder.getChangeEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.optionsEventsBaseModel = Optional.ofNullable(builder.getOptionsEventsBaseModel()).map(f -> f.build()).orElse(null);
            this.additionalEvent = Optional.ofNullable(builder.getAdditionalEvent()).map(f -> f.build()).orElse(null);
            this.collateralization = Optional.ofNullable(builder.getCollateralization()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.paymentDetails = Optional.ofNullable(builder.getPaymentDetails()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradingEventsBaseModel")
        @RuneAttribute(value="tradingEventsBaseModel")
        public TradingEventsBaseModel getTradingEventsBaseModel() {
            return this.tradingEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="postTradeEventsBaseModel")
        @RuneAttribute(value="postTradeEventsBaseModel")
        public PostTradeEventsBaseModel getPostTradeEventsBaseModel() {
            return this.postTradeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="changeEventsBaseModel")
        @RuneAttribute(value="changeEventsBaseModel")
        public ChangeEventsBaseModel getChangeEventsBaseModel() {
            return this.changeEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="optionsEventsBaseModel")
        @RuneAttribute(value="optionsEventsBaseModel")
        public OptionsEventsBaseModel getOptionsEventsBaseModel() {
            return this.optionsEventsBaseModel;
        }

        @Override
        @RosettaAttribute(value="additionalEvent")
        @RuneAttribute(value="additionalEvent")
        public AdditionalEvent getAdditionalEvent() {
            return this.additionalEvent;
        }

        @Override
        @RosettaAttribute(value="collateralization")
        @RuneAttribute(value="collateralization")
        public List<? extends RegulatoryReportingCollateralization> getCollateralization() {
            return this.collateralization;
        }

        @Override
        @RosettaAttribute(value="paymentDetails")
        @RuneAttribute(value="paymentDetails")
        public List<? extends PaymentDetails> getPaymentDetails() {
            return this.paymentDetails;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public ExecutionAdviceRetracted build() {
            return this;
        }

        @Override
        public ExecutionAdviceRetractedBuilder toBuilder() {
            ExecutionAdviceRetractedBuilder builder = ExecutionAdviceRetracted.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExecutionAdviceRetractedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getTradingEventsBaseModel()).ifPresent(builder::setTradingEventsBaseModel);
            Optional.ofNullable(this.getPostTradeEventsBaseModel()).ifPresent(builder::setPostTradeEventsBaseModel);
            Optional.ofNullable(this.getChangeEventsBaseModel()).ifPresent(builder::setChangeEventsBaseModel);
            Optional.ofNullable(this.getOptionsEventsBaseModel()).ifPresent(builder::setOptionsEventsBaseModel);
            Optional.ofNullable(this.getAdditionalEvent()).ifPresent(builder::setAdditionalEvent);
            Optional.ofNullable(this.getCollateralization()).ifPresent(builder::setCollateralization);
            Optional.ofNullable(this.getPaymentDetails()).ifPresent(builder::setPaymentDetails);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExecutionAdviceRetracted _that = (ExecutionAdviceRetracted)this.getType().cast(o);
            if (!Objects.equals(this.tradingEventsBaseModel, _that.getTradingEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.postTradeEventsBaseModel, _that.getPostTradeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.changeEventsBaseModel, _that.getChangeEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.optionsEventsBaseModel, _that.getOptionsEventsBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.additionalEvent, _that.getAdditionalEvent())) {
                return false;
            }
            if (!ListEquals.listEquals(this.collateralization, _that.getCollateralization())) {
                return false;
            }
            if (!ListEquals.listEquals(this.paymentDetails, _that.getPaymentDetails())) {
                return false;
            }
            return Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.tradingEventsBaseModel != null ? this.tradingEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.postTradeEventsBaseModel != null ? this.postTradeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.changeEventsBaseModel != null ? this.changeEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.optionsEventsBaseModel != null ? this.optionsEventsBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.additionalEvent != null ? this.additionalEvent.hashCode() : 0);
            _result = 31 * _result + (this.collateralization != null ? this.collateralization.hashCode() : 0);
            _result = 31 * _result + (this.paymentDetails != null ? this.paymentDetails.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExecutionAdviceRetracted {tradingEventsBaseModel=" + String.valueOf(this.tradingEventsBaseModel) + ", postTradeEventsBaseModel=" + String.valueOf(this.postTradeEventsBaseModel) + ", changeEventsBaseModel=" + String.valueOf(this.changeEventsBaseModel) + ", optionsEventsBaseModel=" + String.valueOf(this.optionsEventsBaseModel) + ", additionalEvent=" + String.valueOf(this.additionalEvent) + ", collateralization=" + String.valueOf(this.collateralization) + ", paymentDetails=" + String.valueOf(this.paymentDetails) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + "} " + super.toString();
        }
    }
}

