/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.confirmation.processes;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.CreditLimitInformation;
import fpml.consolidated.confirmation.processes.EventsOrInfoModel;
import fpml.consolidated.confirmation.processes.meta.ConsentRefusedMeta;
import fpml.consolidated.doc.ApprovalType;
import fpml.consolidated.doc.Reason;
import fpml.consolidated.doc.ValidationModel;
import fpml.consolidated.msg.CorrelationAndOptionalSequenceModel;
import fpml.consolidated.msg.PortfolioReferenceBaseModel;
import fpml.consolidated.msg.ResponseMessage;
import fpml.consolidated.msg.ResponseMessageHeader;
import fpml.consolidated.shared.OnBehalfOfModel;
import fpml.consolidated.shared.PartiesAndAccountsModel;
import fpml.consolidated.shared.PartyReference;
import fpml.consolidated.shared.PersonId;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ConsentRefused", builder=ConsentRefusedBuilderImpl.class, version="1.2.2")
@RuneDataType(value="ConsentRefused", model="fpml", builder=ConsentRefusedBuilderImpl.class, version="1.2.2")
public interface ConsentRefused
extends ResponseMessage {
    public static final ConsentRefusedMeta metaData = new ConsentRefusedMeta();

    public ApprovalType _getType();

    public PersonId getApprover();

    public PartyReference getApprovingPartyReference();

    public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel();

    public EventsOrInfoModel getEventsOrInfoModel();

    public List<? extends CreditLimitInformation> getCreditLimitInformation();

    public PartiesAndAccountsModel getPartiesAndAccountsModel();

    public List<? extends Reason> getReason();

    @Override
    public ConsentRefused build();

    @Override
    public ConsentRefusedBuilder toBuilder();

    public static ConsentRefusedBuilder builder() {
        return new ConsentRefusedBuilderImpl();
    }

    default public RosettaMetaData<? extends ConsentRefused> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ConsentRefused> getType() {
        return ConsentRefused.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.class, this.getHeader(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.class, this.getValidationModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.class, this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.class, this.getOnBehalfOfModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("type"), processor, ApprovalType.class, this._getType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approver"), processor, PersonId.class, this.getApprover(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("approvingPartyReference"), processor, PartyReference.class, this.getApprovingPartyReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventsOrInfoModel"), processor, EventsOrInfoModel.class, this.getEventsOrInfoModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reason"), processor, Reason.class, this.getReason(), new AttributeMeta[0]);
    }

    public static class ConsentRefusedBuilderImpl
    extends ResponseMessage.ResponseMessageBuilderImpl
    implements ConsentRefusedBuilder {
        protected ApprovalType.ApprovalTypeBuilder type;
        protected PersonId.PersonIdBuilder approver;
        protected PartyReference.PartyReferenceBuilder approvingPartyReference;
        protected PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder portfolioReferenceBaseModel;
        protected EventsOrInfoModel.EventsOrInfoModelBuilder eventsOrInfoModel;
        protected List<CreditLimitInformation.CreditLimitInformationBuilder> creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
        protected PartiesAndAccountsModel.PartiesAndAccountsModelBuilder partiesAndAccountsModel;
        protected List<Reason.ReasonBuilder> reason = new ArrayList<Reason.ReasonBuilder>();

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public ApprovalType.ApprovalTypeBuilder _getType() {
            return this.type;
        }

        @Override
        public ApprovalType.ApprovalTypeBuilder getOrCreateType() {
            ApprovalType.ApprovalTypeBuilder result = this.type != null ? this.type : (this.type = ApprovalType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public PersonId.PersonIdBuilder getApprover() {
            return this.approver;
        }

        @Override
        public PersonId.PersonIdBuilder getOrCreateApprover() {
            PersonId.PersonIdBuilder result = this.approver != null ? this.approver : (this.approver = PersonId.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public PartyReference.PartyReferenceBuilder getApprovingPartyReference() {
            return this.approvingPartyReference;
        }

        @Override
        public PartyReference.PartyReferenceBuilder getOrCreateApprovingPartyReference() {
            PartyReference.PartyReferenceBuilder result = this.approvingPartyReference != null ? this.approvingPartyReference : (this.approvingPartyReference = PartyReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel() {
            PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder result = this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel : (this.portfolioReferenceBaseModel = PortfolioReferenceBaseModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public EventsOrInfoModel.EventsOrInfoModelBuilder getEventsOrInfoModel() {
            return this.eventsOrInfoModel;
        }

        @Override
        public EventsOrInfoModel.EventsOrInfoModelBuilder getOrCreateEventsOrInfoModel() {
            EventsOrInfoModel.EventsOrInfoModelBuilder result = this.eventsOrInfoModel != null ? this.eventsOrInfoModel : (this.eventsOrInfoModel = EventsOrInfoModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int index) {
            if (this.creditLimitInformation == null) {
                this.creditLimitInformation = new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>();
            }
            return (CreditLimitInformation.CreditLimitInformationBuilder)this.getIndex(this.creditLimitInformation, index, () -> {
                CreditLimitInformation.CreditLimitInformationBuilder newCreditLimitInformation = CreditLimitInformation.builder();
                return newCreditLimitInformation;
            });
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel() {
            PartiesAndAccountsModel.PartiesAndAccountsModelBuilder result = this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel : (this.partiesAndAccountsModel = PartiesAndAccountsModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason.ReasonBuilder> getReason() {
            return this.reason;
        }

        @Override
        public Reason.ReasonBuilder getOrCreateReason(int index) {
            if (this.reason == null) {
                this.reason = new ArrayList<Reason.ReasonBuilder>();
            }
            return (Reason.ReasonBuilder)this.getIndex(this.reason, index, () -> {
                Reason.ReasonBuilder newReason = Reason.builder();
                return newReason;
            });
        }

        @Override
        @RosettaAttribute(value="fpmlVersion", isRequired=true)
        @RuneAttribute(value="fpmlVersion", isRequired=true)
        public ConsentRefusedBuilder setFpmlVersion(String _fpmlVersion) {
            this.fpmlVersion = _fpmlVersion == null ? null : _fpmlVersion;
            return this;
        }

        @Override
        @RosettaAttribute(value="expectedBuild")
        @RuneAttribute(value="expectedBuild")
        public ConsentRefusedBuilder setExpectedBuild(Integer _expectedBuild) {
            this.expectedBuild = _expectedBuild == null ? null : _expectedBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="actualBuild")
        @RuneAttribute(value="actualBuild")
        public ConsentRefusedBuilder setActualBuild(Integer _actualBuild) {
            this.actualBuild = _actualBuild == null ? null : _actualBuild;
            return this;
        }

        @Override
        @RosettaAttribute(value="header")
        @RuneAttribute(value="header")
        public ConsentRefusedBuilder setHeader(ResponseMessageHeader _header) {
            this.header = _header == null ? null : _header.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="validationModel", isRequired=true)
        @RuneAttribute(value="validationModel", isRequired=true)
        public ConsentRefusedBuilder setValidationModel(ValidationModel _validationModel) {
            this.validationModel = _validationModel == null ? null : _validationModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        @RuneAttribute(value="correlationAndOptionalSequenceModel", isRequired=true)
        public ConsentRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel _correlationAndOptionalSequenceModel) {
            this.correlationAndOptionalSequenceModel = _correlationAndOptionalSequenceModel == null ? null : _correlationAndOptionalSequenceModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="onBehalfOfModel")
        @RuneAttribute(value="onBehalfOfModel")
        public ConsentRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel _onBehalfOfModel) {
            this.onBehalfOfModel = _onBehalfOfModel == null ? null : _onBehalfOfModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public ConsentRefusedBuilder setType(ApprovalType _type) {
            this.type = _type == null ? null : _type.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public ConsentRefusedBuilder setApprover(PersonId _approver) {
            this.approver = _approver == null ? null : _approver.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public ConsentRefusedBuilder setApprovingPartyReference(PartyReference _approvingPartyReference) {
            this.approvingPartyReference = _approvingPartyReference == null ? null : _approvingPartyReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public ConsentRefusedBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel _portfolioReferenceBaseModel) {
            this.portfolioReferenceBaseModel = _portfolioReferenceBaseModel == null ? null : _portfolioReferenceBaseModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public ConsentRefusedBuilder setEventsOrInfoModel(EventsOrInfoModel _eventsOrInfoModel) {
            this.eventsOrInfoModel = _eventsOrInfoModel == null ? null : _eventsOrInfoModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public ConsentRefusedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation) {
            if (_creditLimitInformation != null) {
                this.creditLimitInformation.add(_creditLimitInformation.toBuilder());
            }
            return this;
        }

        @Override
        public ConsentRefusedBuilder addCreditLimitInformation(CreditLimitInformation _creditLimitInformation, int idx) {
            this.getIndex(this.creditLimitInformation, idx, () -> _creditLimitInformation.toBuilder());
            return this;
        }

        @Override
        public ConsentRefusedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            if (creditLimitInformations != null) {
                for (CreditLimitInformation creditLimitInformation : creditLimitInformations) {
                    this.creditLimitInformation.add(creditLimitInformation.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditLimitInformation")
        public ConsentRefusedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> creditLimitInformations) {
            this.creditLimitInformation = creditLimitInformations == null ? new ArrayList<CreditLimitInformation.CreditLimitInformationBuilder>() : (List)creditLimitInformations.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public ConsentRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel _partiesAndAccountsModel) {
            this.partiesAndAccountsModel = _partiesAndAccountsModel == null ? null : _partiesAndAccountsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public ConsentRefusedBuilder addReason(Reason _reason) {
            if (_reason != null) {
                this.reason.add(_reason.toBuilder());
            }
            return this;
        }

        @Override
        public ConsentRefusedBuilder addReason(Reason _reason, int idx) {
            this.getIndex(this.reason, idx, () -> _reason.toBuilder());
            return this;
        }

        @Override
        public ConsentRefusedBuilder addReason(List<? extends Reason> reasons) {
            if (reasons != null) {
                for (Reason reason : reasons) {
                    this.reason.add(reason.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="reason")
        public ConsentRefusedBuilder setReason(List<? extends Reason> reasons) {
            this.reason = reasons == null ? new ArrayList<Reason.ReasonBuilder>() : (List)reasons.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public ConsentRefused build() {
            return new ConsentRefusedImpl(this);
        }

        @Override
        public ConsentRefusedBuilder toBuilder() {
            return this;
        }

        @Override
        public ConsentRefusedBuilder prune() {
            super.prune();
            if (this.type != null && !this.type.prune().hasData()) {
                this.type = null;
            }
            if (this.approver != null && !this.approver.prune().hasData()) {
                this.approver = null;
            }
            if (this.approvingPartyReference != null && !this.approvingPartyReference.prune().hasData()) {
                this.approvingPartyReference = null;
            }
            if (this.portfolioReferenceBaseModel != null && !this.portfolioReferenceBaseModel.prune().hasData()) {
                this.portfolioReferenceBaseModel = null;
            }
            if (this.eventsOrInfoModel != null && !this.eventsOrInfoModel.prune().hasData()) {
                this.eventsOrInfoModel = null;
            }
            this.creditLimitInformation = this.creditLimitInformation.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.partiesAndAccountsModel != null && !this.partiesAndAccountsModel.prune().hasData()) {
                this.partiesAndAccountsModel = null;
            }
            this.reason = this.reason.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this._getType() != null && this._getType().hasData()) {
                return true;
            }
            if (this.getApprover() != null && this.getApprover().hasData()) {
                return true;
            }
            if (this.getApprovingPartyReference() != null && this.getApprovingPartyReference().hasData()) {
                return true;
            }
            if (this.getPortfolioReferenceBaseModel() != null && this.getPortfolioReferenceBaseModel().hasData()) {
                return true;
            }
            if (this.getEventsOrInfoModel() != null && this.getEventsOrInfoModel().hasData()) {
                return true;
            }
            if (this.getCreditLimitInformation() != null && this.getCreditLimitInformation().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartiesAndAccountsModel() != null && this.getPartiesAndAccountsModel().hasData()) {
                return true;
            }
            return this.getReason() != null && this.getReason().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public ConsentRefusedBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ConsentRefusedBuilder o = (ConsentRefusedBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this._getType(), (RosettaModelObjectBuilder)o._getType(), this::setType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprover(), (RosettaModelObjectBuilder)o.getApprover(), this::setApprover);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getApprovingPartyReference(), (RosettaModelObjectBuilder)o.getApprovingPartyReference(), this::setApprovingPartyReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPortfolioReferenceBaseModel(), (RosettaModelObjectBuilder)o.getPortfolioReferenceBaseModel(), this::setPortfolioReferenceBaseModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventsOrInfoModel(), (RosettaModelObjectBuilder)o.getEventsOrInfoModel(), this::setEventsOrInfoModel);
            merger.mergeRosetta(this.getCreditLimitInformation(), o.getCreditLimitInformation(), this::getOrCreateCreditLimitInformation);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartiesAndAccountsModel(), (RosettaModelObjectBuilder)o.getPartiesAndAccountsModel(), this::setPartiesAndAccountsModel);
            merger.mergeRosetta(this.getReason(), o.getReason(), this::getOrCreateReason);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConsentRefused _that = (ConsentRefused)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.approver, _that.getApprover())) {
                return false;
            }
            if (!Objects.equals(this.approvingPartyReference, _that.getApprovingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.eventsOrInfoModel, _that.getEventsOrInfoModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.approver != null ? this.approver.hashCode() : 0);
            _result = 31 * _result + (this.approvingPartyReference != null ? this.approvingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.eventsOrInfoModel != null ? this.eventsOrInfoModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConsentRefusedBuilder {type=" + String.valueOf(this.type) + ", approver=" + String.valueOf(this.approver) + ", approvingPartyReference=" + String.valueOf(this.approvingPartyReference) + ", portfolioReferenceBaseModel=" + String.valueOf(this.portfolioReferenceBaseModel) + ", eventsOrInfoModel=" + String.valueOf(this.eventsOrInfoModel) + ", creditLimitInformation=" + String.valueOf(this.creditLimitInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }

    public static interface ConsentRefusedBuilder
    extends ConsentRefused,
    ResponseMessage.ResponseMessageBuilder {
        public ApprovalType.ApprovalTypeBuilder getOrCreateType();

        @Override
        public ApprovalType.ApprovalTypeBuilder _getType();

        public PersonId.PersonIdBuilder getOrCreateApprover();

        @Override
        public PersonId.PersonIdBuilder getApprover();

        public PartyReference.PartyReferenceBuilder getOrCreateApprovingPartyReference();

        @Override
        public PartyReference.PartyReferenceBuilder getApprovingPartyReference();

        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getOrCreatePortfolioReferenceBaseModel();

        @Override
        public PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder getPortfolioReferenceBaseModel();

        public EventsOrInfoModel.EventsOrInfoModelBuilder getOrCreateEventsOrInfoModel();

        @Override
        public EventsOrInfoModel.EventsOrInfoModelBuilder getEventsOrInfoModel();

        public CreditLimitInformation.CreditLimitInformationBuilder getOrCreateCreditLimitInformation(int var1);

        public List<? extends CreditLimitInformation.CreditLimitInformationBuilder> getCreditLimitInformation();

        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getOrCreatePartiesAndAccountsModel();

        @Override
        public PartiesAndAccountsModel.PartiesAndAccountsModelBuilder getPartiesAndAccountsModel();

        public Reason.ReasonBuilder getOrCreateReason(int var1);

        public List<? extends Reason.ReasonBuilder> getReason();

        @Override
        public ConsentRefusedBuilder setFpmlVersion(String var1);

        @Override
        public ConsentRefusedBuilder setExpectedBuild(Integer var1);

        @Override
        public ConsentRefusedBuilder setActualBuild(Integer var1);

        @Override
        public ConsentRefusedBuilder setHeader(ResponseMessageHeader var1);

        @Override
        public ConsentRefusedBuilder setValidationModel(ValidationModel var1);

        @Override
        public ConsentRefusedBuilder setCorrelationAndOptionalSequenceModel(CorrelationAndOptionalSequenceModel var1);

        @Override
        public ConsentRefusedBuilder setOnBehalfOfModel(OnBehalfOfModel var1);

        public ConsentRefusedBuilder setType(ApprovalType var1);

        public ConsentRefusedBuilder setApprover(PersonId var1);

        public ConsentRefusedBuilder setApprovingPartyReference(PartyReference var1);

        public ConsentRefusedBuilder setPortfolioReferenceBaseModel(PortfolioReferenceBaseModel var1);

        public ConsentRefusedBuilder setEventsOrInfoModel(EventsOrInfoModel var1);

        public ConsentRefusedBuilder addCreditLimitInformation(CreditLimitInformation var1);

        public ConsentRefusedBuilder addCreditLimitInformation(CreditLimitInformation var1, int var2);

        public ConsentRefusedBuilder addCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ConsentRefusedBuilder setCreditLimitInformation(List<? extends CreditLimitInformation> var1);

        public ConsentRefusedBuilder setPartiesAndAccountsModel(PartiesAndAccountsModel var1);

        public ConsentRefusedBuilder addReason(Reason var1);

        public ConsentRefusedBuilder addReason(Reason var1, int var2);

        public ConsentRefusedBuilder addReason(List<? extends Reason> var1);

        public ConsentRefusedBuilder setReason(List<? extends Reason> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("fpmlVersion"), String.class, (Object)this.getFpmlVersion(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("expectedBuild"), Integer.class, (Object)this.getExpectedBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actualBuild"), Integer.class, (Object)this.getActualBuild(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("header"), processor, ResponseMessageHeader.ResponseMessageHeaderBuilder.class, (RosettaModelObjectBuilder)this.getHeader(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("validationModel"), processor, ValidationModel.ValidationModelBuilder.class, (RosettaModelObjectBuilder)this.getValidationModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("correlationAndOptionalSequenceModel"), processor, CorrelationAndOptionalSequenceModel.CorrelationAndOptionalSequenceModelBuilder.class, (RosettaModelObjectBuilder)this.getCorrelationAndOptionalSequenceModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("onBehalfOfModel"), processor, OnBehalfOfModel.OnBehalfOfModelBuilder.class, (RosettaModelObjectBuilder)this.getOnBehalfOfModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("type"), processor, ApprovalType.ApprovalTypeBuilder.class, this._getType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approver"), processor, PersonId.PersonIdBuilder.class, this.getApprover(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("approvingPartyReference"), processor, PartyReference.PartyReferenceBuilder.class, this.getApprovingPartyReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("portfolioReferenceBaseModel"), processor, PortfolioReferenceBaseModel.PortfolioReferenceBaseModelBuilder.class, this.getPortfolioReferenceBaseModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventsOrInfoModel"), processor, EventsOrInfoModel.EventsOrInfoModelBuilder.class, this.getEventsOrInfoModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditLimitInformation"), processor, CreditLimitInformation.CreditLimitInformationBuilder.class, this.getCreditLimitInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partiesAndAccountsModel"), processor, PartiesAndAccountsModel.PartiesAndAccountsModelBuilder.class, this.getPartiesAndAccountsModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reason"), processor, Reason.ReasonBuilder.class, this.getReason(), new AttributeMeta[0]);
        }

        @Override
        public ConsentRefusedBuilder prune();
    }

    public static class ConsentRefusedImpl
    extends ResponseMessage.ResponseMessageImpl
    implements ConsentRefused {
        private final ApprovalType type;
        private final PersonId approver;
        private final PartyReference approvingPartyReference;
        private final PortfolioReferenceBaseModel portfolioReferenceBaseModel;
        private final EventsOrInfoModel eventsOrInfoModel;
        private final List<? extends CreditLimitInformation> creditLimitInformation;
        private final PartiesAndAccountsModel partiesAndAccountsModel;
        private final List<? extends Reason> reason;

        protected ConsentRefusedImpl(ConsentRefusedBuilder builder) {
            super(builder);
            this.type = Optional.ofNullable(builder._getType()).map(f -> f.build()).orElse(null);
            this.approver = Optional.ofNullable(builder.getApprover()).map(f -> f.build()).orElse(null);
            this.approvingPartyReference = Optional.ofNullable(builder.getApprovingPartyReference()).map(f -> f.build()).orElse(null);
            this.portfolioReferenceBaseModel = Optional.ofNullable(builder.getPortfolioReferenceBaseModel()).map(f -> f.build()).orElse(null);
            this.eventsOrInfoModel = Optional.ofNullable(builder.getEventsOrInfoModel()).map(f -> f.build()).orElse(null);
            this.creditLimitInformation = Optional.ofNullable(builder.getCreditLimitInformation()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partiesAndAccountsModel = Optional.ofNullable(builder.getPartiesAndAccountsModel()).map(f -> f.build()).orElse(null);
            this.reason = Optional.ofNullable(builder.getReason()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="type")
        @RuneAttribute(value="type")
        public ApprovalType _getType() {
            return this.type;
        }

        @Override
        @RosettaAttribute(value="approver")
        @RuneAttribute(value="approver")
        public PersonId getApprover() {
            return this.approver;
        }

        @Override
        @RosettaAttribute(value="approvingPartyReference")
        @RuneAttribute(value="approvingPartyReference")
        public PartyReference getApprovingPartyReference() {
            return this.approvingPartyReference;
        }

        @Override
        @RosettaAttribute(value="portfolioReferenceBaseModel")
        @RuneAttribute(value="portfolioReferenceBaseModel")
        public PortfolioReferenceBaseModel getPortfolioReferenceBaseModel() {
            return this.portfolioReferenceBaseModel;
        }

        @Override
        @RosettaAttribute(value="eventsOrInfoModel")
        @RuneAttribute(value="eventsOrInfoModel")
        public EventsOrInfoModel getEventsOrInfoModel() {
            return this.eventsOrInfoModel;
        }

        @Override
        @RosettaAttribute(value="creditLimitInformation")
        @RuneAttribute(value="creditLimitInformation")
        public List<? extends CreditLimitInformation> getCreditLimitInformation() {
            return this.creditLimitInformation;
        }

        @Override
        @RosettaAttribute(value="partiesAndAccountsModel")
        @RuneAttribute(value="partiesAndAccountsModel")
        public PartiesAndAccountsModel getPartiesAndAccountsModel() {
            return this.partiesAndAccountsModel;
        }

        @Override
        @RosettaAttribute(value="reason")
        @RuneAttribute(value="reason")
        public List<? extends Reason> getReason() {
            return this.reason;
        }

        @Override
        public ConsentRefused build() {
            return this;
        }

        @Override
        public ConsentRefusedBuilder toBuilder() {
            ConsentRefusedBuilder builder = ConsentRefused.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ConsentRefusedBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this._getType()).ifPresent(builder::setType);
            Optional.ofNullable(this.getApprover()).ifPresent(builder::setApprover);
            Optional.ofNullable(this.getApprovingPartyReference()).ifPresent(builder::setApprovingPartyReference);
            Optional.ofNullable(this.getPortfolioReferenceBaseModel()).ifPresent(builder::setPortfolioReferenceBaseModel);
            Optional.ofNullable(this.getEventsOrInfoModel()).ifPresent(builder::setEventsOrInfoModel);
            Optional.ofNullable(this.getCreditLimitInformation()).ifPresent(builder::setCreditLimitInformation);
            Optional.ofNullable(this.getPartiesAndAccountsModel()).ifPresent(builder::setPartiesAndAccountsModel);
            Optional.ofNullable(this.getReason()).ifPresent(builder::setReason);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ConsentRefused _that = (ConsentRefused)this.getType().cast(o);
            if (!Objects.equals(this.type, _that._getType())) {
                return false;
            }
            if (!Objects.equals(this.approver, _that.getApprover())) {
                return false;
            }
            if (!Objects.equals(this.approvingPartyReference, _that.getApprovingPartyReference())) {
                return false;
            }
            if (!Objects.equals(this.portfolioReferenceBaseModel, _that.getPortfolioReferenceBaseModel())) {
                return false;
            }
            if (!Objects.equals(this.eventsOrInfoModel, _that.getEventsOrInfoModel())) {
                return false;
            }
            if (!ListEquals.listEquals(this.creditLimitInformation, _that.getCreditLimitInformation())) {
                return false;
            }
            if (!Objects.equals(this.partiesAndAccountsModel, _that.getPartiesAndAccountsModel())) {
                return false;
            }
            return ListEquals.listEquals(this.reason, _that.getReason());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.type != null ? this.type.hashCode() : 0);
            _result = 31 * _result + (this.approver != null ? this.approver.hashCode() : 0);
            _result = 31 * _result + (this.approvingPartyReference != null ? this.approvingPartyReference.hashCode() : 0);
            _result = 31 * _result + (this.portfolioReferenceBaseModel != null ? this.portfolioReferenceBaseModel.hashCode() : 0);
            _result = 31 * _result + (this.eventsOrInfoModel != null ? this.eventsOrInfoModel.hashCode() : 0);
            _result = 31 * _result + (this.creditLimitInformation != null ? this.creditLimitInformation.hashCode() : 0);
            _result = 31 * _result + (this.partiesAndAccountsModel != null ? this.partiesAndAccountsModel.hashCode() : 0);
            _result = 31 * _result + (this.reason != null ? this.reason.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ConsentRefused {type=" + String.valueOf(this.type) + ", approver=" + String.valueOf(this.approver) + ", approvingPartyReference=" + String.valueOf(this.approvingPartyReference) + ", portfolioReferenceBaseModel=" + String.valueOf(this.portfolioReferenceBaseModel) + ", eventsOrInfoModel=" + String.valueOf(this.eventsOrInfoModel) + ", creditLimitInformation=" + String.valueOf(this.creditLimitInformation) + ", partiesAndAccountsModel=" + String.valueOf(this.partiesAndAccountsModel) + ", reason=" + String.valueOf(this.reason) + "} " + super.toString();
        }
    }
}

