/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.cd;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.cd.meta.InitialPaymentMeta;
import fpml.consolidated.shared.Money;
import fpml.consolidated.shared.PayerReceiverModel;
import fpml.consolidated.shared.PaymentBase;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="InitialPayment", builder=InitialPaymentBuilderImpl.class, version="1.2.2")
@RuneDataType(value="InitialPayment", model="fpml", builder=InitialPaymentBuilderImpl.class, version="1.2.2")
public interface InitialPayment
extends PaymentBase {
    public static final InitialPaymentMeta metaData = new InitialPaymentMeta();

    public PayerReceiverModel getPayerReceiverModel();

    public ZonedDateTime getAdjustablePaymentDate();

    public ZonedDateTime getAdjustedPaymentDate();

    public Money getPaymentAmount();

    @Override
    public InitialPayment build();

    @Override
    public InitialPaymentBuilder toBuilder();

    public static InitialPaymentBuilder builder() {
        return new InitialPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends InitialPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends InitialPayment> getType() {
        return InitialPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustablePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustablePaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.class, this.getPaymentAmount(), new AttributeMeta[0]);
    }

    public static class InitialPaymentBuilderImpl
    extends PaymentBase.PaymentBaseBuilderImpl
    implements InitialPaymentBuilder {
        protected PayerReceiverModel.PayerReceiverModelBuilder payerReceiverModel;
        protected ZonedDateTime adjustablePaymentDate;
        protected ZonedDateTime adjustedPaymentDate;
        protected Money.MoneyBuilder paymentAmount;

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel() {
            PayerReceiverModel.PayerReceiverModelBuilder result = this.payerReceiverModel != null ? this.payerReceiverModel : (this.payerReceiverModel = PayerReceiverModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="adjustablePaymentDate")
        @RuneAttribute(value="adjustablePaymentDate")
        public ZonedDateTime getAdjustablePaymentDate() {
            return this.adjustablePaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public Money.MoneyBuilder getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public Money.MoneyBuilder getOrCreatePaymentAmount() {
            Money.MoneyBuilder result = this.paymentAmount != null ? this.paymentAmount : (this.paymentAmount = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public InitialPaymentBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public InitialPaymentBuilder setPayerReceiverModel(PayerReceiverModel _payerReceiverModel) {
            this.payerReceiverModel = _payerReceiverModel == null ? null : _payerReceiverModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustablePaymentDate")
        @RuneAttribute(value="adjustablePaymentDate")
        public InitialPaymentBuilder setAdjustablePaymentDate(ZonedDateTime _adjustablePaymentDate) {
            this.adjustablePaymentDate = _adjustablePaymentDate == null ? null : _adjustablePaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public InitialPaymentBuilder setAdjustedPaymentDate(ZonedDateTime _adjustedPaymentDate) {
            this.adjustedPaymentDate = _adjustedPaymentDate == null ? null : _adjustedPaymentDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public InitialPaymentBuilder setPaymentAmount(Money _paymentAmount) {
            this.paymentAmount = _paymentAmount == null ? null : _paymentAmount.toBuilder();
            return this;
        }

        @Override
        public InitialPayment build() {
            return new InitialPaymentImpl(this);
        }

        @Override
        public InitialPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public InitialPaymentBuilder prune() {
            super.prune();
            if (this.payerReceiverModel != null && !this.payerReceiverModel.prune().hasData()) {
                this.payerReceiverModel = null;
            }
            if (this.paymentAmount != null && !this.paymentAmount.prune().hasData()) {
                this.paymentAmount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPayerReceiverModel() != null && this.getPayerReceiverModel().hasData()) {
                return true;
            }
            if (this.getAdjustablePaymentDate() != null) {
                return true;
            }
            if (this.getAdjustedPaymentDate() != null) {
                return true;
            }
            return this.getPaymentAmount() != null && this.getPaymentAmount().hasData();
        }

        @Override
        public InitialPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            InitialPaymentBuilder o = (InitialPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayerReceiverModel(), (RosettaModelObjectBuilder)o.getPayerReceiverModel(), this::setPayerReceiverModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPaymentAmount(), (RosettaModelObjectBuilder)o.getPaymentAmount(), this::setPaymentAmount);
            merger.mergeBasic((Object)this.getAdjustablePaymentDate(), (Object)o.getAdjustablePaymentDate(), this::setAdjustablePaymentDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAdjustedPaymentDate(), (Object)o.getAdjustedPaymentDate(), this::setAdjustedPaymentDate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InitialPayment _that = (InitialPayment)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.adjustablePaymentDate, _that.getAdjustablePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.adjustablePaymentDate != null ? this.adjustablePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InitialPaymentBuilder {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", adjustablePaymentDate=" + String.valueOf(this.adjustablePaymentDate) + ", adjustedPaymentDate=" + String.valueOf(this.adjustedPaymentDate) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + "} " + super.toString();
        }
    }

    public static interface InitialPaymentBuilder
    extends InitialPayment,
    PaymentBase.PaymentBaseBuilder {
        public PayerReceiverModel.PayerReceiverModelBuilder getOrCreatePayerReceiverModel();

        @Override
        public PayerReceiverModel.PayerReceiverModelBuilder getPayerReceiverModel();

        public Money.MoneyBuilder getOrCreatePaymentAmount();

        @Override
        public Money.MoneyBuilder getPaymentAmount();

        @Override
        public InitialPaymentBuilder setId(String var1);

        public InitialPaymentBuilder setPayerReceiverModel(PayerReceiverModel var1);

        public InitialPaymentBuilder setAdjustablePaymentDate(ZonedDateTime var1);

        public InitialPaymentBuilder setAdjustedPaymentDate(ZonedDateTime var1);

        public InitialPaymentBuilder setPaymentAmount(Money var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payerReceiverModel"), processor, PayerReceiverModel.PayerReceiverModelBuilder.class, this.getPayerReceiverModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustablePaymentDate"), ZonedDateTime.class, (Object)this.getAdjustablePaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("adjustedPaymentDate"), ZonedDateTime.class, (Object)this.getAdjustedPaymentDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("paymentAmount"), processor, Money.MoneyBuilder.class, this.getPaymentAmount(), new AttributeMeta[0]);
        }

        @Override
        public InitialPaymentBuilder prune();
    }

    public static class InitialPaymentImpl
    extends PaymentBase.PaymentBaseImpl
    implements InitialPayment {
        private final PayerReceiverModel payerReceiverModel;
        private final ZonedDateTime adjustablePaymentDate;
        private final ZonedDateTime adjustedPaymentDate;
        private final Money paymentAmount;

        protected InitialPaymentImpl(InitialPaymentBuilder builder) {
            super(builder);
            this.payerReceiverModel = Optional.ofNullable(builder.getPayerReceiverModel()).map(f -> f.build()).orElse(null);
            this.adjustablePaymentDate = builder.getAdjustablePaymentDate();
            this.adjustedPaymentDate = builder.getAdjustedPaymentDate();
            this.paymentAmount = Optional.ofNullable(builder.getPaymentAmount()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="payerReceiverModel", isRequired=true)
        @RuneAttribute(value="payerReceiverModel", isRequired=true)
        public PayerReceiverModel getPayerReceiverModel() {
            return this.payerReceiverModel;
        }

        @Override
        @RosettaAttribute(value="adjustablePaymentDate")
        @RuneAttribute(value="adjustablePaymentDate")
        public ZonedDateTime getAdjustablePaymentDate() {
            return this.adjustablePaymentDate;
        }

        @Override
        @RosettaAttribute(value="adjustedPaymentDate")
        @RuneAttribute(value="adjustedPaymentDate")
        public ZonedDateTime getAdjustedPaymentDate() {
            return this.adjustedPaymentDate;
        }

        @Override
        @RosettaAttribute(value="paymentAmount", isRequired=true)
        @RuneAttribute(value="paymentAmount", isRequired=true)
        public Money getPaymentAmount() {
            return this.paymentAmount;
        }

        @Override
        public InitialPayment build() {
            return this;
        }

        @Override
        public InitialPaymentBuilder toBuilder() {
            InitialPaymentBuilder builder = InitialPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(InitialPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPayerReceiverModel()).ifPresent(builder::setPayerReceiverModel);
            Optional.ofNullable(this.getAdjustablePaymentDate()).ifPresent(builder::setAdjustablePaymentDate);
            Optional.ofNullable(this.getAdjustedPaymentDate()).ifPresent(builder::setAdjustedPaymentDate);
            Optional.ofNullable(this.getPaymentAmount()).ifPresent(builder::setPaymentAmount);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InitialPayment _that = (InitialPayment)this.getType().cast(o);
            if (!Objects.equals(this.payerReceiverModel, _that.getPayerReceiverModel())) {
                return false;
            }
            if (!Objects.equals(this.adjustablePaymentDate, _that.getAdjustablePaymentDate())) {
                return false;
            }
            if (!Objects.equals(this.adjustedPaymentDate, _that.getAdjustedPaymentDate())) {
                return false;
            }
            return Objects.equals(this.paymentAmount, _that.getPaymentAmount());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.payerReceiverModel != null ? this.payerReceiverModel.hashCode() : 0);
            _result = 31 * _result + (this.adjustablePaymentDate != null ? this.adjustablePaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.adjustedPaymentDate != null ? this.adjustedPaymentDate.hashCode() : 0);
            _result = 31 * _result + (this.paymentAmount != null ? this.paymentAmount.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "InitialPayment {payerReceiverModel=" + String.valueOf(this.payerReceiverModel) + ", adjustablePaymentDate=" + String.valueOf(this.adjustablePaymentDate) + ", adjustedPaymentDate=" + String.valueOf(this.adjustedPaymentDate) + ", paymentAmount=" + String.valueOf(this.paymentAmount) + "} " + super.toString();
        }
    }
}

