/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import fpml.consolidated.business.events.CreditChangeEvent;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditChangeEventChoice")
@ImplementedBy(value=Default.class)
public interface CreditChangeEventChoice
extends Validator<CreditChangeEvent> {
    public static final String NAME = "CreditChangeEventChoice";
    public static final String DEFINITION = "optional choice indexReferenceInformation, excludedReferenceEntity";

    public static class NoOp
    implements CreditChangeEventChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditChangeEvent creditChangeEvent) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditChangeEventChoice {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditChangeEvent creditChangeEvent) {
            ComparisonResult result = this.executeDataRule(creditChangeEvent);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditChangeEventChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditChangeEvent", (RosettaPath)path, (String)CreditChangeEventChoice.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditChangeEventChoice.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditChangeEvent", (RosettaPath)path, (String)CreditChangeEventChoice.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditChangeEvent creditChangeEvent) {
            try {
                return ExpressionOperators.choice((Mapper)MapperS.of((Object)creditChangeEvent), Arrays.asList("indexReferenceInformation", "excludedReferenceEntity"), (ChoiceRuleValidationMethod)ChoiceRuleValidationMethod.OPTIONAL);
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

