/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.business.events;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.business.events.AgreementAndEffectiveDatesModel;
import fpml.consolidated.business.events.BusinessEventIdentifier;
import fpml.consolidated.business.events.EventType;
import fpml.consolidated.business.events.ReportingNotionalChangeModel;
import fpml.consolidated.business.events.meta.TradingEventSummaryMeta;
import fpml.consolidated.shared.NonNegativePayment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="TradingEventSummary", builder=TradingEventSummaryBuilderImpl.class, version="1.2.2")
@RuneDataType(value="TradingEventSummary", model="fpml", builder=TradingEventSummaryBuilderImpl.class, version="1.2.2")
public interface TradingEventSummary
extends RosettaModelObject {
    public static final TradingEventSummaryMeta metaData = new TradingEventSummaryMeta();

    public List<? extends BusinessEventIdentifier> getEventIdentifier();

    public EventType getEventType();

    public AgreementAndEffectiveDatesModel getAgreementAndEffectiveDatesModel();

    public ReportingNotionalChangeModel getReportingNotionalChangeModel();

    public NonNegativePayment getPayment();

    public TradingEventSummary build();

    public TradingEventSummaryBuilder toBuilder();

    public static TradingEventSummaryBuilder builder() {
        return new TradingEventSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends TradingEventSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends TradingEventSummary> getType() {
        return TradingEventSummary.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventType"), processor, EventType.class, this.getEventType(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.class, this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingNotionalChangeModel"), processor, ReportingNotionalChangeModel.class, this.getReportingNotionalChangeModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.class, this.getPayment(), new AttributeMeta[0]);
    }

    public static class TradingEventSummaryBuilderImpl
    implements TradingEventSummaryBuilder {
        protected List<BusinessEventIdentifier.BusinessEventIdentifierBuilder> eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
        protected EventType.EventTypeBuilder eventType;
        protected AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder agreementAndEffectiveDatesModel;
        protected ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder reportingNotionalChangeModel;
        protected NonNegativePayment.NonNegativePaymentBuilder payment;

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int index) {
            if (this.eventIdentifier == null) {
                this.eventIdentifier = new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>();
            }
            return (BusinessEventIdentifier.BusinessEventIdentifierBuilder)this.getIndex(this.eventIdentifier, index, () -> {
                BusinessEventIdentifier.BusinessEventIdentifierBuilder newEventIdentifier = BusinessEventIdentifier.builder();
                return newEventIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public EventType.EventTypeBuilder getEventType() {
            return this.eventType;
        }

        @Override
        public EventType.EventTypeBuilder getOrCreateEventType() {
            EventType.EventTypeBuilder result = this.eventType != null ? this.eventType : (this.eventType = EventType.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getAgreementAndEffectiveDatesModel() {
            return this.agreementAndEffectiveDatesModel;
        }

        @Override
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getOrCreateAgreementAndEffectiveDatesModel() {
            AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder result = this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel : (this.agreementAndEffectiveDatesModel = AgreementAndEffectiveDatesModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getReportingNotionalChangeModel() {
            return this.reportingNotionalChangeModel;
        }

        @Override
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getOrCreateReportingNotionalChangeModel() {
            ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder result = this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel : (this.reportingNotionalChangeModel = ReportingNotionalChangeModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public NonNegativePayment.NonNegativePaymentBuilder getPayment() {
            return this.payment;
        }

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment() {
            NonNegativePayment.NonNegativePaymentBuilder result = this.payment != null ? this.payment : (this.payment = NonNegativePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public TradingEventSummaryBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public TradingEventSummaryBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public TradingEventSummaryBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public TradingEventSummaryBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList<BusinessEventIdentifier.BusinessEventIdentifierBuilder>() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public TradingEventSummaryBuilder setEventType(EventType _eventType) {
            this.eventType = _eventType == null ? null : _eventType.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public TradingEventSummaryBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel _agreementAndEffectiveDatesModel) {
            this.agreementAndEffectiveDatesModel = _agreementAndEffectiveDatesModel == null ? null : _agreementAndEffectiveDatesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public TradingEventSummaryBuilder setReportingNotionalChangeModel(ReportingNotionalChangeModel _reportingNotionalChangeModel) {
            this.reportingNotionalChangeModel = _reportingNotionalChangeModel == null ? null : _reportingNotionalChangeModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public TradingEventSummaryBuilder setPayment(NonNegativePayment _payment) {
            this.payment = _payment == null ? null : _payment.toBuilder();
            return this;
        }

        @Override
        public TradingEventSummary build() {
            return new TradingEventSummaryImpl(this);
        }

        @Override
        public TradingEventSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public TradingEventSummaryBuilder prune() {
            this.eventIdentifier = this.eventIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.eventType != null && !this.eventType.prune().hasData()) {
                this.eventType = null;
            }
            if (this.agreementAndEffectiveDatesModel != null && !this.agreementAndEffectiveDatesModel.prune().hasData()) {
                this.agreementAndEffectiveDatesModel = null;
            }
            if (this.reportingNotionalChangeModel != null && !this.reportingNotionalChangeModel.prune().hasData()) {
                this.reportingNotionalChangeModel = null;
            }
            if (this.payment != null && !this.payment.prune().hasData()) {
                this.payment = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getEventIdentifier() != null && this.getEventIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getEventType() != null && this.getEventType().hasData()) {
                return true;
            }
            if (this.getAgreementAndEffectiveDatesModel() != null && this.getAgreementAndEffectiveDatesModel().hasData()) {
                return true;
            }
            if (this.getReportingNotionalChangeModel() != null && this.getReportingNotionalChangeModel().hasData()) {
                return true;
            }
            return this.getPayment() != null && this.getPayment().hasData();
        }

        public TradingEventSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            TradingEventSummaryBuilder o = (TradingEventSummaryBuilder)other;
            merger.mergeRosetta(this.getEventIdentifier(), o.getEventIdentifier(), this::getOrCreateEventIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEventType(), (RosettaModelObjectBuilder)o.getEventType(), this::setEventType);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAgreementAndEffectiveDatesModel(), (RosettaModelObjectBuilder)o.getAgreementAndEffectiveDatesModel(), this::setAgreementAndEffectiveDatesModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingNotionalChangeModel(), (RosettaModelObjectBuilder)o.getReportingNotionalChangeModel(), this::setReportingNotionalChangeModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPayment(), (RosettaModelObjectBuilder)o.getPayment(), this::setPayment);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradingEventSummary _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.agreementAndEffectiveDatesModel, _that.getAgreementAndEffectiveDatesModel())) {
                return false;
            }
            if (!Objects.equals(this.reportingNotionalChangeModel, _that.getReportingNotionalChangeModel())) {
                return false;
            }
            return Objects.equals(this.payment, _that.getPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradingEventSummaryBuilder {eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", eventType=" + String.valueOf(this.eventType) + ", agreementAndEffectiveDatesModel=" + String.valueOf(this.agreementAndEffectiveDatesModel) + ", reportingNotionalChangeModel=" + String.valueOf(this.reportingNotionalChangeModel) + ", payment=" + String.valueOf(this.payment) + "}";
        }
    }

    public static interface TradingEventSummaryBuilder
    extends TradingEventSummary,
    RosettaModelObjectBuilder {
        public BusinessEventIdentifier.BusinessEventIdentifierBuilder getOrCreateEventIdentifier(int var1);

        public List<? extends BusinessEventIdentifier.BusinessEventIdentifierBuilder> getEventIdentifier();

        public EventType.EventTypeBuilder getOrCreateEventType();

        @Override
        public EventType.EventTypeBuilder getEventType();

        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getOrCreateAgreementAndEffectiveDatesModel();

        @Override
        public AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder getAgreementAndEffectiveDatesModel();

        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getOrCreateReportingNotionalChangeModel();

        @Override
        public ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder getReportingNotionalChangeModel();

        public NonNegativePayment.NonNegativePaymentBuilder getOrCreatePayment();

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getPayment();

        public TradingEventSummaryBuilder addEventIdentifier(BusinessEventIdentifier var1);

        public TradingEventSummaryBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        public TradingEventSummaryBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public TradingEventSummaryBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public TradingEventSummaryBuilder setEventType(EventType var1);

        public TradingEventSummaryBuilder setAgreementAndEffectiveDatesModel(AgreementAndEffectiveDatesModel var1);

        public TradingEventSummaryBuilder setReportingNotionalChangeModel(ReportingNotionalChangeModel var1);

        public TradingEventSummaryBuilder setPayment(NonNegativePayment var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventType"), processor, EventType.EventTypeBuilder.class, this.getEventType(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("agreementAndEffectiveDatesModel"), processor, AgreementAndEffectiveDatesModel.AgreementAndEffectiveDatesModelBuilder.class, this.getAgreementAndEffectiveDatesModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingNotionalChangeModel"), processor, ReportingNotionalChangeModel.ReportingNotionalChangeModelBuilder.class, this.getReportingNotionalChangeModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payment"), processor, NonNegativePayment.NonNegativePaymentBuilder.class, this.getPayment(), new AttributeMeta[0]);
        }

        public TradingEventSummaryBuilder prune();
    }

    public static class TradingEventSummaryImpl
    implements TradingEventSummary {
        private final List<? extends BusinessEventIdentifier> eventIdentifier;
        private final EventType eventType;
        private final AgreementAndEffectiveDatesModel agreementAndEffectiveDatesModel;
        private final ReportingNotionalChangeModel reportingNotionalChangeModel;
        private final NonNegativePayment payment;

        protected TradingEventSummaryImpl(TradingEventSummaryBuilder builder) {
            this.eventIdentifier = Optional.ofNullable(builder.getEventIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.eventType = Optional.ofNullable(builder.getEventType()).map(f -> f.build()).orElse(null);
            this.agreementAndEffectiveDatesModel = Optional.ofNullable(builder.getAgreementAndEffectiveDatesModel()).map(f -> f.build()).orElse(null);
            this.reportingNotionalChangeModel = Optional.ofNullable(builder.getReportingNotionalChangeModel()).map(f -> f.build()).orElse(null);
            this.payment = Optional.ofNullable(builder.getPayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public List<? extends BusinessEventIdentifier> getEventIdentifier() {
            return this.eventIdentifier;
        }

        @Override
        @RosettaAttribute(value="eventType", isRequired=true)
        @RuneAttribute(value="eventType", isRequired=true)
        public EventType getEventType() {
            return this.eventType;
        }

        @Override
        @RosettaAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        @RuneAttribute(value="agreementAndEffectiveDatesModel", isRequired=true)
        public AgreementAndEffectiveDatesModel getAgreementAndEffectiveDatesModel() {
            return this.agreementAndEffectiveDatesModel;
        }

        @Override
        @RosettaAttribute(value="reportingNotionalChangeModel")
        @RuneAttribute(value="reportingNotionalChangeModel")
        public ReportingNotionalChangeModel getReportingNotionalChangeModel() {
            return this.reportingNotionalChangeModel;
        }

        @Override
        @RosettaAttribute(value="payment")
        @RuneAttribute(value="payment")
        public NonNegativePayment getPayment() {
            return this.payment;
        }

        @Override
        public TradingEventSummary build() {
            return this;
        }

        @Override
        public TradingEventSummaryBuilder toBuilder() {
            TradingEventSummaryBuilder builder = TradingEventSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(TradingEventSummaryBuilder builder) {
            Optional.ofNullable(this.getEventIdentifier()).ifPresent(builder::setEventIdentifier);
            Optional.ofNullable(this.getEventType()).ifPresent(builder::setEventType);
            Optional.ofNullable(this.getAgreementAndEffectiveDatesModel()).ifPresent(builder::setAgreementAndEffectiveDatesModel);
            Optional.ofNullable(this.getReportingNotionalChangeModel()).ifPresent(builder::setReportingNotionalChangeModel);
            Optional.ofNullable(this.getPayment()).ifPresent(builder::setPayment);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            TradingEventSummary _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.eventIdentifier, _that.getEventIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.eventType, _that.getEventType())) {
                return false;
            }
            if (!Objects.equals(this.agreementAndEffectiveDatesModel, _that.getAgreementAndEffectiveDatesModel())) {
                return false;
            }
            if (!Objects.equals(this.reportingNotionalChangeModel, _that.getReportingNotionalChangeModel())) {
                return false;
            }
            return Objects.equals(this.payment, _that.getPayment());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.eventIdentifier != null ? this.eventIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.eventType != null ? this.eventType.hashCode() : 0);
            _result = 31 * _result + (this.agreementAndEffectiveDatesModel != null ? this.agreementAndEffectiveDatesModel.hashCode() : 0);
            _result = 31 * _result + (this.reportingNotionalChangeModel != null ? this.reportingNotionalChangeModel.hashCode() : 0);
            _result = 31 * _result + (this.payment != null ? this.payment.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "TradingEventSummary {eventIdentifier=" + String.valueOf(this.eventIdentifier) + ", eventType=" + String.valueOf(this.eventType) + ", agreementAndEffectiveDatesModel=" + String.valueOf(this.agreementAndEffectiveDatesModel) + ", reportingNotionalChangeModel=" + String.valueOf(this.reportingNotionalChangeModel) + ", payment=" + String.valueOf(this.payment) + "}";
        }
    }
}

