/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.asset;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.consolidated.asset.ActualPrice;
import fpml.consolidated.asset.FxConversion;
import fpml.consolidated.asset.meta.EquityPriceModelMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="EquityPriceModel", builder=EquityPriceModelBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EquityPriceModel", model="fpml", builder=EquityPriceModelBuilderImpl.class, version="1.2.2")
public interface EquityPriceModel
extends RosettaModelObject {
    public static final EquityPriceModelMeta metaData = new EquityPriceModelMeta();

    public ActualPrice getGrossPrice();

    public ActualPrice getNetPrice();

    public BigDecimal getAccruedInterestPrice();

    public FxConversion getFxConversion();

    public EquityPriceModel build();

    public EquityPriceModelBuilder toBuilder();

    public static EquityPriceModelBuilder builder() {
        return new EquityPriceModelBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityPriceModel> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityPriceModel> getType() {
        return EquityPriceModel.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("grossPrice"), processor, ActualPrice.class, this.getGrossPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("netPrice"), processor, ActualPrice.class, this.getNetPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("accruedInterestPrice"), BigDecimal.class, (Object)this.getAccruedInterestPrice(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxConversion"), processor, FxConversion.class, this.getFxConversion(), new AttributeMeta[0]);
    }

    public static class EquityPriceModelBuilderImpl
    implements EquityPriceModelBuilder {
        protected ActualPrice.ActualPriceBuilder grossPrice;
        protected ActualPrice.ActualPriceBuilder netPrice;
        protected BigDecimal accruedInterestPrice;
        protected FxConversion.FxConversionBuilder fxConversion;

        @Override
        @RosettaAttribute(value="grossPrice")
        @RuneAttribute(value="grossPrice")
        public ActualPrice.ActualPriceBuilder getGrossPrice() {
            return this.grossPrice;
        }

        @Override
        public ActualPrice.ActualPriceBuilder getOrCreateGrossPrice() {
            ActualPrice.ActualPriceBuilder result = this.grossPrice != null ? this.grossPrice : (this.grossPrice = ActualPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="netPrice")
        @RuneAttribute(value="netPrice")
        public ActualPrice.ActualPriceBuilder getNetPrice() {
            return this.netPrice;
        }

        @Override
        public ActualPrice.ActualPriceBuilder getOrCreateNetPrice() {
            ActualPrice.ActualPriceBuilder result = this.netPrice != null ? this.netPrice : (this.netPrice = ActualPrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accruedInterestPrice")
        @RuneAttribute(value="accruedInterestPrice")
        public BigDecimal getAccruedInterestPrice() {
            return this.accruedInterestPrice;
        }

        @Override
        @RosettaAttribute(value="fxConversion")
        @RuneAttribute(value="fxConversion")
        public FxConversion.FxConversionBuilder getFxConversion() {
            return this.fxConversion;
        }

        @Override
        public FxConversion.FxConversionBuilder getOrCreateFxConversion() {
            FxConversion.FxConversionBuilder result = this.fxConversion != null ? this.fxConversion : (this.fxConversion = FxConversion.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="grossPrice")
        @RuneAttribute(value="grossPrice")
        public EquityPriceModelBuilder setGrossPrice(ActualPrice _grossPrice) {
            this.grossPrice = _grossPrice == null ? null : _grossPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="netPrice")
        @RuneAttribute(value="netPrice")
        public EquityPriceModelBuilder setNetPrice(ActualPrice _netPrice) {
            this.netPrice = _netPrice == null ? null : _netPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accruedInterestPrice")
        @RuneAttribute(value="accruedInterestPrice")
        public EquityPriceModelBuilder setAccruedInterestPrice(BigDecimal _accruedInterestPrice) {
            this.accruedInterestPrice = _accruedInterestPrice == null ? null : _accruedInterestPrice;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxConversion")
        @RuneAttribute(value="fxConversion")
        public EquityPriceModelBuilder setFxConversion(FxConversion _fxConversion) {
            this.fxConversion = _fxConversion == null ? null : _fxConversion.toBuilder();
            return this;
        }

        @Override
        public EquityPriceModel build() {
            return new EquityPriceModelImpl(this);
        }

        @Override
        public EquityPriceModelBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityPriceModelBuilder prune() {
            if (this.grossPrice != null && !this.grossPrice.prune().hasData()) {
                this.grossPrice = null;
            }
            if (this.netPrice != null && !this.netPrice.prune().hasData()) {
                this.netPrice = null;
            }
            if (this.fxConversion != null && !this.fxConversion.prune().hasData()) {
                this.fxConversion = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getGrossPrice() != null && this.getGrossPrice().hasData()) {
                return true;
            }
            if (this.getNetPrice() != null && this.getNetPrice().hasData()) {
                return true;
            }
            if (this.getAccruedInterestPrice() != null) {
                return true;
            }
            return this.getFxConversion() != null && this.getFxConversion().hasData();
        }

        public EquityPriceModelBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            EquityPriceModelBuilder o = (EquityPriceModelBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGrossPrice(), (RosettaModelObjectBuilder)o.getGrossPrice(), this::setGrossPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNetPrice(), (RosettaModelObjectBuilder)o.getNetPrice(), this::setNetPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxConversion(), (RosettaModelObjectBuilder)o.getFxConversion(), this::setFxConversion);
            merger.mergeBasic((Object)this.getAccruedInterestPrice(), (Object)o.getAccruedInterestPrice(), this::setAccruedInterestPrice, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityPriceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.grossPrice, _that.getGrossPrice())) {
                return false;
            }
            if (!Objects.equals(this.netPrice, _that.getNetPrice())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterestPrice, _that.getAccruedInterestPrice())) {
                return false;
            }
            return Objects.equals(this.fxConversion, _that.getFxConversion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.grossPrice != null ? this.grossPrice.hashCode() : 0);
            _result = 31 * _result + (this.netPrice != null ? this.netPrice.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterestPrice != null ? this.accruedInterestPrice.hashCode() : 0);
            _result = 31 * _result + (this.fxConversion != null ? this.fxConversion.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityPriceModelBuilder {grossPrice=" + String.valueOf(this.grossPrice) + ", netPrice=" + String.valueOf(this.netPrice) + ", accruedInterestPrice=" + String.valueOf(this.accruedInterestPrice) + ", fxConversion=" + String.valueOf(this.fxConversion) + "}";
        }
    }

    public static interface EquityPriceModelBuilder
    extends EquityPriceModel,
    RosettaModelObjectBuilder {
        public ActualPrice.ActualPriceBuilder getOrCreateGrossPrice();

        @Override
        public ActualPrice.ActualPriceBuilder getGrossPrice();

        public ActualPrice.ActualPriceBuilder getOrCreateNetPrice();

        @Override
        public ActualPrice.ActualPriceBuilder getNetPrice();

        public FxConversion.FxConversionBuilder getOrCreateFxConversion();

        @Override
        public FxConversion.FxConversionBuilder getFxConversion();

        public EquityPriceModelBuilder setGrossPrice(ActualPrice var1);

        public EquityPriceModelBuilder setNetPrice(ActualPrice var1);

        public EquityPriceModelBuilder setAccruedInterestPrice(BigDecimal var1);

        public EquityPriceModelBuilder setFxConversion(FxConversion var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("grossPrice"), processor, ActualPrice.ActualPriceBuilder.class, this.getGrossPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("netPrice"), processor, ActualPrice.ActualPriceBuilder.class, this.getNetPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("accruedInterestPrice"), BigDecimal.class, (Object)this.getAccruedInterestPrice(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxConversion"), processor, FxConversion.FxConversionBuilder.class, this.getFxConversion(), new AttributeMeta[0]);
        }

        public EquityPriceModelBuilder prune();
    }

    public static class EquityPriceModelImpl
    implements EquityPriceModel {
        private final ActualPrice grossPrice;
        private final ActualPrice netPrice;
        private final BigDecimal accruedInterestPrice;
        private final FxConversion fxConversion;

        protected EquityPriceModelImpl(EquityPriceModelBuilder builder) {
            this.grossPrice = Optional.ofNullable(builder.getGrossPrice()).map(f -> f.build()).orElse(null);
            this.netPrice = Optional.ofNullable(builder.getNetPrice()).map(f -> f.build()).orElse(null);
            this.accruedInterestPrice = builder.getAccruedInterestPrice();
            this.fxConversion = Optional.ofNullable(builder.getFxConversion()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="grossPrice")
        @RuneAttribute(value="grossPrice")
        public ActualPrice getGrossPrice() {
            return this.grossPrice;
        }

        @Override
        @RosettaAttribute(value="netPrice")
        @RuneAttribute(value="netPrice")
        public ActualPrice getNetPrice() {
            return this.netPrice;
        }

        @Override
        @RosettaAttribute(value="accruedInterestPrice")
        @RuneAttribute(value="accruedInterestPrice")
        public BigDecimal getAccruedInterestPrice() {
            return this.accruedInterestPrice;
        }

        @Override
        @RosettaAttribute(value="fxConversion")
        @RuneAttribute(value="fxConversion")
        public FxConversion getFxConversion() {
            return this.fxConversion;
        }

        @Override
        public EquityPriceModel build() {
            return this;
        }

        @Override
        public EquityPriceModelBuilder toBuilder() {
            EquityPriceModelBuilder builder = EquityPriceModel.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityPriceModelBuilder builder) {
            Optional.ofNullable(this.getGrossPrice()).ifPresent(builder::setGrossPrice);
            Optional.ofNullable(this.getNetPrice()).ifPresent(builder::setNetPrice);
            Optional.ofNullable(this.getAccruedInterestPrice()).ifPresent(builder::setAccruedInterestPrice);
            Optional.ofNullable(this.getFxConversion()).ifPresent(builder::setFxConversion);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            EquityPriceModel _that = this.getType().cast(o);
            if (!Objects.equals(this.grossPrice, _that.getGrossPrice())) {
                return false;
            }
            if (!Objects.equals(this.netPrice, _that.getNetPrice())) {
                return false;
            }
            if (!Objects.equals(this.accruedInterestPrice, _that.getAccruedInterestPrice())) {
                return false;
            }
            return Objects.equals(this.fxConversion, _that.getFxConversion());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.grossPrice != null ? this.grossPrice.hashCode() : 0);
            _result = 31 * _result + (this.netPrice != null ? this.netPrice.hashCode() : 0);
            _result = 31 * _result + (this.accruedInterestPrice != null ? this.accruedInterestPrice.hashCode() : 0);
            _result = 31 * _result + (this.fxConversion != null ? this.fxConversion.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "EquityPriceModel {grossPrice=" + String.valueOf(this.grossPrice) + ", netPrice=" + String.valueOf(this.netPrice) + ", accruedInterestPrice=" + String.valueOf(this.accruedInterestPrice) + ", fxConversion=" + String.valueOf(this.fxConversion) + "}";
        }
    }
}

