/*
 * Decompiled with CFR 0.152.
 */
package fpml.consolidated.accumulator;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.consolidated.accumulator.AccumulatorKnockOut;
import fpml.consolidated.accumulator.EquityForwardExpiration;
import fpml.consolidated.accumulator.Gearing;
import fpml.consolidated.accumulator.ObservationPeriod;
import fpml.consolidated.accumulator.meta.EquityAccumulatorMeta;
import fpml.consolidated.asset.Underlyer;
import fpml.consolidated.eqd.PrePayment;
import fpml.consolidated.fpmlenum.SettlementTypeEnum;
import fpml.consolidated.shared.BuyerSellerModel;
import fpml.consolidated.shared.Currency;
import fpml.consolidated.shared.NonNegativeMoney;
import fpml.consolidated.shared.Product;
import fpml.consolidated.shared.ProductModel;
import fpml.consolidated.shared.SettlementPriceSource;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="EquityAccumulator", builder=EquityAccumulatorBuilderImpl.class, version="1.2.2")
@RuneDataType(value="EquityAccumulator", model="fpml", builder=EquityAccumulatorBuilderImpl.class, version="1.2.2")
public interface EquityAccumulator
extends Product {
    public static final EquityAccumulatorMeta metaData = new EquityAccumulatorMeta();

    public BuyerSellerModel getBuyerSellerModel();

    public NonNegativeMoney getNotional();

    public Underlyer getUnderlyer();

    public NonNegativeMoney getForwardPrice();

    public NonNegativeMoney getSpotPrice();

    public BigDecimal getNumberOfSharesPerDay();

    public Integer getMaxNoOfTradingDays();

    public Gearing getGearing();

    public ZonedDateTime getGuaranteedPeriodEndDate();

    public List<? extends ObservationPeriod> getObservationPeriod();

    public EquityForwardExpiration getExpiration();

    public PrePayment getPrePayment();

    public SettlementTypeEnum getSettlementType();

    public Currency getSettlementCurrency();

    public SettlementPriceSource getSettlementPriceSource();

    public AccumulatorKnockOut getKnockOut();

    @Override
    public EquityAccumulator build();

    @Override
    public EquityAccumulatorBuilder toBuilder();

    public static EquityAccumulatorBuilder builder() {
        return new EquityAccumulatorBuilderImpl();
    }

    default public RosettaMetaData<? extends EquityAccumulator> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends EquityAccumulator> getType() {
        return EquityAccumulator.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.class, this.getNotional(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("forwardPrice"), processor, NonNegativeMoney.class, this.getForwardPrice(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("spotPrice"), processor, NonNegativeMoney.class, this.getSpotPrice(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberOfSharesPerDay"), BigDecimal.class, (Object)this.getNumberOfSharesPerDay(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("maxNoOfTradingDays"), Integer.class, (Object)this.getMaxNoOfTradingDays(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("gearing"), processor, Gearing.class, this.getGearing(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("guaranteedPeriodEndDate"), ZonedDateTime.class, (Object)this.getGuaranteedPeriodEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationPeriod"), processor, ObservationPeriod.class, this.getObservationPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expiration"), processor, EquityForwardExpiration.class, this.getExpiration(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("prePayment"), processor, PrePayment.class, this.getPrePayment(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.class, this.getSettlementCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("settlementPriceSource"), processor, SettlementPriceSource.class, this.getSettlementPriceSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("knockOut"), processor, AccumulatorKnockOut.class, this.getKnockOut(), new AttributeMeta[0]);
    }

    public static class EquityAccumulatorBuilderImpl
    extends Product.ProductBuilderImpl
    implements EquityAccumulatorBuilder {
        protected BuyerSellerModel.BuyerSellerModelBuilder buyerSellerModel;
        protected NonNegativeMoney.NonNegativeMoneyBuilder notional;
        protected Underlyer.UnderlyerBuilder underlyer;
        protected NonNegativeMoney.NonNegativeMoneyBuilder forwardPrice;
        protected NonNegativeMoney.NonNegativeMoneyBuilder spotPrice;
        protected BigDecimal numberOfSharesPerDay;
        protected Integer maxNoOfTradingDays;
        protected Gearing.GearingBuilder gearing;
        protected ZonedDateTime guaranteedPeriodEndDate;
        protected List<ObservationPeriod.ObservationPeriodBuilder> observationPeriod = new ArrayList<ObservationPeriod.ObservationPeriodBuilder>();
        protected EquityForwardExpiration.EquityForwardExpirationBuilder expiration;
        protected PrePayment.PrePaymentBuilder prePayment;
        protected SettlementTypeEnum settlementType;
        protected Currency.CurrencyBuilder settlementCurrency;
        protected SettlementPriceSource.SettlementPriceSourceBuilder settlementPriceSource;
        protected AccumulatorKnockOut.AccumulatorKnockOutBuilder knockOut;

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel() {
            BuyerSellerModel.BuyerSellerModelBuilder result = this.buyerSellerModel != null ? this.buyerSellerModel : (this.buyerSellerModel = BuyerSellerModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional() {
            return this.notional;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.notional != null ? this.notional : (this.notional = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public Underlyer.UnderlyerBuilder getUnderlyer() {
            return this.underlyer;
        }

        @Override
        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer() {
            Underlyer.UnderlyerBuilder result = this.underlyer != null ? this.underlyer : (this.underlyer = Underlyer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public NonNegativeMoney.NonNegativeMoneyBuilder getForwardPrice() {
            return this.forwardPrice;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateForwardPrice() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.forwardPrice != null ? this.forwardPrice : (this.forwardPrice = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public NonNegativeMoney.NonNegativeMoneyBuilder getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateSpotPrice() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.spotPrice != null ? this.spotPrice : (this.spotPrice = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="numberOfSharesPerDay", isRequired=true)
        @RuneAttribute(value="numberOfSharesPerDay", isRequired=true)
        public BigDecimal getNumberOfSharesPerDay() {
            return this.numberOfSharesPerDay;
        }

        @Override
        @RosettaAttribute(value="maxNoOfTradingDays")
        @RuneAttribute(value="maxNoOfTradingDays")
        public Integer getMaxNoOfTradingDays() {
            return this.maxNoOfTradingDays;
        }

        @Override
        @RosettaAttribute(value="gearing")
        @RuneAttribute(value="gearing")
        public Gearing.GearingBuilder getGearing() {
            return this.gearing;
        }

        @Override
        public Gearing.GearingBuilder getOrCreateGearing() {
            Gearing.GearingBuilder result = this.gearing != null ? this.gearing : (this.gearing = Gearing.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="guaranteedPeriodEndDate")
        @RuneAttribute(value="guaranteedPeriodEndDate")
        public ZonedDateTime getGuaranteedPeriodEndDate() {
            return this.guaranteedPeriodEndDate;
        }

        @Override
        @RosettaAttribute(value="observationPeriod", isRequired=true)
        @RuneAttribute(value="observationPeriod", isRequired=true)
        public List<? extends ObservationPeriod.ObservationPeriodBuilder> getObservationPeriod() {
            return this.observationPeriod;
        }

        @Override
        public ObservationPeriod.ObservationPeriodBuilder getOrCreateObservationPeriod(int index) {
            if (this.observationPeriod == null) {
                this.observationPeriod = new ArrayList<ObservationPeriod.ObservationPeriodBuilder>();
            }
            return (ObservationPeriod.ObservationPeriodBuilder)this.getIndex(this.observationPeriod, index, () -> {
                ObservationPeriod.ObservationPeriodBuilder newObservationPeriod = ObservationPeriod.builder();
                return newObservationPeriod;
            });
        }

        @Override
        @RosettaAttribute(value="expiration", isRequired=true)
        @RuneAttribute(value="expiration", isRequired=true)
        public EquityForwardExpiration.EquityForwardExpirationBuilder getExpiration() {
            return this.expiration;
        }

        @Override
        public EquityForwardExpiration.EquityForwardExpirationBuilder getOrCreateExpiration() {
            EquityForwardExpiration.EquityForwardExpirationBuilder result = this.expiration != null ? this.expiration : (this.expiration = EquityForwardExpiration.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public PrePayment.PrePaymentBuilder getPrePayment() {
            return this.prePayment;
        }

        @Override
        public PrePayment.PrePaymentBuilder getOrCreatePrePayment() {
            PrePayment.PrePaymentBuilder result = this.prePayment != null ? this.prePayment : (this.prePayment = PrePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementType", isRequired=true)
        @RuneAttribute(value="settlementType", isRequired=true)
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public Currency.CurrencyBuilder getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        public Currency.CurrencyBuilder getOrCreateSettlementCurrency() {
            Currency.CurrencyBuilder result = this.settlementCurrency != null ? this.settlementCurrency : (this.settlementCurrency = Currency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public SettlementPriceSource.SettlementPriceSourceBuilder getSettlementPriceSource() {
            return this.settlementPriceSource;
        }

        @Override
        public SettlementPriceSource.SettlementPriceSourceBuilder getOrCreateSettlementPriceSource() {
            SettlementPriceSource.SettlementPriceSourceBuilder result = this.settlementPriceSource != null ? this.settlementPriceSource : (this.settlementPriceSource = SettlementPriceSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public AccumulatorKnockOut.AccumulatorKnockOutBuilder getKnockOut() {
            return this.knockOut;
        }

        @Override
        public AccumulatorKnockOut.AccumulatorKnockOutBuilder getOrCreateKnockOut() {
            AccumulatorKnockOut.AccumulatorKnockOutBuilder result = this.knockOut != null ? this.knockOut : (this.knockOut = AccumulatorKnockOut.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public EquityAccumulatorBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public EquityAccumulatorBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public EquityAccumulatorBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public EquityAccumulatorBuilder setNotional(NonNegativeMoney _notional) {
            this.notional = _notional == null ? null : _notional.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public EquityAccumulatorBuilder setUnderlyer(Underlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public EquityAccumulatorBuilder setForwardPrice(NonNegativeMoney _forwardPrice) {
            this.forwardPrice = _forwardPrice == null ? null : _forwardPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public EquityAccumulatorBuilder setSpotPrice(NonNegativeMoney _spotPrice) {
            this.spotPrice = _spotPrice == null ? null : _spotPrice.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="numberOfSharesPerDay", isRequired=true)
        @RuneAttribute(value="numberOfSharesPerDay", isRequired=true)
        public EquityAccumulatorBuilder setNumberOfSharesPerDay(BigDecimal _numberOfSharesPerDay) {
            this.numberOfSharesPerDay = _numberOfSharesPerDay == null ? null : _numberOfSharesPerDay;
            return this;
        }

        @Override
        @RosettaAttribute(value="maxNoOfTradingDays")
        @RuneAttribute(value="maxNoOfTradingDays")
        public EquityAccumulatorBuilder setMaxNoOfTradingDays(Integer _maxNoOfTradingDays) {
            this.maxNoOfTradingDays = _maxNoOfTradingDays == null ? null : _maxNoOfTradingDays;
            return this;
        }

        @Override
        @RosettaAttribute(value="gearing")
        @RuneAttribute(value="gearing")
        public EquityAccumulatorBuilder setGearing(Gearing _gearing) {
            this.gearing = _gearing == null ? null : _gearing.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="guaranteedPeriodEndDate")
        @RuneAttribute(value="guaranteedPeriodEndDate")
        public EquityAccumulatorBuilder setGuaranteedPeriodEndDate(ZonedDateTime _guaranteedPeriodEndDate) {
            this.guaranteedPeriodEndDate = _guaranteedPeriodEndDate == null ? null : _guaranteedPeriodEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observationPeriod", isRequired=true)
        @RuneAttribute(value="observationPeriod", isRequired=true)
        public EquityAccumulatorBuilder addObservationPeriod(ObservationPeriod _observationPeriod) {
            if (_observationPeriod != null) {
                this.observationPeriod.add(_observationPeriod.toBuilder());
            }
            return this;
        }

        @Override
        public EquityAccumulatorBuilder addObservationPeriod(ObservationPeriod _observationPeriod, int idx) {
            this.getIndex(this.observationPeriod, idx, () -> _observationPeriod.toBuilder());
            return this;
        }

        @Override
        public EquityAccumulatorBuilder addObservationPeriod(List<? extends ObservationPeriod> observationPeriods) {
            if (observationPeriods != null) {
                for (ObservationPeriod observationPeriod : observationPeriods) {
                    this.observationPeriod.add(observationPeriod.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="observationPeriod")
        public EquityAccumulatorBuilder setObservationPeriod(List<? extends ObservationPeriod> observationPeriods) {
            this.observationPeriod = observationPeriods == null ? new ArrayList<ObservationPeriod.ObservationPeriodBuilder>() : (List)observationPeriods.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="expiration", isRequired=true)
        @RuneAttribute(value="expiration", isRequired=true)
        public EquityAccumulatorBuilder setExpiration(EquityForwardExpiration _expiration) {
            this.expiration = _expiration == null ? null : _expiration.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public EquityAccumulatorBuilder setPrePayment(PrePayment _prePayment) {
            this.prePayment = _prePayment == null ? null : _prePayment.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType", isRequired=true)
        @RuneAttribute(value="settlementType", isRequired=true)
        public EquityAccumulatorBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public EquityAccumulatorBuilder setSettlementCurrency(Currency _settlementCurrency) {
            this.settlementCurrency = _settlementCurrency == null ? null : _settlementCurrency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public EquityAccumulatorBuilder setSettlementPriceSource(SettlementPriceSource _settlementPriceSource) {
            this.settlementPriceSource = _settlementPriceSource == null ? null : _settlementPriceSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public EquityAccumulatorBuilder setKnockOut(AccumulatorKnockOut _knockOut) {
            this.knockOut = _knockOut == null ? null : _knockOut.toBuilder();
            return this;
        }

        @Override
        public EquityAccumulator build() {
            return new EquityAccumulatorImpl(this);
        }

        @Override
        public EquityAccumulatorBuilder toBuilder() {
            return this;
        }

        @Override
        public EquityAccumulatorBuilder prune() {
            super.prune();
            if (this.buyerSellerModel != null && !this.buyerSellerModel.prune().hasData()) {
                this.buyerSellerModel = null;
            }
            if (this.notional != null && !this.notional.prune().hasData()) {
                this.notional = null;
            }
            if (this.underlyer != null && !this.underlyer.prune().hasData()) {
                this.underlyer = null;
            }
            if (this.forwardPrice != null && !this.forwardPrice.prune().hasData()) {
                this.forwardPrice = null;
            }
            if (this.spotPrice != null && !this.spotPrice.prune().hasData()) {
                this.spotPrice = null;
            }
            if (this.gearing != null && !this.gearing.prune().hasData()) {
                this.gearing = null;
            }
            this.observationPeriod = this.observationPeriod.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.expiration != null && !this.expiration.prune().hasData()) {
                this.expiration = null;
            }
            if (this.prePayment != null && !this.prePayment.prune().hasData()) {
                this.prePayment = null;
            }
            if (this.settlementCurrency != null && !this.settlementCurrency.prune().hasData()) {
                this.settlementCurrency = null;
            }
            if (this.settlementPriceSource != null && !this.settlementPriceSource.prune().hasData()) {
                this.settlementPriceSource = null;
            }
            if (this.knockOut != null && !this.knockOut.prune().hasData()) {
                this.knockOut = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getBuyerSellerModel() != null && this.getBuyerSellerModel().hasData()) {
                return true;
            }
            if (this.getNotional() != null && this.getNotional().hasData()) {
                return true;
            }
            if (this.getUnderlyer() != null && this.getUnderlyer().hasData()) {
                return true;
            }
            if (this.getForwardPrice() != null && this.getForwardPrice().hasData()) {
                return true;
            }
            if (this.getSpotPrice() != null && this.getSpotPrice().hasData()) {
                return true;
            }
            if (this.getNumberOfSharesPerDay() != null) {
                return true;
            }
            if (this.getMaxNoOfTradingDays() != null) {
                return true;
            }
            if (this.getGearing() != null && this.getGearing().hasData()) {
                return true;
            }
            if (this.getGuaranteedPeriodEndDate() != null) {
                return true;
            }
            if (this.getObservationPeriod() != null && this.getObservationPeriod().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getExpiration() != null && this.getExpiration().hasData()) {
                return true;
            }
            if (this.getPrePayment() != null && this.getPrePayment().hasData()) {
                return true;
            }
            if (this.getSettlementType() != null) {
                return true;
            }
            if (this.getSettlementCurrency() != null && this.getSettlementCurrency().hasData()) {
                return true;
            }
            if (this.getSettlementPriceSource() != null && this.getSettlementPriceSource().hasData()) {
                return true;
            }
            return this.getKnockOut() != null && this.getKnockOut().hasData();
        }

        @Override
        public EquityAccumulatorBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            EquityAccumulatorBuilder o = (EquityAccumulatorBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getBuyerSellerModel(), (RosettaModelObjectBuilder)o.getBuyerSellerModel(), this::setBuyerSellerModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotional(), (RosettaModelObjectBuilder)o.getNotional(), this::setNotional);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUnderlyer(), (RosettaModelObjectBuilder)o.getUnderlyer(), this::setUnderlyer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getForwardPrice(), (RosettaModelObjectBuilder)o.getForwardPrice(), this::setForwardPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSpotPrice(), (RosettaModelObjectBuilder)o.getSpotPrice(), this::setSpotPrice);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getGearing(), (RosettaModelObjectBuilder)o.getGearing(), this::setGearing);
            merger.mergeRosetta(this.getObservationPeriod(), o.getObservationPeriod(), this::getOrCreateObservationPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpiration(), (RosettaModelObjectBuilder)o.getExpiration(), this::setExpiration);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPrePayment(), (RosettaModelObjectBuilder)o.getPrePayment(), this::setPrePayment);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementCurrency(), (RosettaModelObjectBuilder)o.getSettlementCurrency(), this::setSettlementCurrency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSettlementPriceSource(), (RosettaModelObjectBuilder)o.getSettlementPriceSource(), this::setSettlementPriceSource);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getKnockOut(), (RosettaModelObjectBuilder)o.getKnockOut(), this::setKnockOut);
            merger.mergeBasic((Object)this.getNumberOfSharesPerDay(), (Object)o.getNumberOfSharesPerDay(), this::setNumberOfSharesPerDay, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMaxNoOfTradingDays(), (Object)o.getMaxNoOfTradingDays(), this::setMaxNoOfTradingDays, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getGuaranteedPeriodEndDate(), (Object)o.getGuaranteedPeriodEndDate(), this::setGuaranteedPeriodEndDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSettlementType(), (Object)o.getSettlementType(), this::setSettlementType, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityAccumulator _that = (EquityAccumulator)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals(this.forwardPrice, _that.getForwardPrice())) {
                return false;
            }
            if (!Objects.equals(this.spotPrice, _that.getSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.numberOfSharesPerDay, _that.getNumberOfSharesPerDay())) {
                return false;
            }
            if (!Objects.equals(this.maxNoOfTradingDays, _that.getMaxNoOfTradingDays())) {
                return false;
            }
            if (!Objects.equals(this.gearing, _that.getGearing())) {
                return false;
            }
            if (!Objects.equals(this.guaranteedPeriodEndDate, _that.getGuaranteedPeriodEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observationPeriod, _that.getObservationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.expiration, _that.getExpiration())) {
                return false;
            }
            if (!Objects.equals(this.prePayment, _that.getPrePayment())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementPriceSource, _that.getSettlementPriceSource())) {
                return false;
            }
            return Objects.equals(this.knockOut, _that.getKnockOut());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.forwardPrice != null ? this.forwardPrice.hashCode() : 0);
            _result = 31 * _result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfSharesPerDay != null ? this.numberOfSharesPerDay.hashCode() : 0);
            _result = 31 * _result + (this.maxNoOfTradingDays != null ? this.maxNoOfTradingDays.hashCode() : 0);
            _result = 31 * _result + (this.gearing != null ? this.gearing.hashCode() : 0);
            _result = 31 * _result + (this.guaranteedPeriodEndDate != null ? this.guaranteedPeriodEndDate.hashCode() : 0);
            _result = 31 * _result + (this.observationPeriod != null ? this.observationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.expiration != null ? this.expiration.hashCode() : 0);
            _result = 31 * _result + (this.prePayment != null ? this.prePayment.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceSource != null ? this.settlementPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityAccumulatorBuilder {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", notional=" + String.valueOf(this.notional) + ", underlyer=" + String.valueOf(this.underlyer) + ", forwardPrice=" + String.valueOf(this.forwardPrice) + ", spotPrice=" + String.valueOf(this.spotPrice) + ", numberOfSharesPerDay=" + String.valueOf(this.numberOfSharesPerDay) + ", maxNoOfTradingDays=" + this.maxNoOfTradingDays + ", gearing=" + String.valueOf(this.gearing) + ", guaranteedPeriodEndDate=" + String.valueOf(this.guaranteedPeriodEndDate) + ", observationPeriod=" + String.valueOf(this.observationPeriod) + ", expiration=" + String.valueOf(this.expiration) + ", prePayment=" + String.valueOf(this.prePayment) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", settlementPriceSource=" + String.valueOf(this.settlementPriceSource) + ", knockOut=" + String.valueOf(this.knockOut) + "} " + super.toString();
        }
    }

    public static interface EquityAccumulatorBuilder
    extends EquityAccumulator,
    Product.ProductBuilder {
        public BuyerSellerModel.BuyerSellerModelBuilder getOrCreateBuyerSellerModel();

        @Override
        public BuyerSellerModel.BuyerSellerModelBuilder getBuyerSellerModel();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateNotional();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getNotional();

        public Underlyer.UnderlyerBuilder getOrCreateUnderlyer();

        @Override
        public Underlyer.UnderlyerBuilder getUnderlyer();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateForwardPrice();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getForwardPrice();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateSpotPrice();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getSpotPrice();

        public Gearing.GearingBuilder getOrCreateGearing();

        @Override
        public Gearing.GearingBuilder getGearing();

        public ObservationPeriod.ObservationPeriodBuilder getOrCreateObservationPeriod(int var1);

        public List<? extends ObservationPeriod.ObservationPeriodBuilder> getObservationPeriod();

        public EquityForwardExpiration.EquityForwardExpirationBuilder getOrCreateExpiration();

        @Override
        public EquityForwardExpiration.EquityForwardExpirationBuilder getExpiration();

        public PrePayment.PrePaymentBuilder getOrCreatePrePayment();

        @Override
        public PrePayment.PrePaymentBuilder getPrePayment();

        public Currency.CurrencyBuilder getOrCreateSettlementCurrency();

        @Override
        public Currency.CurrencyBuilder getSettlementCurrency();

        public SettlementPriceSource.SettlementPriceSourceBuilder getOrCreateSettlementPriceSource();

        @Override
        public SettlementPriceSource.SettlementPriceSourceBuilder getSettlementPriceSource();

        public AccumulatorKnockOut.AccumulatorKnockOutBuilder getOrCreateKnockOut();

        @Override
        public AccumulatorKnockOut.AccumulatorKnockOutBuilder getKnockOut();

        @Override
        public EquityAccumulatorBuilder setProductModel(ProductModel var1);

        @Override
        public EquityAccumulatorBuilder setId(String var1);

        public EquityAccumulatorBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public EquityAccumulatorBuilder setNotional(NonNegativeMoney var1);

        public EquityAccumulatorBuilder setUnderlyer(Underlyer var1);

        public EquityAccumulatorBuilder setForwardPrice(NonNegativeMoney var1);

        public EquityAccumulatorBuilder setSpotPrice(NonNegativeMoney var1);

        public EquityAccumulatorBuilder setNumberOfSharesPerDay(BigDecimal var1);

        public EquityAccumulatorBuilder setMaxNoOfTradingDays(Integer var1);

        public EquityAccumulatorBuilder setGearing(Gearing var1);

        public EquityAccumulatorBuilder setGuaranteedPeriodEndDate(ZonedDateTime var1);

        public EquityAccumulatorBuilder addObservationPeriod(ObservationPeriod var1);

        public EquityAccumulatorBuilder addObservationPeriod(ObservationPeriod var1, int var2);

        public EquityAccumulatorBuilder addObservationPeriod(List<? extends ObservationPeriod> var1);

        public EquityAccumulatorBuilder setObservationPeriod(List<? extends ObservationPeriod> var1);

        public EquityAccumulatorBuilder setExpiration(EquityForwardExpiration var1);

        public EquityAccumulatorBuilder setPrePayment(PrePayment var1);

        public EquityAccumulatorBuilder setSettlementType(SettlementTypeEnum var1);

        public EquityAccumulatorBuilder setSettlementCurrency(Currency var1);

        public EquityAccumulatorBuilder setSettlementPriceSource(SettlementPriceSource var1);

        public EquityAccumulatorBuilder setKnockOut(AccumulatorKnockOut var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notional"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getNotional(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, Underlyer.UnderlyerBuilder.class, this.getUnderlyer(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("forwardPrice"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getForwardPrice(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("spotPrice"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getSpotPrice(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberOfSharesPerDay"), BigDecimal.class, (Object)this.getNumberOfSharesPerDay(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("maxNoOfTradingDays"), Integer.class, (Object)this.getMaxNoOfTradingDays(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("gearing"), processor, Gearing.GearingBuilder.class, this.getGearing(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("guaranteedPeriodEndDate"), ZonedDateTime.class, (Object)this.getGuaranteedPeriodEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationPeriod"), processor, ObservationPeriod.ObservationPeriodBuilder.class, this.getObservationPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expiration"), processor, EquityForwardExpiration.EquityForwardExpirationBuilder.class, this.getExpiration(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("prePayment"), processor, PrePayment.PrePaymentBuilder.class, this.getPrePayment(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementCurrency"), processor, Currency.CurrencyBuilder.class, this.getSettlementCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("settlementPriceSource"), processor, SettlementPriceSource.SettlementPriceSourceBuilder.class, this.getSettlementPriceSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("knockOut"), processor, AccumulatorKnockOut.AccumulatorKnockOutBuilder.class, this.getKnockOut(), new AttributeMeta[0]);
        }

        @Override
        public EquityAccumulatorBuilder prune();
    }

    public static class EquityAccumulatorImpl
    extends Product.ProductImpl
    implements EquityAccumulator {
        private final BuyerSellerModel buyerSellerModel;
        private final NonNegativeMoney notional;
        private final Underlyer underlyer;
        private final NonNegativeMoney forwardPrice;
        private final NonNegativeMoney spotPrice;
        private final BigDecimal numberOfSharesPerDay;
        private final Integer maxNoOfTradingDays;
        private final Gearing gearing;
        private final ZonedDateTime guaranteedPeriodEndDate;
        private final List<? extends ObservationPeriod> observationPeriod;
        private final EquityForwardExpiration expiration;
        private final PrePayment prePayment;
        private final SettlementTypeEnum settlementType;
        private final Currency settlementCurrency;
        private final SettlementPriceSource settlementPriceSource;
        private final AccumulatorKnockOut knockOut;

        protected EquityAccumulatorImpl(EquityAccumulatorBuilder builder) {
            super(builder);
            this.buyerSellerModel = Optional.ofNullable(builder.getBuyerSellerModel()).map(f -> f.build()).orElse(null);
            this.notional = Optional.ofNullable(builder.getNotional()).map(f -> f.build()).orElse(null);
            this.underlyer = Optional.ofNullable(builder.getUnderlyer()).map(f -> f.build()).orElse(null);
            this.forwardPrice = Optional.ofNullable(builder.getForwardPrice()).map(f -> f.build()).orElse(null);
            this.spotPrice = Optional.ofNullable(builder.getSpotPrice()).map(f -> f.build()).orElse(null);
            this.numberOfSharesPerDay = builder.getNumberOfSharesPerDay();
            this.maxNoOfTradingDays = builder.getMaxNoOfTradingDays();
            this.gearing = Optional.ofNullable(builder.getGearing()).map(f -> f.build()).orElse(null);
            this.guaranteedPeriodEndDate = builder.getGuaranteedPeriodEndDate();
            this.observationPeriod = Optional.ofNullable(builder.getObservationPeriod()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.expiration = Optional.ofNullable(builder.getExpiration()).map(f -> f.build()).orElse(null);
            this.prePayment = Optional.ofNullable(builder.getPrePayment()).map(f -> f.build()).orElse(null);
            this.settlementType = builder.getSettlementType();
            this.settlementCurrency = Optional.ofNullable(builder.getSettlementCurrency()).map(f -> f.build()).orElse(null);
            this.settlementPriceSource = Optional.ofNullable(builder.getSettlementPriceSource()).map(f -> f.build()).orElse(null);
            this.knockOut = Optional.ofNullable(builder.getKnockOut()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public BuyerSellerModel getBuyerSellerModel() {
            return this.buyerSellerModel;
        }

        @Override
        @RosettaAttribute(value="notional", isRequired=true)
        @RuneAttribute(value="notional", isRequired=true)
        public NonNegativeMoney getNotional() {
            return this.notional;
        }

        @Override
        @RosettaAttribute(value="underlyer", isRequired=true)
        @RuneAttribute(value="underlyer", isRequired=true)
        public Underlyer getUnderlyer() {
            return this.underlyer;
        }

        @Override
        @RosettaAttribute(value="forwardPrice")
        @RuneAttribute(value="forwardPrice")
        public NonNegativeMoney getForwardPrice() {
            return this.forwardPrice;
        }

        @Override
        @RosettaAttribute(value="spotPrice")
        @RuneAttribute(value="spotPrice")
        public NonNegativeMoney getSpotPrice() {
            return this.spotPrice;
        }

        @Override
        @RosettaAttribute(value="numberOfSharesPerDay", isRequired=true)
        @RuneAttribute(value="numberOfSharesPerDay", isRequired=true)
        public BigDecimal getNumberOfSharesPerDay() {
            return this.numberOfSharesPerDay;
        }

        @Override
        @RosettaAttribute(value="maxNoOfTradingDays")
        @RuneAttribute(value="maxNoOfTradingDays")
        public Integer getMaxNoOfTradingDays() {
            return this.maxNoOfTradingDays;
        }

        @Override
        @RosettaAttribute(value="gearing")
        @RuneAttribute(value="gearing")
        public Gearing getGearing() {
            return this.gearing;
        }

        @Override
        @RosettaAttribute(value="guaranteedPeriodEndDate")
        @RuneAttribute(value="guaranteedPeriodEndDate")
        public ZonedDateTime getGuaranteedPeriodEndDate() {
            return this.guaranteedPeriodEndDate;
        }

        @Override
        @RosettaAttribute(value="observationPeriod", isRequired=true)
        @RuneAttribute(value="observationPeriod", isRequired=true)
        public List<? extends ObservationPeriod> getObservationPeriod() {
            return this.observationPeriod;
        }

        @Override
        @RosettaAttribute(value="expiration", isRequired=true)
        @RuneAttribute(value="expiration", isRequired=true)
        public EquityForwardExpiration getExpiration() {
            return this.expiration;
        }

        @Override
        @RosettaAttribute(value="prePayment")
        @RuneAttribute(value="prePayment")
        public PrePayment getPrePayment() {
            return this.prePayment;
        }

        @Override
        @RosettaAttribute(value="settlementType", isRequired=true)
        @RuneAttribute(value="settlementType", isRequired=true)
        public SettlementTypeEnum getSettlementType() {
            return this.settlementType;
        }

        @Override
        @RosettaAttribute(value="settlementCurrency")
        @RuneAttribute(value="settlementCurrency")
        public Currency getSettlementCurrency() {
            return this.settlementCurrency;
        }

        @Override
        @RosettaAttribute(value="settlementPriceSource")
        @RuneAttribute(value="settlementPriceSource")
        public SettlementPriceSource getSettlementPriceSource() {
            return this.settlementPriceSource;
        }

        @Override
        @RosettaAttribute(value="knockOut")
        @RuneAttribute(value="knockOut")
        public AccumulatorKnockOut getKnockOut() {
            return this.knockOut;
        }

        @Override
        public EquityAccumulator build() {
            return this;
        }

        @Override
        public EquityAccumulatorBuilder toBuilder() {
            EquityAccumulatorBuilder builder = EquityAccumulator.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(EquityAccumulatorBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getBuyerSellerModel()).ifPresent(builder::setBuyerSellerModel);
            Optional.ofNullable(this.getNotional()).ifPresent(builder::setNotional);
            Optional.ofNullable(this.getUnderlyer()).ifPresent(builder::setUnderlyer);
            Optional.ofNullable(this.getForwardPrice()).ifPresent(builder::setForwardPrice);
            Optional.ofNullable(this.getSpotPrice()).ifPresent(builder::setSpotPrice);
            Optional.ofNullable(this.getNumberOfSharesPerDay()).ifPresent(builder::setNumberOfSharesPerDay);
            Optional.ofNullable(this.getMaxNoOfTradingDays()).ifPresent(builder::setMaxNoOfTradingDays);
            Optional.ofNullable(this.getGearing()).ifPresent(builder::setGearing);
            Optional.ofNullable(this.getGuaranteedPeriodEndDate()).ifPresent(builder::setGuaranteedPeriodEndDate);
            Optional.ofNullable(this.getObservationPeriod()).ifPresent(builder::setObservationPeriod);
            Optional.ofNullable(this.getExpiration()).ifPresent(builder::setExpiration);
            Optional.ofNullable(this.getPrePayment()).ifPresent(builder::setPrePayment);
            Optional.ofNullable(this.getSettlementType()).ifPresent(builder::setSettlementType);
            Optional.ofNullable(this.getSettlementCurrency()).ifPresent(builder::setSettlementCurrency);
            Optional.ofNullable(this.getSettlementPriceSource()).ifPresent(builder::setSettlementPriceSource);
            Optional.ofNullable(this.getKnockOut()).ifPresent(builder::setKnockOut);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            EquityAccumulator _that = (EquityAccumulator)this.getType().cast(o);
            if (!Objects.equals(this.buyerSellerModel, _that.getBuyerSellerModel())) {
                return false;
            }
            if (!Objects.equals(this.notional, _that.getNotional())) {
                return false;
            }
            if (!Objects.equals(this.underlyer, _that.getUnderlyer())) {
                return false;
            }
            if (!Objects.equals(this.forwardPrice, _that.getForwardPrice())) {
                return false;
            }
            if (!Objects.equals(this.spotPrice, _that.getSpotPrice())) {
                return false;
            }
            if (!Objects.equals(this.numberOfSharesPerDay, _that.getNumberOfSharesPerDay())) {
                return false;
            }
            if (!Objects.equals(this.maxNoOfTradingDays, _that.getMaxNoOfTradingDays())) {
                return false;
            }
            if (!Objects.equals(this.gearing, _that.getGearing())) {
                return false;
            }
            if (!Objects.equals(this.guaranteedPeriodEndDate, _that.getGuaranteedPeriodEndDate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.observationPeriod, _that.getObservationPeriod())) {
                return false;
            }
            if (!Objects.equals(this.expiration, _that.getExpiration())) {
                return false;
            }
            if (!Objects.equals(this.prePayment, _that.getPrePayment())) {
                return false;
            }
            if (!Objects.equals((Object)this.settlementType, (Object)_that.getSettlementType())) {
                return false;
            }
            if (!Objects.equals(this.settlementCurrency, _that.getSettlementCurrency())) {
                return false;
            }
            if (!Objects.equals(this.settlementPriceSource, _that.getSettlementPriceSource())) {
                return false;
            }
            return Objects.equals(this.knockOut, _that.getKnockOut());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.buyerSellerModel != null ? this.buyerSellerModel.hashCode() : 0);
            _result = 31 * _result + (this.notional != null ? this.notional.hashCode() : 0);
            _result = 31 * _result + (this.underlyer != null ? this.underlyer.hashCode() : 0);
            _result = 31 * _result + (this.forwardPrice != null ? this.forwardPrice.hashCode() : 0);
            _result = 31 * _result + (this.spotPrice != null ? this.spotPrice.hashCode() : 0);
            _result = 31 * _result + (this.numberOfSharesPerDay != null ? this.numberOfSharesPerDay.hashCode() : 0);
            _result = 31 * _result + (this.maxNoOfTradingDays != null ? this.maxNoOfTradingDays.hashCode() : 0);
            _result = 31 * _result + (this.gearing != null ? this.gearing.hashCode() : 0);
            _result = 31 * _result + (this.guaranteedPeriodEndDate != null ? this.guaranteedPeriodEndDate.hashCode() : 0);
            _result = 31 * _result + (this.observationPeriod != null ? this.observationPeriod.hashCode() : 0);
            _result = 31 * _result + (this.expiration != null ? this.expiration.hashCode() : 0);
            _result = 31 * _result + (this.prePayment != null ? this.prePayment.hashCode() : 0);
            _result = 31 * _result + (this.settlementType != null ? ((Object)((Object)this.settlementType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.settlementCurrency != null ? this.settlementCurrency.hashCode() : 0);
            _result = 31 * _result + (this.settlementPriceSource != null ? this.settlementPriceSource.hashCode() : 0);
            _result = 31 * _result + (this.knockOut != null ? this.knockOut.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "EquityAccumulator {buyerSellerModel=" + String.valueOf(this.buyerSellerModel) + ", notional=" + String.valueOf(this.notional) + ", underlyer=" + String.valueOf(this.underlyer) + ", forwardPrice=" + String.valueOf(this.forwardPrice) + ", spotPrice=" + String.valueOf(this.spotPrice) + ", numberOfSharesPerDay=" + String.valueOf(this.numberOfSharesPerDay) + ", maxNoOfTradingDays=" + this.maxNoOfTradingDays + ", gearing=" + String.valueOf(this.gearing) + ", guaranteedPeriodEndDate=" + String.valueOf(this.guaranteedPeriodEndDate) + ", observationPeriod=" + String.valueOf(this.observationPeriod) + ", expiration=" + String.valueOf(this.expiration) + ", prePayment=" + String.valueOf(this.prePayment) + ", settlementType=" + String.valueOf((Object)this.settlementType) + ", settlementCurrency=" + String.valueOf(this.settlementCurrency) + ", settlementPriceSource=" + String.valueOf(this.settlementPriceSource) + ", knockOut=" + String.valueOf(this.knockOut) + "} " + super.toString();
        }
    }
}

