/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import java.util.List;
import java.util.stream.Collectors;

public interface Validator<T> {
    default public List<ValidationResult<?>> getValidationResults(RosettaPath path, T objectToBeValidated) {
        return Lists.newArrayList((Object[])new ValidationResult[]{this.validate(path, (RosettaModelObject)objectToBeValidated)});
    }

    @Deprecated
    default public ValidationResult<T> validate(RosettaPath path, T objectToBeValidated) {
        List<ValidationResult<?>> results = this.getValidationResults(path, objectToBeValidated);
        if (results.isEmpty()) {
            return ValidationResult.success(null, null, null, path, null);
        }
        ValidationResult<?> first = results.get(0);
        if (results.size() == 1) {
            return first;
        }
        String error = results.stream().filter(res -> res.getFailureReason().isPresent()).map(res -> res.getFailureReason().get()).collect(Collectors.joining("; "));
        if (!Strings.isNullOrEmpty((String)error)) {
            return ValidationResult.failure(first.getName(), first.getValidationType(), first.getModelObjectName(), path, first.getDefinition(), error);
        }
        return ValidationResult.success(first.getName(), first.getValidationType(), first.getModelObjectName(), path, first.getDefinition());
    }

    @Deprecated
    default public List<ValidationResult<?>> getValidationResults(RosettaPath path, RosettaModelObject objectToBeValidated) {
        return this.getValidationResults(path, (T)objectToBeValidated);
    }

    @Deprecated
    default public ValidationResult<T> validate(RosettaPath path, RosettaModelObject objectToBeValidated) {
        return this.validate(path, (T)objectToBeValidated);
    }
}

