/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.validation;

import com.rosetta.model.lib.path.RosettaPath;
import java.util.Optional;
import java.util.function.Function;

public interface ValidationResult<T> {
    public boolean isSuccess();

    public String getModelObjectName();

    public String getName();

    public ValidationType getValidationType();

    public String getDefinition();

    public Optional<String> getFailureReason();

    public RosettaPath getPath();

    public static <T> ValidationResult<T> success(String name, ValidationType validationType, String modelObjectName, RosettaPath path, String definition) {
        return new ModelValidationResult(name, validationType, modelObjectName, path, definition, Optional.empty());
    }

    public static <T> ValidationResult<T> failure(String name, ValidationType validationType, String modelObjectName, RosettaPath path, String definition, String failureMessage) {
        return new ModelValidationResult(name, validationType, modelObjectName, path, definition, Optional.of(failureMessage));
    }

    public static class ModelValidationResult<T>
    implements ValidationResult<T> {
        private final String modelObjectName;
        private final String name;
        private final String definition;
        private final Optional<String> failureReason;
        private final ValidationType validationType;
        private final RosettaPath path;

        public ModelValidationResult(String name, ValidationType validationType, String modelObjectName, RosettaPath path, String definition, Optional<String> failureReason) {
            this.name = name;
            this.validationType = validationType;
            this.path = path;
            this.modelObjectName = modelObjectName;
            this.definition = definition;
            this.failureReason = failureReason;
        }

        @Override
        public boolean isSuccess() {
            return !this.failureReason.isPresent();
        }

        @Override
        public String getModelObjectName() {
            return this.modelObjectName;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public RosettaPath getPath() {
            return this.path;
        }

        @Override
        public String getDefinition() {
            return this.definition;
        }

        @Override
        public Optional<String> getFailureReason() {
            if (this.failureReason.isPresent() && this.modelObjectName.endsWith("Report") && ValidationType.DATA_RULE.equals((Object)this.validationType)) {
                return this.getUpdatedFailureReason();
            }
            return this.failureReason;
        }

        @Override
        public ValidationType getValidationType() {
            return this.validationType;
        }

        public String toString() {
            return String.format("Validation %s on [%s] for [%s] [%s] %s", new Object[]{this.isSuccess() ? "SUCCESS" : "FAILURE", this.path.buildPath(), this.validationType, this.name, this.failureReason.map(s -> "because [" + s + "]").orElse("")});
        }

        private Optional<String> getUpdatedFailureReason() {
            String conditionName = this.name.replaceFirst(this.modelObjectName, "");
            String failReason = this.failureReason.get();
            failReason = failReason.replaceAll(this.modelObjectName, "");
            failReason = failReason.replaceAll("->get", " ");
            failReason = failReason.replaceAll("[^\\w-]+", " ");
            failReason = failReason.replaceAll("^\\s+", "");
            return Optional.of(conditionName + ":- " + failReason);
        }
    }

    public static enum ValidationType {
        DATA_RULE,
        CARDINALITY,
        TYPE_FORMAT,
        KEY,
        ONLY_EXISTS,
        PRE_PROCESS_EXCEPTION,
        POST_PROCESS_EXCEPTION;

    }

    public static class ProcessValidationResult<T>
    implements ValidationResult<T> {
        private String message;
        private String modelObjectName;
        private String processorName;
        private RosettaPath path;

        public ProcessValidationResult(String message, String modelObjectName, String processorName, RosettaPath path) {
            this.message = message;
            this.modelObjectName = modelObjectName;
            this.processorName = processorName;
            this.path = path;
        }

        @Override
        public boolean isSuccess() {
            return false;
        }

        @Override
        public String getModelObjectName() {
            return this.modelObjectName;
        }

        @Override
        public String getName() {
            return this.processorName;
        }

        @Override
        public ValidationType getValidationType() {
            return ValidationType.POST_PROCESS_EXCEPTION;
        }

        @Override
        public String getDefinition() {
            return "";
        }

        @Override
        public Optional<String> getFailureReason() {
            return Optional.of(this.message);
        }

        @Override
        public RosettaPath getPath() {
            return this.path;
        }
    }

    @Deprecated
    public static enum ChoiceRuleValidationMethod {
        OPTIONAL("Zero or one field must be set", fieldCount -> fieldCount == 1 || fieldCount == 0),
        REQUIRED("One and only one field must be set", fieldCount -> fieldCount == 1);

        private final String desc;
        private final Function<Integer, Boolean> check;

        private ChoiceRuleValidationMethod(String desc, Function<Integer, Boolean> check) {
            this.desc = desc;
            this.check = check;
        }

        public boolean check(int fields) {
            return this.check.apply(fields);
        }

        public String getDescription() {
            return this.desc;
        }
    }
}

