/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.records;

import com.rosetta.model.lib.records.DateImpl;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;

public interface Date
extends Comparable<Date> {
    public int getDay();

    public int getMonth();

    public int getYear();

    public LocalDate toLocalDate();

    public static Date of(int year, int month, int dayOfMonth) {
        return new DateImpl(year, month, dayOfMonth);
    }

    public static Date of(LocalDate localDate) {
        return Date.of(localDate.getYear(), localDate.getMonthValue(), localDate.getDayOfMonth());
    }

    public static Date parse(String text) {
        return Date.of(LocalDate.parse(text));
    }

    public static LocalDateTime of(Date date, LocalTime time) {
        return LocalDateTime.of(date.toLocalDate(), time);
    }
}

