/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.function.Function;

public class Converter {
    private static final Table<Class<?>, Class<?>, Function<?, ?>> convertors = HashBasedTable.create();

    private static <A, B> void insert(Class<A> a, Class<B> b, Function<A, B> func) {
        convertors.put(a, b, func);
    }

    public static <C, A> C convert(Class<C> clazz, A t) {
        if (t == null) {
            return null;
        }
        Class<?> classa = t.getClass();
        if (classa.equals(clazz)) {
            return (C)t;
        }
        Function func = (Function)convertors.get(classa, clazz);
        if (func != null) {
            return (C)func.apply(t);
        }
        return null;
    }

    static {
        Converter.insert(String.class, Double.class, s -> Double.valueOf(s));
        Converter.insert(String.class, Float.class, s -> Float.valueOf(s));
        Converter.insert(String.class, Integer.class, s -> Integer.valueOf(s));
        Converter.insert(String.class, LocalTime.class, s -> LocalTime.parse(s));
        Converter.insert(String.class, LocalDate.class, s -> LocalDate.parse(s));
        Converter.insert(String.class, LocalDateTime.class, s -> LocalDateTime.parse(s));
        Converter.insert(String.class, ZonedDateTime.class, s -> ZonedDateTime.parse(s));
        Converter.insert(String.class, BigDecimal.class, s -> new BigDecimal((String)s));
        Converter.insert(String.class, Boolean.class, s -> Boolean.valueOf(s));
        Converter.insert(Double.class, String.class, d -> Double.toString(d));
        Converter.insert(Double.class, Float.class, d -> Float.valueOf(d.floatValue()));
        Converter.insert(Double.class, Integer.class, d -> d.intValue());
        Converter.insert(Double.class, BigDecimal.class, d -> new BigDecimal((double)d));
        Converter.insert(Float.class, String.class, f -> Float.toString(f.floatValue()));
        Converter.insert(Float.class, Double.class, f -> f.doubleValue());
        Converter.insert(Float.class, Integer.class, f -> f.intValue());
        Converter.insert(Float.class, BigDecimal.class, f -> new BigDecimal(f.floatValue()));
        Converter.insert(Integer.class, String.class, i -> Integer.toString(i));
        Converter.insert(Integer.class, Double.class, i -> i.doubleValue());
        Converter.insert(Integer.class, Float.class, i -> Float.valueOf(i.floatValue()));
        Converter.insert(Integer.class, BigDecimal.class, i -> new BigDecimal((int)i));
        Converter.insert(LocalTime.class, String.class, lt -> lt.toString());
        Converter.insert(LocalDate.class, String.class, ld -> ld.toString());
        Converter.insert(LocalDate.class, LocalDateTime.class, ld -> ld.atStartOfDay());
        Converter.insert(LocalDateTime.class, String.class, ldt -> ldt.toString());
        Converter.insert(LocalDateTime.class, LocalTime.class, ldt -> ldt.toLocalTime());
        Converter.insert(LocalDateTime.class, LocalDate.class, ldt -> ldt.toLocalDate());
        Converter.insert(ZonedDateTime.class, String.class, ldt -> ldt.toString());
        Converter.insert(BigDecimal.class, String.class, bd -> bd.toString());
        Converter.insert(BigDecimal.class, Double.class, bd -> bd.doubleValue());
        Converter.insert(BigDecimal.class, Float.class, bd -> Float.valueOf(bd.floatValue()));
        Converter.insert(BigDecimal.class, Integer.class, bd -> bd.intValue());
        Converter.insert(Boolean.class, String.class, b -> Boolean.toString(b));
    }
}

