/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

public interface RosettaModelObjectBuilder
extends RosettaModelObject {
    public <B extends RosettaModelObjectBuilder> B prune();

    public void process(RosettaPath var1, BuilderProcessor var2);

    default public <R extends RosettaModelObjectBuilder> void processRosetta(RosettaPath path, BuilderProcessor processor, Class<R> clazz, R child, AttributeMeta ... metas) {
        boolean processFurther = processor.processRosetta(path, clazz, child, this, metas);
        if (child != null && processFurther) {
            child.process(path, processor);
        }
    }

    default public <R extends RosettaModelObjectBuilder> void processRosetta(RosettaPath path, BuilderProcessor processor, Class<R> clazz, List<? extends R> children, AttributeMeta ... metas) {
        processor.processRosetta(path, clazz, children, this, metas);
        if (children != null) {
            int index = 0;
            ArrayList<R> copy = new ArrayList<R>(children);
            for (RosettaModelObjectBuilder child : copy) {
                if (child == null) continue;
                RosettaPath indexedPath = path.withIndex(index);
                child.process(indexedPath, processor);
                ++index;
            }
        }
    }

    public boolean hasData();

    default public <A> A getIndex(List<A> list, int index, Supplier<A> supplier) {
        if (index == -1 || index == Integer.MAX_VALUE) {
            index = list.size();
        }
        if (list.size() > index) {
            A a = list.get(index);
            if (a == null) {
                a = supplier.get();
                list.set(index, a);
            }
            return a;
        }
        for (int i = list.size(); i < index; ++i) {
            list.add(null);
        }
        A item = supplier.get();
        list.add(item);
        return item;
    }

    public <B extends RosettaModelObjectBuilder> B merge(B var1, BuilderMerger var2);
}

