/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.rosetta.model.lib.ModelId;
import com.rosetta.util.DottedPath;
import java.util.Arrays;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;

public class ModelReportId
extends ModelId
implements Comparable<ModelReportId> {
    private static Pattern REGULATORY_REFERENCE_REPR_PATTERN = Pattern.compile("<(?<body>[a-zA-Z0-9_]+)(?: (?<corpusList>[a-zA-Z0-9_ ]+))?>");
    private final String body;
    private final String[] corpusList;

    public ModelReportId(DottedPath namespace, String body, String ... corpusList) {
        super(namespace);
        Objects.requireNonNull(body);
        Validate.noNullElements((Object[])corpusList);
        this.body = body;
        this.corpusList = corpusList;
    }

    @JsonCreator
    public static ModelReportId fromNamespaceAndRegulatoryReferenceString(String str) {
        DottedPath parts = DottedPath.splitOnDots(str);
        DottedPath namespace = parts.parent();
        Matcher matcher = REGULATORY_REFERENCE_REPR_PATTERN.matcher(parts.last());
        if (matcher.matches()) {
            String body = matcher.group("body");
            String rawCorpusList = matcher.group("corpusList");
            String[] corpusList = rawCorpusList == null ? new String[]{} : rawCorpusList.split(" ");
            return new ModelReportId(namespace, body, corpusList);
        }
        throw new IllegalArgumentException("Invalid format for regulatory reference string: " + parts.last());
    }

    public String getBody() {
        return this.body;
    }

    public String[] getCorpusList() {
        return this.corpusList;
    }

    @Override
    public String getAlphanumericName() {
        return this.joinRegulatoryReference();
    }

    public String joinRegulatoryReference() {
        return this.joinRegulatoryReference("");
    }

    public String joinRegulatoryReference(String separator) {
        return this.joinRegulatoryReference(separator, separator);
    }

    public String joinRegulatoryReference(String bodySeparator, String corpusSeparator) {
        if (this.corpusList.length == 0) {
            return this.body;
        }
        return this.body + bodySeparator + String.join((CharSequence)corpusSeparator, this.corpusList);
    }

    @JsonValue
    public String toString() {
        return this.getNamespace().child("<" + this.joinRegulatoryReference(" ") + ">").withDots();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.corpusList);
        result = 31 * result + Objects.hash(this.body, this.getNamespace());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ModelReportId other = (ModelReportId)obj;
        return Objects.equals(this.body, other.body) && Arrays.equals(this.corpusList, other.corpusList) && Objects.equals(this.getNamespace(), other.getNamespace());
    }

    @Override
    public int compareTo(ModelReportId o) {
        int namespaceComp = this.getNamespace().compareTo(o.getNamespace());
        if (namespaceComp != 0) {
            return namespaceComp;
        }
        int bodyComp = this.body.compareTo(o.body);
        if (bodyComp != 0) {
            return bodyComp;
        }
        for (int i = 0; i < this.corpusList.length && i < o.corpusList.length; ++i) {
            int c = this.corpusList[i].compareTo(o.corpusList[i]);
            if (c == 0) continue;
            return c;
        }
        return Integer.compare(this.corpusList.length, o.corpusList.length);
    }
}

