/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.testing.pipeline;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.inject.Injector;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.postprocess.WorkflowPostProcessor;
import com.regnosys.rosetta.common.transform.PipelineModel;
import com.regnosys.rosetta.common.transform.TestPackUtils;
import com.regnosys.rosetta.common.transform.TransformType;
import com.regnosys.rosetta.common.validation.RosettaTypeValidator;
import com.regnosys.testing.pipeline.PipelineFunctionRunner;
import com.regnosys.testing.pipeline.PipelineFunctionRunnerImpl;
import com.regnosys.testing.pipeline.PipelineFunctionRunnerProvider;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.process.PostProcessor;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Optional;
import java.util.function.Function;
import javax.xml.validation.Validator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipelineFunctionRunnerProviderImpl
implements PipelineFunctionRunnerProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipelineFunctionRunnerProviderImpl.class);
    @Inject
    RosettaTypeValidator typeValidator;
    @Inject
    ReferenceConfig referenceConfig;
    @Inject
    Injector injector;
    @Inject
    WorkflowPostProcessor postProcessor;

    @Override
    public PipelineFunctionRunner create(TransformType transformType, Class<? extends RosettaModelObject> inputType, Class<?> functionType, PipelineModel.Serialisation inputSerialisation, PipelineModel.Serialisation outputSerialisation, ObjectMapper defaultJsonObjectMapper, ObjectWriter defaultJsonObjectWriter, Validator outputXsdValidator) {
        ObjectMapper inputObjectMapper = Optional.ofNullable(inputSerialisation).flatMap(TestPackUtils::getObjectMapper).orElse(defaultJsonObjectMapper);
        ObjectWriter outputObjectWriter = Optional.ofNullable(outputSerialisation).flatMap(TestPackUtils::getObjectWriter).orElse(defaultJsonObjectWriter);
        return this.createTestPackFunctionRunner(transformType, functionType, inputType, inputObjectMapper, outputObjectWriter, outputXsdValidator);
    }

    private <IN extends RosettaModelObject> PipelineFunctionRunner createTestPackFunctionRunner(TransformType transformType, Class<?> functionType, Class<IN> inputType, ObjectMapper inputObjectMapper, ObjectWriter outputObjectWriter, Validator xsdValidator) {
        Function<IN, RosettaModelObject> transformFunction = this.getTransformFunction(functionType, inputType);
        return new PipelineFunctionRunnerImpl<IN>(transformType, transformFunction, inputType, this.typeValidator, this.referenceConfig, inputObjectMapper, outputObjectWriter, (PostProcessor)this.postProcessor, xsdValidator);
    }

    private <IN extends RosettaModelObject> Function<IN, RosettaModelObject> getTransformFunction(Class<?> functionType, Class<IN> inputType) {
        Method evaluateMethod;
        Object functionInstance = this.injector.getInstance(functionType);
        try {
            evaluateMethod = functionInstance.getClass().getMethod("evaluate", inputType);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Function %s evaluate method with input type %s not found", functionType.getName(), inputType.getName()), e);
        }
        return resolvedInput -> {
            try {
                if (resolvedInput == null) {
                    LOGGER.info("Not invoking function {} as input is null", (Object)functionType.getName());
                    return null;
                }
                return (RosettaModelObject)evaluateMethod.invoke(functionInstance, resolvedInput);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(String.format("Failed to invoke function %s evaluate method", functionType.getName()), e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(String.format("Failed to invoke function %s evaluate method", functionType.getName()), e);
            }
        };
    }
}

