/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.serialisation.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.dataformat.xml.JacksonXmlModule;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.deser.FromXmlParser;
import com.rosetta.model.lib.ModelSymbolId;
import com.rosetta.util.serialisation.RosettaXMLConfiguration;
import com.rosetta.util.serialisation.TypeXMLConfiguration;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;

public class RosettaXmlMapper
extends XmlMapper {
    private static final long serialVersionUID = 1L;
    private final RosettaXMLConfiguration config;
    private final ClassLoader classLoader;

    public RosettaXmlMapper(RosettaXMLConfiguration config, ClassLoader classLoader) {
        super((JacksonXmlModule)null);
        this.config = config;
        this.classLoader = classLoader;
    }

    protected Object _readValue(DeserializationConfig cfg, JsonParser p, JavaType valueType) throws IOException {
        JavaType typeFromRootElementName = this.getTypeFromRootElementName(p);
        if (typeFromRootElementName != null) {
            this.checkRootTypeIsSubtypeOfProvidedType(typeFromRootElementName, valueType);
            Object value = super._readValue(cfg, p, typeFromRootElementName);
            return valueType.getRawClass().cast(value);
        }
        return super._readValue(cfg, p, valueType);
    }

    protected Object _readMapAndClose(JsonParser p, JavaType valueType) throws IOException {
        JavaType typeFromRootElementName = this.getTypeFromRootElementName(p);
        if (typeFromRootElementName != null) {
            this.checkRootTypeIsSubtypeOfProvidedType(typeFromRootElementName, valueType);
            Object value = super._readMapAndClose(p, typeFromRootElementName);
            return valueType.getRawClass().cast(value);
        }
        return super._readMapAndClose(p, valueType);
    }

    private void checkRootTypeIsSubtypeOfProvidedType(JavaType rootType, JavaType providedType) {
        if (rootType.isTypeOrSubTypeOf(providedType.getRawClass())) {
            return;
        }
        throw new IllegalArgumentException("The inferred root type " + rootType + " is not a subtype of the provided type " + providedType + ".");
    }

    private JavaType getTypeFromRootElementName(JsonParser p) {
        String rootElementName = this.getRootXMLElementName(p);
        if (rootElementName == null) {
            return null;
        }
        return this.getValueTypeForElement(rootElementName).map(this::convertClassToJavaType).orElse(null);
    }

    private String getRootXMLElementName(JsonParser p) {
        if (p instanceof FromXmlParser) {
            FromXmlParser fromXmlParser = (FromXmlParser)p;
            return fromXmlParser.getStaxReader().getLocalName();
        }
        return null;
    }

    private Optional<Class<?>> getValueTypeForElement(String elementName) {
        for (Map.Entry entry : this.config.getTypeConfigMap().entrySet()) {
            TypeXMLConfiguration typeXMLConfiguration = (TypeXMLConfiguration)entry.getValue();
            if (!typeXMLConfiguration.getXmlElementName().map(x -> x.equals(elementName)).orElse(false).booleanValue()) continue;
            ModelSymbolId modelSymbolId = (ModelSymbolId)entry.getKey();
            try {
                Class<?> aClass = this.loadModelSymbolAsClass(modelSymbolId);
                return Optional.of(aClass);
            }
            catch (ClassNotFoundException e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private Class<?> loadModelSymbolAsClass(ModelSymbolId modelSymbolId) throws ClassNotFoundException {
        return this.classLoader.loadClass(modelSymbolId.getQualifiedName().toString());
    }

    private JavaType convertClassToJavaType(Class<?> clazz) {
        return this.getTypeFactory().constructType(clazz);
    }
}

