/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.codahale.metrics.Timer;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.MappingError;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.EntityImpl;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import com.regnosys.rosetta.translate.synonymmap.AttributeGroupMapping;
import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.SynonymGroup;
import com.regnosys.rosetta.translate.synonymmap.SynonymMap;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Pair;

public class CardinalityChecker {
    private static final Logger LOGGER = Logger.getLogger((String)CardinalityChecker.class.getName());

    public List<MappingError> checkCardinalities(List<SynonymMap> synonyms) {
        Timer timer = IngesterGenerator.GENERATOR_METRICS.timer("checking cardinality");
        Timer.Context time = timer.time();
        HashSet checked = new HashSet();
        LOGGER.trace((Object)"Checking cardinality");
        EntityImpl top = new EntityImpl(new NamespaceName("top", "TopLevel"), false);
        List<MappingError> errors = synonyms.stream().flatMap(s -> this.validCardinalities((SynonymMap)s, top, checked).stream()).collect(Collectors.toList());
        time.stop();
        return errors;
    }

    private List<MappingError> validCardinalities(SynonymMap s, Entity parentEntity, Set<Pair<SynonymMap, Entity>> checked) {
        Pair key = new Pair((Object)s, (Object)parentEntity);
        if (checked.contains(key)) {
            return Collections.emptyList();
        }
        checked.add((Pair<SynonymMap, Entity>)key);
        ArrayList<MappingError> errors = new ArrayList<MappingError>();
        for (AttributeGroupMapping mappedGroups : s.getMappedGroups()) {
            long rosettaCardinality = mappedGroups.getGroup().getAttributePath().stream().filter(ra -> ra.isMultiple()).count();
            for (SynonymGroup sg : mappedGroups.getGroup().getSynonymGroups()) {
                for (SynonymValue path : sg.getSynonymValues()) {
                    long synonymCardinality = this.getCardinality(parentEntity, path.getSynonymPath());
                    if (rosettaCardinality > 1L && synonymCardinality > 0L) {
                        errors.add(new MappingError(MappingError.MappingErrorLevel.WARNING, "Ambiguous cardinality choices for path " + s.getRosetta().getName() + ":" + mappedGroups.getGroup().attsToString() + " matching " + path.getSynonymPath().toString()));
                    } else if (synonymCardinality >= 1L && rosettaCardinality == 0L) {
                        errors.add(new MappingError(MappingError.MappingErrorLevel.ERROR, "Invalid cardinality choices for " + s.getRosetta().getName() + ":XSD " + this.toPath(parentEntity, path) + " is multiple while Rosetta " + this.toPath(s, mappedGroups.getGroup().attsToString()) + " is single "));
                    }
                    Entity last = path.getSynonymPath().get(path.getSynonymPath().size() - 1).getEntity();
                    errors.addAll(this.validCardinalities(mappedGroups.getMappings(), last, checked));
                }
            }
        }
        return errors;
    }

    private String toPath(Entity parentEntity, SynonymValue path) {
        StringBuilder builder = new StringBuilder();
        builder.append(Optional.ofNullable(parentEntity).map(Entity::getName).map(Object::toString).orElse(""));
        for (Element el : path.getSynonymPath()) {
            builder.append("->");
            builder.append(el.getName());
        }
        return builder.toString();
    }

    private String toPath(SynonymMap s, String attsToString) {
        StringBuilder builder = new StringBuilder();
        builder.append(s.getRosetta().getName());
        builder.append("->");
        builder.append(attsToString);
        return builder.toString();
    }

    private long getCardinality(Entity parentEntity, List<Element> path) {
        Entity ent = parentEntity;
        long card = 0L;
        for (Element e : path) {
            if (ent != null) {
                Optional<Attribute> findFirst = ent.getAllPossibleAttributes().filter(att -> att.getName().equals(e.getName())).findFirst();
                if (!findFirst.isPresent()) {
                    return 0L;
                }
                Attribute link = findFirst.get();
                if (link.getCardinality() == Cardinality.MULTIPLE) {
                    ++card;
                }
            }
            ent = e.getEntity();
        }
        return card;
    }
}

