/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.synonymmap;

import com.regnosys.rosetta.rosetta.RosettaCallableWithArgs;
import com.regnosys.rosetta.rosetta.RosettaMapTestFunc;
import com.regnosys.rosetta.rosetta.RosettaModel;
import com.regnosys.rosetta.translate.synonymmap.SynonymTest;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SynonymConditionFuncTest
implements SynonymTest {
    private final String funcClassName;
    private final List<String> predicatePathEndsWith;

    public SynonymConditionFuncTest(RosettaMapTestFunc test) {
        RosettaCallableWithArgs func = test.getFunc();
        this.funcClassName = String.format("%s.functions.%s", ((RosettaModel)func.eContainer()).getName(), func.getName());
        this.predicatePathEndsWith = Optional.ofNullable(test.getPredicatePath()).map(p -> p.getPath()).map(p -> Arrays.asList(p.split("->"))).orElse(null);
    }

    @Override
    public List<SynonymValue> getPaths() {
        return Collections.emptyList();
    }

    public String getFuncClassName() {
        return this.funcClassName;
    }

    public List<String> getPredicatePathEndsWith() {
        return this.predicatePathEndsWith;
    }

    public int hashCode() {
        return Objects.hash(this.funcClassName, this.predicatePathEndsWith);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SynonymConditionFuncTest other = (SynonymConditionFuncTest)obj;
        return Objects.equals(this.funcClassName, other.funcClassName) && Objects.equals(this.predicatePathEndsWith, other.predicatePathEndsWith);
    }

    public String toString() {
        return "SynonymConditionFuncTest [funcClassName=" + this.funcClassName + ", predicatePathEndsWith=" + String.valueOf(this.predicatePathEndsWith) + "]";
    }
}

