/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.datamodel;

import com.regnosys.rosetta.translate.CustomDeserialise;
import com.regnosys.rosetta.translate.datamodel.Attribute;
import com.regnosys.rosetta.translate.datamodel.AttributeImpl;
import com.regnosys.rosetta.translate.datamodel.BasicType;
import com.regnosys.rosetta.translate.datamodel.Cardinality;
import com.regnosys.rosetta.translate.datamodel.Entity;
import com.regnosys.rosetta.translate.datamodel.EntityImpl;
import com.regnosys.rosetta.translate.datamodel.NamespaceName;
import com.regnosys.rosetta.translate.datamodel.Schema;
import com.regnosys.rosetta.translate.datamodel.SimpleType;
import com.regnosys.rosetta.translate.datamodel.json.JsonAttribute;
import com.regnosys.rosetta.translate.datamodel.json.JsonEntity;
import java.util.List;

public class SchemaDeserialise
extends CustomDeserialise {
    public SchemaDeserialise() {
        this.parseMethods.put(Schema.class.getName(), this::readSchema);
        this.parseMethods.put(EntityImpl.class.getName(), this::readEntityImpl);
        this.parseMethods.put(AttributeImpl.class.getName(), this::readAttributeImpl);
        this.parseMethods.put(JsonAttribute.class.getName(), this::readAttributeImpl);
        this.parseMethods.put(EntityImpl.class.getName(), this::readEntityImpl);
        this.parseMethods.put(JsonEntity.class.getName(), this::readEntityImpl);
        this.parseMethods.put(SimpleType.class.getName(), this::readSimpleType);
    }

    private Schema readSchema(Long id, CustomDeserialise.DeserialiseContext context) {
        context.read("attributes");
        List<Attribute> atts = this.readList(context);
        context.read("entities:");
        List<Entity> ents = this.readList(context);
        return new Schema(atts, ents);
    }

    private EntityImpl readEntityImpl(Long objectId, CustomDeserialise.DeserialiseContext context) {
        String ns = context.read("namespace:");
        String namename = context.read("name:");
        boolean hasData = Boolean.valueOf(context.read("hasData:"));
        NamespaceName name = new NamespaceName(ns, namename);
        EntityImpl entityImpl = new EntityImpl(name, hasData);
        context.addObjectId(objectId, entityImpl);
        context.read("extends:");
        Entity extendedEntity = (Entity)this.readOne(context);
        entityImpl.setExtended(extendedEntity);
        context.read("attributes");
        List<Attribute> atts = this.readList(context);
        context.read("extending:");
        List extendingEntities = this.readList(context);
        atts.forEach(a -> entityImpl.addAttribute((Attribute)a));
        entityImpl.getKnownExtendingEntities().addAll(extendingEntities);
        context.read("child:");
        return entityImpl;
    }

    private AttributeImpl readAttributeImpl(long objectId, CustomDeserialise.DeserialiseContext context) {
        String name = context.read("name:");
        Cardinality cardinality = Cardinality.valueOf(context.read("cardinality:"));
        context.read("type:");
        Entity type = (Entity)this.readOne(context);
        AttributeImpl attributeImpl = new AttributeImpl(name, cardinality, type);
        context.addObjectId(objectId, attributeImpl);
        return attributeImpl;
    }

    private SimpleType readSimpleType(long objectId, CustomDeserialise.DeserialiseContext context) {
        String ns = context.read("namespace:");
        String namename = context.read("name:");
        BasicType type = BasicType.valueOf(context.read("type:"));
        NamespaceName name = new NamespaceName(ns, namename);
        SimpleType simpleType = new SimpleType(name, type);
        context.addObjectId(objectId, simpleType);
        context.read("extending:");
        List extendingEntities = this.readList(context);
        simpleType.getKnownExtendingEntities().addAll(extendingEntities);
        return simpleType;
    }
}

