/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate.basic;

import com.regnosys.rosetta.translate.basic.BasicParseHandler;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;

public class TimeParseHandler
extends BasicParseHandler<LocalTime> {
    private DateTimeFormatter pattern;

    public TimeParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ISO_LOCAL_TIME;
    }

    public TimeParseHandler(boolean allowsMultiple, boolean isCondition, boolean removeHtml, String pattern) {
        super(allowsMultiple, isCondition, removeHtml);
        this.pattern = DateTimeFormatter.ofPattern(pattern);
    }

    public String toString() {
        return "LocalTime";
    }

    @Override
    protected LocalTime convert(String value) {
        return LocalTime.parse(value, this.pattern);
    }
}

