/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.regnosys.rosetta.common.hashing.ReferenceConfig;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.HandlerFactory;
import com.regnosys.rosetta.translate.HandlerStackItem;
import com.regnosys.rosetta.translate.HandlerSupplier;
import com.regnosys.rosetta.translate.HandlerWithPath;
import com.regnosys.rosetta.translate.IngestException;
import com.regnosys.rosetta.translate.ParserHelper;
import com.regnosys.rosetta.translate.ParserParent;
import com.regnosys.rosetta.translate.ParserResult;
import com.regnosys.rosetta.translate.ROMParseHandler;
import com.regnosys.rosetta.translate.SynonymToEnumMapBuilder;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.validation.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OurJsonParser
extends ParserParent {
    private static final Logger LOGGER = LoggerFactory.getLogger(OurJsonParser.class);

    public OurJsonParser(HandlerFactory factory, SynonymToEnumMapBuilder synonymToEnumMap, ReferenceConfig referenceConfig) {
        super(factory, synonymToEnumMap, referenceConfig);
    }

    @Override
    protected <T extends RosettaModelObject> ParserResult parseTheDocument(Reader reader, Schema schema, Class<T> returnClass) {
        ParserResult parserResult;
        ParserResult.Context context = new ParserResult.Context(this.synonymToEnumMap);
        Map<Class<? extends RosettaModelObject>, HandlerSupplier> handlers = this.factory.getHandlerSuppliers(context.getMappingContext());
        if (!handlers.containsKey(returnClass)) {
            throw new IngestException("Do not have parser for " + returnClass.getSimpleName());
        }
        CharArrayReader json = new CharArrayReader(ParserHelper.toCharsfromReader(reader));
        try {
            ROMParseHandler handler = (ROMParseHandler)handlers.get(returnClass).apply(new Path(), new Path());
            handler.setRosettaPath(new Path().addElement(new Path.PathElement(returnClass.getSimpleName())));
            JsonFactory factory = new JsonFactory();
            JsonParser parser = factory.createParser((Reader)json);
            while (!parser.isClosed()) {
                this.parse(parser, handler, context);
            }
            Object rosettaInstance = handler.getUnderlying();
            LOGGER.info("Finished parsing");
            parserResult = new ParserResult((RosettaModelObjectBuilder)rosettaInstance, context);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)json).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IngestException("error reading input json", e);
            }
        }
        ((Reader)json).close();
        return parserResult;
    }

    private void parse(JsonParser parser, ROMParseHandler<?> rootHandler, ParserResult.Context context) throws IOException {
        ArrayDeque<HandlerStackItem> handlerStack = new ArrayDeque<HandlerStackItem>();
        boolean end = false;
        HandlerStackItem currentHandlers = new HandlerStackItem(Collections.singletonList(new HandlerWithPath(rootHandler)), new Path(Collections.emptyList()));
        handlerStack.push(currentHandlers);
        block9: while (!end) {
            JsonToken currentToken = parser.nextToken();
            if (null == currentToken) {
                end = true;
                break;
            }
            List<HandlerWithPath> handlers = currentHandlers.handlers();
            Path fullPath = currentHandlers.fullPath();
            switch (currentToken) {
                case FIELD_NAME: {
                    String fieldName = parser.getCurrentName();
                    Path.PathElement element = currentHandlers.addChild(fieldName, Collections.emptyMap());
                    Path newPath = fullPath.addElement(element);
                    List complexHandlers = handlers.stream().filter(HandlerWithPath::isComplexHandler).collect(Collectors.toList());
                    List<HandlerWithPath> newHandlers = complexHandlers.stream().flatMap(hwp -> hwp.matchingHandlers(element, fullPath).stream()).collect(Collectors.toList());
                    complexHandlers.stream().flatMap(hwp -> hwp.matchingMappingProcessors(fullPath, context.getMappingContext()).stream()).forEach(mapEntryProcessor -> context.getMappingProcessors().put((RosettaPath)mapEntryProcessor.getKey(), (MappingProcessor)mapEntryProcessor.getValue()));
                    if (newHandlers.isEmpty()) {
                        LOGGER.debug(String.valueOf(newPath) + " had no destination");
                        context.getMappingContext().getMappings().add(new Mapping(newPath, null, new Path(Collections.emptyList()), null, "had no destination", false, false, false));
                    }
                    currentHandlers = new HandlerStackItem(newHandlers, newPath);
                    continue block9;
                }
                case VALUE_FALSE: 
                case VALUE_TRUE: 
                case VALUE_NUMBER_INT: 
                case VALUE_NUMBER_FLOAT: 
                case VALUE_STRING: {
                    handlerStack.push(currentHandlers);
                    String stringVal = parser.getValueAsString().trim();
                    if (stringVal.length() > 0) {
                        context.getMappingContext().getMappings().addAll(HandlerWithPath.createMappings(handlers, stringVal, fullPath));
                    }
                    currentHandlers = this.stepOutPopFilter(handlerStack);
                    continue block9;
                }
                case END_OBJECT: {
                    currentHandlers = this.stepOutPopFilter(handlerStack);
                    if (currentHandlers != null) continue block9;
                    return;
                }
                case START_OBJECT: {
                    handlerStack.push(currentHandlers);
                    continue block9;
                }
                case START_ARRAY: {
                    handlerStack.push(currentHandlers);
                    continue block9;
                }
                case END_ARRAY: {
                    currentHandlers = this.stepOutPopFilter(handlerStack);
                    continue block9;
                }
                case VALUE_EMBEDDED_OBJECT: 
                case VALUE_NULL: {
                    continue block9;
                }
            }
            throw new AssertionError((Object)("Unhandled JsonToken parsed value: " + String.valueOf(currentToken)));
        }
    }

    protected HandlerStackItem stepOutPopFilter(Deque<HandlerStackItem> handlerStack) {
        handlerStack.pop();
        if (handlerStack.isEmpty()) {
            return null;
        }
        handlerStack.peek().handlers().stream().filter(HandlerWithPath::isComplexHandler).forEach(HandlerWithPath::removeLastIfExists);
        return handlerStack.peek();
    }
}

