/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.translate.synonymmap.Element;
import com.regnosys.rosetta.translate.synonymmap.SynonymMap;
import com.regnosys.rosetta.translate.synonymmap.SynonymValue;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.generated.GeneratedJavaClass;
import com.rosetta.util.types.generated.GeneratedJavaGenericTypeDeclaration;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class IngesterGeneratorUtils {
    static boolean isConditionalMappingPredicatedOnDifferentPath(List<SynonymValue> synonymPaths, List<SynonymValue> conditionSynonymPaths) {
        return !IngesterGeneratorUtils.toFirstPathElements(synonymPaths).stream().anyMatch(p -> IngesterGeneratorUtils.toFirstPathElements(conditionSynonymPaths).contains(p));
    }

    private static List<Element> toFirstPathElements(List<SynonymValue> paths) {
        return paths.stream().map(SynonymValue::getSynonymPath).map(IngesterGeneratorUtils::getFirstItem).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toList());
    }

    private static <T> Optional<T> getFirstItem(List<T> list) {
        Iterator<T> iterator = list.iterator();
        return iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
    }

    static JavaClass<?> toBuilderType(JavaClass<?> type) {
        if (type.equals((Object)JavaClass.from(RosettaModelObject.class))) {
            return JavaClass.from(RosettaModelObjectBuilder.class);
        }
        GeneratedJavaClass base = new GeneratedJavaClass(type.getPackageName(), type.getSimpleName() + "." + type.getSimpleName() + "Builder", Object.class);
        if (type instanceof JavaParameterizedType) {
            return JavaParameterizedType.from((JavaGenericTypeDeclaration)new GeneratedJavaGenericTypeDeclaration(base, new String[]{"T"}), (List)((JavaParameterizedType)type).getArguments());
        }
        return base;
    }

    static List<String> getTraversedImports(SynonymMap mapping) {
        return mapping.attributeGroups().stream().flatMap(g -> g.getAttributePath().stream()).map(p -> p.getType()).filter(Objects::nonNull).filter(t -> !t.isBuiltInType()).filter(t -> t.getModel() != null).map(t -> t.getModel().getName() + "." + t.getName()).distinct().sorted().collect(Collectors.toList());
    }
}

