/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.translate.HandlerWithPath;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;

class HandlerStackItem {
    private final List<HandlerWithPath> handlers;
    private final List<Path.PathElement> knownChildren = new ArrayList<Path.PathElement>();
    private final Path fullPath;

    HandlerStackItem(List<HandlerWithPath> handlers, Path fullPath) {
        this.handlers = handlers;
        this.fullPath = fullPath;
    }

    Path.PathElement addChild(String child, Map<String, String> metas) {
        Optional<Path.PathElement> last = this.knownChildren.stream().filter(pe -> pe.getPathName().equals(child)).reduce(HandlerStackItem.last());
        Path.PathElement newChild = last.map(pe -> new Path.PathElement(child, pe.forceGetIndex() + 1, metas)).orElse(new Path.PathElement(child, metas));
        this.knownChildren.add(newChild);
        return newChild;
    }

    List<HandlerWithPath> handlers() {
        return this.handlers;
    }

    Path fullPath() {
        return this.fullPath;
    }

    HandlerStackItem withNewFullPath() {
        return new HandlerStackItem(this.handlers, new Path());
    }

    public String toString() {
        return "HandlerStackItem [handlers=" + String.valueOf(this.handlers) + ", fullPath=" + String.valueOf(this.fullPath) + "]";
    }

    private static <T> BinaryOperator<T> last() {
        return (a, b) -> b;
    }
}

