/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.translate;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.inject.Injector;
import com.regnosys.rosetta.RosettaStandaloneSetup;
import com.regnosys.rosetta.translate.IngesterGenerator;
import com.regnosys.rosetta.translate.SynonymToEnumMapGenerator;
import com.regnosys.rosetta.translate.Translator;
import com.regnosys.rosetta.translate.TranslatorOptions;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.apache.log4j.Logger;

public class GeneratorMain {
    private static final Logger LOGGER = Logger.getLogger(GeneratorMain.class);

    public static void main(String[] args) throws IOException {
        CLI options = new CLI(args);
        Path javaOut = Paths.get(options.getOutputPath(), new String[0]);
        Injector injector = new RosettaStandaloneSetup().createInjectorAndDoEMFRegistration();
        IngesterGenerator generator = (IngesterGenerator)injector.getInstance(IngesterGenerator.class);
        SynonymToEnumMapGenerator synonymToEnumMapGenerator = (SynonymToEnumMapGenerator)injector.getInstance(SynonymToEnumMapGenerator.class);
        new Translator(options, GeneratorMain.class.getClassLoader(), generator, synonymToEnumMapGenerator).generateJava(javaOut, true);
    }

    static class CLI
    implements TranslatorOptions {
        private final Multimap<String, String> argsMap;

        public CLI(String[] args) {
            Object[] argList = Joiner.on((String)" ").skipNulls().join((Object[])args).split("\\s+");
            LOGGER.info((Object)("Running with args: " + Joiner.on((char)' ').join(argList)));
            List partitionedArgs = Lists.partition((List)Lists.newArrayList((Object[])argList), (int)2);
            ImmutableListMultimap indexed = Multimaps.index((Iterable)partitionedArgs, l -> (String)l.get(0));
            this.argsMap = Multimaps.transformValues((Multimap)indexed, l -> (String)Iterables.get((Iterable)l, (int)1, null));
        }

        @Override
        public String getName() {
            return this.requiredSingleValue("name");
        }

        @Override
        public Optional<String> getModelId() {
            return this.singleValue("modelId");
        }

        @Override
        public Collection<String> getModelClasspath() {
            return this.multiValue("model-classpath");
        }

        @Override
        public String getModelFileDirIncludeRegex() {
            return this.singleValue("model-file-dir-include-regex").orElse(".*\\.rosetta");
        }

        @Override
        public Optional<String> getModelFileDirExcludeRegex() {
            return this.singleValue("model-file-dir-exclude-regex");
        }

        @Override
        public String getXsdFilePath(String rosettaClassName) {
            return this.requiredSingleValue(rosettaClassName.toLowerCase() + "-xsd-file-path");
        }

        @Override
        public String getXmlExclusionsFilePath() {
            return this.singleValue("xml-exclusions-file-path").orElse(null);
        }

        @Override
        public Collection<String> getRosettaClasses() {
            return this.requiredMultiValue("rosetta-class");
        }

        @Override
        public String getGeneratedPackage() {
            return this.requiredSingleValue("package");
        }

        public String getOutputPath() {
            return this.requiredSingleValue("output");
        }

        @Override
        public Collection<String> getSynonymSources(String rosettaClassName) {
            return this.requiredMultiValue(rosettaClassName.toLowerCase() + "-synonym-source");
        }

        @Override
        public Collection<String> getTopLevelTags(String rosettaClassName) {
            return this.multiValue(rosettaClassName.toLowerCase() + "-top-level-tags");
        }

        @Override
        public String getGeneratedFactoryName() {
            return this.singleValue("generated-factory-name").orElse("XmlHandlerFactoryImpl");
        }

        @Override
        public String getChildPackageName(String rosettaClass) {
            return this.requiredSingleValue("namespace");
        }

        @Override
        public String getCdmClassesDir() {
            return this.singleValue("cdm-classes-dir").orElse("");
        }

        @Override
        public Collection<String> getIntegrationTestRoots(String rosettaClassName) {
            return this.multiValue(rosettaClassName.toLowerCase() + "integration-test-files-root-dir");
        }

        @Override
        public boolean isVerbose() {
            Optional<String> verbose = this.singleValue("verbose");
            return verbose.map(Boolean::valueOf).orElse(false);
        }

        @Override
        public boolean clean() {
            return this.singleValue("clean").map(Boolean::valueOf).orElse(true);
        }

        @Override
        public boolean isJson() {
            return false;
        }

        private Optional<String> singleValue(String key) {
            Collection value = this.argsMap.get((Object)("--" + key));
            if (value.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(value).map(Iterables::getOnlyElement);
        }

        private String requiredSingleValue(String key) {
            return this.singleValue(key).orElseThrow(() -> new RuntimeException(key + " is a required argument"));
        }

        private Collection<String> multiValue(String key) {
            return this.argsMap.get((Object)("--" + key));
        }

        private Collection<String> requiredMultiValue(String key) {
            Collection collection = this.argsMap.get((Object)("--" + key));
            if (collection.isEmpty()) {
                throw new RuntimeException(key + " is a required argument");
            }
            return collection;
        }

        @Override
        public boolean isDefault() {
            return true;
        }

        @Override
        public String getFullClassname(String rosettaClassName) {
            return this.requiredSingleValue("fullClassName");
        }

        @Override
        public boolean isCoreIgnored() {
            return true;
        }

        @Override
        public boolean preProcessJson() {
            return false;
        }
    }
}

