/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.synonym;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class MappingResult {
    private final boolean success;
    private final RosettaPath externalPath;
    private final String value;
    private final Map<RosettaPath, ? extends Object> internalPaths;
    private final Result result;
    private final List<String> issues;
    private final boolean excludedExternalPath;
    private final boolean allowsMultiple;
    private final boolean isCondition;

    public MappingResult(boolean success, RosettaPath externalPath, String value, Map<RosettaPath, ? extends Object> internalPaths, List<String> issues, boolean excludedExternalPath, boolean allowsMultiple, boolean isCondition, Result result) {
        this.success = success;
        this.externalPath = externalPath;
        this.value = value;
        this.internalPaths = internalPaths;
        this.issues = issues;
        this.excludedExternalPath = excludedExternalPath;
        this.allowsMultiple = allowsMultiple;
        this.isCondition = isCondition;
        this.result = result;
    }

    @JsonProperty
    public boolean isSuccess() {
        return this.success;
    }

    @JsonProperty
    public boolean isExcludedExternalPath() {
        return this.excludedExternalPath;
    }

    @JsonProperty
    public String getExternalPathString() {
        return this.externalPath.toString();
    }

    public RosettaPath getExternalPath() {
        return this.externalPath;
    }

    @JsonProperty
    public String getExternalPathNoMeta() {
        return String.join((CharSequence)".", this.externalPath.allElementPaths());
    }

    @JsonProperty
    public String getValue() {
        return this.value;
    }

    @JsonProperty
    public Map<RosettaPath, ? extends Object> getInternalPaths() {
        return this.internalPaths;
    }

    @JsonProperty
    public Result getResult() {
        return this.result;
    }

    @JsonProperty
    public List<String> getIssues() {
        return this.issues;
    }

    public boolean allowsMultiple() {
        return this.allowsMultiple;
    }

    public boolean isCondition() {
        return this.isCondition;
    }

    public String toString() {
        return String.format("Mapping %s [%s] \n\texternal path: [%s]\n\t%s onto [%d] internal path(s)%s%s", new Object[]{this.success ? "SUCCESS" : "FAILURE", this.result, this.externalPath, this.success ? "mapped " : "FAILED to map", this.internalPaths.size(), !this.internalPaths.isEmpty() ? ":\n\t\t[" + this.internalPaths.entrySet().stream().map(e -> ((RosettaPath)e.getKey()).buildPath() + "=" + String.valueOf(e.getValue())).collect(Collectors.joining(",\n\t\t")) + "]" : "", !this.issues.isEmpty() ? "\n\tbecause: \n\t\t" + String.join((CharSequence)",\n\t\t", this.issues) : ""});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MappingResult that = (MappingResult)o;
        return this.success == that.success && Objects.equals(this.externalPath, that.externalPath) && Objects.equals(this.value, that.value) && Objects.equals(this.internalPaths, that.internalPaths) && this.result == that.result && this.excludedExternalPath == that.excludedExternalPath && Objects.equals(this.issues, that.issues);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.success, this.externalPath, this.value, this.internalPaths, this.result, this.issues, this.excludedExternalPath});
    }

    public static enum Result {
        Fail_MappedNone,
        Fail_MappedMultiple,
        Success,
        Excluded;

    }
}

