/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.ingest.test.framework.ingestor.synonym;

import com.regnosys.ingest.test.framework.ingestor.synonym.MappingReport;
import com.regnosys.ingest.test.framework.ingestor.synonym.MappingResult;
import com.regnosys.ingest.test.framework.util.PathUtils;
import com.regnosys.rosetta.common.translation.Mapping;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappingReportBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MappingReportBuilder.class);

    public MappingReport toMappingReport(List<Mapping> mappings, List<Path> excludedExternalPaths, boolean isJson) {
        Map<Path, List<Mapping>> mapToMappings = mappings.stream().collect(Collectors.groupingBy(Mapping::getXmlPath));
        ArrayList<MappingResult> mappingResults = new ArrayList<MappingResult>();
        for (List<Mapping> mapping : mapToMappings.values()) {
            if (isJson) {
                Optional<MappingResult> jsonMappingResult = this.toJsonMappingResult(mapping, excludedExternalPaths);
                jsonMappingResult.ifPresentOrElse(mappingResults::add, () -> LOGGER.info("No JSON path was found for {} ", (Object)mapping));
                continue;
            }
            this.toXMLMappingResult(mapping, excludedExternalPaths).ifPresent(mappingResults::add);
        }
        return new MappingReport(mappingResults);
    }

    private Optional<MappingResult> toXMLMappingResult(Collection<Mapping> mappings, Collection<Path> excludedExternalPaths) {
        return this.externalPath(mappings, true).map(p -> this.mappingResult(mappings, excludedExternalPaths, (RosettaPath)p));
    }

    private Optional<MappingResult> toJsonMappingResult(Collection<Mapping> mappings, Collection<Path> excludedExternalPaths) {
        Optional<RosettaPath> externalPath = this.externalPath(mappings, false);
        return externalPath.map(t -> this.mappingResult(mappings, excludedExternalPaths, (RosettaPath)externalPath.get()));
    }

    private Optional<RosettaPath> externalPath(Collection<Mapping> mappings, boolean trimFirst) {
        return mappings.stream().filter(m -> m.getXmlValue() != null).map(Mapping::getXmlPath).map(PathUtils::toHierarchicalPath).map(p -> trimFirst ? p.trimFirst() : p).filter(Objects::nonNull).findAny();
    }

    private MappingResult mappingResult(Collection<Mapping> mappings, Collection<Path> excludedExternalPaths, RosettaPath externalPath) {
        String value = this.xmlValue(mappings);
        Map<RosettaPath, Object> internalPaths = this.internalPaths(mappings);
        List<String> issues = this.issues(mappings);
        boolean excluded = this.isExcludedExternalPath(mappings, excludedExternalPaths);
        boolean success = issues.isEmpty();
        boolean allowsMultiple = mappings.stream().anyMatch(Mapping::isAllowsMultiple);
        boolean isCondition = mappings.stream().anyMatch(Mapping::isCondition);
        MappingResult.Result result = this.calculateResult(excluded, value);
        return new MappingResult(success, externalPath, value, internalPaths, issues, excluded, allowsMultiple, isCondition, result);
    }

    private MappingResult.Result calculateResult(boolean excluded, String value) {
        if (excluded) {
            return MappingResult.Result.Excluded;
        }
        if (value == null) {
            return MappingResult.Result.Fail_MappedNone;
        }
        return MappingResult.Result.Success;
    }

    private String xmlValue(Collection<Mapping> mappings) {
        return mappings.stream().map(Mapping::getXmlValue).filter(Objects::nonNull).map(Object::toString).findFirst().orElse(null);
    }

    private List<String> issues(Collection<Mapping> mappings) {
        if (mappings.stream().anyMatch(m -> m.getXmlValue() != null && m.getRosettaValue() != null && (m.getError() == null || m.isDuplicate()))) {
            return mappings.stream().filter(Mapping::isDuplicate).map(Mapping::getError).distinct().collect(Collectors.toList());
        }
        return mappings.stream().map(Mapping::getError).filter(Objects::nonNull).distinct().collect(Collectors.toList());
    }

    private boolean isExcludedExternalPath(Collection<Mapping> mappings, Collection<Path> excludedExternalPaths) {
        return mappings.stream().filter(this::isUnmappedInternalPath).map(Mapping::getXmlPath).anyMatch(externalPath -> excludedExternalPaths.stream().anyMatch(ignoredExtPath -> ignoredExtPath.nameStartMatches(externalPath, true)));
    }

    private boolean isUnmappedInternalPath(Mapping mapping) {
        return mapping.getRosettaPath() == null || mapping.getRosettaPath().getElements().isEmpty();
    }

    private Map<RosettaPath, Object> internalPaths(Collection<Mapping> mappings) {
        HashMap<RosettaPath, Object> result = new HashMap<RosettaPath, Object>();
        for (Mapping mapping : mappings) {
            if (mapping.getRosettaPath() == null || mapping.getRosettaPath().getElements().isEmpty()) continue;
            result.put(PathUtils.toHierarchicalPath(mapping.getRosettaPath()), mapping.getRosettaValue());
        }
        return result;
    }
}

